/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.jvm.checkers;

import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.BuiltInsPackageFragment;
import org.jetbrains.kotlin.config.JvmAnalysisFlags;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassOrPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001c\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/MissingBuiltInDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "diagnosticFor", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "ClassifierUsage", "frontend.java"})
public final class MissingBuiltInDeclarationChecker
implements CallChecker {
    public static final MissingBuiltInDeclarationChecker INSTANCE;

    /*
     * Unable to fully structure code
     */
    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        block4: {
            block3: {
                Intrinsics.checkParameterIsNotNull(resolvedCall, "resolvedCall");
                Intrinsics.checkParameterIsNotNull(reportOn, "reportOn");
                Intrinsics.checkParameterIsNotNull(context, "context");
                if (context.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getSuppressMissingBuiltinsError()).booleanValue()) {
                    return;
                }
                descriptor = resolvedCall.getResultingDescriptor();
                v0 = this.diagnosticFor((DeclarationDescriptor)descriptor, reportOn);
                if (v0 != null) break block3;
                v1 = this;
                v2 = descriptor;
                Intrinsics.checkExpressionValueIsNotNull(v2, "descriptor");
                v3 = v2.getReturnType();
                if (v3 == null) ** GOTO lbl-1000
                var6_5 = v3;
                var7_6 = this;
                var12_7 = v1;
                var8_8 = false;
                var9_9 = false;
                p1 = var6_5;
                $i$a$-unknown-MissingBuiltInDeclarationChecker$check$error$1 = false;
                var13_12 = CallCheckerKt.isComputingDeferredType((MissingBuiltInDeclarationChecker)var7_6, (KotlinType)p1) == false ? var6_5 : null;
                v1 = var12_7;
                v3 = var13_12;
                if (v3 != null && (v3 = v3.getConstructor()) != null) {
                    v4 = v3.getDeclarationDescriptor();
                } else lbl-1000:
                // 2 sources

                {
                    v4 = null;
                }
                v0 = v1.diagnosticFor(v4, reportOn);
            }
            v5 = error = v0;
            if (v5 == null) break block4;
            var6_5 = v5;
            var7_6 = context.getTrace();
            var8_8 = false;
            var9_9 = false;
            p1 = var6_5;
            $i$a$-unknown-MissingBuiltInDeclarationChecker$check$1 = false;
            var7_6.report((Diagnostic)p1);
        }
    }

    private final Diagnostic diagnosticFor(DeclarationDescriptor descriptor2, PsiElement reportOn) {
        if (descriptor2 == null) {
            return null;
        }
        ClassOrPackageFragmentDescriptor containingClassOrPackage = DescriptorUtils.getParentOfType(descriptor2, ClassOrPackageFragmentDescriptor.class);
        if (containingClassOrPackage instanceof ClassDescriptor) {
            PackageFragmentDescriptor containingPackage = DescriptorUtils.getParentOfType(descriptor2, PackageFragmentDescriptor.class);
            PackageFragmentDescriptor packageFragmentDescriptor = containingPackage;
            if (!(packageFragmentDescriptor instanceof BuiltInsPackageFragment)) {
                packageFragmentDescriptor = null;
            }
            BuiltInsPackageFragment builtInsPackageFragment = (BuiltInsPackageFragment)packageFragmentDescriptor;
            if (builtInsPackageFragment != null) {
                if (builtInsPackageFragment.isFallback()) {
                    return Errors.MISSING_BUILT_IN_DECLARATION.on(reportOn, DescriptorUtilsKt.getFqNameSafe(containingClassOrPackage));
                }
            }
        } else if (containingClassOrPackage instanceof BuiltInsPackageFragment && ((BuiltInsPackageFragment)containingClassOrPackage).isFallback()) {
            return Errors.MISSING_BUILT_IN_DECLARATION.on(reportOn, DescriptorUtilsKt.getFqNameSafe(descriptor2));
        }
        return null;
    }

    private MissingBuiltInDeclarationChecker() {
    }

    static {
        MissingBuiltInDeclarationChecker missingBuiltInDeclarationChecker;
        INSTANCE = missingBuiltInDeclarationChecker = new MissingBuiltInDeclarationChecker();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/resolve/jvm/checkers/MissingBuiltInDeclarationChecker$ClassifierUsage;", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "()V", "check", "", "targetDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassifierDescriptor;", "element", "Lcom/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend.java"})
    public static final class ClassifierUsage
    implements ClassifierUsageChecker {
        public static final ClassifierUsage INSTANCE;

        @Override
        public void check(@NotNull ClassifierDescriptor targetDescriptor, @NotNull PsiElement element, @NotNull ClassifierUsageCheckerContext context2) {
            block1: {
                Intrinsics.checkParameterIsNotNull(targetDescriptor, "targetDescriptor");
                Intrinsics.checkParameterIsNotNull(element, "element");
                Intrinsics.checkParameterIsNotNull(context2, "context");
                if (context2.getLanguageVersionSettings().getFlag(JvmAnalysisFlags.getSuppressMissingBuiltinsError()).booleanValue()) {
                    return;
                }
                Diagnostic diagnostic = INSTANCE.diagnosticFor(targetDescriptor, element);
                if (diagnostic == null) break block1;
                Diagnostic diagnostic2 = diagnostic;
                BindingTrace bindingTrace = context2.getTrace();
                boolean bl = false;
                boolean bl2 = false;
                Diagnostic p1 = diagnostic2;
                boolean bl3 = false;
                bindingTrace.report(p1);
            }
        }

        private ClassifierUsage() {
        }

        static {
            ClassifierUsage classifierUsage;
            INSTANCE = classifierUsage = new ClassifierUsage();
        }
    }
}

