/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.tools.analyser;

import java.io.File;
import java.io.IOException;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.IvyPatternHelper;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.tools.analyser.DependencyAnalyser;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.tools.analyser.JarJarDependencyAnalyser;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.tools.analyser.JarModuleFinder;
import org.jetbrains.kotlin.mainKts.relocatedDeps.org.apache.ivy.util.Message;

public class RepositoryAnalyser {
    public void analyse(String pattern, DependencyAnalyser depAnalyser) {
        JarModuleFinder finder = new JarModuleFinder(pattern);
        ModuleDescriptor[] mds = depAnalyser.analyze(finder.findJarModules());
        Message.info("found " + mds.length + " modules");
        for (ModuleDescriptor md : mds) {
            File ivyFile = new File(IvyPatternHelper.substitute(pattern, DefaultArtifact.newIvyArtifact(md.getModuleRevisionId(), md.getPublicationDate())));
            try {
                Message.info("generating " + ivyFile);
                XmlModuleDescriptorWriter.write(md, ivyFile);
            }
            catch (IOException e) {
                Message.debug(e);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("usage: ivyanalyser path/to/jarjar.jar absolute-ivy-repository-pattern");
            return;
        }
        String jarjarLocation = args[0];
        String pattern = args[1];
        JarJarDependencyAnalyser a = new JarJarDependencyAnalyser(new File(jarjarLocation));
        new RepositoryAnalyser().analyse(pattern, a);
    }
}

