{
 *  MDExternalDatastore.h
 *  MDDatastoreHarness
 *
 *  Created by Jonah Petri on 1/6/06.
 *  Copyright 2006 Apple. All rights reserved.
 *
 }
 
 { Pascal Translation: Gorazd Krosl <gorazd_1957@yahoo.ca>, October 2009 }
 
{
    Modified for use with Free Pascal
    Version 308
    Please report any bugs to <gpc@microbizz.nl>
}

{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}
{$mode macpas}
{$packenum 1}
{$macro on}
{$inline on}
{$calling mwpascal}

unit MDExternalDatastore;
interface
{$setc UNIVERSAL_INTERFACES_VERSION := $0400}
{$setc GAP_INTERFACES_VERSION := $0308}

{$ifc not defined USE_CFSTR_CONSTANT_MACROS}
    {$setc USE_CFSTR_CONSTANT_MACROS := TRUE}
{$endc}

{$ifc defined CPUPOWERPC and defined CPUI386}
	{$error Conflicting initial definitions for CPUPOWERPC and CPUI386}
{$endc}
{$ifc defined FPC_BIG_ENDIAN and defined FPC_LITTLE_ENDIAN}
	{$error Conflicting initial definitions for FPC_BIG_ENDIAN and FPC_LITTLE_ENDIAN}
{$endc}

{$ifc not defined __ppc__ and defined CPUPOWERPC32}
	{$setc __ppc__ := 1}
{$elsec}
	{$setc __ppc__ := 0}
{$endc}
{$ifc not defined __ppc64__ and defined CPUPOWERPC64}
	{$setc __ppc64__ := 1}
{$elsec}
	{$setc __ppc64__ := 0}
{$endc}
{$ifc not defined __i386__ and defined CPUI386}
	{$setc __i386__ := 1}
{$elsec}
	{$setc __i386__ := 0}
{$endc}
{$ifc not defined __x86_64__ and defined CPUX86_64}
	{$setc __x86_64__ := 1}
{$elsec}
	{$setc __x86_64__ := 0}
{$endc}
{$ifc not defined __arm__ and defined CPUARM}
	{$setc __arm__ := 1}
{$elsec}
	{$setc __arm__ := 0}
{$endc}

{$ifc defined cpu64}
  {$setc __LP64__ := 1}
{$elsec}
  {$setc __LP64__ := 0}
{$endc}


{$ifc defined __ppc__ and __ppc__ and defined __i386__ and __i386__}
	{$error Conflicting definitions for __ppc__ and __i386__}
{$endc}

{$ifc defined __ppc__ and __ppc__}
	{$setc TARGET_CPU_PPC := TRUE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __ppc64__ and __ppc64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := TRUE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __i386__ and __i386__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := TRUE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := FALSE}
{$ifc defined(iphonesim)}
 	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := TRUE}
{$elsec}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
{$endc}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __x86_64__ and __x86_64__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := TRUE}
	{$setc TARGET_CPU_ARM := FALSE}
	{$setc TARGET_OS_MAC := TRUE}
	{$setc TARGET_OS_IPHONE := FALSE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := FALSE}
{$elifc defined __arm__ and __arm__}
	{$setc TARGET_CPU_PPC := FALSE}
	{$setc TARGET_CPU_PPC64 := FALSE}
	{$setc TARGET_CPU_X86 := FALSE}
	{$setc TARGET_CPU_X86_64 := FALSE}
	{$setc TARGET_CPU_ARM := TRUE}
	{ will require compiler define when/if other Apple devices with ARM cpus ship }
	{$setc TARGET_OS_MAC := FALSE}
	{$setc TARGET_OS_IPHONE := TRUE}
	{$setc TARGET_IPHONE_SIMULATOR := FALSE}
	{$setc TARGET_OS_EMBEDDED := TRUE}
{$elsec}
	{$error __ppc__ nor __ppc64__ nor __i386__ nor __x86_64__ nor __arm__ is defined.}
{$endc}

{$ifc defined __LP64__ and __LP64__ }
  {$setc TARGET_CPU_64 := TRUE}
{$elsec}
  {$setc TARGET_CPU_64 := FALSE}
{$endc}

{$ifc defined FPC_BIG_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := TRUE}
	{$setc TARGET_RT_LITTLE_ENDIAN := FALSE}
{$elifc defined FPC_LITTLE_ENDIAN}
	{$setc TARGET_RT_BIG_ENDIAN := FALSE}
	{$setc TARGET_RT_LITTLE_ENDIAN := TRUE}
{$elsec}
	{$error Neither FPC_BIG_ENDIAN nor FPC_LITTLE_ENDIAN are defined.}
{$endc}
{$setc ACCESSOR_CALLS_ARE_FUNCTIONS := TRUE}
{$setc CALL_NOT_IN_CARBON := FALSE}
{$setc OLDROUTINENAMES := FALSE}
{$setc OPAQUE_TOOLBOX_STRUCTS := TRUE}
{$setc OPAQUE_UPP_TYPES := TRUE}
{$setc OTCARBONAPPLICATION := TRUE}
{$setc OTKERNEL := FALSE}
{$setc PM_USE_SESSION_APIS := TRUE}
{$setc TARGET_API_MAC_CARBON := TRUE}
{$setc TARGET_API_MAC_OS8 := FALSE}
{$setc TARGET_API_MAC_OSX := TRUE}
{$setc TARGET_CARBON := TRUE}
{$setc TARGET_CPU_68K := FALSE}
{$setc TARGET_CPU_MIPS := FALSE}
{$setc TARGET_CPU_SPARC := FALSE}
{$setc TARGET_OS_UNIX := FALSE}
{$setc TARGET_OS_WIN32 := FALSE}
{$setc TARGET_RT_MAC_68881 := FALSE}
{$setc TARGET_RT_MAC_CFM := FALSE}
{$setc TARGET_RT_MAC_MACHO := TRUE}
{$setc TYPED_FUNCTION_POINTERS := TRUE}
{$setc TYPE_BOOL := FALSE}
{$setc TYPE_EXTENDED := FALSE}
{$setc TYPE_LONGLONG := TRUE}
uses MacTypes,CFBase,CFArray,CFUUID,CFPlugIn,CFPlugInCOM;
{$endc} {not MACOSALLINCLUDE}

{$ifc TARGET_OS_MAC}

{$ALIGN POWER}

function kMDExternalDatastoreTypeID : CFUUIDRef; inline;
function kMDExternalDatastoreStoreInterfaceID : CFUUIDRef; inline;

{ some opaque types }
type
	MDExternalDatastoreQueryRef = UnivPtr;
	MDExternalDatastoreRef = UnivPtr;
	MDResponseChannelRef = UnivPtr;

{ an enumeration of oids, for space efficiency }
type
	MDOIDEnumerationRef = UnivPtr;
function MDOIDEnumerationNextOID( oidEnum: MDOIDEnumerationRef ): UInt64; external name '_MDOIDEnumerationNextOID';
function MDOIDEnumerationHasMoreOIDs( oidEnum: MDOIDEnumerationRef ): CBool; external name '_MDOIDEnumerationHasMoreOIDs';

{ send an object in response to a query.  Returns true if the query should keep going, false if it has been cancelled, and should stop. }
function MDResponseChannelSendObject( channel: MDResponseChannelRef; var obj: CFTypeRef ): CBool; external name '_MDResponseChannelSendObject';

{ send an OID in response to a URL=>OID conversion.  Use MDResponseChannelSendOID, it will return true if the store should keep processing the URLs, false otherwise  }
function MDResponseChannelSendOID( channel: MDResponseChannelRef; oid: UInt64 ): CBool; external name '_MDResponseChannelSendOID';

type
	MDExternalDatastoreStoreInterfaceStruct = record
		IUNKNOWN_C_GUTS	: IUnknownVTbl;
		{ Initialize a store structure for a token, and return it.  In the static store case, token will be NULL.}
		MDExternalDatastoreCreate : function(token: CFTypeRef): MDExternalDatastoreRef;
		
		{ Dealloc a given store }
		MDExternalDatastoreDealloc : procedure(store: MDExternalDatastoreRef);
		
    { execute the query, and send the attribute dicitonaries of each URL through the channel 
        - query will be explained more later, but will include the query tree, and maybe grouping and sorting params, maybe original text? 
        - channel expects CFDictionaries, with at a minimum a kMDItemURL set.  
        - If the store wants to talk in terms of OIDs, it should send along an OID in the dictionary too.
        }
        MDExternalDatastoreExecuteQuery: function(store: MDExternalDatastoreRef; channel: MDResponseChannelRef; query: MDExternalDatastoreQueryRef): Boolean;

	{ send the attribute dictionaries of each URL through the channel
        - urls is a CFArrayRef of CFURLRefs
        - attributes is a CFArrayRef of CFStringRefs 
       }
       MDExternalDatastoreFetchAttributesForURLs: function(store: MDExternalDatastoreRef; channel: MDResponseChannelRef; attributes: CFArrayRef; URLs: CFArrayRef): Boolean;
       
    { OID<=>URL converters.  If the external datastore has reasonably persistant object IDs, it should provide them as part of the query answers.  It will then be expected to implement the following functions concerning OIDs.  
        
        Implementing these functions can result in substantial gains in performance for your plugin. }
       
       {  send an OID in response to a URL=>OID conversion.  Use MDResponseChannelSendOID, it will return true if the store should keep processing the URLs, false otherwise  }
       MDExternalDatastoreFetchOIDsForURLs: function(store: MDExternalDatastoreRef; channel: MDResponseChannelRef; URLs: CFArrayRef): Boolean;
       
       { send attribute dictionaries for the given OIDs.  Use MDResponseChannelSendObject on each dictionary, it will return true if the store should keep processing the OIDs, false otherwise  }
       MDExternalDatastoreFetchAttributesForOIDs: function(store: MDExternalDatastoreRef; channel: MDResponseChannelRef; attributes: CFArrayRef; OIDs: MDOIDEnumerationRef): Boolean;
       
       { send URLs in response to OID=>URL conversions.  Use MDResponseChannelSendObject, it will return true if the store should keep processing the OIDs, false otherwise  }
       MDExternalDatastoreFetchURLsForOIDs: function(store: MDExternalDatastoreRef; channel: MDResponseChannelRef; OIDs: MDOIDEnumerationRef): Boolean;
	end;

	MDExternalDatastoreStoreInterfaceStructPtr = ^MDExternalDatastoreStoreInterfaceStruct;
{$endc} {TARGET_OS_MAC}
	
{$ifc not defined MACOSALLINCLUDE or not MACOSALLINCLUDE}
implementation

{$ifc TARGET_OS_MAC}


function kMDExternalDatastoreTypeID : CFUUIDRef; inline;
begin
	kMDExternalDatastoreTypeID := CFUUIDGetConstantUUIDWithBytes(kCFAllocatorDefault,$49,$68,$94,$B1,$00,$30,$47,$E0,$96,$11,$F2,$48,$FB,$E0,$B8,$CA)
end;

function kMDExternalDatastoreStoreInterfaceID : CFUUIDRef; inline;
begin
	kMDExternalDatastoreStoreInterfaceID := CFUUIDGetConstantUUIDWithBytes(kCFAllocatorDefault,$DA,$62,$12,$99,$ED,$BE,$4A,$63,$92,$39,$CB,$24,$13,$73,$E2,$07)
end;

{$endc} {TARGET_OS_MAC}

end.

{$endc} {not MACOSALLINCLUDE}
