/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.control;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.control.InGameController;
import net.sf.freecol.client.control.InputHandler;
import net.sf.freecol.common.debug.FreeColDebugger;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.FoundingFather;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.LastSale;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.ChatMessage;
import net.sf.freecol.common.networking.ChooseFoundingFatherMessage;
import net.sf.freecol.common.networking.Connection;
import net.sf.freecol.common.networking.DOMMessage;
import net.sf.freecol.common.networking.DiplomacyMessage;
import net.sf.freecol.common.networking.FirstContactMessage;
import net.sf.freecol.common.networking.IndianDemandMessage;
import net.sf.freecol.common.networking.LootCargoMessage;
import net.sf.freecol.common.networking.MonarchActionMessage;
import net.sf.freecol.common.networking.NewLandNameMessage;
import net.sf.freecol.common.networking.NewRegionNameMessage;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class InGameInputHandler
extends InputHandler {
    private static final Logger logger = Logger.getLogger(InGameInputHandler.class.getName());
    private final Runnable closeMenusRunnable = () -> this.igc().closeMenus();
    private final Runnable displayModelMessagesRunnable = () -> this.igc().displayModelMessages(false);
    private final Runnable reconnectRunnable = () -> this.igc().reconnect();

    public InGameInputHandler(FreeColClient freeColClient) {
        super(freeColClient);
    }

    private InGameController igc() {
        return this.getFreeColClient().getInGameController();
    }

    private void invokeAndWait(Runnable runnable) {
        this.getFreeColClient().getGUI().invokeNowOrWait(runnable);
    }

    private void invokeLater(Runnable runnable) {
        this.getFreeColClient().getGUI().invokeNowOrLater(runnable);
    }

    private static int getIntegerAttribute(Element element, String attrib) {
        int n;
        try {
            n = Integer.parseInt(element.getAttribute(attrib));
        }
        catch (NumberFormatException e) {
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    private static Element selectElement(Element parent, String key) {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            if (!key.equals(FreeColObject.readId(e))) continue;
            return e;
        }
        return null;
    }

    private static Unit selectUnitFromElement(Game game, Element element, String id) {
        Element e = InGameInputHandler.selectElement(element, id);
        Unit u = null;
        if (e != null && (u = new Unit(game, e)).getLocation() == null) {
            throw new RuntimeException("Null location: " + u);
        }
        return u;
    }

    @Override
    public Element handle(Connection connection, Element element) {
        Element reply;
        if (element == null) {
            throw new RuntimeException("Received empty (null) message!");
        }
        String type = element.getTagName();
        logger.log(Level.FINEST, "Received: " + type);
        switch (type) {
            case "disconnect": {
                reply = this.disconnect(element);
                break;
            }
            case "addObject": {
                reply = this.addObject(element);
                break;
            }
            case "addPlayer": {
                reply = this.addPlayer(element);
                break;
            }
            case "animateAttack": {
                reply = this.animateAttack(element);
                break;
            }
            case "animateMove": {
                reply = this.animateMove(element);
                break;
            }
            case "chat": {
                reply = this.chat(element);
                break;
            }
            case "chooseFoundingFather": {
                reply = this.chooseFoundingFather(element);
                break;
            }
            case "closeMenus": {
                reply = this.closeMenus();
                break;
            }
            case "diplomacy": {
                reply = this.diplomacy(element);
                break;
            }
            case "error": {
                reply = this.error(element);
                break;
            }
            case "featureChange": {
                reply = this.featureChange(element);
                break;
            }
            case "firstContact": {
                reply = this.firstContact(element);
                break;
            }
            case "fountainOfYouth": {
                reply = this.fountainOfYouth(element);
                break;
            }
            case "gameEnded": {
                reply = this.gameEnded(element);
                break;
            }
            case "indianDemand": {
                reply = this.indianDemand(element);
                break;
            }
            case "lootCargo": {
                reply = this.lootCargo(element);
                break;
            }
            case "monarchAction": {
                reply = this.monarchAction(element);
                break;
            }
            case "multiple": {
                reply = this.multiple(connection, element);
                break;
            }
            case "newLandName": {
                reply = this.newLandName(element);
                break;
            }
            case "newRegionName": {
                reply = this.newRegionName(element);
                break;
            }
            case "newTurn": {
                reply = this.newTurn(element);
                break;
            }
            case "reconnect": {
                reply = this.reconnect(element);
                break;
            }
            case "remove": {
                reply = this.remove(element);
                break;
            }
            case "setAI": {
                reply = this.setAI(element);
                break;
            }
            case "setCurrentPlayer": {
                reply = this.setCurrentPlayer(element);
                break;
            }
            case "setDead": {
                reply = this.setDead(element);
                break;
            }
            case "setStance": {
                reply = this.setStance(element);
                break;
            }
            case "spyResult": {
                reply = this.spyResult(element);
                break;
            }
            case "update": {
                reply = this.update(element);
                break;
            }
            default: {
                logger.warning("Unsupported message type: " + type);
                return null;
            }
        }
        logger.log(Level.FINEST, "Handled message: " + type + " replying with: " + (reply == null ? "null" : reply.getTagName()));
        FreeColClient fcc = this.getFreeColClient();
        if (Boolean.TRUE.toString().equals(element.getAttribute("flush")) && fcc.currentPlayerIsMyPlayer()) {
            this.invokeLater(this.displayModelMessagesRunnable);
        }
        return reply;
    }

    private Element addObject(Element element) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String owner = e.getAttribute("owner");
            Player player = game.getFreeColGameObject(owner, Player.class);
            if (player == null) {
                logger.warning("addObject with broken owner: " + owner);
                continue;
            }
            String tag = e.getTagName();
            if (FoundingFather.getXMLElementTagName().equals(tag)) {
                FoundingFather father = spec.getFoundingFather(FreeColObject.readId(e));
                if (father != null) {
                    player.addFather(father);
                }
                player.invalidateCanSeeTiles();
                continue;
            }
            if (HistoryEvent.getXMLElementTagName().equals(tag)) {
                player.getHistory().add(new HistoryEvent(e));
                continue;
            }
            if (LastSale.getXMLElementTagName().equals(tag)) {
                player.addLastSale(new LastSale(e));
                continue;
            }
            if (ModelMessage.getXMLElementTagName().equals(tag)) {
                player.addModelMessage(new ModelMessage(e));
                continue;
            }
            if (TradeRoute.getXMLElementTagName().equals(tag)) {
                player.getTradeRoutes().add(new TradeRoute(game, e));
                continue;
            }
            logger.warning("addObject unrecognized: " + tag);
        }
        return null;
    }

    private Element addPlayer(Element element) {
        Game game = this.getGame();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element playerElement = (Element)nodes.item(i);
            String id = FreeColObject.readId(playerElement);
            Player p = game.getFreeColGameObject(id, Player.class);
            if (p == null) {
                game.addPlayer(new Player(game, playerElement));
                continue;
            }
            p.readFromXMLElement(playerElement);
        }
        return null;
    }

    private Element animateAttack(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        Game game = this.getGame();
        Player player = freeColClient.getMyPlayer();
        String str = element.getAttribute("attacker");
        if (str.isEmpty()) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " missing attacker attribute.");
        }
        Unit u = game.getFreeColGameObject(str, Unit.class);
        if (u == null && (u = InGameInputHandler.selectUnitFromElement(game, element, str)) == null) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " omitted attacker: " + str);
        }
        Unit attacker = u;
        str = element.getAttribute("defender");
        if (str.isEmpty()) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " missing defender attribute.");
        }
        u = game.getFreeColGameObject(str, Unit.class);
        if (u == null && (u = InGameInputHandler.selectUnitFromElement(game, element, str)) == null) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " omitted defender: " + str);
        }
        Unit defender = u;
        str = element.getAttribute("attackerTile");
        if (str.isEmpty()) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " missing attacker tile attribute.");
        }
        Tile attackerTile = game.getFreeColGameObject(str, Tile.class);
        if (attackerTile == null) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " omitted attacker tile: " + str);
        }
        str = element.getAttribute("defenderTile");
        if (str.isEmpty()) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " missing defender tile attribute.");
        }
        Tile defenderTile = game.getFreeColGameObject(str, Tile.class);
        if (defenderTile == null) {
            throw new IllegalStateException("Attack animation for: " + player.getId() + " omitted defender tile: " + str);
        }
        boolean success = Boolean.parseBoolean(element.getAttribute("success"));
        this.invokeAndWait(() -> this.igc().animateAttack(attacker, defender, attackerTile, defenderTile, success));
        return null;
    }

    private Element animateMove(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        Game game = this.getGame();
        Player player = freeColClient.getMyPlayer();
        String unitId = element.getAttribute("unit");
        if (unitId.isEmpty()) {
            logger.warning("Animation for: " + player.getId() + " missing unitId.");
            return null;
        }
        Unit u = game.getFreeColGameObject(unitId, Unit.class);
        if (u == null) {
            u = InGameInputHandler.selectUnitFromElement(game, element, unitId);
        }
        if (u == null) {
            logger.warning("Animation for: " + player.getId() + " missing unit:" + unitId);
            return null;
        }
        Unit unit = u;
        String oldTileId = element.getAttribute("oldTile");
        if (oldTileId.isEmpty()) {
            logger.warning("Animation for: " + player.getId() + " missing oldTileId");
            return null;
        }
        Tile oldTile = game.getFreeColGameObject(oldTileId, Tile.class);
        if (oldTile == null) {
            logger.warning("Animation for: " + player.getId() + " missing oldTile: " + oldTileId);
            return null;
        }
        String newTileId = element.getAttribute("newTile");
        if (newTileId.isEmpty()) {
            logger.warning("Animation for: " + player.getId() + " missing newTileId");
            return null;
        }
        Tile newTile = game.getFreeColGameObject(newTileId, Tile.class);
        if (newTile == null) {
            logger.warning("Animation for: " + player.getId() + " missing newTile: " + newTileId);
            return null;
        }
        this.invokeAndWait(() -> this.igc().animateMove(unit, oldTile, newTile));
        return null;
    }

    private Element chat(Element element) {
        Game game = this.getGame();
        ChatMessage chatMessage = new ChatMessage(game, element);
        this.invokeLater(() -> this.igc().chat(chatMessage.getPlayer(game), chatMessage.getMessage(), chatMessage.isPrivate()));
        return null;
    }

    private Element chooseFoundingFather(Element element) {
        ChooseFoundingFatherMessage message = new ChooseFoundingFatherMessage(this.getGame(), element);
        List<FoundingFather> ffs = message.getFathers();
        this.invokeLater(() -> this.igc().chooseFoundingFather(ffs));
        return null;
    }

    private Element closeMenus() {
        this.invokeAndWait(this.closeMenusRunnable);
        return null;
    }

    private Element diplomacy(Element element) {
        Game game = this.getGame();
        DiplomacyMessage message = new DiplomacyMessage(this.getGame(), element);
        DiplomaticTrade agreement = message.getAgreement();
        FreeColGameObject our = message.getOurFCGO(game);
        if (our == null) {
            logger.warning("Our FCGO omitted from diplomacy message.");
            return null;
        }
        FreeColGameObject other = message.getOtherFCGO(game);
        if (other == null) {
            logger.warning("Other FCGO omitted from diplomacy message.");
            return null;
        }
        this.invokeAndWait(() -> message.setAgreement(this.igc().diplomacy(our, other, agreement)));
        return message.getAgreement() == null ? null : message.toXMLElement();
    }

    private Element disposeUnits(Element element) {
        Game game = this.getGame();
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String id = FreeColObject.readId(e);
            Unit u = game.getFreeColGameObject(id, Unit.class);
            if (u == null) {
                logger.warning("Object is not a unit");
                continue;
            }
            u.dispose();
        }
        return null;
    }

    private Element error(Element element) {
        String messageId = element.getAttribute("messageID");
        String message = element.getAttribute("message");
        this.invokeLater(() -> this.igc().error(messageId, message));
        return null;
    }

    private Element featureChange(Element element) {
        Game game = this.getGame();
        Specification spec = game.getSpecification();
        boolean add = "add".equalsIgnoreCase(element.getAttribute("add"));
        String id = FreeColObject.readId(element);
        FreeColGameObject object = game.getFreeColGameObject(id);
        if (object == null) {
            logger.warning("featureChange with null object");
            return null;
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element e = (Element)nodes.item(i);
            String tag = e.getTagName();
            if (Ability.getXMLElementTagName().equals(tag)) {
                if (add) {
                    object.addAbility(new Ability(e, spec));
                    continue;
                }
                object.removeAbility(new Ability(e, spec));
                continue;
            }
            if (Modifier.getXMLElementTagName().equals(tag)) {
                if (add) {
                    object.addModifier(new Modifier(e, spec));
                    continue;
                }
                object.removeModifier(new Modifier(e, spec));
                continue;
            }
            logger.warning("featureChange unrecognized: " + tag);
        }
        return null;
    }

    private Element firstContact(Element element) {
        Game game = this.getGame();
        FirstContactMessage message = new FirstContactMessage(game, element);
        Player player = message.getPlayer(game);
        if (player == null || player != this.getFreeColClient().getMyPlayer()) {
            logger.warning("firstContact with bad player: " + player);
            return null;
        }
        Player other = message.getOtherPlayer(game);
        if (other == null || other == player || !other.isIndian()) {
            logger.warning("firstContact with bad other player: " + other);
            return null;
        }
        Tile tile = message.getTile(game);
        if (tile != null && tile.getOwner() != other) {
            logger.warning("firstContact with bad tile: " + tile);
            return null;
        }
        int n = message.getSettlementCount();
        this.invokeLater(() -> this.igc().firstContact(player, other, tile, n));
        return null;
    }

    private Element fountainOfYouth(Element element) {
        int n = InGameInputHandler.getIntegerAttribute(element, "migrants");
        if (n <= 0) {
            logger.warning("Invalid migrants attribute: " + element.getAttribute("migrants"));
            return null;
        }
        this.invokeLater(() -> this.igc().fountainOfYouth(n));
        return null;
    }

    private Element gameEnded(Element element) {
        FreeColClient freeColClient = this.getFreeColClient();
        FreeColDebugger.finishDebugRun(freeColClient, true);
        Player winner = this.getGame().getFreeColGameObject(element.getAttribute("winner"), Player.class);
        if (winner == null) {
            logger.warning("Invalid player for gameEnded");
            return null;
        }
        String highScore = element.getAttribute("highScore");
        if (winner == freeColClient.getMyPlayer()) {
            this.invokeLater(() -> this.igc().victory(highScore));
        }
        return null;
    }

    private Element indianDemand(Element element) {
        Game game = this.getGame();
        Player player = this.getFreeColClient().getMyPlayer();
        IndianDemandMessage message = new IndianDemandMessage(game, element);
        Unit unit = message.getUnit(game);
        if (unit == null) {
            logger.warning("IndianDemand with null unit: " + element.getAttribute("unit"));
            return null;
        }
        Colony colony = message.getColony(game);
        if (colony == null) {
            logger.warning("IndianDemand with null colony: " + element.getAttribute("colony"));
            return null;
        }
        if (!player.owns(colony)) {
            throw new IllegalArgumentException("Demand to anothers colony");
        }
        this.invokeAndWait(() -> message.setResult(this.igc().indianDemand(unit, colony, message.getType(game), message.getAmount())));
        return message.toXMLElement();
    }

    private Element lootCargo(Element element) {
        Game game = this.getGame();
        LootCargoMessage message = new LootCargoMessage(game, element);
        Unit unit = message.getUnit(game);
        String defenderId = message.getDefenderId();
        List<Goods> goods = message.getGoods();
        if (unit == null || goods == null) {
            return null;
        }
        this.invokeLater(() -> this.igc().loot(unit, goods, defenderId));
        return null;
    }

    private Element monarchAction(Element element) {
        Game game = this.getGame();
        MonarchActionMessage message = new MonarchActionMessage(game, element);
        this.invokeLater(() -> this.igc().monarch(message.getAction(), message.getTemplate(), message.getMonarchKey()));
        return null;
    }

    private Element multiple(Connection connection, Element element) {
        NodeList nodes = element.getChildNodes();
        ArrayList<Element> results = new ArrayList<Element>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            try {
                Element reply = this.handle(connection, (Element)nodes.item(i));
                if (reply == null) continue;
                results.add(reply);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Caught crash in multiple item " + i + ", continuing.", e);
            }
        }
        return DOMMessage.collapseElements(results);
    }

    private Element newLandName(Element element) {
        Game game = this.getGame();
        NewLandNameMessage message = new NewLandNameMessage(game, element);
        Unit unit = message.getUnit(this.getFreeColClient().getMyPlayer());
        String defaultName = message.getNewLandName();
        if (unit == null || defaultName == null || !unit.hasTile()) {
            return null;
        }
        this.invokeLater(() -> this.igc().newLandName(defaultName, unit));
        return null;
    }

    private Element newRegionName(Element element) {
        Game game = this.getGame();
        NewRegionNameMessage message = new NewRegionNameMessage(game, element);
        Tile tile = message.getTile(game);
        Unit unit = message.getUnit(this.getFreeColClient().getMyPlayer());
        Region region = message.getRegion(game);
        String defaultName = message.getNewRegionName();
        if (defaultName == null || region == null) {
            return null;
        }
        this.invokeLater(() -> this.igc().newRegionName(region, defaultName, tile, unit));
        return null;
    }

    private Element newTurn(Element element) {
        int n = InGameInputHandler.getIntegerAttribute(element, "turn");
        if (n < 0) {
            logger.warning("Invalid turn for newTurn");
            return null;
        }
        this.invokeLater(() -> this.igc().newTurn(n));
        return null;
    }

    private Element reconnect(Element element) {
        logger.finest("Entered reconnect.");
        this.invokeLater(this.reconnectRunnable);
        return null;
    }

    private Element remove(Element element) {
        Game game = this.getGame();
        FreeColGameObject divert = game.getFreeColGameObject(element.getAttribute("divert"));
        ArrayList<FreeColGameObject> objects = new ArrayList<FreeColGameObject>();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element e = (Element)nodeList.item(i);
            String idString = FreeColObject.readId(e);
            FreeColGameObject fcgo = game.getFreeColGameObject(idString);
            if (fcgo == null) continue;
            objects.add(fcgo);
        }
        if (!objects.isEmpty()) {
            this.invokeLater(() -> this.igc().remove(objects, divert));
        }
        return null;
    }

    private Element setAI(Element element) {
        Game game = this.getGame();
        Player p = game.getFreeColGameObject(element.getAttribute("player"), Player.class);
        p.setAI(Boolean.parseBoolean(element.getAttribute("ai")));
        return null;
    }

    private Element setCurrentPlayer(Element element) {
        Player player = this.getGame().getFreeColGameObject(element.getAttribute("player"), Player.class);
        if (player == null) {
            logger.warning("Invalid player for setCurrentPlayer");
            return null;
        }
        this.igc().setCurrentPlayer(player);
        return null;
    }

    private Element setDead(Element element) {
        Player player = this.getGame().getFreeColGameObject(element.getAttribute("player"), Player.class);
        if (player == null) {
            logger.warning("Invalid player for setDead");
            return null;
        }
        this.invokeLater(() -> this.igc().setDead(player));
        return null;
    }

    private Element setStance(Element element) {
        Game game = this.getGame();
        Stance stance = Enum.valueOf(Stance.class, element.getAttribute("stance"));
        if (stance == null) {
            logger.warning("Invalid stance for setStance");
            return null;
        }
        Player p1 = game.getFreeColGameObject(element.getAttribute("first"), Player.class);
        if (p1 == null) {
            logger.warning("Invalid player1 for setStance");
            return null;
        }
        Player p2 = game.getFreeColGameObject(element.getAttribute("second"), Player.class);
        if (p2 == null) {
            logger.warning("Invalid player2 for setStance");
            return null;
        }
        this.invokeLater(() -> this.igc().setStance(stance, p1, p2));
        return null;
    }

    private Element spyResult(Element element) {
        String tileId;
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() != 2) {
            logger.warning("spyResult length = " + nodeList.getLength());
            return null;
        }
        Game game = this.getGame();
        Tile tile = game.getFreeColGameObject(tileId = element.getAttribute("tile"), Tile.class);
        if (tile == null) {
            logger.warning("spyResult bad tile = " + tileId);
            return null;
        }
        Element fullElement = (Element)nodeList.item(0);
        Element normalElement = (Element)nodeList.item(1);
        tile.readFromXMLElement(fullElement);
        this.invokeLater(() -> this.igc().spyColony(tile, () -> tile.readFromXMLElement(normalElement)));
        return null;
    }

    private Element update(Element element) {
        Player player = this.getFreeColClient().getMyPlayer();
        boolean visibilityChange = false;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element e = (Element)nodeList.item(i);
            String id = FreeColObject.readId(e);
            FreeColGameObject fcgo = this.getGame().getFreeColGameObject(id);
            if (fcgo == null) {
                logger.warning("Update object not present in client: " + id);
            } else {
                fcgo.readFromXMLElement(e);
            }
            if ((!(fcgo instanceof Player) || fcgo != player) && (!(fcgo instanceof Settlement) && !(fcgo instanceof Unit) || !player.owns((Ownable)((Object)fcgo)))) continue;
            visibilityChange = true;
        }
        if (visibilityChange) {
            player.invalidateCanSeeTiles();
        }
        return null;
    }
}

