/*
 * Decompiled with CFR 0.152.
 */
package org.fibs.geotag.webserver;

import fi.iki.elonen.NanoHTTPD;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.fibs.geotag.Settings;
import org.fibs.geotag.external.ExternalUpdate;
import org.fibs.geotag.external.ExternalUpdateConsumer;
import org.fibs.geotag.webserver.ContextHandler;
import org.fibs.geotag.webserver.WebServer;

public class UpdateHandler
implements ContextHandler {
    private ExternalUpdateConsumer parent;

    public UpdateHandler(ExternalUpdateConsumer parent) {
        this.parent = parent;
    }

    @Override
    public NanoHTTPD.Response serve(WebServer server, String uri, String method, Properties header, Properties parms) {
        Double latitude = null;
        Double longitude = null;
        Double direction = null;
        Integer image = null;
        Enumeration<Object> parameters = parms.keys();
        while (parameters.hasMoreElements()) {
            String parameter = (String)parameters.nextElement();
            String value = parms.getProperty(parameter);
            if (parameter.equals("latitude")) {
                latitude = new Double(Double.parseDouble(value));
                continue;
            }
            if (parameter.equals("longitude")) {
                longitude = new Double(Double.parseDouble(value));
                continue;
            }
            if (parameter.equals("image")) {
                image = Integer.parseInt(value);
                continue;
            }
            if (!parameter.equals("direction")) continue;
            direction = new Double(Double.parseDouble(value));
        }
        if (latitude != null && longitude != null && image != null) {
            ExternalUpdate externalUpdate = new ExternalUpdate(image, latitude, longitude, direction == null ? Double.NaN : direction);
            final ArrayList<ExternalUpdate> updateList = new ArrayList<ExternalUpdate>();
            updateList.add(externalUpdate);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    UpdateHandler.this.getParent().processExternalUpdates(updateList);
                }
            });
            Settings.put(Settings.SETTING.LAST_GOOGLE_MAPS_LATITUDE, latitude.toString());
            Settings.put(Settings.SETTING.LAST_GOOGLE_MAPS_LONGITUDE, longitude.toString());
        }
        return server.xmlResponse("<ok/>");
    }

    ExternalUpdateConsumer getParent() {
        return this.parent;
    }
}

