/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.protege.editor.owl.model.util.OWLUtilities;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeprecationCache {
    private static final Logger logger = LoggerFactory.getLogger(DeprecationCache.class);
    private final Set<IRI> deprecatedEntities = new HashSet<IRI>();
    @Nonnull
    private final OWLAnnotationProperty owlDeprecatedAnnotationProperty;

    public DeprecationCache(@Nonnull OWLAnnotationProperty owlDeprecatedAnnotationProperty) {
        this.owlDeprecatedAnnotationProperty = owlDeprecatedAnnotationProperty;
    }

    public boolean isDeprecated(@Nonnull OWLObject object) {
        IRI iri;
        if (object instanceof IRI) {
            iri = (IRI)object;
        } else if (object instanceof OWLEntity) {
            iri = ((OWLEntity)object).getIRI();
        } else {
            return false;
        }
        return this.deprecatedEntities.contains(iri);
    }

    public void rebuildCacheFromActiveOntologies(@Nonnull Collection<OWLOntology> ontologies) {
        logger.debug("[DeprecationCache] Rebuilding deprecated entities cache");
        this.deprecatedEntities.clear();
        ontologies.forEach(o -> o.getReferencingAxioms((OWLPrimitive)this.owlDeprecatedAnnotationProperty).stream().filter(ax -> ax instanceof OWLAnnotationAssertionAxiom).map(ax -> (OWLAnnotationAssertionAxiom)ax).filter(ax -> ax.getSubject() instanceof IRI).map(ax -> (IRI)ax.getSubject()).forEach(this.deprecatedEntities::add));
    }

    public void handleOntologyChanges(@Nonnull List<? extends OWLOntologyChange> changes, @Nonnull Collection<OWLOntology> ontologies) {
        logger.debug("[DeprecationCache] Updating deprecated entities cache");
        changes.stream().filter(OWLOntologyChange::isAxiomChange).map(chg -> (OWLAxiomChange)chg).filter(chg -> chg.getAxiom() instanceof OWLAnnotationAssertionAxiom).map(chg -> (OWLAnnotationAssertionAxiom)chg.getAxiom()).filter(ax -> ax.getProperty().isDeprecated()).filter(ax -> ax.getSubject() instanceof IRI).map(ax -> (IRI)ax.getSubject()).distinct().forEach(iri -> {
            if (OWLUtilities.isDeprecated(iri, ontologies)) {
                this.deprecatedEntities.add((IRI)iri);
            } else {
                this.deprecatedEntities.remove(iri);
            }
        });
    }
}

