/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.extensions.impl;

import com.intellij.diagnostic.ActivityCategory;
import com.intellij.diagnostic.StartUpMeasurer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionException;
import com.intellij.openapi.extensions.ExtensionNotApplicableException;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointAdapter;
import com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.LoadingOrder;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.PicoContainer;

public abstract class ExtensionPointImpl<T>
implements ExtensionPoint<T>,
Iterable<T> {
    static final Logger LOG = Logger.getInstance("#com.intellij.openapi.extensions.impl.ExtensionPointImpl");
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    private static final ArrayFactory<ExtensionPointListener<?>> LISTENER_ARRAY_FACTORY;
    private final String myName;
    private final String myClassName;
    private volatile List<T> myExtensionsCache;
    @Nullable
    private volatile T[] myExtensionsCacheAsArray;
    @NotNull
    final ComponentManager myComponentManager;
    @NotNull
    private final PluginDescriptor myDescriptor;
    @NotNull
    private List<ExtensionComponentAdapter> myAdapters;
    private boolean myAdaptersIsSorted;
    @NotNull
    private ExtensionPointListener<T>[] myListeners;
    @Nullable
    Class<T> myExtensionClass;
    private final boolean myDynamic;
    private static Runnable CHECK_CANCELED;

    ExtensionPointImpl(@NotNull String name, @NotNull String className2, @NotNull ComponentManager componentManager, @NotNull PluginDescriptor pluginDescriptor, boolean dynamic) {
        if (name == null) {
            ExtensionPointImpl.$$$reportNull$$$0(0);
        }
        if (className2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        if (componentManager == null) {
            ExtensionPointImpl.$$$reportNull$$$0(2);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        this.myAdapters = Collections.emptyList();
        this.myAdaptersIsSorted = true;
        this.myListeners = ExtensionPointListener.EMPTY_ARRAY;
        this.myName = name;
        this.myClassName = className2;
        this.myComponentManager = componentManager;
        this.myDescriptor = pluginDescriptor;
        this.myDynamic = dynamic;
    }

    @NotNull
    public String getName() {
        String string2 = this.myName;
        if (string2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(4);
        }
        return string2;
    }

    @NotNull
    public String getClassName() {
        String string2 = this.myClassName;
        if (string2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(5);
        }
        return string2;
    }

    @Override
    public void registerExtension(@NotNull T extension2) {
        if (extension2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(6);
        }
        this.doRegisterExtension(extension2, LoadingOrder.ANY, null);
    }

    @Override
    public void registerExtension(@NotNull T extension2, @NotNull Disposable parentDisposable) {
        if (extension2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(10);
        }
        this.doRegisterExtension(extension2, LoadingOrder.ANY, parentDisposable);
    }

    @NotNull
    final PluginDescriptor getDescriptor() {
        PluginDescriptor pluginDescriptor = this.myDescriptor;
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(11);
        }
        return pluginDescriptor;
    }

    private synchronized void doRegisterExtension(@NotNull T extension2, @NotNull LoadingOrder order2, @Nullable Disposable parentDisposable) {
        if (extension2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(15);
        }
        if (order2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(16);
        }
        this.assertNotReadOnlyMode();
        this.checkExtensionType(extension2, this.getExtensionClass(), null);
        for (ExtensionComponentAdapter adapter : this.myAdapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || ExtensionPointImpl.castComponentInstance(adapter) != extension2) continue;
            LOG.error("Extension was already added: " + extension2);
            return;
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension2, this.getDescriptor(), order2);
        this.addExtensionAdapter(adapter);
        this.notifyListenersOnAdd(extension2, adapter.getPluginDescriptor(), this.myListeners);
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> {
                ExtensionPointImpl extensionPointImpl = this;
                synchronized (extensionPointImpl) {
                    List<ExtensionComponentAdapter> list2 = this.myAdapters;
                    int index2 = ContainerUtil.indexOfIdentity(list2, adapter);
                    if (index2 < 0) {
                        LOG.error("Extension to be removed not found: " + adapter.myComponentInstance);
                    }
                    list2.remove(index2);
                    this.clearCache();
                    this.notifyListenersOnRemove(adapter.myComponentInstance, adapter.getPluginDescriptor(), this.myListeners);
                }
            });
        }
    }

    private synchronized void checkExtensionType(@NotNull T extension2, @NotNull Class<T> extensionClass, @Nullable ExtensionComponentAdapter adapter) {
        if (extension2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(18);
        }
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(19);
        }
        if (!extensionClass.isInstance(extension2)) {
            String message2 = "Extension " + extension2.getClass() + " does not implement " + extensionClass;
            if (adapter != null) {
                message2 = message2 + ". It came from " + adapter;
            }
            throw new ExtensionException(message2, extension2.getClass());
        }
    }

    private void notifyListenersOnAdd(@NotNull T extension2, @NotNull PluginDescriptor pluginDescriptor, @NotNull ExtensionPointListener<T>[] listeners) {
        if (extension2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(20);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(21);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(22);
        }
        for (ExtensionPointListener<T> listener : listeners) {
            try {
                listener.extensionAdded(extension2, pluginDescriptor);
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<T> getExtensionList() {
        List<T> result2 = this.myExtensionsCache;
        if (result2 == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                result2 = this.myExtensionsCache;
                if (result2 == null) {
                    T[] array = this.processAdapters();
                    this.myExtensionsCacheAsArray = array;
                    this.myExtensionsCache = result2 = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
                }
            }
        }
        List<T> list2 = result2;
        if (list2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(23);
        }
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public T[] getExtensions() {
        T[] array = this.myExtensionsCacheAsArray;
        if (array == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                array = this.myExtensionsCacheAsArray;
                if (array == null) {
                    this.myExtensionsCacheAsArray = array = this.processAdapters();
                    this.myExtensionsCache = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
                }
            }
        }
        Object[] objectArray = array.length == 0 ? array : (Object[])array.clone();
        if (objectArray == null) {
            ExtensionPointImpl.$$$reportNull$$$0(24);
        }
        return objectArray;
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public final Iterator<T> iterator() {
        List<T> result2 = this.myExtensionsCache;
        Iterator<T> iterator2 = result2 == null ? this.createIterator() : result2.iterator();
        if (iterator2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(25);
        }
        return iterator2;
    }

    @NotNull
    private synchronized List<ExtensionComponentAdapter> getThreadSafeAdapterList(boolean failIfListenerAdded) {
        CHECK_CANCELED.run();
        if (!this.myDynamic && this.myListeners.length > 0) {
            String message2 = "Listeners not allowed for extension point " + this.getName();
            if (failIfListenerAdded) {
                LOG.error(message2);
            } else {
                LOG.warn(message2);
                this.getExtensionList();
            }
        }
        List<ExtensionComponentAdapter> list2 = ContainerUtil.copyList(this.getSortedAdapters());
        if (list2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(27);
        }
        return list2;
    }

    @NotNull
    private Iterator<T> createIterator() {
        final List<ExtensionComponentAdapter> adapters = this.getThreadSafeAdapterList(true);
        final int size = adapters.size();
        if (size == 0) {
            Iterator iterator2 = Collections.emptyIterator();
            if (iterator2 == null) {
                ExtensionPointImpl.$$$reportNull$$$0(28);
            }
            return iterator2;
        }
        return new Iterator<T>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return this.currentIndex < size;
            }

            @Override
            @Nullable
            public T next() {
                do {
                    Object extension2;
                    if ((extension2 = ExtensionPointImpl.this.processAdapter((ExtensionComponentAdapter)adapters.get(this.currentIndex++))) == null) continue;
                    return extension2;
                } while (this.hasNext());
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasAnyExtensions() {
        List<T> cache2 = this.myExtensionsCache;
        if (cache2 != null) {
            return !cache2.isEmpty();
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            return !this.myAdapters.isEmpty();
        }
    }

    @NotNull
    private synchronized List<ExtensionComponentAdapter> getSortedAdapters() {
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        if (!this.myAdaptersIsSorted) {
            LoadingOrder.sort(adapters);
            this.myAdaptersIsSorted = true;
        }
        List<ExtensionComponentAdapter> list2 = adapters;
        if (list2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(30);
        }
        return list2;
    }

    @NotNull
    private synchronized T[] processAdapters() {
        this.assertNotReadOnlyMode();
        CHECK_CANCELED.run();
        long startTime = StartUpMeasurer.getCurrentTime();
        List<ExtensionComponentAdapter> adapters = this.getSortedAdapters();
        int totalSize = adapters.size();
        Class<T> extensionClass = this.getExtensionClass();
        T[] result2 = ArrayUtil.newArray(extensionClass, totalSize);
        if (totalSize == 0) {
            if (result2 == null) {
                ExtensionPointImpl.$$$reportNull$$$0(31);
            }
            return result2;
        }
        OpenTHashSet duplicates = this instanceof BeanExtensionPoint ? null : new OpenTHashSet(totalSize);
        ExtensionPointListener<T>[] listeners = this.myListeners;
        int extensionIndex = 0;
        for (int i = 0; i < adapters.size(); ++i) {
            T extension2 = this.processAdapter(adapters.get(i), listeners, result2, duplicates, extensionClass, adapters);
            if (extension2 == null) continue;
            result2[extensionIndex++] = extension2;
        }
        if (extensionIndex != result2.length) {
            result2 = Arrays.copyOf(result2, extensionIndex);
        }
        ActivityCategory category = ExtensionPointImpl.getActivityCategory(this.myComponentManager.getPicoContainer());
        StartUpMeasurer.addCompletedActivity(startTime, extensionClass, category, null, StartUpMeasurer.MEASURE_THRESHOLD);
        if (result2 == null) {
            ExtensionPointImpl.$$$reportNull$$$0(32);
        }
        return result2;
    }

    @NotNull
    public static ActivityCategory getActivityCategory(@NotNull PicoContainer picoContainer) {
        PicoContainer parent2;
        if (picoContainer == null) {
            ExtensionPointImpl.$$$reportNull$$$0(33);
        }
        if ((parent2 = picoContainer.getParent()) == null) {
            ActivityCategory activityCategory = ActivityCategory.APP_EXTENSION;
            if (activityCategory == null) {
                ExtensionPointImpl.$$$reportNull$$$0(34);
            }
            return activityCategory;
        }
        if (parent2.getParent() == null) {
            ActivityCategory activityCategory = ActivityCategory.PROJECT_EXTENSION;
            if (activityCategory == null) {
                ExtensionPointImpl.$$$reportNull$$$0(35);
            }
            return activityCategory;
        }
        ActivityCategory activityCategory = ActivityCategory.MODULE_EXTENSION;
        if (activityCategory == null) {
            ExtensionPointImpl.$$$reportNull$$$0(36);
        }
        return activityCategory;
    }

    private T processAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(37);
        }
        return this.processAdapter(adapter, null, null, null, null, null);
    }

    @Nullable
    private T processAdapter(@NotNull ExtensionComponentAdapter adapter, @Nullable ExtensionPointListener<T>[] listeners, @Nullable T[] result2, @Nullable OpenTHashSet<T> duplicates, @Nullable Class<T> extensionClassForCheck, @Nullable List<? extends ExtensionComponentAdapter> adapters) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(38);
        }
        try {
            T duplicate;
            boolean isNotifyThatAdded = listeners != null && listeners.length != 0 && !adapter.isInstanceCreated() && !this.myDynamic;
            Object extension2 = adapter.createInstance(this.myComponentManager);
            if (duplicates != null && !duplicates.add(extension2)) {
                duplicate = duplicates.get(extension2);
                assert (result2 != null);
            } else {
                if (extensionClassForCheck != null) {
                    this.checkExtensionType(extension2, extensionClassForCheck, adapter);
                }
                if (isNotifyThatAdded) {
                    this.notifyListenersOnAdd(extension2, adapter.getPluginDescriptor(), listeners);
                }
                return extension2;
            }
            LOG.error("Duplicate extension found:\n                   " + extension2 + ";\n  prev extension:  " + duplicate + ";\n  adapter:         " + adapter + ";\n  extension class: " + extensionClassForCheck + ";\n  result:          " + Arrays.asList(result2) + ";\n  adapters:        " + adapters);
        }
        catch (ExtensionNotApplicableException ignore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    @Override
    public void unregisterExtension(@NotNull Class<? extends T> extensionClass) {
        String classNameToUnregister;
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(43);
        }
        if (!this.unregisterExtensions((arg_0, arg_1) -> ExtensionPointImpl.lambda$unregisterExtension$2(classNameToUnregister = extensionClass.getCanonicalName(), arg_0, arg_1), true)) {
            LOG.warn("Extension to be removed not found: " + extensionClass);
        }
    }

    public synchronized boolean unregisterExtensions(@NotNull BiPredicate<? super String, ? super ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch) {
        if (extensionClassFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(44);
        }
        boolean found2 = false;
        for (int i = this.myAdapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = this.myAdapters.get(i);
            if (extensionClassFilter.test(adapter.getAssignableToClassName(), adapter)) continue;
            this.clearCache();
            this.removeAdapter(adapter, i);
            if (stopAfterFirstMatch) {
                return true;
            }
            found2 = true;
        }
        return found2;
    }

    private void notifyListenersOnRemove(@NotNull T extensionObject, @NotNull PluginDescriptor pluginDescriptor, @NotNull ExtensionPointListener<T>[] listeners) {
        if (extensionObject == null) {
            ExtensionPointImpl.$$$reportNull$$$0(45);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(46);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(47);
        }
        for (ExtensionPointListener<T> listener : listeners) {
            try {
                listener.extensionRemoved(extensionObject, pluginDescriptor);
            }
            catch (Throwable e) {
                LOG.error(e);
            }
        }
    }

    @Override
    public synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        boolean isAdded;
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(48);
        }
        if (invokeForLoadedExtensions) {
            this.getExtensionList();
        }
        if ((isAdded = this.addListener(listener)) && invokeForLoadedExtensions) {
            this.notifyListenersAboutLoadedExtensions(this.myAdapters, listener, false);
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listener));
        }
    }

    @NotNull
    private static <T> ArrayFactory<ExtensionPointListener<T>> listenerArrayFactory() {
        ArrayFactory<ExtensionPointListener<T>> arrayFactory = LISTENER_ARRAY_FACTORY;
        if (arrayFactory == null) {
            ExtensionPointImpl.$$$reportNull$$$0(49);
        }
        return arrayFactory;
    }

    private synchronized boolean addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(50);
        }
        if (ArrayUtil.indexOf(this.myListeners, listener) != -1) {
            return false;
        }
        this.myListeners = listener instanceof ExtensionPointPriorityListener ? ArrayUtil.prepend(listener, this.myListeners, ExtensionPointImpl.listenerArrayFactory()) : ArrayUtil.append(this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
        return true;
    }

    private synchronized void removeListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(51);
        }
        this.myListeners = ArrayUtil.remove(this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
    }

    @Override
    public void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(53);
        }
        this.removeListener(listener);
    }

    private static <T> T castComponentInstance(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(54);
        }
        return (T)((ObjectComponentAdapter)adapter).myComponentInstance;
    }

    private synchronized void notifyListenersAboutLoadedExtensions(@NotNull List<? extends ExtensionComponentAdapter> loadedAdapters, @Nullable ExtensionPointListener<T> onlyListener, boolean isRemoved) {
        ExtensionPointListener<T>[] listeners;
        if (loadedAdapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(55);
        }
        if ((listeners = this.myListeners).length == 0) {
            return;
        }
        T[] extensions = this.myExtensionsCacheAsArray;
        int size = loadedAdapters.size();
        for (int i = 0; i < size; ++i) {
            T extension2;
            ExtensionComponentAdapter adapter = loadedAdapters.get(i);
            if (adapter instanceof ObjectComponentAdapter) {
                extension2 = ExtensionPointImpl.castComponentInstance(adapter);
            } else {
                if (extensions == null) continue;
                extension2 = extensions[i];
            }
            if (isRemoved) {
                if (onlyListener == null) {
                    this.notifyListenersOnRemove(extension2, adapter.getPluginDescriptor(), listeners);
                    continue;
                }
                onlyListener.extensionRemoved(extension2, adapter.getPluginDescriptor());
                continue;
            }
            if (onlyListener == null) {
                this.notifyListenersOnAdd(extension2, adapter.getPluginDescriptor(), listeners);
                continue;
            }
            onlyListener.extensionAdded(extension2, adapter.getPluginDescriptor());
        }
    }

    @NotNull
    public Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.myDescriptor.getPluginClassLoader();
                Class<?> extClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
                this.myExtensionClass = extensionClass = extClass;
            }
            catch (ClassNotFoundException e) {
                throw this.myComponentManager.createError(e, this.myDescriptor.getPluginId());
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            ExtensionPointImpl.$$$reportNull$$$0(56);
        }
        return clazz;
    }

    public String toString() {
        return this.getName();
    }

    synchronized void addExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(57);
        }
        if (this.myAdapters == Collections.emptyList()) {
            this.myAdapters = new ArrayList<ExtensionComponentAdapter>();
        }
        this.myAdapters.add(adapter);
        this.clearCache();
    }

    synchronized void clearCache() {
        this.myExtensionsCache = null;
        this.myExtensionsCacheAsArray = null;
        this.myAdaptersIsSorted = false;
        this.assertNotReadOnlyMode();
    }

    private void assertNotReadOnlyMode() {
        if (this.isInReadOnlyMode()) {
            throw new IllegalStateException(this + " in a read-only mode and cannot be modified");
        }
    }

    private synchronized void removeAdapter(@NotNull ExtensionComponentAdapter adapter, int index2) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(58);
        }
        this.myAdapters.remove(index2);
        if (this.myListeners.length != 0 && adapter.isInstanceCreated()) {
            this.notifyListenersOnRemove(adapter.createInstance(this.myComponentManager), adapter.getPluginDescriptor(), this.myListeners);
        }
    }

    @NotNull
    protected abstract ExtensionComponentAdapter createAdapterAndRegisterInPicoContainerIfNeeded(@NotNull Element var1, @NotNull PluginDescriptor var2, @NotNull ComponentManager var3);

    final synchronized void registerExtensions(@NotNull List<? extends Element> extensionElements, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, boolean notifyListeners) {
        List<ExtensionComponentAdapter> adapters;
        if (extensionElements == null) {
            ExtensionPointImpl.$$$reportNull$$$0(62);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(63);
        }
        if (componentManager == null) {
            ExtensionPointImpl.$$$reportNull$$$0(64);
        }
        if ((adapters = this.myAdapters) == Collections.emptyList()) {
            this.myAdapters = adapters = new ArrayList<ExtensionComponentAdapter>(extensionElements.size());
            this.myAdaptersIsSorted = false;
        } else {
            ((ArrayList)adapters).ensureCapacity(adapters.size() + extensionElements.size());
        }
        int oldSize = adapters.size();
        for (Element element : extensionElements) {
            adapters.add(this.createAdapterAndRegisterInPicoContainerIfNeeded(element, pluginDescriptor, componentManager));
        }
        if (notifyListeners) {
            this.clearCache();
            for (ExtensionPointListener listener : this.myListeners) {
                if (listener instanceof ExtensionPointAdapter) {
                    ((ExtensionPointAdapter)listener).extensionListChanged();
                    continue;
                }
                for (int i = oldSize; i < adapters.size(); ++i) {
                    listener.extensionAdded(adapters.get(i).createInstance(componentManager), pluginDescriptor);
                }
            }
        }
    }

    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        if (oldArea == null) {
            ExtensionPointImpl.$$$reportNull$$$0(65);
        }
        for (ExtensionPointListener<T> listener : this.myListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(oldArea);
        }
    }

    private synchronized boolean isInReadOnlyMode() {
        return POINTS_IN_READONLY_MODE != null && POINTS_IN_READONLY_MODE.contains(this);
    }

    private static /* synthetic */ boolean lambda$unregisterExtension$2(String classNameToUnregister, String className2, ExtensionComponentAdapter adapter) {
        return !className2.equals(classNameToUnregister);
    }

    static {
        LISTENER_ARRAY_FACTORY = n -> n == 0 ? ExtensionPointListener.EMPTY_ARRAY : new ExtensionPointListener[n];
        CHECK_CANCELED = EmptyRunnable.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 49: 
            case 56: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 49: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 61: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 3: 
            case 21: 
            case 46: 
            case 60: 
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 49: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 18: 
            case 20: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 10: 
            case 14: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 19: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 22: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picoContainer";
                break;
            }
            case 37: 
            case 38: 
            case 54: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassFilter";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionObject";
                break;
            }
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedAdapters";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElements";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArea";
                break;
            }
            case 66: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strictMatch";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkCanceled";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescriptor";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionList";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getThreadSafeAdapterList";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "extensions";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedAdapters";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdapters";
                break;
            }
            case 34: 
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityCategory";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "listenerArrayFactory";
                break;
            }
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 49: 
            case 56: {
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtension";
                break;
            }
            case 17: 
            case 62: 
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkExtensionType";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnAdd";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processWithPluginDescriptor";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getActivityCategory";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "processAdapter";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "maskAll";
                break;
            }
            case 41: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersOnRemove";
                break;
            }
            case 48: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "removeListener";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "removeExtensionPointListener";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "castComponentInstance";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "notifyListenersAboutLoadedExtensions";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionAdapter";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "removeAdapter";
                break;
            }
            case 59: 
            case 60: 
            case 61: {
                objectArray = objectArray;
                objectArray[2] = "createAndRegisterAdapter";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
            case 66: 
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByExactClass";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "setCheckCanceledAction";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "isInsideClassInitializer";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 4: 
            case 5: 
            case 11: 
            case 23: 
            case 24: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 35: 
            case 36: 
            case 49: 
            case 56: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ObjectComponentAdapter<T>
    extends ExtensionComponentAdapter {
        private final T myComponentInstance;

        private ObjectComponentAdapter(@NotNull T extension2, @NotNull PluginDescriptor pluginDescriptor, @NotNull LoadingOrder loadingOrder) {
            if (extension2 == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(1);
            }
            if (loadingOrder == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(2);
            }
            super(extension2.getClass().getName(), pluginDescriptor, null, loadingOrder);
            this.myComponentInstance = extension2;
        }

        @Override
        boolean isInstanceCreated() {
            return true;
        }

        @NotNull
        public <I> I createInstance(@Nullable ComponentManager componentManager) {
            T t = this.myComponentInstance;
            if (t == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(3);
            }
            return (I)t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string2;
            switch (n) {
                default: {
                    string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string2 = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loadingOrder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string3 = String.format(string2, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string3);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string3);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

