/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.db.sql;

import java.io.File;
import org.zaproxy.zap.db.sql.HsqldbDatabaseServer;
import org.zaproxy.zap.db.sql.SqlDatabase;
import org.zaproxy.zap.db.sql.SqlDatabaseServer;

public class HsqldbDatabase
extends SqlDatabase {
    @Override
    public void deleteSession(String sessionName) {
        super.deleteSession(sessionName);
        this.logger.debug((Object)("deleteSession " + sessionName));
        this.deleteDbFile(new File(sessionName));
        this.deleteDbFile(new File(sessionName + ".data"));
        this.deleteDbFile(new File(sessionName + ".script"));
        this.deleteDbFile(new File(sessionName + ".properties"));
        this.deleteDbFile(new File(sessionName + ".backup"));
        this.deleteDbFile(new File(sessionName + ".lobs"));
    }

    private void deleteDbFile(File file) {
        this.logger.debug((Object)("Deleting " + file.getAbsolutePath()));
        if (file.exists() && !file.delete()) {
            this.logger.error((Object)("Failed to delete " + file.getAbsolutePath()));
        }
    }

    @Override
    protected SqlDatabaseServer createDatabaseServer(String path) throws Exception {
        return new HsqldbDatabaseServer(path);
    }

    @Override
    public void close(boolean compact, boolean cleanup) {
        this.logger.debug((Object)"close");
        super.close(compact, cleanup);
        if (this.getDatabaseServer() == null) {
            return;
        }
        try {
            ((HsqldbDatabaseServer)this.getDatabaseServer()).shutdown(compact);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isFileBased() {
        return true;
    }
}

