/*
 * Decompiled with CFR 0.152.
 */
package org.ice4j.socket;

import java.net.DatagramPacket;
import java.net.SocketException;
import java.util.LinkedList;

abstract class SocketReceiveBuffer
extends LinkedList<DatagramPacket> {
    private static final int DEFAULT_RECEIVE_BUFFER_SIZE = 0x100000;
    private static final long serialVersionUID = 2804762379509257652L;
    private int receiveBufferSize;
    private int size;

    SocketReceiveBuffer() {
    }

    @Override
    public boolean add(DatagramPacket p) {
        int pSize;
        boolean added = super.add(p);
        if (added && p != null && (pSize = p.getLength()) > 0) {
            this.size += pSize;
            if (this.size() > 1) {
                int receiveBufferSize = this.receiveBufferSize;
                if (receiveBufferSize <= 0 || this.modCount % 1000 == 0) {
                    try {
                        receiveBufferSize = this.getReceiveBufferSize();
                    }
                    catch (SocketException socketException) {
                        // empty catch block
                    }
                    if (receiveBufferSize <= 0) {
                        receiveBufferSize = 0x100000;
                    } else if (receiveBufferSize < 0x100000 && (receiveBufferSize *= 2) <= 0) {
                        receiveBufferSize = 0x100000;
                    }
                    this.receiveBufferSize = receiveBufferSize;
                }
                if (this.size > receiveBufferSize) {
                    this.remove(0);
                }
            }
        }
        return added;
    }

    public abstract int getReceiveBufferSize() throws SocketException;

    @Override
    public DatagramPacket remove(int index) {
        int pSize;
        DatagramPacket p = (DatagramPacket)super.remove(index);
        if (p != null && (pSize = p.getLength()) > 0) {
            this.size -= pSize;
            if (this.size < 0) {
                this.size = 0;
            }
        }
        return p;
    }
}

