/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import sun.awt.X11.Native;
import sun.awt.X11.XAtom;
import sun.awt.X11.XWrapperBase;
import sun.awt.X11.XlibWrapper;
import sun.misc.Unsafe;

public class XClientMessageEvent
extends XWrapperBase {
    private Unsafe unsafe = XlibWrapper.unsafe;
    private final boolean should_free_memory;
    long pData;

    public static int getSize() {
        return 48;
    }

    @Override
    public int getDataSize() {
        return XClientMessageEvent.getSize();
    }

    @Override
    public long getPData() {
        return this.pData;
    }

    public XClientMessageEvent(long l) {
        log.finest("Creating");
        this.pData = l;
        this.should_free_memory = false;
    }

    public XClientMessageEvent() {
        log.finest("Creating");
        this.pData = this.unsafe.allocateMemory(XClientMessageEvent.getSize());
        this.should_free_memory = true;
    }

    public void dispose() {
        log.finest("Disposing");
        if (this.should_free_memory) {
            log.finest("freeing memory");
            this.unsafe.freeMemory(this.pData);
        }
    }

    public int get_type() {
        log.finest("");
        return Native.getInt(this.pData + 0L);
    }

    public void set_type(int n) {
        log.finest("");
        Native.putInt(this.pData + 0L, n);
    }

    public long get_serial() {
        log.finest("");
        return Native.getLong(this.pData + 4L);
    }

    public void set_serial(long l) {
        log.finest("");
        Native.putLong(this.pData + 4L, l);
    }

    public boolean get_send_event() {
        log.finest("");
        return Native.getBool(this.pData + 8L);
    }

    public void set_send_event(boolean bl) {
        log.finest("");
        Native.putBool(this.pData + 8L, bl);
    }

    public long get_display() {
        log.finest("");
        return Native.getLong(this.pData + 12L);
    }

    public void set_display(long l) {
        log.finest("");
        Native.putLong(this.pData + 12L, l);
    }

    public long get_window() {
        log.finest("");
        return Native.getLong(this.pData + 16L);
    }

    public void set_window(long l) {
        log.finest("");
        Native.putLong(this.pData + 16L, l);
    }

    public long get_message_type() {
        log.finest("");
        return Native.getLong(this.pData + 20L);
    }

    public void set_message_type(long l) {
        log.finest("");
        Native.putLong(this.pData + 20L, l);
    }

    public int get_format() {
        log.finest("");
        return Native.getInt(this.pData + 24L);
    }

    public void set_format(int n) {
        log.finest("");
        Native.putInt(this.pData + 24L, n);
    }

    public long get_data(int n) {
        log.finest("");
        return Native.getLong(this.pData + 28L + (long)(n * Native.getLongSize()));
    }

    public void set_data(int n, long l) {
        log.finest("");
        Native.putLong(this.pData + 28L + (long)(n * Native.getLongSize()), l);
    }

    public long get_data() {
        log.finest("");
        return this.pData + 28L;
    }

    @Override
    String getName() {
        return "XClientMessageEvent";
    }

    @Override
    String getFieldsAsString() {
        StringBuilder stringBuilder = new StringBuilder(320);
        stringBuilder.append("type = ").append(XlibWrapper.eventToString[this.get_type()]).append(", ");
        stringBuilder.append("serial = ").append(this.get_serial()).append(", ");
        stringBuilder.append("send_event = ").append(this.get_send_event()).append(", ");
        stringBuilder.append("display = ").append(this.get_display()).append(", ");
        stringBuilder.append("window = ").append(this.getWindow(this.get_window())).append(", ");
        stringBuilder.append("message_type = ").append(XAtom.get(this.get_message_type())).append(", ");
        stringBuilder.append("format = ").append(this.get_format()).append(", ");
        stringBuilder.append("{").append(this.get_data(0)).append(" ").append(this.get_data(1)).append(" ").append(this.get_data(2)).append(" ").append(this.get_data(3)).append(" ").append(this.get_data(4)).append(" ").append("}");
        return stringBuilder.toString();
    }
}

