/*
 * Copyright (c) 2012, 2020, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_uz extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Moskva standart vaqti",
               "",
               "Moskva yozgi vaqti",
               "",
               "Moskva vaqti",
               "",
            };
        final String[] Pakistan = new String[] {
               "Pokiston standart vaqti",
               "",
               "Pokiston yozgi vaqti",
               "",
               "Pokiston vaqti",
               "",
            };
        final String[] Magadan = new String[] {
               "Magadan standart vaqti",
               "",
               "Magadan yozgi vaqti",
               "",
               "Magadan vaqti",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Markaziy Yevropa standart vaqti",
               "",
               "Markaziy Yevropa yozgi vaqti",
               "",
               "Markaziy Yevropa vaqti",
               "",
            };
        final String[] America_Eastern = new String[] {
               "Sharqiy Amerika standart vaqti",
               "",
               "Sharqiy Amerika yozgi vaqti",
               "",
               "Sharqiy Amerika vaqti",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Lord-Xau standart vaqti",
               "",
               "Lord-Xau yozgi vaqti",
               "",
               "Lord-Xau vaqti",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Yangi Zelandiya standart vaqti",
               "",
               "Yangi Zelandiya yozgi vaqti",
               "",
               "Yangi Zelandiya vaqti",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hind okeani vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Yakutsk standart vaqti",
               "",
               "Yakutsk yozgi vaqti",
               "",
               "Yakutsk vaqti",
               "",
            };
        final String[] East_Timor = new String[] {
               "Sharqiy Timor vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kosrae = new String[] {
               "Kosrae vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "Sharqiy Yevropa standart vaqti",
               "",
               "Sharqiy Yevropa yozgi vaqti",
               "",
               "Sharqiy Yevropa vaqti",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "G\u02bbarbiy Argentina standart vaqti",
               "",
               "G\u02bbarbiy Argentina yozgi vaqti",
               "",
               "G\u02bbarbiy Argentina vaqti",
               "",
            };
        final String[] Ponape = new String[] {
               "Ponape vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Bolivia = new String[] {
               "Boliviya vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Sen-Pyer va Mikelon standart vaqti",
               "",
               "Sen-Pyer va Mikelon yozgi vaqti",
               "",
               "Sen-Pyer va Mikelon vaqti",
               "",
            };
        final String[] Indochina = new String[] {
               "Hindixitoy vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Yekaterinburg standart vaqti",
               "",
               "Yekaterinburg yozgi vaqti",
               "",
               "Yekaterinburg vaqti",
               "",
            };
        final String[] Maldives = new String[] {
               "Maldiv orollari vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Taiti vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Uollis va Futuna vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "Janubiy Afrika standart vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Syowa = new String[] {
               "Syova vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Layn orollari vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "O\u2018zbekiston standart vaqti",
               "",
               "O\u2018zbekiston yozgi vaqti",
               "",
               "O\u2018zbekiston vaqti",
               "",
            };
        final String[] Mongolia = new String[] {
               "Ulan-Bator standart vaqti",
               "",
               "Ulan-Bator yozgi vaqti",
               "",
               "Ulan-Bator vaqti",
               "",
            };
        final String[] America_Central = new String[] {
               "Markaziy Amerika standart vaqti",
               "",
               "Markaziy Amerika yozgi vaqti",
               "",
               "Markaziy Amerika vaqti",
               "",
            };
        final String[] Niue = new String[] {
               "Niuye vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Ueyk oroli vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "Folklend orollari standart vaqti",
               "",
               "Folklend orollari yozgi vaqti",
               "",
               "Folklend orollari vaqti",
               "",
            };
        final String[] Apia = new String[] {
               "Apia standart vaqti",
               "",
               "Apia yozgi vaqti",
               "",
               "Apia vaqti",
               "",
            };
        final String[] Bhutan = new String[] {
               "Butan vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "Nauru vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "G\u02bbarbiy Qozog\u02bbiston vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "Rojdestvo oroli vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Reunion = new String[] {
               "Reyunion vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "Kokos orollari vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Chatem standart vaqti",
               "",
               "Chatem yozgi vaqti",
               "",
               "Chatem vaqti",
               "",
            };
        final String[] Vostok = new String[] {
               "Vostok vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Argentina standart vaqti",
               "",
               "Argentina yozgi vaqti",
               "",
               "Argentina vaqti",
               "",
            };
        final String[] Gambier = new String[] {
               "Gambye vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Galapagos vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Venesuela vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Phoenix_Islands = new String[] {
               "Feniks orollari vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Kabo-Verde standart vaqti",
               "",
               "Kabo-Verde yozgi vaqti",
               "",
               "Kabo-Verde vaqti",
               "",
            };
        final String[] Norfolk = new String[] {
               "Norfolk oroli vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Samoa standart vaqti",
               "",
               "Samoa yozgi vaqti",
               "",
               "Samoa vaqti",
               "",
            };
        final String[] Davis = new String[] {
               "Deyvis vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cuba = new String[] {
               "Kuba standart vaqti",
               "",
               "Kuba yozgi vaqti",
               "",
               "Kuba vaqti",
               "",
            };
        final String[] GMT = new String[] {
               "Grinvich o\u2018rtacha vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "Filippin standart vaqti",
               "",
               "Filippin yozgi vaqti",
               "",
               "Filippin vaqti",
               "",
            };
        final String[] French_Southern = new String[] {
               "Fransuz Janubiy hududlari va Antarktika vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Yangi Kaledoniya standart vaqti",
               "",
               "Yangi Kaledoniya yozgi vaqti",
               "",
               "Yangi Kaledoniya vaqti",
               "",
            };
        final String[] Brunei = new String[] {
               "Bruney-Dorussalom vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "Eron standart vaqti",
               "",
               "Eron yozgi vaqti",
               "",
               "Eron vaqti",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Tojikiston vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Tonga standart vaqti",
               "",
               "Tonga yozgi vaqti",
               "",
               "Tonga vaqti",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Bangladesh standart vaqti",
               "",
               "Bangladesh yozgi vaqti",
               "",
               "Bangladesh vaqti",
               "",
            };
        final String[] Peru = new String[] {
               "Peru standart vaqti",
               "",
               "Peru yozgi vaqti",
               "",
               "Peru vaqti",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "Sharqiy Grenlandiya standart vaqti",
               "",
               "Sharqiy Grenlandiya yozgi vaqti",
               "",
               "Sharqiy Grenlandiya vaqti",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Sharqiy Indoneziya vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Qirg\u02bbiziston vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "Sharqiy Avstraliya standart vaqti",
               "",
               "Sharqiy Avstraliya yozgi vaqti",
               "",
               "Sharqiy Avstraliya vaqti",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Fransuz Gvianasi vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "Kolumbiya standart vaqti",
               "",
               "Kolumbiya yozgi vaqti",
               "",
               "Kolumbiya vaqti",
               "",
            };
        final String[] Chile = new String[] {
               "Chili standart vaqti",
               "",
               "Chili yozgi vaqti",
               "",
               "Chili vaqti",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Gilbert orollari vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk standart vaqti",
               "",
               "Irkutsk yozgi vaqti",
               "",
               "Irkutsk vaqti",
               "",
            };
        final String[] Georgia = new String[] {
               "Gruziya standart vaqti",
               "",
               "Gruziya yozgi vaqti",
               "",
               "Gruziya vaqti",
               "",
            };
        final String[] Choibalsan = new String[] {
               "Choybalsan standart vaqti",
               "",
               "Choybalsan yozgi vaqti",
               "",
               "Choybalsan vaqti",
               "",
            };
        final String[] China = new String[] {
               "Xitoy standart vaqti",
               "",
               "Xitoy yozgi vaqti",
               "",
               "Xitoy vaqti",
               "",
            };
        final String[] Armenia = new String[] {
               "Armaniston standart vaqti",
               "",
               "Armaniston yozgi vaqti",
               "",
               "Armaniston vaqti",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Markaziy Afrika vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Japan = new String[] {
               "Yaponiya standart vaqti",
               "",
               "Yaponiya yozgi vaqti",
               "",
               "Yaponiya vaqti",
               "",
            };
        final String[] Taipei = new String[] {
               "Tayvan standart vaqti",
               "",
               "Tayvan yozgi vaqti",
               "",
               "Tayvan vaqti",
               "",
            };
        final String[] Hovd = new String[] {
               "Xovd standart vaqti",
               "",
               "Xovd yozgi vaqti",
               "",
               "Xovd vaqti",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Markaziy Avstraliya g\u2018arbiy standart vaqti",
               "",
               "Markaziy Avstraliya g\u2018arbiy yozgi vaqti",
               "",
               "Markaziy Avstraliya g\u2018arbiy vaqti",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Saxalin standart vaqti",
               "",
               "Saxalin yozgi vaqti",
               "",
               "Saxalin vaqti",
               "",
            };
        final String[] Paraguay = new String[] {
               "Paragvay standart vaqti",
               "",
               "Paragvay yozgi vaqti",
               "",
               "Paragvay vaqti",
               "",
            };
        final String[] Malaysia = new String[] {
               "Malayziya vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Mavrikiy standart vaqti",
               "",
               "Mavrikiy yozgi vaqti",
               "",
               "Mavrikiy vaqti",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "Sharqiy Afrika vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Solomon orollari vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "Marshall orollari vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Nyufaundlend standart vaqti",
               "",
               "Nyufaundlend yozgi vaqti",
               "",
               "Nyufaundlend vaqti",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Afg\u02bboniston vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Gonkong standart vaqti",
               "",
               "Gonkong yozgi vaqti",
               "",
               "Gonkong vaqti",
               "",
            };
        final String[] Atlantic = new String[] {
               "Atlantika standart vaqti",
               "",
               "Atlantika yozgi vaqti",
               "",
               "Atlantika vaqti",
               "",
            };
        final String[] Israel = new String[] {
               "Isroil standart vaqti",
               "",
               "Isroil yozgi vaqti",
               "",
               "Isroil vaqti",
               "",
            };
        final String[] Indonesia_Central = new String[] {
               "Markaziy Indoneziya vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Omsk standart vaqti",
               "",
               "Omsk yozgi vaqti",
               "",
               "Omsk vaqti",
               "",
            };
        final String[] Seychelles = new String[] {
               "Seyshel orollari vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Urugvay standart vaqti",
               "",
               "Urugvay yozgi vaqti",
               "",
               "Urugvay vaqti",
               "",
            };
        final String[] Nepal = new String[] {
               "Nepal vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Truk = new String[] {
               "Chuuk vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Vanuatu standart vaqti",
               "",
               "Vanuatu yozgi vaqti",
               "",
               "Vanuatu vaqti",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk standart vaqti",
               "",
               "Novosibirsk yozgi vaqti",
               "",
               "Novosibirsk vaqti",
               "",
            };
        final String[] Singapore = new String[] {
               "Singapur vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "Azor orollari standart vaqti",
               "",
               "Azor orollari yozgi vaqti",
               "",
               "Azor orollari vaqti",
               "",
            };
        final String[] Suriname = new String[] {
               "Surinam vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnoyarsk standart vaqti",
               "",
               "Krasnoyarsk yozgi vaqti",
               "",
               "Krasnoyarsk vaqti",
               "",
            };
        final String[] Myanmar = new String[] {
               "Myanma vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "Amazonka standart vaqti",
               "",
               "Amazonka yozgi vaqti",
               "",
               "Amazonka vaqti",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Sharqiy Qozog\u02bbiston vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "Fiji standart vaqti",
               "",
               "Fiji yozgi vaqti",
               "",
               "Fiji vaqti",
               "",
            };
        final String[] Tuvalu = new String[] {
               "Tuvalu vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "Makkuori oroli vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Gavayi-aleut standart vaqti",
               "",
               "Gavayi-aleut yozgi vaqti",
               "",
               "Gavayi-aleut vaqti",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Markaziy Avstraliya standart vaqti",
               "",
               "Markaziy Avstraliya yozgi vaqti",
               "",
               "Markaziy Avstraliya vaqti",
               "",
            };
        final String[] America_Pacific = new String[] {
               "Tinch okeani standart vaqti",
               "",
               "Tinch okeani yozgi vaqti",
               "",
               "Tinch okeani vaqti",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "Turkmaniston standart vaqti",
               "",
               "Turkmaniston yozgi vaqti",
               "",
               "Turkmaniston vaqti",
               "",
            };
        final String[] Europe_Western = new String[] {
               "G\u2018arbiy Yevropa standart vaqti",
               "",
               "G\u2018arbiy Yevropa yozgi vaqti",
               "",
               "G\u2018arbiy Yevropa vaqti",
               "",
            };
        final String[] Guyana = new String[] {
               "Gayana vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Pitkern vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Rotera vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Palau vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Ozarbayjon standart vaqti",
               "",
               "Ozarbayjon yozgi vaqti",
               "",
               "Ozarbayjon vaqti",
               "",
            };
        final String[] Mawson = new String[] {
               "Mouson vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mexico_Pacific = new String[] {
               "Meksika Tinch okeani standart vaqti",
               "",
               "Meksika Tinch okeani yozgi vaqti",
               "",
               "Meksika Tinch okeani vaqti",
               "",
            };
        final String[] Africa_Western = new String[] {
               "G\u02bbarbiy Afrika standart vaqti",
               "",
               "G\u02bbarbiy Afrika yozgi vaqti",
               "",
               "G\u02bbarbiy Afrika vaqti",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Janubiy Georgiya vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Pasxa oroli standart vaqti",
               "",
               "Pasxa oroli yozgi vaqti",
               "",
               "Pasxa oroli vaqti",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "Shimoli-g\u2018arbiy Meksika standart vaqti",
               "",
               "Shimoli-g\u2018arbiy Meksika yozgi vaqti",
               "",
               "Shimoli-g\u2018arbiy Meksika vaqti",
               "",
            };
        final String[] DumontDUrville = new String[] {
               "Dyumon-d\u2019Yurvil vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "G\u2018arbiy Grenlandiya standart vaqti",
               "",
               "G\u2018arbiy Grenlandiya yozgi vaqti",
               "",
               "G\u2018arbiy Grenlandiya vaqti",
               "",
            };
        final String[] Ecuador = new String[] {
               "Ekvador vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gulf = new String[] {
               "Fors ko\u2018rfazi standart vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "Koreya standart vaqti",
               "",
               "Koreya yozgi vaqti",
               "",
               "Koreya vaqti",
               "",
            };
        final String[] Australia_Western = new String[] {
               "G\u2018arbiy Avstraliya standart vaqti",
               "",
               "G\u2018arbiy Avstraliya yozgi vaqti",
               "",
               "G\u2018arbiy Avstraliya vaqti",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "G\u02bbarbiy Indoneziya vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Tog\u2018 standart vaqti (AQSH)",
               "",
               "Tog\u2018 yozgi vaqti (AQSH)",
               "",
               "Tog\u2018 vaqti (AQSH)",
               "",
            };
        final String[] Marquesas = new String[] {
               "Markiz orollari vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Saudiya Arabistoni standart vaqti",
               "",
               "Saudiya Arabistoni yozgi vaqti",
               "",
               "Saudiya Arabistoni vaqti",
               "",
            };
        final String[] Alaska = new String[] {
               "Alyaska standart vaqti",
               "",
               "Alyaska yozgi vaqti",
               "",
               "Alyaska vaqti",
               "",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostok standart vaqti",
               "",
               "Vladivostok yozgi vaqti",
               "",
               "Vladivostok vaqti",
               "",
            };
        final String[] Chamorro = new String[] {
               "Chamorro standart vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Tokelau vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Papua-Yangi Gvineya vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Noronha = new String[] {
               "Fernandu-di-Noronya standart vaqti",
               "",
               "Fernandu-di-Noronya yozgi vaqti",
               "",
               "Fernandu-di-Noronya vaqti",
               "",
            };
        final String[] Brasilia = new String[] {
               "Braziliya standart vaqti",
               "",
               "Braziliya yozgi vaqti",
               "",
               "Braziliya vaqti",
               "",
            };
        final String[] Pyongyang = new String[] {
               "Pxenyan vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hindiston standart vaqti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "Kuk orollari standart vaqti",
               "",
               "Kuk orollari yarim yozgi vaqti",
               "",
               "Kuk orollari vaqti",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Aden", Arabian },
            { "timezone.excity.America/Phoenix", "Feniks" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Lyublyana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Pacific/Marquesas", "Markiz orollari" },
            { "America/El_Salvador", America_Central },
            { "timezone.excity.America/Buenos_Aires", "Buenos-Ayres" },
            { "Asia/Pontianak", Indonesia_Western },
            { "timezone.excity.America/Danmarkshavn", "Denmarksxavn" },
            { "timezone.excity.America/Anchorage", "Ankorij" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Europe/London",
                new String[] {
                    "Grinvich o\u2018rtacha vaqti",
                    "",
                    "Britaniya yozgi vaqti",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Antarctica/Vostok", "Vostok" },
            { "America/Panama", America_Eastern },
            { "timezone.excity.America/North_Dakota/Beulah", "Boyla, Shimoliy Dakota" },
            { "timezone.excity.Pacific/Fiji", "Fiji" },
            { "timezone.excity.Europe/Gibraltar", "Gibraltar" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Libreville", "Librevil" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Africa/Addis_Ababa", "Addis-Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallin" },
            { "timezone.excity.Pacific/Truk", "Truk orollari" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "timezone.excity.Europe/Vaduz", "Vaduts" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "timezone.excity.America/Santa_Isabel", "Santa-Izabel" },
            { "timezone.excity.Asia/Barnaul", "Barnaul" },
            { "Antarctica/Syowa", Syowa },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "timezone.excity.Europe/London", "London" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Pacific/Pitcairn", "Pitkern" },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnoyarsk" },
            { "Antarctica/McMurdo", New_Zealand },
            { "timezone.excity.America/Nome", "Nom" },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.America/Vancouver", "Vankuver" },
            { "timezone.excity.America/Matamoros", "Matamoros" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Asia/Choibalsan", "Choybalsan" },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "timezone.excity.America/St_Lucia", "Sent-Lyusiya" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznetsk" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midvey orollari" },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Godthab", "Gotxob" },
            { "timezone.excity.America/Martinique", "Martinika" },
            { "America/Dawson_Creek", America_Mountain },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Pert" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Africa/Asmera", "Asmera" },
            { "timezone.excity.Arctic/Longyearbyen", "Longyir" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegusigalpa" },
            { "timezone.excity.Africa/Windhoek", "Vindxuk" },
            { "Africa/Lubumbashi", Africa_Central },
            { "timezone.excity.Pacific/Majuro", "Majuro" },
            { "timezone.excity.America/Lower_Princes", "Louer-Prinses-Kuorter" },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.Australia/Lindeman", "Lindeman" },
            { "timezone.excity.America/Miquelon", "Mikelon" },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.America/Jujuy", "Jujuy" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ushuaya" },
            { "timezone.excity.America/North_Dakota/Center", "Markaz, Shimoliy Dakota" },
            { "timezone.excity.America/Cayenne", "Kayenna" },
            { "Pacific/Chatham", Chatham },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Beliz" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "America/Puerto_Rico", Atlantic },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "timezone.excity.Pacific/Johnston", "Jonston" },
            { "America/Cayenne", French_Guiana },
            { "timezone.excity.Europe/Jersey", "Jersi" },
            { "timezone.excity.America/Pangnirtung", "Pangnirtang" },
            { "timezone.excity.Atlantic/South_Georgia", "Janubiy Georgiya" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "SystemV/AST4", Atlantic },
            { "timezone.excity.America/Havana", "Gavana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "timezone.excity.America/Detroit", "Detroyt" },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Asia/Phnom_Penh", "Pnompen" },
            { "timezone.excity.Europe/Rome", "Rim" },
            { "timezone.excity.Asia/Hebron", "Xevron" },
            { "Asia/Jakarta", Indonesia_Western },
            { "timezone.excity.Antarctica/Mawson", "Mouson" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.America/Resolute", "Rezolyut" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "timezone.excity.America/Argentina/Salta", "Salta" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Maskat" },
            { "America/Noronha", Noronha },
            { "timezone.excity.Africa/El_Aaiun", "Al-Ayun" },
            { "timezone.excity.Australia/Hobart", "Xobart" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.America/Lima", "Lima" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Nyu-Salem, Shimoliy Dakota" },
            { "timezone.excity.Asia/Atyrau", "Atirau" },
            { "America/Paramaribo", Suriname },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "Antarctica/Troll", GMT },
            { "timezone.excity.America/Ojinaga", "Oxinaga" },
            { "timezone.excity.Europe/Zurich", "Syurix" },
            { "America/Antigua", Atlantic },
            { "timezone.excity.America/Sao_Paulo", "San-Paulu" },
            { "Pacific/Gambier", Gambier },
            { "Africa/Gaborone", Africa_Central },
            { "Asia/Pyongyang", Pyongyang },
            { "timezone.excity.America/New_York", "Nyu-York" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Akkra" },
            { "timezone.excity.Etc/Unknown", "noma\u2019lum shahar" },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Tule" },
            { "timezone.excity.America/Grand_Turk", "Grand Turk" },
            { "America/Yakutat", Alaska },
            { "timezone.excity.America/Indiana/Petersburg", "Pitersberg, Indiana" },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Vinnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Makkuori" },
            { "timezone.excity.Europe/Uzhgorod", "Ujgorod" },
            { "timezone.excity.America/Caracas", "Karakas" },
            { "timezone.excity.America/Dawson_Creek", "Douson-Krik" },
            { "timezone.excity.America/Bogota", "Bogota" },
            { "timezone.excity.Asia/Baku", "Boku" },
            { "timezone.excity.Asia/Hovd", "Xovd" },
            { "timezone.excity.Africa/Harare", "Xarare" },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.America/Blanc-Sablon", "Blank-Sablon" },
            { "timezone.excity.Africa/Algiers", "Jazoir" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Xartum" },
            { "Africa/Abidjan", GMT },
            { "America/Santarem", Brasilia },
            { "timezone.excity.Asia/Khandyga", "Xandiga" },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Atlantic/Bermuda", Atlantic },
            { "timezone.excity.Pacific/Galapagos", "Galapagos" },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.America/Argentina/Tucuman", "Tukuman" },
            { "timezone.excity.America/Rio_Branco", "Riu-Branku" },
            { "Africa/Accra", GMT },
            { "timezone.excity.Europe/Ulyanovsk", "Ulyanovsk" },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayorka" },
            { "America/Maceio", Brasilia },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "Grinvich o\u2018rtacha vaqti",
                    "",
                    "Irlandiya yozgi vaqti",
                    "",
                    "",
                    "",
                }
            },
            { "Pacific/Truk", Truk },
            { "timezone.excity.Africa/Conakry", "Konakri" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Saratov", "Saratov" },
            { "SystemV/CST6", America_Central },
            { "timezone.excity.Pacific/Efate", "Efate" },
            { "timezone.excity.Asia/Aqtobe", "Oqto\u2018ba" },
            { "Asia/Vladivostok", Vladivostok },
            { "timezone.excity.Atlantic/St_Helena", "Muqaddas Yelena oroli" },
            { "Africa/Maputo", Africa_Central },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Lyuksemburg" },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrayn" },
            { "timezone.excity.Indian/Mahe", "Mae" },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "timezone.excity.Europe/Isle_of_Man", "Men oroli" },
            { "Pacific/Saipan", Chamorro },
            { "timezone.excity.America/Curacao", "Kyurasao" },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago-Pago" },
            { "Antarctica/Rothera", Rothera },
            { "timezone.excity.America/Guyana", "Gayana" },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Parij" },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "timezone.excity.America/Scoresbysund", "Ittokkortoormiut" },
            { "timezone.excity.America/Indiana/Vevay", "Vivey, Indiana" },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Swift_Current", "Svift-Karrent" },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.America/Tortola", "Tortola" },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapesht" },
            { "timezone.excity.America/Catamarca", "Katamarka" },
            { "timezone.excity.America/Port_of_Spain", "Port-of-Speyn" },
            { "timezone.excity.Asia/Chita", "Chita" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.America/Rankin_Inlet", "Rankin-Inlet" },
            { "America/Punta_Arenas",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.America/Santarem", "Santarem" },
            { "timezone.excity.Asia/Tomsk", "Tomsk" },
            { "timezone.excity.Europe/Helsinki", "Xelsinki" },
            { "America/Mexico_City", America_Central },
            { "timezone.excity.America/Yakutat", "Yakutat" },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Urumqi", "Urumchi" },
            { "timezone.excity.America/Costa_Rica", "Kosta-Rika" },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bisau" },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Africa/Douala", "Duala" },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Mogadisho" },
            { "timezone.excity.America/Bahia_Banderas", "Bahiya-Banderas" },
            { "timezone.excity.Asia/Jayapura", "Jaypur" },
            { "America/Menominee", America_Central },
            { "timezone.excity.Pacific/Guadalcanal", "Gvadalkanal" },
            { "America/Resolute", America_Central },
            { "timezone.excity.Africa/Lome", "Lome" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "timezone.excity.Asia/Kuwait", "Quvayt" },
            { "timezone.excity.America/Santo_Domingo", "Santo-Domingo" },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "Africa/Bujumbura", Africa_Central },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taypey" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Grinvich o\u2018rtacha vaqti",
                    "",
                    "Britaniya yozgi vaqti",
                    "",
                    "",
                    "",
                }
            },
            { "Asia/Ashgabat", Turkmenistan },
            { "timezone.excity.Asia/Dhaka", "Dakka" },
            { "America/Nipigon", America_Eastern },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "timezone.excity.America/Fort_Nelson", "Fort Nelson" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "America/Lima", Peru },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "timezone.excity.Asia/Famagusta", "Famagusta" },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "America/Vancouver", America_Pacific },
            { "timezone.excity.America/Marigot", "Marigo" },
            { "Africa/Blantyre", Africa_Central },
            { "America/Detroit", America_Eastern },
            { "timezone.excity.America/Kentucky/Monticello", "Montisello, Kentukki" },
            { "America/Thule", Atlantic },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan-Bator" },
            { "timezone.excity.Antarctica/McMurdo", "Mak-Merdo" },
            { "Asia/Sakhalin", Sakhalin },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "America/Nome", Alaska },
            { "timezone.excity.Africa/Nairobi", "Nayrobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "timezone.excity.Pacific/Fakaofo", "Fakaofo" },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Astrakhan",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "Asia/Saigon", Indochina },
            { "timezone.excity.Africa/Johannesburg", "Yoxannesburg" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "timezone.excity.Europe/Dublin", "Dublin" },
            { "timezone.excity.Antarctica/Casey", "Keysi" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kabo-Verde" },
            { "timezone.excity.Africa/Maputo", "Maputu" },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.America/Goose_Bay", "Gus-Bey" },
            { "timezone.excity.America/Eirunepe", "Eyrunepe" },
            { "timezone.excity.America/Los_Angeles", "Los-Anjeles" },
            { "America/Whitehorse", America_Pacific },
            { "timezone.excity.America/Cuiaba", "Kuyaba" },
            { "Pacific/Noumea", New_Caledonia },
            { "timezone.excity.Atlantic/Azores", "Azor orollari" },
            { "timezone.excity.Australia/Melbourne", "Melburn" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Angilya" },
            { "timezone.excity.Pacific/Honolulu", "Gonolulu" },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisben" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivu" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Vyentyan" },
            { "America/Grenada", Atlantic },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "timezone.excity.Indian/Christmas", "Rojdestvo oroli" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "timezone.excity.Asia/Aqtau", "Oqtov" },
            { "timezone.excity.America/Regina", "Rejayna" },
            { "SystemV/YST9YDT", Alaska },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "timezone.excity.America/Thunder_Bay", "Tander-Bey" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "SystemV/PST8PDT", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.America/Louisville", "Luisvill" },
            { "timezone.excity.America/Cancun", "Kankun" },
            { "timezone.excity.Australia/Broken_Hill", "Broken-Xill" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Pacific/Kiritimati", "Kiritimati" },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Pacific/Tarawa", "Tarava" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.America/Asuncion", "Asunson" },
            { "Asia/Amman", Europe_Eastern },
            { "Etc/UTC",
                new String[] {
                    "Koordinatali universal vaqt",
                    "UTC",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Chisinau", "Kishinyov" },
            { "timezone.excity.America/Moncton", "Monkton" },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnyus" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chikago" },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San-Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "timezone.excity.Pacific/Ponape", "Ponpei oroli" },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "timezone.excity.Europe/Skopje", "Skopye" },
            { "timezone.excity.America/Chihuahua", "Chihuahua" },
            { "America/Belize", America_Central },
            { "timezone.excity.America/Indiana/Winamac", "Vinamak, Indiana" },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykyavik" },
            { "timezone.excity.Asia/Kamchatka", "Kamchatka" },
            { "Europe/Warsaw", Europe_Central },
            { "Pacific/Yap", Truk },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Africa/Djibouti", "Jibuti" },
            { "America/Tegucigalpa", America_Central },
            { "timezone.excity.America/Recife", "Resifi" },
            { "timezone.excity.Pacific/Wallis", "Uollis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Antarctica/Palmer", "Palmer" },
            { "timezone.excity.Asia/Tashkent", "Toshkent" },
            { "timezone.excity.America/Argentina/San_Juan", "San-Xuan" },
            { "timezone.excity.Antarctica/Rothera", "Rotera" },
            { "timezone.excity.Asia/Shanghai", "Shanxay" },
            { "timezone.excity.America/Juneau", "Juno" },
            { "timezone.excity.Pacific/Bougainville", "Bugenvil" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Pasxa oroli" },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "timezone.excity.America/Menominee", "Menomini" },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "timezone.excity.Australia/Lord_Howe", "Lord-Xau oroli" },
            { "Indian/Reunion", Reunion },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Asia/Magadan", "Magadan" },
            { "timezone.excity.Pacific/Wake", "Ueyk oroli" },
            { "timezone.excity.Atlantic/Canary", "Kanar orollari" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.America/Glace_Bay", "Gleys-Bey" },
            { "timezone.excity.Africa/Casablanca", "Kasablanka" },
            { "Etc/GMT", GMT },
            { "timezone.excity.America/Kralendijk", "Kralendeyk" },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "timezone.excity.Asia/Yerevan", "Yerevan" },
            { "timezone.excity.Europe/Kirov", "Kirov" },
            { "timezone.excity.America/Creston", "Kreston" },
            { "timezone.excity.Africa/Cairo", "Qohira" },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.Europe/Warsaw", "Varshava" },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.America/Indiana/Tell_City", "Tell-Siti, Indiana" },
            { "America/Cordoba", Argentina },
            { "America/Regina", America_Central },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Anguilla", Atlantic },
            { "Europe/Saratov",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "San-Tome" },
            { "timezone.excity.America/Dawson", "Douson" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "America/Barbados", Atlantic },
            { "timezone.excity.America/Guadeloupe", "Gvadelupa" },
            { "timezone.excity.Africa/Freetown", "Fritaun" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "timezone.excity.America/Fortaleza", "Fortaleza" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Asia/Almaty", "Almati" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Minsk" },
            { "America/Curacao", Atlantic },
            { "timezone.excity.Africa/Monrovia", "Monroviya" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "timezone.excity.America/Rainy_River", "Reyni-River" },
            { "timezone.excity.America/Coral_Harbour", "Koral-Xarbor" },
            { "timezone.excity.Asia/Beirut", "Bayrut" },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Rankin_Inlet", America_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.Asia/Pontianak", "Pontianak" },
            { "timezone.excity.America/Adak", "Adak oroli" },
            { "Europe/Zagreb", Europe_Central },
            { "timezone.excity.America/Toronto", "Toronto" },
            { "America/Port_of_Spain", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Bag\u2018dod" },
            { "timezone.excity.Antarctica/DumontDUrville", "Dyumon-d\u2019Yurvil" },
            { "Pacific/Bougainville",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Sao_Tome", Africa_Western },
            { "Indian/Chagos", Indian_Ocean },
            { "timezone.excity.America/Metlakatla", "Metlakatla" },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "timezone.excity.America/Maceio", "Maseyo" },
            { "timezone.excity.America/Guayaquil", "Guayakil" },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.America/St_Vincent", "Sent-Vinsent" },
            { "timezone.excity.America/Panama", "Panama" },
            { "timezone.excity.Europe/Simferopol", "Simferopol" },
            { "timezone.excity.Indian/Kerguelen", "Kergelen" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "Asia/Tashkent", Uzbekistan },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La-Pas" },
            { "timezone.excity.Africa/Tripoli", "Tripoli" },
            { "America/Swift_Current", America_Central },
            { "timezone.excity.Pacific/Enderbury", "Enderberi oroli" },
            { "timezone.excity.Asia/Pyongyang", "Pxenyan" },
            { "timezone.excity.Europe/Bucharest", "Buxarest" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Afina" },
            { "Africa/Djibouti", Africa_Eastern },
            { "timezone.excity.America/Indiana/Knox", "Noks, Indiana" },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "timezone.excity.America/Porto_Velho", "Portu-Velyu" },
            { "Europe/Prague", Europe_Central },
            { "timezone.excity.America/Managua", "Managua" },
            { "America/Kralendijk", Atlantic },
            { "Indian/Christmas", Christmas },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "America/Moncton", Atlantic },
            { "timezone.excity.Europe/Copenhagen", "Kopengagen" },
            { "timezone.excity.Australia/Darwin", "Darvin" },
            { "America/St_Vincent", Atlantic },
            { "PST8PDT", America_Pacific },
            { "timezone.excity.Asia/Jerusalem", "Quddus" },
            { "Atlantic/Faeroe", Europe_Western },
            { "timezone.excity.Asia/Riyadh", "Ar-Riyod" },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangi" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "timezone.excity.Asia/Ust-Nera", "Ust-Nera" },
            { "timezone.excity.Asia/Damascus", "Damashq" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Pacific/Kosrae", "Kosrae" },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "timezone.excity.Africa/Brazzaville", "Brazzavil" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Rio-Galyegos" },
            { "SystemV/MST7", America_Mountain },
            { "America/Dominica", Atlantic },
            { "timezone.excity.America/Bahia", "Baiya" },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Tehron" },
            { "timezone.excity.Pacific/Tahiti", "Taiti oroli" },
            { "timezone.excity.America/St_Kitts", "Sent-Kits" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dor-us-Salom" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "Pacific/Wake", Wake },
            { "timezone.excity.America/Belem", "Belem" },
            { "Asia/Chongqing", China },
            { "America/Indiana/Knox", America_Central },
            { "timezone.excity.Asia/Saigon", "Xoshimin" },
            { "America/North_Dakota/Beulah", America_Central },
            { "timezone.excity.Asia/Makassar", "Makasar" },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinburg" },
            { "timezone.excity.Europe/Sofia", "Sofiya" },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Europe/Astrakhan", "Astraxan" },
            { "timezone.excity.America/Yellowknife", "Yellounayf" },
            { "timezone.excity.Europe/Belgrade", "Belgrad" },
            { "timezone.excity.America/Puerto_Rico", "Puerto-Riko" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Kalkutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "timezone.excity.Asia/Gaza", "G\u2018azo" },
            { "timezone.excity.Africa/Ceuta", "Seuta" },
            { "Africa/Libreville", Africa_Western },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Antarctica/Troll", "Troll" },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Hong_Kong", "Gonkong" },
            { "timezone.excity.America/Port-au-Prince", "Port-o-Prens" },
            { "America/Tijuana", America_Pacific },
            { "timezone.excity.Australia/Eucla", "Evkla" },
            { "timezone.excity.America/Mexico_City", "Mexiko" },
            { "timezone.excity.Pacific/Kwajalein", "Kvajaleyn" },
            { "SystemV/YST9", Gambier },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "timezone.excity.Europe/Lisbon", "Lissabon" },
            { "timezone.excity.Pacific/Gambier", "Gambye oroli" },
            { "timezone.excity.America/Boise", "Boyse" },
            { "America/Santiago", Chile },
            { "timezone.excity.Europe/Zaporozhye", "Zaporojye" },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "timezone.excity.Pacific/Chatham", "Chatem oroli" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Antarctica/Palmer",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Pacific/Port_Moresby", "Port-Morsbi" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.America/Mendoza", "Mendoza" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.America/Noronha", "Noronya" },
            { "timezone.excity.Asia/Sakhalin", "Saxalin" },
            { "Pacific/Kiritimati", Line_Islands },
            { "timezone.excity.America/Nipigon", "Nipigon" },
            { "timezone.excity.Europe/Guernsey", "Gernsi" },
            { "timezone.excity.America/Argentina/San_Luis", "San-Luis" },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "timezone.excity.America/Araguaina", "Araguaina" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "timezone.excity.America/Cordoba", "Kordoba" },
            { "timezone.excity.America/Cambridge_Bay", "Kembrij-Bey" },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.America/Campo_Grande", "Kampu-Grandi" },
            { "timezone.excity.Africa/Blantyre", "Blantayr" },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "timezone.excity.Australia/Sydney", "Sidney" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.America/Sitka", "Sitka" },
            { "SystemV/EST5", America_Eastern },
            { "timezone.excity.Antarctica/Davis", "Deyvis" },
            { "America/Santo_Domingo", Atlantic },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "timezone.excity.Asia/Qyzylorda", "Qizilo\u2018rda" },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Magadan", Magadan },
            { "SystemV/PST8", Pitcairn },
            { "timezone.excity.Indian/Mauritius", "Mavrikiy" },
            { "America/St_Barthelemy", Atlantic },
            { "timezone.excity.America/Argentina/La_Rioja", "La-Rioxa" },
            { "Africa/Luanda", Africa_Western },
            { "timezone.excity.Europe/Mariehamn", "Mariyexamn" },
            { "timezone.excity.America/St_Johns", "Sent-Jons" },
            { "timezone.excity.America/St_Barthelemy", "Sen-Bartelemi" },
            { "timezone.excity.America/Santiago", "Santyago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "timezone.excity.Asia/Oral", "Uralsk" },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Pacific/Kosrae", Kosrae },
            { "Australia/Sydney", Australia_Eastern },
            { "timezone.excity.America/Indianapolis", "Indianapolis" },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "timezone.excity.America/St_Thomas", "Sent-Tomas" },
            { "timezone.excity.Europe/Busingen", "Byuzingen" },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "timezone.excity.Europe/Sarajevo", "Sarayevo" },
            { "America/Danmarkshavn", GMT },
            { "timezone.excity.Africa/Ndjamena", "Ndjamena" },
            { "timezone.excity.America/Punta_Arenas", "Punta-Arenas" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "Africa/Lusaka", Africa_Central },
            { "timezone.excity.Africa/Tunis", "Tunis" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "SystemV/CST6CDT", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "America/Scoresbysund", Greenland_Eastern },
            { "timezone.excity.Asia/Samarkand", "Samarqand" },
            { "Africa/Khartoum", Africa_Central },
            { "timezone.excity.Australia/Adelaide", "Adelaida" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Vena" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Kayman orollari" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Nikosiya" },
            { "timezone.excity.Europe/Kiev", "Kiyev" },
            { "timezone.excity.Asia/Dili", "Dili" },
            { "timezone.excity.Asia/Omsk", "Omsk" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.America/Mazatlan", "Masatlan" },
            { "timezone.excity.Asia/Brunei", "Bruney" },
            { "timezone.excity.Atlantic/Faeroe", "Farer orollari" },
            { "timezone.excity.America/Whitehorse", "Uaytxors" },
            { "timezone.excity.Asia/Kuching", "Kuching" },
            { "timezone.excity.America/Halifax", "Galifaks" },
            { "timezone.excity.America/Merida", "Merida" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Pacific/Auckland", "Oklend" },
            { "Africa/Niamey", Africa_Western },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "timezone.excity.Asia/Ashgabat", "Ashxobod" },
            { "timezone.excity.Pacific/Tongatapu", "Tongatapu" },
            { "timezone.excity.Antarctica/Syowa", "Syova" },
            { "timezone.excity.America/Jamaica", "Yamayka" },
            { "timezone.excity.America/Hermosillo", "Ermosillo" },
            { "timezone.excity.Pacific/Funafuti", "Funafuti" },
            { "timezone.excity.Europe/Podgorica", "Podgoritsa" },
            { "timezone.excity.Indian/Reunion", "Reyunion" },
            { "timezone.excity.Pacific/Noumea", "Numea" },
            { "timezone.excity.Asia/Aden", "Adan" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Famagusta",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Atlantic/Stanley", "Stenli" },
            { "Pacific/Tongatapu", Tonga },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "Europe/Ulyanovsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Asia/Dubai", "Dubay" },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala-Lumpur" },
            { "America/Guadeloupe", Atlantic },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Uagadugu" },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "Asia/Srednekolymsk",
                new String[] {
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Qobul" },
            { "timezone.excity.America/Iqaluit", "Ikaluit" },
            { "America/Winnipeg", America_Central },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Atlantic/Bermuda", "Bermuda orollari" },
            { "timezone.excity.Pacific/Saipan", "Saypan" },
            { "timezone.excity.Indian/Cocos", "Kokos orollari" },
            { "timezone.excity.Australia/Currie", "Kerri" },
            { "SystemV/AST4ADT", Atlantic },
            { "timezone.excity.Asia/Amman", "Ammon" },
            { "timezone.excity.America/Indiana/Vincennes", "Vinsens, Indiana" },
            { "America/Toronto", America_Eastern },
            { "timezone.excity.Europe/Brussels", "Bryussel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeyra oroli" },
            { "timezone.excity.Indian/Comoro", "Komor orollari" },
            { "timezone.excity.America/Boa_Vista", "Boa-Vista" },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stokgolm" },
            { "timezone.excity.Europe/Samara", "Samara" },
            { "timezone.excity.America/Tijuana", "Tixuana" },
            { "timezone.excity.Indian/Maldives", "Maldiv orollari" },
        };
        return data;
    }
}
