/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.ConfigurationException;
import com.google.inject.Stage;
import com.google.inject.internal.AbstractProcessor;
import com.google.inject.internal.Errors;
import com.google.inject.internal.Initializer;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.InternalContext;
import com.google.inject.internal.InternalProvisionException;
import com.google.inject.internal.SingleMemberInjector;
import com.google.inject.spi.InjectionRequest;
import com.google.inject.spi.StaticInjectionRequest;
import java.util.List;
import java.util.Set;

final class InjectionRequestProcessor
extends AbstractProcessor {
    private final List<StaticInjection> staticInjections = Lists.newArrayList();
    private final Initializer initializer;

    InjectionRequestProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public Boolean visit(StaticInjectionRequest request) {
        this.staticInjections.add(new StaticInjection(this.injector, request));
        return true;
    }

    @Override
    public Boolean visit(InjectionRequest<?> request) {
        Set injectionPoints;
        try {
            injectionPoints = request.getInjectionPoints();
        }
        catch (ConfigurationException e2) {
            this.errors.merge(e2.getErrorMessages());
            injectionPoints = (Set)e2.getPartialValue();
        }
        this.initializer.requestInjection(this.injector, request.getInstance(), null, request.getSource(), injectionPoints);
        return true;
    }

    void validate() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.validate();
        }
    }

    void injectMembers() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.injectMembers();
        }
    }

    private class StaticInjection {
        final InjectorImpl injector;
        final Object source;
        final StaticInjectionRequest request;
        ImmutableList<SingleMemberInjector> memberInjectors;

        public StaticInjection(InjectorImpl injector, StaticInjectionRequest request) {
            this.injector = injector;
            this.source = request.getSource();
            this.request = request;
        }

        void validate() {
            Set injectionPoints;
            Errors errorsForMember = InjectionRequestProcessor.this.errors.withSource(this.source);
            try {
                injectionPoints = this.request.getInjectionPoints();
            }
            catch (ConfigurationException e2) {
                errorsForMember.merge(e2.getErrorMessages());
                injectionPoints = (Set)e2.getPartialValue();
            }
            this.memberInjectors = injectionPoints != null ? this.injector.membersInjectorStore.getInjectors(injectionPoints, errorsForMember) : ImmutableList.of();
            InjectionRequestProcessor.this.errors.merge(errorsForMember);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void injectMembers() {
            try (InternalContext context = this.injector.enterContext();){
                boolean isStageTool = this.injector.options.stage == Stage.TOOL;
                for (SingleMemberInjector memberInjector : this.memberInjectors) {
                    if (isStageTool && !memberInjector.getInjectionPoint().isToolable()) continue;
                    try {
                        memberInjector.inject(context, null);
                    }
                    catch (InternalProvisionException e2) {
                        InjectionRequestProcessor.this.errors.merge(e2);
                    }
                }
            }
        }
    }
}

