#Patroneo
Program version 1.5


Patroneo (which is Esperanto for "Pattern") is an easy to use, pattern based midi sequencer, a 
program that sends digital "notes" to software instruments such as synthesizers and samplers.

Patroneo is primarily designed for educational purposes, where the main goal is to teach the
importance of patterns and repetitions in any kind of music. However, Patroneo is a full sequencer
you can use to create real music. The constraints it presents will more likely boost your
creativity than suppressing it.

You have tracks with one pattern each. Turn on steps in the pattern to play
musical notes. Switch the patterns on and off in a sequence to create a song structure.
Connect external synthesizers and samplers to create sounds.


This README is just a short introduction. Consult the manual (see below) for more information.

# Contact and Information

* Website https://www.laborejo.org
* Bugs and Issues: https://www.laborejo.org/bugs
* Git Repositories for all programs: https://git.laborejo.org
* Documentation and Manual https://www.laborejo.org/documentation/patroneo

# Installation and Starting

## Download

### Release Version
If the latest release is not available through your package manger you can build it yourself:
Download the latest code release on https://www.laborejo.org/downloads and extract it.

### Git Version
It is possible to clone a git repository.

`git clone https://git.laborejo.org/lss/patroneo.git`

## Dependencies
* Glibc
* Python 3.6 (maybe earlier)
* PyQt5 for Python 3
* DejaVu Sans Sarif TTF (Font) (recommended, but not technically necessary)


#### Build Dependencies
* Bash
* Nuitka >= 0.6 (maybe earlier. Optional when running from source dir)
* GCC (development is done on 8.2, but most likely you can use a much earlier version)

### Environment:
* Jack Audio Connection Kit must be running
* Non Session Manager

## Build
    ./configure --prefix=/usr/local
    make
    sudo make install


## Starting

There are multiple ways to run Patroneo which should give you the flexibility to configure your
system as you want.

We make no distinction if you installed Patroneo yourself or through the distributions package-manager.

The differences are: With or without NSM, with or without sound, installed or from the source dir.

### Installed with Non Session Manager (recommended)
Starting Patroneo through the Non Session Manager after you installed patroneo system-wide
is the recommended and only supported way. Start non-session-manager and load or create a new
session. Then use the button "Add Client to Session" and type in `patroneo`.
It should appear with an icon in the list and open its GUI.

### Installed without NSM
If you start patroneo directly it will present you with a dialog to choose your session directory.

You can also start patroneo from a terminal (or create a starter script).

`patroneo --save DIRECTORY`

Uses the given directory to save. The dir will be created or loaded from if already present. Use
the applications file menu to save (Ctrl+s).

You can use this to load and save the files from an existing NSM session. If you create a new
directory you can copy it manually to an NSM session directory, but that requires renaming the
directory to append the unique ID provided by NSM.

Sending SIGUSR1 to the program in this mode will trigger a save.

Closing through your window manager in this mode will actually quit the application without a
prompt to save changes.

## From source directory
You can run Patroneo after extracting the release archive or cloning from git, without installation.

### Calfbox
"Calfbox" is the name of our internal realtime midi/audio python module.

* You can either choose to install the module systemwide, which will make running all Laborejo Software Suite programs more convenient (when run from the source dir). Please consult https://github.com/kfoltman/calfbox 
* Or you just run `./configure` and `make calfbox` without subsequent install, which creates a `site-packages` directory in the source dir.
* A third option is `patroneo --mute` which runs without sound at all and does not need calfbox.

### From source directory with NSM
The developer uses this way to develop and use the software, so it will always be as stable as the
compiled version. But it is a bit less performant than building and installing it.

After extracting the release archive create a symlink from `patroneo` into your PATH. e.g. /usr/bin
or ~/bin, if that exists on your system.

If you compiled without installing you can also symlink to `./patroneo.bin`

### From source dir without NSM
Use `./patroneo --save` (see above). If you compiled without installing you can also run `./patroneo.bin`

### No NSM, no Make, No Sound
Combining the above options you can start the program directly after unpacking or cloning from git:

`./patroneo --save /tmp --mute`

Or even shorter:

`./patroneo -s /tmp -m`

This is the minimal run mode which is only useful for testing and development. But if you only want
to look at the GUI and are not in the mood to install anything -including dependencies-, go ahead.

