/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.color.ColorChangerMonochrome;

public class UImage
implements UShape {
    private final BufferedImage image;
    private final String formula;
    private final String rawFileName;
    private static final int mask_a__ = -16777216;
    private static final int mask_rgb = 0xFFFFFF;

    public String getRawFileName() {
        return this.rawFileName;
    }

    public UImage(BufferedImage image) {
        this(null, image, null);
    }

    public UImage(String rawFileName, BufferedImage image) {
        this(rawFileName, image, null);
    }

    public UImage(String rawFileName, BufferedImage image, String formula) {
        this.image = image;
        this.formula = formula;
        this.rawFileName = rawFileName;
    }

    public UImage scale(double scale) {
        return this.scale(scale, 2);
    }

    public UImage scaleNearestNeighbor(double scale) {
        return this.scale(scale, 1);
    }

    private UImage scale(double scale, int type) {
        if (scale == 1.0) {
            return this;
        }
        int w = (int)Math.round((double)this.image.getWidth() * scale);
        int h = (int)Math.round((double)this.image.getHeight() * scale);
        BufferedImage after = new BufferedImage(w, h, this.image.getType());
        AffineTransform at = new AffineTransform();
        at.scale(scale, scale);
        AffineTransformOp scaleOp = new AffineTransformOp(at, type);
        return new UImage(this.rawFileName, scaleOp.filter(this.image, after), this.formula);
    }

    public final BufferedImage getImage() {
        return this.image;
    }

    public int getWidth() {
        return this.image.getWidth() - 1;
    }

    public int getHeight() {
        return this.image.getHeight() - 1;
    }

    public final String getFormula() {
        return this.formula;
    }

    public UImage muteColor(Color newColor) {
        if (newColor == null) {
            return this;
        }
        int darkerRgb = this.getDarkerRgb();
        BufferedImage copy = this.deepCopy2();
        for (int i = 0; i < this.image.getWidth(); ++i) {
            for (int j = 0; j < this.image.getHeight(); ++j) {
                int color = this.image.getRGB(i, j);
                int rgb = this.getRgb(color);
                int a = this.getA(color);
                if (a == 0 || rgb != darkerRgb) continue;
                copy.setRGB(i, j, newColor.getRGB() + a);
            }
        }
        return new UImage(this.rawFileName, copy, this.formula);
    }

    public UImage muteTransparentColor(Color newColor) {
        if (newColor == null) {
            newColor = Color.WHITE;
        }
        BufferedImage copy = this.deepCopy2();
        for (int i = 0; i < this.image.getWidth(); ++i) {
            for (int j = 0; j < this.image.getHeight(); ++j) {
                int color = this.image.getRGB(i, j);
                int a = this.getA(color);
                if (a != 0) continue;
                copy.setRGB(i, j, newColor.getRGB());
            }
        }
        return new UImage(this.rawFileName, copy, this.formula);
    }

    private int getDarkerRgb() {
        int darkerRgb = -1;
        for (int i = 0; i < this.image.getWidth(); ++i) {
            for (int j = 0; j < this.image.getHeight(); ++j) {
                int color = this.image.getRGB(i, j);
                int rgb = this.getRgb(color);
                int a = this.getA(color);
                if (a != -16777216) continue;
                int grey = ColorChangerMonochrome.getGrayScale(rgb);
                if (darkerRgb != -1 && grey >= ColorChangerMonochrome.getGrayScale(darkerRgb)) continue;
                darkerRgb = rgb;
            }
        }
        return darkerRgb;
    }

    private int getRgb(int color) {
        return color & 0xFFFFFF;
    }

    private int getA(int color) {
        return color & 0xFF000000;
    }

    private static BufferedImage deepCopyOld(BufferedImage bi) {
        ColorModel cm = bi.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = bi.copyData(bi.getRaster().createCompatibleWritableRaster());
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    private BufferedImage deepCopy2() {
        BufferedImage result = new BufferedImage(this.image.getWidth(), this.image.getHeight(), 2);
        for (int i = 0; i < this.image.getWidth(); ++i) {
            for (int j = 0; j < this.image.getHeight(); ++j) {
                result.setRGB(i, j, this.image.getRGB(i, j));
            }
        }
        return result;
    }
}

