/*
 * Decompiled with CFR 0.152.
 */
package sbt.internal.inc;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import sbt.internal.inc.APIs;
import sbt.internal.inc.Analysis;
import sbt.internal.inc.CompanionsStore;
import sbt.internal.inc.FileAnalysisStore$;
import sbt.internal.inc.JavaInterfaceUtil$;
import sbt.internal.inc.binary.BinaryAnalysisFormat;
import sbt.internal.inc.text.TextAnalysisFormat;
import sbt.io.IO$;
import sbt.io.Using$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.Exception$;
import xsbti.api.Companions;
import xsbti.compile.AnalysisContents;
import xsbti.compile.AnalysisStore;
import xsbti.compile.CompileAnalysis;
import xsbti.compile.MiniSetup;
import xsbti.compile.analysis.ReadWriteMappers;

@ScalaSignature(bytes="\u0006\u0001\u0005\rw!\u0002\u0015*\u0011\u0003\u0001d!\u0002\u001a*\u0011\u0003\u0019\u0004\"\u0002\u001e\u0002\t\u0003Y\u0004b\u0002\u001f\u0002\u0005\u0004%i!\u0010\u0005\u0007\u0003\u0006\u0001\u000bQ\u0002 \t\u000f\t\u000b!\u0019!C\u0007\u0007\"1q*\u0001Q\u0001\u000e\u0011Cq\u0001U\u0001C\u0002\u001351\t\u0003\u0004R\u0003\u0001\u0006i\u0001\u0012\u0005\u0006%\u0006!\ta\u0015\u0005\u0006%\u0006!\tA\u001a\u0005\u0006a\u0006!\t!\u001d\u0005\u0006a\u0006!\t\u0001\u001e\u0005\u0006a\u0006!\ta\u001e\u0004\u0007\u0003\u0003\ta!a\u0001\t\u0011Mt!\u0011!Q\u0001\nyC\u0011\"!\u0005\u000f\u0005\u0003\u0005\u000b\u0011\u00026\t\rirA\u0011AA\n\u0011!QhB1A\u0005\u000e\u0005u\u0001\u0002CA\u0015\u001d\u0001\u0006i!a\b\t\u0013\u0005-bB1A\u0005\u000e\u00055\u0002\u0002CA\u001b\u001d\u0001\u0006i!a\f\t\u000f\u0005]b\u0002\"\u0011\u0002:!9\u0011Q\n\b\u0005B\u0005=cABA.\u0003\u0019\ti\u0006\u0003\u0005t1\t\u0005\t\u0015!\u0003_\u0011!Q\bD!A!\u0002\u0013Y\bB\u0002\u001e\u0019\t\u0003\ty\u0006C\u0005\u0002ha\u0011\r\u0011\"\u0001\u0002j!A\u0011\u0011\u0015\r!\u0002\u0013\tY\u0007C\u0004\u0002Na!\t!a)\t\u000f\u0005]\u0002\u0004\"\u0001\u0002:!9\u0011Q\u0014\r\u0005\u0002\u0005%\u0006bBAV\u0003\u0011%\u0011Q\u0016\u0004\u0007\u0003[\na!a\u001c\t\u0011M\u0014#\u0011!Q\u0001\nyC\u0001B\u001f\u0012\u0003\u0002\u0003\u0006Ia\u001f\u0005\u0007u\t\"\t!a\u001e\t\u000f\u0005]\"\u0005\"\u0001\u0002~!9\u0011Q\u0014\u0012\u0005\u0002\u0005}\u0015!\u0005$jY\u0016\fe.\u00197zg&\u001c8\u000b^8sK*\u0011!fK\u0001\u0004S:\u001c'B\u0001\u0017.\u0003!Ig\u000e^3s]\u0006d'\"\u0001\u0018\u0002\u0007M\u0014Go\u0001\u0001\u0011\u0005E\nQ\"A\u0015\u0003#\u0019KG.Z!oC2L8/[:Ti>\u0014Xm\u0005\u0002\u0002iA\u0011Q\u0007O\u0007\u0002m)\tq'A\u0003tG\u0006d\u0017-\u0003\u0002:m\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u0019\u0002\u0019\tKg.\u0012=uK:\u001c\u0018n\u001c8\u0016\u0003yz\u0011aP\u0011\u0002\u0001\u0006\u0019!-\u001b8\u0002\u001b\tKg.\u0012=uK:\u001c\u0018n\u001c8!\u0003A\tg.\u00197zg&\u001ch)\u001b7f\u001d\u0006lW-F\u0001E!\t)EJ\u0004\u0002G\u0015B\u0011qIN\u0007\u0002\u0011*\u0011\u0011jL\u0001\u0007yI|w\u000e\u001e \n\u0005-3\u0014A\u0002)sK\u0012,g-\u0003\u0002N\u001d\n11\u000b\u001e:j]\u001eT!a\u0013\u001c\u0002#\u0005t\u0017\r\\=tSN4\u0015\u000e\\3OC6,\u0007%\u0001\nd_6\u0004\u0018M\\5p]N4\u0015\u000e\\3OC6,\u0017aE2p[B\fg.[8og\u001aKG.\u001a(b[\u0016\u0004\u0013A\u00022j]\u0006\u0014\u0018\u0010\u0006\u0002U9B\u0011QKW\u0007\u0002-*\u0011q\u000bW\u0001\bG>l\u0007/\u001b7f\u0015\u0005I\u0016!\u0002=tERL\u0017BA.W\u00055\te.\u00197zg&\u001c8\u000b^8sK\")Q,\u0003a\u0001=\u0006a\u0011M\\1msNL7OR5mKB\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\u0003S>T\u0011aY\u0001\u0005U\u00064\u0018-\u0003\u0002fA\n!a)\u001b7f)\r!v\r\u001b\u0005\u0006;*\u0001\rA\u0018\u0005\u0006S*\u0001\rA[\u0001\b[\u0006\u0004\b/\u001a:t!\tYg.D\u0001m\u0015\tig+\u0001\u0005b]\u0006d\u0017p]5t\u0013\tyGN\u0001\tSK\u0006$wK]5uK6\u000b\u0007\u000f]3sg\u0006!A/\u001a=u)\t!&\u000fC\u0003t\u0017\u0001\u0007a,\u0001\u0003gS2,Gc\u0001+vm\")1\u000f\u0004a\u0001=\")\u0011\u000e\u0004a\u0001UR\u0019A\u000b_=\t\u000bMl\u0001\u0019\u00010\t\u000bil\u0001\u0019A>\u0002\r\u0019|'/\\1u!\tah0D\u0001~\u0015\t\u0001\u0018&\u0003\u0002\u0000{\n\u0011B+\u001a=u\u0003:\fG._:jg\u001a{'/\\1u\u0005=\u0011\u0015N\\1ss\u001aKG.Z*u_J,7\u0003\u0002\b\u0002\u0006Q\u0003B!a\u0002\u0002\u000e5\u0011\u0011\u0011\u0002\u0006\u0004\u0003\u0017\u0011\u0017\u0001\u00027b]\u001eLA!a\u0004\u0002\n\t1qJ\u00196fGR\f\u0001C]3bI^\u0013\u0018\u000e^3NCB\u0004XM]:\u0015\r\u0005U\u0011\u0011DA\u000e!\r\t9BD\u0007\u0002\u0003!)1/\u0005a\u0001=\"1\u0011\u0011C\tA\u0002),\"!a\b\u0011\t\u0005\u0005\u0012QE\u0007\u0003\u0003GQ!AU\u0015\n\t\u0005\u001d\u00121\u0005\u0002\u0015\u0005&t\u0017M]=B]\u0006d\u0017p]5t\r>\u0014X.\u0019;\u0002\u000f\u0019|'/\\1uA\u0005IA+\u001c9F]\u0012LgnZ\u000b\u0003\u0003_y!!!\r\"\u0005\u0005M\u0012\u0001\u0002\u0018u[B\f!\u0002V7q\u000b:$\u0017N\\4!\u0003\r9W\r\u001e\u000b\u0003\u0003w\u0001b!!\u0010\u0002D\u0005\u001dSBAA \u0015\r\t\tEY\u0001\u0005kRLG.\u0003\u0003\u0002F\u0005}\"\u0001C(qi&|g.\u00197\u0011\u0007U\u000bI%C\u0002\u0002LY\u0013\u0001#\u00118bYf\u001c\u0018n]\"p]R,g\u000e^:\u0002\u0007M,G\u000f\u0006\u0003\u0002R\u0005]\u0003cA\u001b\u0002T%\u0019\u0011Q\u000b\u001c\u0003\tUs\u0017\u000e\u001e\u0005\b\u00033:\u0002\u0019AA$\u0003!\u0019wN\u001c;f]R\u001c(A\u0005$jY\u0016\u0014\u0015m]3e'R|'/Z%na2\u001cB\u0001GA\u0003)R1\u0011\u0011MA2\u0003K\u00022!a\u0006\u0019\u0011\u0015\u00198\u00041\u0001_\u0011\u0015Q8\u00041\u0001|\u0003=\u0019w.\u001c9b]&|gn]*u_J,WCAA6!\r\t9B\t\u0002\u001c\r&dWMQ1tK\u0012\u001cu.\u001c9b]&|gn]'baN#xN]3\u0014\t\t\"\u0014\u0011\u000f\t\u0004c\u0005M\u0014bAA;S\ty1i\\7qC:LwN\\:Ti>\u0014X\r\u0006\u0004\u0002l\u0005e\u00141\u0010\u0005\u0006g\u0016\u0002\rA\u0018\u0005\u0006u\u0016\u0002\ra\u001f\u000b\u0003\u0003\u007f\u0002R!NAA\u0003\u000bK1!a!7\u0005\u0019y\u0005\u000f^5p]B9Q'a\"\u0002\f\u0006-\u0015bAAEm\t1A+\u001e9mKJ\u0002b!RAG\t\u0006E\u0015bAAH\u001d\n\u0019Q*\u00199\u0011\t\u0005M\u0015\u0011T\u0007\u0003\u0003+S1!a&Y\u0003\r\t\u0007/[\u0005\u0005\u00037\u000b)J\u0001\u0006D_6\u0004\u0018M\\5p]N\f1bZ3u+:\u001c\u0017-^4iiR\u0011\u0011QQ\u0001\u0011G>l\u0007/\u00198j_:\u001c8\u000b^8sK\u0002\"B!!\u0015\u0002&\"9\u0011q\u0015\u0010A\u0002\u0005\u001d\u0013\u0001E1oC2L8/[:D_:$XM\u001c;t)\t\t9%A\u0006m_>\\W\u000f]#oiJLHCBA)\u0003_\u000by\fC\u0004\u00022\u0006\u0002\r!a-\u0002\u0005%t\u0007\u0003BA[\u0003wk!!a.\u000b\t\u0005e\u0016qH\u0001\u0004u&\u0004\u0018\u0002BA_\u0003o\u0013aBW5q\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004\u0002B\u0006\u0002\r\u0001R\u0001\u0005]\u0006lW\r")
public final class FileAnalysisStore {
    public static AnalysisStore text(File file, TextAnalysisFormat textAnalysisFormat) {
        return FileAnalysisStore$.MODULE$.text(file, textAnalysisFormat);
    }

    public static AnalysisStore text(File file, ReadWriteMappers readWriteMappers) {
        return FileAnalysisStore$.MODULE$.text(file, readWriteMappers);
    }

    public static AnalysisStore text(File file) {
        return FileAnalysisStore$.MODULE$.text(file);
    }

    public static AnalysisStore binary(File file, ReadWriteMappers readWriteMappers) {
        return FileAnalysisStore$.MODULE$.binary(file, readWriteMappers);
    }

    public static AnalysisStore binary(File file) {
        return FileAnalysisStore$.MODULE$.binary(file);
    }

    public static final class BinaryFileStore
    implements AnalysisStore {
        private final File file;
        private final BinaryAnalysisFormat format;

        private final BinaryAnalysisFormat format() {
            return this.format;
        }

        private final String TmpEnding() {
            return ".tmp";
        }

        public Optional<AnalysisContents> get() {
            Option nestedRead = Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> (Option)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream($this.file), (Function1 & Serializable & scala.Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName());
                CodedInputStream reader = CodedInputStream.newInstance((InputStream)inputStream);
                Tuple2<CompileAnalysis, MiniSetup> tuple2 = this.format().read(reader);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompileAnalysis analysis2 = (CompileAnalysis)tuple2._1();
                MiniSetup miniSetup = (MiniSetup)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)analysis2, (Object)miniSetup);
                Tuple2 tuple23 = tuple22;
                CompileAnalysis analysis3 = (CompileAnalysis)tuple23._1();
                MiniSetup miniSetup2 = (MiniSetup)tuple23._2();
                Option analysisWithAPIs = Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> {
                    FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName());
                    return this.format().readAPIs(reader, analysis3, miniSetup2.storeApis());
                });
                return analysisWithAPIs.map((Function1 & Serializable & scala.Serializable)analysis -> AnalysisContents.create((CompileAnalysis)analysis, (MiniSetup)miniSetup2));
            }));
            return JavaInterfaceUtil$.MODULE$.EnrichOption(nestedRead.flatten(Predef$.MODULE$.$conforms())).toOptional();
        }

        public void set(AnalysisContents contents) {
            CompileAnalysis analysis = contents.getAnalysis();
            MiniSetup setup = contents.getMiniSetup();
            File tmpAnalysisFile = File.createTempFile(this.file.getName(), ".tmp");
            Object object = !this.file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)this.file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            FileOutputStream outputStream2 = new FileOutputStream(tmpAnalysisFile);
            Using$.MODULE$.zipOutputStream().apply((Object)outputStream2, (Function1 & Serializable & scala.Serializable)outputStream -> {
                BinaryFileStore.$anonfun$set$1(this, analysis, setup, outputStream);
                return BoxedUnit.UNIT;
            });
            IO$.MODULE$.move(tmpAnalysisFile, this.file);
        }

        public static final /* synthetic */ void $anonfun$set$1(BinaryFileStore $this, CompileAnalysis analysis$2, MiniSetup setup$1, ZipOutputStream outputStream) {
            CodedOutputStream protobufWriter = CodedOutputStream.newInstance((OutputStream)outputStream);
            outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName()));
            $this.format().write(protobufWriter, analysis$2, setup$1);
            outputStream.closeEntry();
            outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName()));
            $this.format().writeAPIs(protobufWriter, analysis$2, setup$1.storeApis());
            outputStream.closeEntry();
        }

        public BinaryFileStore(File file, ReadWriteMappers readWriteMappers) {
            this.file = file;
            this.format = new BinaryAnalysisFormat(readWriteMappers);
        }
    }

    public static final class FileBasedCompanionsMapStore
    implements CompanionsStore {
        private final File file;
        private final TextAnalysisFormat format;

        public Option<Tuple2<Map<String, Companions>, Map<String, Companions>>> get() {
            return Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> this.getUncaught());
        }

        public Tuple2<Map<String, Companions>, Map<String, Companions>> getUncaught() {
            return (Tuple2)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream(this.file), (Function1 & Serializable & scala.Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName());
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, IO$.MODULE$.utf8()));
                return $this.format.readCompanionMap(reader);
            });
        }

        public FileBasedCompanionsMapStore(File file, TextAnalysisFormat format) {
            this.file = file;
            this.format = format;
        }
    }

    public static final class FileBasedStoreImpl
    implements AnalysisStore {
        private final File file;
        private final TextAnalysisFormat format;
        private final FileBasedCompanionsMapStore companionsStore;

        public FileBasedCompanionsMapStore companionsStore() {
            return this.companionsStore;
        }

        public void set(AnalysisContents analysisContents) {
            CompileAnalysis analysis = analysisContents.getAnalysis();
            MiniSetup setup = analysisContents.getMiniSetup();
            File tmpAnalysisFile = File.createTempFile(this.file.getName(), ".tmp");
            Object object = !this.file.getParentFile().exists() ? BoxesRunTime.boxToBoolean((boolean)this.file.getParentFile().mkdirs()) : BoxedUnit.UNIT;
            Using$.MODULE$.zipOutputStream().apply((Object)new FileOutputStream(tmpAnalysisFile), (Function1 & Serializable & scala.Serializable)outputStream -> {
                FileBasedStoreImpl.$anonfun$set$2(this, analysis, setup, outputStream);
                return BoxedUnit.UNIT;
            });
            IO$.MODULE$.move(tmpAnalysisFile, this.file);
        }

        public Optional<AnalysisContents> get() {
            return JavaInterfaceUtil$.MODULE$.EnrichOption(Exception$.MODULE$.allCatch().opt((Function0 & Serializable & scala.Serializable)() -> this.getUncaught())).toOptional();
        }

        public AnalysisContents getUncaught() {
            return (AnalysisContents)Using$.MODULE$.zipInputStream().apply((Object)new FileInputStream(this.file), (Function1 & Serializable & scala.Serializable)inputStream -> {
                FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$lookupEntry((ZipInputStream)inputStream, FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName());
                BufferedReader writer = new BufferedReader(new InputStreamReader((InputStream)inputStream, IO$.MODULE$.utf8()));
                Tuple2<CompileAnalysis, MiniSetup> tuple2 = $this.format.read(writer, this.companionsStore());
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                CompileAnalysis analysis = (CompileAnalysis)tuple2._1();
                MiniSetup setup = (MiniSetup)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)analysis, (Object)setup);
                Tuple2 tuple23 = tuple22;
                CompileAnalysis analysis2 = (CompileAnalysis)tuple23._1();
                MiniSetup setup2 = (MiniSetup)tuple23._2();
                return AnalysisContents.create((CompileAnalysis)analysis2, (MiniSetup)setup2);
            });
        }

        public static final /* synthetic */ void $anonfun$set$2(FileBasedStoreImpl $this, CompileAnalysis analysis$3, MiniSetup setup$2, ZipOutputStream outputStream) {
            block1: {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, IO$.MODULE$.utf8()));
                outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$analysisFileName()));
                $this.format.write(writer, analysis$3, setup$2);
                outputStream.closeEntry();
                if (!setup$2.storeApis()) break block1;
                outputStream.putNextEntry(new ZipEntry(FileAnalysisStore$.MODULE$.sbt$internal$inc$FileAnalysisStore$$companionsFileName()));
                CompileAnalysis compileAnalysis = analysis$3;
                if (!(compileAnalysis instanceof Analysis)) {
                    throw new MatchError((Object)compileAnalysis);
                }
                Analysis analysis = (Analysis)compileAnalysis;
                APIs aPIs = analysis.apis();
                $this.format.writeCompanionMap(writer, aPIs);
                outputStream.closeEntry();
            }
        }

        public FileBasedStoreImpl(File file, TextAnalysisFormat format) {
            this.file = file;
            this.format = format;
            this.companionsStore = new FileBasedCompanionsMapStore(file, format);
        }
    }
}

