/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.save;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tim.prune.App;
import tim.prune.ExternalTools;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;
import tim.prune.save.GpxExporter;
import tim.prune.save.SettingsForExport;

public class GpsSaver
extends GenericFunction
implements Runnable {
    private boolean _gpsBabelChecked = false;
    private JDialog _dialog = null;
    private JTextField _deviceField = null;
    private JTextField _formatField = null;
    private JTextField _trackNameField = null;
    private JCheckBox _waypointCheckbox = null;
    private JCheckBox _trackCheckbox = null;
    private boolean _switchedWaypointsOff = false;
    private boolean _switchedTrackpointsOff = false;
    private JButton _okButton = null;
    private JProgressBar _progressBar = null;
    private boolean _cancelled = false;

    public GpsSaver(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.sendtogps";
    }

    @Override
    public void begin() {
        if (this._gpsBabelChecked || ExternalTools.isToolInstalled(1) || JOptionPane.showConfirmDialog(this._dialog, I18nManager.getText("dialog.gpsload.nogpsbabel"), I18nManager.getText(this.getNameKey()), 0, 2) == 0) {
            this._gpsBabelChecked = true;
            if (this._dialog == null) {
                this._dialog = new JDialog(this._parentFrame, I18nManager.getText("function.sendtogps"), true);
                this._dialog.setLocationRelativeTo(this._parentFrame);
                this._dialog.setDefaultCloseOperation(2);
                this._dialog.getContentPane().add(this.makeDialogComponents());
                this._dialog.pack();
            }
            this.enableCheckboxes();
            this.enableOkButton();
            this.setupProgressBar(true);
            this._trackNameField.requestFocus();
            this._dialog.setVisible(true);
        }
    }

    private JPanel makeDialogComponents() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(0, 2, 10, 3));
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.gpsload.device"));
        jLabel.setHorizontalAlignment(4);
        jPanel3.add(jLabel);
        this._deviceField = new JTextField(Config.getConfigString("prune.gpsdevice"), 12);
        jPanel3.add(this._deviceField);
        JLabel jLabel2 = new JLabel(I18nManager.getText("dialog.gpsload.format"));
        jLabel2.setHorizontalAlignment(4);
        jPanel3.add(jLabel2);
        this._formatField = new JTextField(Config.getConfigString("prune.gpsformat"), 12);
        jPanel3.add(this._formatField);
        JLabel jLabel3 = new JLabel(I18nManager.getText("dialog.gpssend.trackname"));
        jLabel3.setHorizontalAlignment(4);
        jPanel3.add(jLabel3);
        this._trackNameField = new JTextField("", 12);
        jPanel3.add(this._trackNameField);
        jPanel3.setAlignmentX(0.5f);
        jPanel3.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 20));
        jPanel2.add(jPanel3);
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    GpsSaver.this._dialog.dispose();
                }
            }
        };
        this._deviceField.addKeyListener(keyAdapter);
        this._formatField.addKeyListener(keyAdapter);
        this._trackNameField.addKeyListener(keyAdapter);
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GpsSaver.this.enableOkButton();
            }
        };
        this._waypointCheckbox = new JCheckBox(I18nManager.getText("dialog.gpssend.sendwaypoints"), true);
        this._waypointCheckbox.addChangeListener(changeListener);
        this._waypointCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._waypointCheckbox);
        this._trackCheckbox = new JCheckBox(I18nManager.getText("dialog.gpssend.sendtracks"), true);
        this._trackCheckbox.addChangeListener(changeListener);
        this._trackCheckbox.setAlignmentX(0.5f);
        jPanel2.add(this._trackCheckbox);
        this._progressBar = new JProgressBar(0, 10);
        jPanel2.add(this._progressBar);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(2));
        this._okButton = new JButton(I18nManager.getText("button.ok"));
        this._okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsSaver.this._cancelled = false;
                new Thread(GpsSaver.this).start();
            }
        });
        jPanel4.add(this._okButton);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GpsSaver.this._cancelled = true;
                GpsSaver.this._dialog.dispose();
            }
        });
        jPanel4.add(jButton);
        jPanel.add((Component)jPanel4, "South");
        return jPanel;
    }

    private void setupProgressBar(boolean bl) {
        this._progressBar.setVisible(!bl);
        this._progressBar.setIndeterminate(false);
        this._progressBar.setValue(0);
    }

    private void enableCheckboxes() {
        if (this._waypointCheckbox.isSelected()) {
            if (!this._app.getTrackInfo().getTrack().hasWaypoints()) {
                this._waypointCheckbox.setSelected(false);
                this._switchedWaypointsOff = true;
            } else {
                this._switchedWaypointsOff = false;
            }
        } else if (this._app.getTrackInfo().getTrack().hasWaypoints() && this._switchedWaypointsOff) {
            this._waypointCheckbox.setSelected(true);
            this._switchedWaypointsOff = false;
        }
        if (this._trackCheckbox.isSelected()) {
            if (!this._app.getTrackInfo().getTrack().hasTrackPoints()) {
                this._trackCheckbox.setSelected(false);
                this._switchedTrackpointsOff = true;
            } else {
                this._switchedTrackpointsOff = false;
            }
        } else if (this._app.getTrackInfo().getTrack().hasTrackPoints() && this._switchedTrackpointsOff) {
            this._trackCheckbox.setSelected(true);
            this._switchedTrackpointsOff = false;
        }
    }

    private void enableOkButton() {
        this._okButton.setEnabled(this._waypointCheckbox.isSelected() || this._trackCheckbox.isSelected());
    }

    @Override
    public void run() {
        this._okButton.setEnabled(false);
        this.setupProgressBar(false);
        this._progressBar.setIndeterminate(true);
        try {
            this.callGpsBabel();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this._dialog, exception.getMessage(), I18nManager.getText("function.sendtogps"), 0);
            this._cancelled = true;
        }
        this.setupProgressBar(true);
        this.enableOkButton();
        if (!this._cancelled) {
            this._dialog.dispose();
        }
    }

    private void callGpsBabel() throws Exception {
        String string = Config.getConfigString("prune.gpsbabelpath");
        String[] stringArray = null;
        String string2 = this._deviceField.getText().trim();
        String string3 = this._formatField.getText().trim();
        if (this._waypointCheckbox.isSelected() && this._trackCheckbox.isSelected()) {
            stringArray = new String[]{string, "-w", "-t", "-i", "gpx", "-f", "-", "-o", string3, "-F", string2};
        } else {
            stringArray = new String[]{string, "-w", "-i", "gpx", "-f", "-", "-o", string3, "-F", string2};
            if (this._trackCheckbox.isSelected()) {
                stringArray[1] = "-t";
            }
        }
        Config.setConfigString("prune.gpsdevice", string2);
        Config.setConfigString("prune.gpsformat", string3);
        String string4 = "";
        Process process = Runtime.getRuntime().exec(stringArray);
        String string5 = this._trackNameField.getText();
        if (string5 == null || string5.equals("")) {
            string5 = "gpsprune";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(process.getOutputStream());
        SettingsForExport settingsForExport = new SettingsForExport();
        settingsForExport.setExportMissingAltitudesAsZero(true);
        GpxExporter.exportData(outputStreamWriter, this._app.getTrackInfo(), string5, null, settingsForExport, null);
        outputStreamWriter.close();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String string6 = null;
        String string7 = "";
        while ((string6 = bufferedReader.readLine()) != null) {
            string7 = String.valueOf(string7) + string6 + "\n";
        }
        try {
            bufferedReader.close();
        }
        catch (Exception exception) {}
        if (string7.length() > 0) {
            string4 = string7;
        }
        if (string4.length() > 0) {
            throw new Exception(string4);
        }
    }
}

