/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.undo;

import tim.prune.I18nManager;
import tim.prune.data.DataPoint;
import tim.prune.data.MediaObject;
import tim.prune.data.Photo;
import tim.prune.data.TrackInfo;
import tim.prune.undo.UndoException;
import tim.prune.undo.UndoOperation;

public class UndoCorrelatePhotos
implements UndoOperation {
    private DataPoint[] _contents = null;
    private DataPoint[] _photoPoints = null;
    private int _numPhotosCorrelated = -1;

    public UndoCorrelatePhotos(TrackInfo trackInfo) {
        this._contents = trackInfo.getTrack().cloneContents();
        int n = trackInfo.getPhotoList().getNumPhotos();
        this._photoPoints = new DataPoint[n];
        int n2 = 0;
        while (n2 < n) {
            this._photoPoints[n2] = trackInfo.getPhotoList().getPhoto(n2).getDataPoint();
            ++n2;
        }
    }

    public void setNumPhotosCorrelated(int n) {
        this._numPhotosCorrelated = n;
    }

    @Override
    public String getDescription() {
        return String.valueOf(I18nManager.getText("undo.correlatephotos")) + " (" + this._numPhotosCorrelated + ")";
    }

    @Override
    public void performUndo(TrackInfo trackInfo) throws UndoException {
        trackInfo.getTrack().replaceContents(this._contents);
        int n = 0;
        while (n < this._photoPoints.length) {
            Photo photo = trackInfo.getPhotoList().getPhoto(n);
            if (photo.getCurrentStatus() == MediaObject.Status.CONNECTED) {
                DataPoint dataPoint = this._photoPoints[n];
                DataPoint dataPoint2 = photo.getDataPoint();
                photo.setDataPoint(dataPoint);
                if (dataPoint2 != null) {
                    dataPoint2.setPhoto(null);
                }
                if (dataPoint != null) {
                    dataPoint.setPhoto(photo);
                }
            }
            ++n;
        }
        trackInfo.getSelection().clearAll();
    }
}

