/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.symbol;

import java.lang.invoke.MethodType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.objectweb.asm.commons.Method;

public class FunctionTable {
    protected Map<String, LocalFunction> localFunctions = new HashMap<String, LocalFunction>();

    public static String buildLocalFunctionKey(String functionName, int functionArity) {
        return functionName + "/" + functionArity;
    }

    public LocalFunction addFunction(String functionName, Class<?> returnType, List<Class<?>> typeParameters, boolean isInternal) {
        String functionKey = FunctionTable.buildLocalFunctionKey(functionName, typeParameters.size());
        LocalFunction function = new LocalFunction(functionName, returnType, typeParameters, isInternal);
        this.localFunctions.put(functionKey, function);
        return function;
    }

    public LocalFunction addFunction(LocalFunction function) {
        String functionKey = FunctionTable.buildLocalFunctionKey(function.getFunctionName(), function.getTypeParameters().size());
        this.localFunctions.put(functionKey, function);
        return function;
    }

    public LocalFunction getFunction(String functionName, int functionArity) {
        String functionKey = FunctionTable.buildLocalFunctionKey(functionName, functionArity);
        return this.localFunctions.get(functionKey);
    }

    public LocalFunction getFunction(String functionKey) {
        return this.localFunctions.get(functionKey);
    }

    public static class LocalFunction {
        protected final String functionName;
        protected final Class<?> returnType;
        protected final List<Class<?>> typeParameters;
        protected final boolean isInternal;
        protected final MethodType methodType;
        protected final Method asmMethod;

        public LocalFunction(String functionName, Class<?> returnType, List<Class<?>> typeParameters, boolean isInternal) {
            this.functionName = Objects.requireNonNull(functionName);
            this.returnType = Objects.requireNonNull(returnType);
            this.typeParameters = Collections.unmodifiableList(Objects.requireNonNull(typeParameters));
            this.isInternal = isInternal;
            Class<?> javaReturnType = PainlessLookupUtility.typeToJavaType(returnType);
            Class[] javaTypeParameters = (Class[])typeParameters.stream().map(PainlessLookupUtility::typeToJavaType).toArray(Class[]::new);
            this.methodType = MethodType.methodType(javaReturnType, javaTypeParameters);
            this.asmMethod = new Method(functionName, MethodType.methodType(javaReturnType, javaTypeParameters).toMethodDescriptorString());
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public List<Class<?>> getTypeParameters() {
            return this.typeParameters;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public MethodType getMethodType() {
            return this.methodType;
        }

        public Method getAsmMethod() {
            return this.asmMethod;
        }
    }
}

