/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.context;

import io.micronaut.context.BeanDefinitionRegistry;
import io.micronaut.context.BeanLocator;
import io.micronaut.context.DefaultBeanContext;
import io.micronaut.context.ExecutionHandleLocator;
import io.micronaut.context.LifeCycle;
import io.micronaut.context.Qualifier;
import io.micronaut.context.event.ApplicationEventPublisher;
import io.micronaut.core.annotation.AnnotationMetadataResolver;
import io.micronaut.inject.BeanIdentifier;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.NotNull;

public interface BeanContext
extends LifeCycle<BeanContext>,
ExecutionHandleLocator,
BeanLocator,
BeanDefinitionRegistry,
ApplicationEventPublisher,
AnnotationMetadataResolver {
    @Nonnull
    public <T> T inject(@Nonnull T var1);

    @Nonnull
    default public <T> T createBean(@Nonnull Class<T> beanType) {
        return this.createBean(beanType, (Qualifier)null);
    }

    @Nonnull
    public <T> T createBean(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2);

    @Nonnull
    public <T> T createBean(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2, @Nullable Map<String, Object> var3);

    @Nonnull
    public <T> T createBean(@Nonnull Class<T> var1, @Nullable Qualifier<T> var2, Object ... var3);

    @Nonnull
    default public <T> T createBean(@Nonnull Class<T> beanType, Object ... args) {
        return this.createBean(beanType, null, args);
    }

    @Nonnull
    default public <T> T createBean(@Nonnull Class<T> beanType, @Nullable Map<String, Object> argumentValues) {
        return this.createBean(beanType, null, argumentValues);
    }

    @Nullable
    public <T> T destroyBean(@Nonnull Class<T> var1);

    @Nonnull
    public <T> Optional<T> refreshBean(@Nullable BeanIdentifier var1);

    @Nonnull
    public ClassLoader getClassLoader();

    @Override
    @Nonnull
    public <T> BeanContext registerSingleton(@Nonnull Class<T> var1, @Nonnull T var2, @Nullable Qualifier<T> var3, boolean var4);

    @Override
    default public BeanContext registerSingleton(@Nonnull Object singleton) {
        Objects.requireNonNull(singleton, "Argument [singleton] must not be null");
        Class<?> type = singleton.getClass();
        return this.registerSingleton((Class)type, singleton);
    }

    @Override
    default public <T> BeanContext registerSingleton(Class<T> type, T singleton, Qualifier<T> qualifier) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)qualifier, true);
    }

    @Override
    default public <T> BeanContext registerSingleton(Class<T> type, T singleton) {
        return this.registerSingleton((Class)type, (Object)singleton, (Qualifier)null, true);
    }

    @Override
    @NotNull
    default public BeanContext registerSingleton(@NotNull Object singleton, boolean inject) {
        return (BeanContext)BeanDefinitionRegistry.super.registerSingleton(singleton, inject);
    }

    @Nonnull
    public static BeanContext run() {
        return (BeanContext)BeanContext.build().start();
    }

    @Nonnull
    public static BeanContext build() {
        return new DefaultBeanContext();
    }

    @Nonnull
    public static BeanContext run(ClassLoader classLoader) {
        return (BeanContext)BeanContext.build(classLoader).start();
    }

    @Nonnull
    public static BeanContext build(ClassLoader classLoader) {
        return new DefaultBeanContext(classLoader);
    }
}

