/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.service;

import java.io.Closeable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.service.RelevantMethods;
import org.gradle.internal.service.ServiceCreationException;
import org.gradle.internal.service.ServiceLookupException;
import org.gradle.internal.service.ServiceMethod;
import org.gradle.internal.service.ServiceRegistration;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceValidationException;
import org.gradle.internal.service.UnknownServiceException;

public class DefaultServiceRegistry
implements ServiceRegistry,
Closeable {
    private static final ServiceRegistry[] NO_PARENTS = new ServiceRegistry[0];
    private static final Service[] NO_DEPENDENTS = new Service[0];
    private static final Object[] NO_PARAMS = new Object[0];
    private final OwnServices ownServices;
    private final ServiceProvider allServices;
    private final ServiceProvider parentServices;
    private final String displayName;
    private final ServiceProvider thisAsServiceProvider;
    private AtomicReference<State> state = new AtomicReference<State>(State.INIT);

    public DefaultServiceRegistry() {
        this((String)null, NO_PARENTS);
    }

    public DefaultServiceRegistry(String displayName) {
        this(displayName, NO_PARENTS);
    }

    public DefaultServiceRegistry(ServiceRegistry ... parents) {
        this((String)null, parents);
    }

    public DefaultServiceRegistry(String displayName, ServiceRegistry ... parents) {
        this.displayName = displayName;
        this.ownServices = new OwnServices();
        this.thisAsServiceProvider = new ParentServices(this);
        if (parents.length == 0) {
            this.parentServices = null;
            this.allServices = this.ownServices;
        } else {
            this.parentServices = DefaultServiceRegistry.setupParentServices(parents);
            this.allServices = new CompositeServiceProvider(new ServiceProvider[]{this.ownServices, this.parentServices});
        }
        this.findProviderMethods(this);
    }

    private static ServiceProvider setupParentServices(ServiceRegistry[] parents) {
        ServiceProvider parentServices;
        if (parents.length == 1) {
            parentServices = DefaultServiceRegistry.toParentServices(parents[0]);
        } else {
            ServiceProvider[] parentServiceProviders = new ServiceProvider[parents.length];
            for (int i = 0; i < parents.length; ++i) {
                parentServiceProviders[i] = DefaultServiceRegistry.toParentServices(parents[i]);
            }
            parentServices = new CompositeServiceProvider(parentServiceProviders);
        }
        return parentServices;
    }

    private ServiceProvider asProvider() {
        return this.thisAsServiceProvider;
    }

    private static ServiceProvider toParentServices(ServiceRegistry serviceRegistry) {
        if (serviceRegistry instanceof DefaultServiceRegistry) {
            return ((DefaultServiceRegistry)serviceRegistry).asProvider();
        }
        return new ParentServices(serviceRegistry);
    }

    public static ServiceRegistry create(Object ... providers) {
        DefaultServiceRegistry registry = new DefaultServiceRegistry();
        for (Object provider : providers) {
            registry.addProvider(provider);
        }
        return registry;
    }

    private String getDisplayName() {
        return this.displayName == null ? this.getClass().getSimpleName() : this.displayName;
    }

    public String toString() {
        return this.getDisplayName();
    }

    private void findProviderMethods(Object target) {
        Class<?> type = target.getClass();
        RelevantMethods methods = RelevantMethods.getMethods(type);
        for (ServiceMethod method : methods.decorators) {
            if (this.parentServices == null) {
                throw new ServiceLookupException(String.format("Cannot use decorator method %s.%s() when no parent registry is provided.", type.getSimpleName(), method.getName()));
            }
            this.ownServices.add(new FactoryMethodService(this, target, method));
        }
        for (ServiceMethod method : methods.factories) {
            this.ownServices.add(new FactoryMethodService(this, target, method));
        }
        for (ServiceMethod method : methods.configurers) {
            this.applyConfigureMethod(method, target);
        }
    }

    private void applyConfigureMethod(ServiceMethod method, Object target) {
        Object[] params = new Object[method.getParameterTypes().length];
        for (int i = 0; i < method.getParameterTypes().length; ++i) {
            Type paramType = method.getParameterTypes()[i];
            if (paramType.equals(ServiceRegistration.class)) {
                params[i] = this.newRegistration();
                continue;
            }
            Service paramProvider = this.find(paramType, this.allServices);
            if (paramProvider == null) {
                throw new ServiceLookupException(String.format("Cannot configure services using %s.%s() as required service of type %s is not available.", method.getOwner().getSimpleName(), method.getName(), DefaultServiceRegistry.format(paramType)));
            }
            params[i] = paramProvider.get();
        }
        try {
            method.invoke(target, params);
        }
        catch (Exception e) {
            throw new ServiceLookupException(String.format("Could not configure services using %s.%s().", method.getOwner().getSimpleName(), method.getName()), e);
        }
    }

    public void register(Action<? super ServiceRegistration> action) {
        this.assertMutable();
        action.execute(this.newRegistration());
    }

    private void assertMutable() {
        if (this.state.get() != State.INIT) {
            throw new IllegalStateException("Cannot add provide to service registry " + this + " as it is no longer mutable");
        }
    }

    private ServiceRegistration newRegistration() {
        return new ServiceRegistration(){

            @Override
            public <T> void add(Class<T> serviceType, T serviceInstance) {
                DefaultServiceRegistry.this.add(serviceType, serviceInstance);
            }

            @Override
            public void add(Class<?> serviceType) {
                DefaultServiceRegistry.this.ownServices.add(new ConstructorService(DefaultServiceRegistry.this, serviceType));
            }

            @Override
            public void addProvider(Object provider) {
                DefaultServiceRegistry.this.addProvider(provider);
            }
        };
    }

    public <T> DefaultServiceRegistry add(Class<T> serviceType, T serviceInstance) {
        this.assertMutable();
        this.ownServices.add(new FixedInstanceService<T>(this, serviceType, serviceInstance));
        return this;
    }

    public DefaultServiceRegistry addProvider(Object provider) {
        this.assertMutable();
        this.findProviderMethods(provider);
        return this;
    }

    @Override
    public void close() {
        this.noLongerMutable();
        if (this.state.compareAndSet(State.STARTED, State.CLOSED)) {
            CompositeStoppable.stoppable(this.allServices).stop();
        }
    }

    private void serviceRequested() {
        this.noLongerMutable();
        if (this.state.get() == State.CLOSED) {
            throw new IllegalStateException(String.format("%s has been closed.", this.getDisplayName()));
        }
    }

    private void noLongerMutable() {
        if (this.state.compareAndSet(State.INIT, State.STARTED)) {
            this.ownServices.noLongerMutable();
        }
    }

    public boolean isClosed() {
        return this.state.get() == State.CLOSED;
    }

    @Override
    public <T> T get(Class<T> serviceType) throws UnknownServiceException, ServiceLookupException {
        return serviceType.cast(this.get((Type)serviceType));
    }

    @Override
    public Object get(Type serviceType) throws UnknownServiceException, ServiceLookupException {
        Object instance = this.find(serviceType);
        if (instance == null) {
            throw new UnknownServiceException(serviceType, String.format("No service of type %s available in %s.", DefaultServiceRegistry.format(serviceType), this.getDisplayName()));
        }
        return instance;
    }

    @Override
    public Object find(Type serviceType) throws ServiceLookupException {
        DefaultServiceRegistry.assertValidServiceType(DefaultServiceRegistry.unwrap(serviceType));
        Service provider = this.getService(serviceType);
        return provider == null ? null : provider.get();
    }

    private Service getService(Type serviceType) {
        this.serviceRequested();
        return this.find(serviceType, this.allServices);
    }

    @Override
    public <T> Factory<T> getFactory(Class<T> type) {
        Factory factory;
        DefaultServiceRegistry.assertValidServiceType(type);
        Service provider = this.getFactoryService(type);
        Factory factory2 = factory = provider == null ? null : (Factory)provider.get();
        if (factory == null) {
            throw new UnknownServiceException(type, String.format("No factory for objects of type %s available in %s.", DefaultServiceRegistry.format(type), this.getDisplayName()));
        }
        return factory;
    }

    private Service getFactoryService(Class<?> serviceType) {
        this.serviceRequested();
        return this.allServices.getFactory(serviceType);
    }

    @Override
    public <T> List<T> getAll(Class<T> serviceType) throws ServiceLookupException {
        DefaultServiceRegistry.assertValidServiceType(serviceType);
        ArrayList services = new ArrayList();
        this.collectServices(serviceType, new InstanceUnpackingList(serviceType, services));
        return services;
    }

    private <T> void collectServices(Class<T> serviceType, List<Service> results) {
        this.serviceRequested();
        this.allServices.getAll(serviceType, results);
    }

    @Override
    public <T> T newInstance(Class<T> type) {
        return this.getFactory(type).create();
    }

    private static Class<?> unwrap(Type type) {
        WildcardType wildcardType;
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof WildcardType && (wildcardType = (WildcardType)type).getUpperBounds()[0] instanceof Class && wildcardType.getLowerBounds().length == 0) {
            return (Class)wildcardType.getUpperBounds()[0];
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        return (Class)parameterizedType.getRawType();
    }

    private Service getThisAsService() {
        return new Service(){

            @Override
            public String getDisplayName() {
                return "ServiceRegistry " + DefaultServiceRegistry.this.getDisplayName();
            }

            @Override
            public Object get() {
                return DefaultServiceRegistry.this;
            }

            @Override
            public void requiredBy(ServiceProvider serviceProvider) {
            }
        };
    }

    public Service find(Type serviceType, ServiceProvider serviceProvider) {
        if (serviceType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)serviceType;
            Type rawType = parameterizedType.getRawType();
            if (rawType.equals(Factory.class)) {
                Type typeArg = parameterizedType.getActualTypeArguments()[0];
                return this.getFactoryService(typeArg, serviceProvider);
            }
            if (rawType instanceof Class) {
                if (((Class)rawType).isAssignableFrom(List.class)) {
                    Type typeArg = parameterizedType.getActualTypeArguments()[0];
                    return this.getCollectionService(typeArg, serviceProvider);
                }
                DefaultServiceRegistry.assertValidServiceType((Class)rawType);
                return serviceProvider.getService(serviceType);
            }
        }
        if (serviceType instanceof Class) {
            DefaultServiceRegistry.assertValidServiceType((Class)serviceType);
            return serviceProvider.getService(serviceType);
        }
        throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(serviceType)));
    }

    private Service getFactoryService(Type type, ServiceProvider serviceProvider) {
        if (type instanceof Class) {
            return serviceProvider.getFactory((Class)type);
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            if (wildcardType.getLowerBounds().length == 1 && wildcardType.getUpperBounds().length == 1 && wildcardType.getLowerBounds()[0] instanceof Class && wildcardType.getUpperBounds()[0].equals(Object.class)) {
                return serviceProvider.getFactory((Class)wildcardType.getLowerBounds()[0]);
            }
            if (wildcardType.getLowerBounds().length == 0 && wildcardType.getUpperBounds().length == 1 && wildcardType.getUpperBounds()[0] instanceof Class) {
                return serviceProvider.getFactory((Class)wildcardType.getUpperBounds()[0]);
            }
        }
        throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(type)));
    }

    private Service getCollectionService(Type elementType, ServiceProvider serviceProvider) {
        WildcardType wildcardType;
        if (elementType instanceof Class) {
            Class elementClass = (Class)elementType;
            return this.getCollectionService(elementClass, serviceProvider);
        }
        if (elementType instanceof WildcardType && (wildcardType = (WildcardType)elementType).getUpperBounds()[0] instanceof Class && wildcardType.getLowerBounds().length == 0) {
            Class elementClass = (Class)wildcardType.getUpperBounds()[0];
            return this.getCollectionService(elementClass, serviceProvider);
        }
        throw new ServiceValidationException(String.format("Locating services with type %s is not supported.", DefaultServiceRegistry.format(elementType)));
    }

    private Service getCollectionService(Class<?> elementClass, ServiceProvider serviceProvider) {
        DefaultServiceRegistry.assertValidServiceType(elementClass);
        ArrayList<Service> providers = new ArrayList<Service>();
        serviceProvider.getAll(elementClass, providers);
        ArrayList<Object> services = new ArrayList<Object>(providers.size());
        for (Service service : providers) {
            services.add(service.get());
        }
        return new CollectionService(elementClass, services, providers);
    }

    private static boolean isSatisfiedBy(Type expected, Type actual) {
        if (expected.equals(actual)) {
            return true;
        }
        if (expected instanceof Class) {
            return DefaultServiceRegistry.isSatisfiedBy((Class)expected, actual);
        }
        if (expected instanceof ParameterizedType) {
            return DefaultServiceRegistry.isSatisfiedBy((ParameterizedType)expected, actual);
        }
        return false;
    }

    private static boolean isSatisfiedBy(Class<?> expectedClass, Type actual) {
        if (actual instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actual;
            if (parameterizedType.getRawType() instanceof Class) {
                return expectedClass.isAssignableFrom((Class)parameterizedType.getRawType());
            }
        } else if (actual instanceof Class) {
            Class other = (Class)actual;
            return expectedClass.isAssignableFrom(other);
        }
        return false;
    }

    private static boolean isSatisfiedBy(ParameterizedType expectedParameterizedType, Type actual) {
        Type expectedRawType = expectedParameterizedType.getRawType();
        if (actual instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actual;
            if (!DefaultServiceRegistry.isSatisfiedBy(expectedRawType, parameterizedType.getRawType())) {
                return false;
            }
            Type[] expectedTypeArguments = expectedParameterizedType.getActualTypeArguments();
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                Type type = parameterizedType.getActualTypeArguments()[i];
                if (DefaultServiceRegistry.isSatisfiedBy(expectedTypeArguments[i], type)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static void assertValidServiceType(Class<?> serviceClass) {
        if (serviceClass.isArray()) {
            throw new ServiceValidationException("Locating services with array type is not supported.");
        }
        if (serviceClass.isAnnotation()) {
            throw new ServiceValidationException("Locating services with annotation type is not supported.");
        }
        if (serviceClass == Object.class) {
            throw new ServiceValidationException("Locating services with type Object is not supported.");
        }
    }

    private static String format(Type type) {
        if (type instanceof Class) {
            Class aClass = (Class)type;
            return aClass.getSimpleName();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            StringBuilder builder = new StringBuilder();
            builder.append(DefaultServiceRegistry.format(parameterizedType.getRawType()));
            builder.append("<");
            for (int i = 0; i < parameterizedType.getActualTypeArguments().length; ++i) {
                Type typeParam = parameterizedType.getActualTypeArguments()[i];
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(DefaultServiceRegistry.format(typeParam));
            }
            builder.append(">");
            return builder.toString();
        }
        return type.toString();
    }

    private static class CollectionService
    implements Service {
        private final Type typeArg;
        private final List<Object> services;
        private final List<Service> providers;

        public CollectionService(Type typeArg, List<Object> services, List<Service> providers) {
            this.typeArg = typeArg;
            this.services = services;
            this.providers = providers;
        }

        @Override
        public String getDisplayName() {
            return "services with type " + this.typeArg;
        }

        @Override
        public Object get() {
            return this.services;
        }

        @Override
        public void requiredBy(ServiceProvider serviceProvider) {
            for (Service service : this.providers) {
                service.requiredBy(serviceProvider);
            }
        }
    }

    private static class ParentServices
    implements ServiceProvider {
        private final ServiceRegistry parent;

        private ParentServices(ServiceRegistry parent) {
            this.parent = parent;
        }

        @Override
        public Service getFactory(Class<?> serviceType) {
            if (this.parent instanceof DefaultServiceRegistry) {
                return ((DefaultServiceRegistry)this.parent).getFactoryService(serviceType);
            }
            try {
                Factory<?> factory = this.parent.getFactory(serviceType);
                return this.instanceToService(factory);
            }
            catch (UnknownServiceException e) {
                if (!e.getType().equals(serviceType)) {
                    throw e;
                }
                return null;
            }
        }

        @Override
        public Service getService(Type serviceType) {
            if (this.parent instanceof DefaultServiceRegistry) {
                return ((DefaultServiceRegistry)this.parent).getService(serviceType);
            }
            try {
                Object service = this.parent.get(serviceType);
                return this.instanceToService(service);
            }
            catch (UnknownServiceException e) {
                if (!e.getType().equals(serviceType)) {
                    throw e;
                }
                return null;
            }
        }

        @Override
        public void getAll(Class<?> serviceType, List<Service> result) {
            if (this.parent instanceof DefaultServiceRegistry) {
                ((DefaultServiceRegistry)this.parent).collectServices(serviceType, result);
                return;
            }
            List<?> services = this.parent.getAll(serviceType);
            for (Object service : services) {
                result.add(this.instanceToService(service));
            }
        }

        private Service instanceToService(final Object instance) {
            if (instance == null) {
                return null;
            }
            return new Service(){

                @Override
                public String getDisplayName() {
                    return "ServiceRegistry " + ParentServices.this.parent;
                }

                @Override
                public Object get() {
                    return instance;
                }

                @Override
                public void requiredBy(ServiceProvider serviceProvider) {
                }
            };
        }

        @Override
        public void stop() {
        }
    }

    private static class CompositeServiceProvider
    implements ServiceProvider {
        private final ServiceProvider[] serviceProviders;

        private CompositeServiceProvider(ServiceProvider ... serviceProviders) {
            this.serviceProviders = serviceProviders;
        }

        @Override
        public Service getService(Type serviceType) {
            for (ServiceProvider serviceProvider : this.serviceProviders) {
                Service service = serviceProvider.getService(serviceType);
                if (service == null) continue;
                return service;
            }
            return null;
        }

        @Override
        public Service getFactory(Class<?> type) {
            for (ServiceProvider serviceProvider : this.serviceProviders) {
                Service factory = serviceProvider.getFactory(type);
                if (factory == null) continue;
                return factory;
            }
            return null;
        }

        @Override
        public void getAll(Class<?> serviceType, List<Service> result) {
            for (ServiceProvider serviceProvider : this.serviceProviders) {
                serviceProvider.getAll(serviceType, result);
            }
        }

        @Override
        public void stop() {
            try {
                CompositeStoppable.stoppable(Arrays.asList(this.serviceProviders)).stop();
            }
            finally {
                Arrays.fill(this.serviceProviders, null);
            }
        }
    }

    private static class ConstructorService
    extends FactoryService {
        private final Constructor<?> constructor;

        private ConstructorService(DefaultServiceRegistry owner, Class<?> serviceType) {
            super(owner, serviceType);
            Constructor<?>[] constructors = serviceType.getDeclaredConstructors();
            if (constructors.length != 1) {
                throw new ServiceValidationException(String.format("Expected a single constructor for %s.", DefaultServiceRegistry.format(serviceType)));
            }
            this.constructor = constructors[0];
        }

        @Override
        protected Type[] getParameterTypes() {
            return this.constructor.getGenericParameterTypes();
        }

        @Override
        protected Member getFactory() {
            return this.constructor;
        }

        @Override
        protected Object invokeMethod(Object[] params) {
            try {
                return this.constructor.newInstance(params);
            }
            catch (InvocationTargetException e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s.", DefaultServiceRegistry.format(this.serviceType)), e.getCause());
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s.", DefaultServiceRegistry.format(this.serviceType)), e);
            }
        }

        @Override
        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.serviceType);
        }
    }

    private static class FixedInstanceService<T>
    extends SingletonService {
        public FixedInstanceService(DefaultServiceRegistry owner, Class<T> serviceType, T serviceInstance) {
            super(owner, serviceType);
            this.setInstance(serviceInstance);
        }

        @Override
        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.serviceType) + " with implementation " + this.getInstance();
        }

        @Override
        protected Object create() {
            throw new UnsupportedOperationException();
        }
    }

    private class FactoryMethodService
    extends FactoryService {
        private final ServiceMethod method;
        private Object target;

        public FactoryMethodService(DefaultServiceRegistry owner, Object target, ServiceMethod method) {
            super(owner, method.getServiceType());
            this.target = target;
            this.method = method;
        }

        @Override
        public String getDisplayName() {
            return "Service " + DefaultServiceRegistry.format(this.method.getServiceType()) + " at " + this.method.getOwner().getSimpleName() + "." + this.method.getName() + "()";
        }

        @Override
        protected Type[] getParameterTypes() {
            return this.method.getParameterTypes();
        }

        @Override
        protected Member getFactory() {
            return this.method.getMethod();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Object invokeMethod(Object[] params) {
            Object result;
            try {
                result = this.method.invoke(this.target, params);
            }
            catch (Exception e) {
                throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s().", DefaultServiceRegistry.format(this.serviceType), this.method.getOwner().getSimpleName(), this.method.getName()), e);
            }
            try {
                if (result == null) {
                    throw new ServiceCreationException(String.format("Could not create service of type %s using %s.%s() as this method returned null.", DefaultServiceRegistry.format(this.serviceType), this.method.getOwner().getSimpleName(), this.method.getName()));
                }
                Object object = result;
                return object;
            }
            finally {
                this.target = null;
            }
        }
    }

    private static abstract class FactoryService
    extends SingletonService {
        private Service[] paramServices;

        protected FactoryService(DefaultServiceRegistry owner, Type serviceType) {
            super(owner, serviceType);
        }

        protected abstract Type[] getParameterTypes();

        protected abstract Member getFactory();

        @Override
        protected void bind() {
            Type[] parameterTypes = this.getParameterTypes();
            if (parameterTypes.length == 0) {
                this.paramServices = NO_DEPENDENTS;
                return;
            }
            this.paramServices = new Service[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                Service paramProvider;
                Type paramType = parameterTypes[i];
                if (paramType.equals(ServiceRegistry.class)) {
                    this.paramServices[i] = this.owner.getThisAsService();
                    continue;
                }
                if (paramType.equals(this.serviceType)) {
                    paramProvider = this.owner.find(paramType, this.owner.parentServices);
                    if (paramProvider == null) {
                        throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as required service of type %s is not available in parent registries.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), DefaultServiceRegistry.format(paramType)));
                    }
                    this.paramServices[i] = paramProvider;
                    continue;
                }
                try {
                    paramProvider = this.owner.find(paramType, this.owner.allServices);
                }
                catch (ServiceLookupException e) {
                    throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as there is a problem with parameter #%s of type %s.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), i + 1, DefaultServiceRegistry.format(paramType)), e);
                }
                if (paramProvider == null) {
                    throw new ServiceCreationException(String.format("Cannot create service of type %s using %s.%s() as required service of type %s is not available.", DefaultServiceRegistry.format(this.serviceType), this.getFactory().getDeclaringClass().getSimpleName(), this.getFactory().getName(), DefaultServiceRegistry.format(paramType)));
                }
                this.paramServices[i] = paramProvider;
                paramProvider.requiredBy(this);
            }
        }

        @Override
        protected Object create() {
            Object[] params = this.assembleParameters();
            Object result = this.invokeMethod(params);
            this.paramServices = null;
            return result;
        }

        private Object[] assembleParameters() {
            if (this.paramServices == NO_DEPENDENTS) {
                return NO_PARAMS;
            }
            Object[] params = new Object[this.paramServices.length];
            for (int i = 0; i < this.paramServices.length; ++i) {
                Service paramProvider = this.paramServices[i];
                params[i] = paramProvider.get();
            }
            return params;
        }

        protected abstract Object invokeMethod(Object[] var1);
    }

    private static abstract class SingletonService
    extends ManagedObjectServiceProvider<Object>
    implements Service {
        final Type serviceType;
        final Class serviceClass;
        BindState state = BindState.UNBOUND;
        Class factoryElementType;

        SingletonService(DefaultServiceRegistry owner, Type serviceType) {
            super(owner);
            this.serviceType = serviceType;
            this.serviceClass = DefaultServiceRegistry.unwrap(serviceType);
        }

        public String toString() {
            return this.getDisplayName();
        }

        @Override
        public Object get() {
            return this.getInstance();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Service prepare() {
            if (this.state == BindState.BOUND) {
                return this;
            }
            SingletonService singletonService = this;
            synchronized (singletonService) {
                if (this.state == BindState.BINDING) {
                    throw new ServiceValidationException("Cycle in dependencies of " + this.getDisplayName() + " detected");
                }
                if (this.state == BindState.UNBOUND) {
                    this.state = BindState.BINDING;
                    try {
                        this.bind();
                        this.state = BindState.BOUND;
                    }
                    catch (RuntimeException e) {
                        this.state = BindState.UNBOUND;
                        throw e;
                    }
                }
                return this;
            }
        }

        protected void bind() {
        }

        @Override
        public Service getService(Type serviceType) {
            if (!DefaultServiceRegistry.isSatisfiedBy(serviceType, this.serviceType)) {
                return null;
            }
            return this.prepare();
        }

        @Override
        public void getAll(Class<?> serviceType, List<Service> result) {
            if (serviceType.isAssignableFrom(this.serviceClass)) {
                result.add(this.prepare());
            }
        }

        @Override
        public Service getFactory(Class<?> elementType) {
            if (!this.isFactory(this.serviceType, elementType)) {
                return null;
            }
            return this.prepare();
        }

        private boolean isFactory(Type type, Class<?> elementType) {
            Type actualType;
            ParameterizedType parameterizedType;
            Class c = DefaultServiceRegistry.unwrap(type);
            if (!Factory.class.isAssignableFrom(c)) {
                return false;
            }
            if (this.factoryElementType != null) {
                return elementType.isAssignableFrom(this.factoryElementType);
            }
            if (type instanceof ParameterizedType && (parameterizedType = (ParameterizedType)type).getRawType().equals(Factory.class) && (actualType = parameterizedType.getActualTypeArguments()[0]) instanceof Class) {
                this.factoryElementType = (Class)actualType;
                return elementType.isAssignableFrom((Class)actualType);
            }
            for (Type interfaceType : c.getGenericInterfaces()) {
                if (!this.isFactory(interfaceType, elementType)) continue;
                return true;
            }
            return false;
        }

        private static enum BindState {
            UNBOUND,
            BINDING,
            BOUND;

        }
    }

    private static abstract class ManagedObjectServiceProvider<T>
    implements ServiceProvider {
        protected final DefaultServiceRegistry owner;
        private final Queue<ServiceProvider> dependents = new ConcurrentLinkedQueue<ServiceProvider>();
        private volatile T instance;

        protected ManagedObjectServiceProvider(DefaultServiceRegistry owner) {
            this.owner = owner;
        }

        protected final void setInstance(T instance) {
            this.instance = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final T getInstance() {
            T result = this.instance;
            if (result == null) {
                ManagedObjectServiceProvider managedObjectServiceProvider = this;
                synchronized (managedObjectServiceProvider) {
                    result = this.instance;
                    if (result == null) {
                        result = this.instance = this.create();
                        assert (this.instance != null) : String.format("create() of %s returned null", this.toString());
                    }
                }
            }
            return result;
        }

        protected abstract T create();

        public final void requiredBy(ServiceProvider serviceProvider) {
            if (this.fromSameRegistry(serviceProvider)) {
                this.dependents.add(serviceProvider);
            }
        }

        private boolean fromSameRegistry(ServiceProvider serviceProvider) {
            return serviceProvider instanceof ManagedObjectServiceProvider && ((ManagedObjectServiceProvider)serviceProvider).owner == this.owner;
        }

        @Override
        public final synchronized void stop() {
            try {
                if (this.instance != null) {
                    CompositeStoppable.stoppable(this.dependents).add((Object)this.instance).stop();
                }
            }
            finally {
                this.dependents.clear();
                this.instance = null;
            }
        }
    }

    private class OwnServices
    implements ServiceProvider {
        private final Map<Class<?>, List<ServiceProvider>> providersByType = new HashMap(16, 0.5f);
        private final CompositeStoppable stoppable = CompositeStoppable.stoppable(new Object[0]);
        private ProviderAnalyser analyser = new ProviderAnalyser();

        private OwnServices() {
        }

        @Override
        public Service getFactory(Class<?> type) {
            List<ServiceProvider> serviceProviders = this.getProviders(Factory.class);
            if (serviceProviders.isEmpty()) {
                return null;
            }
            if (serviceProviders.size() == 1) {
                return serviceProviders.get(0).getFactory(type);
            }
            ArrayList<Service> services = new ArrayList<Service>(serviceProviders.size());
            for (ServiceProvider serviceProvider : serviceProviders) {
                Service service = serviceProvider.getFactory(type);
                if (service == null) continue;
                services.add(service);
            }
            if (services.isEmpty()) {
                return null;
            }
            if (services.size() == 1) {
                return (Service)services.get(0);
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (Service candidate : services) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple factories for objects of type %s available in %s:", DefaultServiceRegistry.format(type), DefaultServiceRegistry.this.getDisplayName());
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        @Override
        public Service getService(Type type) {
            List<ServiceProvider> serviceProviders = this.getProviders(DefaultServiceRegistry.unwrap(type));
            if (serviceProviders.isEmpty()) {
                return null;
            }
            if (serviceProviders.size() == 1) {
                return serviceProviders.get(0).getService(type);
            }
            ArrayList<Service> services = new ArrayList<Service>(serviceProviders.size());
            for (ServiceProvider serviceProvider : serviceProviders) {
                Service service = serviceProvider.getService(type);
                if (service == null) continue;
                services.add(service);
            }
            if (services.isEmpty()) {
                return null;
            }
            if (services.size() == 1) {
                return (Service)services.get(0);
            }
            TreeSet<String> descriptions = new TreeSet<String>();
            for (Service candidate : services) {
                descriptions.add(candidate.getDisplayName());
            }
            Formatter formatter = new Formatter();
            formatter.format("Multiple services of type %s available in %s:", DefaultServiceRegistry.format(type), DefaultServiceRegistry.this.getDisplayName());
            for (String description : descriptions) {
                formatter.format("%n   - %s", description);
            }
            throw new ServiceLookupException(formatter.toString());
        }

        private List<ServiceProvider> getProviders(Class<?> type) {
            List<ServiceProvider> providers = this.providersByType.get(type);
            return providers == null ? Collections.emptyList() : providers;
        }

        @Override
        public void getAll(Class<?> serviceType, List<Service> result) {
            for (ServiceProvider serviceProvider : this.getProviders(serviceType)) {
                serviceProvider.getAll(serviceType, result);
            }
        }

        @Override
        public void stop() {
            this.stoppable.stop();
        }

        public void add(ServiceProvider serviceProvider) {
            DefaultServiceRegistry.this.assertMutable();
            if (!(serviceProvider instanceof SingletonService)) {
                throw new UnsupportedOperationException("Unsupported service provider type: " + serviceProvider);
            }
            this.stoppable.add((Object)serviceProvider);
            this.analyser.addProviderForClassHierarchy(((SingletonService)serviceProvider).serviceClass, serviceProvider);
        }

        public void noLongerMutable() {
            this.analyser = null;
        }

        private class ProviderAnalyser {
            private Set<Class<?>> seen = new HashSet(4, 0.5f);

            private ProviderAnalyser() {
            }

            public void addProviderForClassHierarchy(Class<?> serviceType, ServiceProvider serviceProvider) {
                this.analyseType(serviceType, serviceProvider);
                this.seen.clear();
            }

            private void analyseType(Class<?> type, ServiceProvider serviceProvider) {
                if (type == null || type == Object.class) {
                    return;
                }
                if (this.seen.add(type)) {
                    this.putServiceType(type, serviceProvider);
                    this.analyseType(type.getSuperclass(), serviceProvider);
                    for (Class<?> iface : type.getInterfaces()) {
                        this.analyseType(iface, serviceProvider);
                    }
                }
            }

            private void putServiceType(Class<?> type, ServiceProvider serviceProvider) {
                ArrayList<ServiceProvider> serviceProviders = (ArrayList<ServiceProvider>)OwnServices.this.providersByType.get(type);
                if (serviceProviders == null) {
                    serviceProviders = new ArrayList<ServiceProvider>(2);
                    OwnServices.this.providersByType.put(type, serviceProviders);
                }
                serviceProviders.add(serviceProvider);
            }
        }
    }

    static interface ServiceProvider
    extends Stoppable {
        public Service getService(Type var1);

        public Service getFactory(Class<?> var1);

        public void getAll(Class<?> var1, List<Service> var2);
    }

    static interface Service {
        public String getDisplayName();

        public Object get();

        public void requiredBy(ServiceProvider var1);
    }

    private static class InstanceUnpackingList<T>
    extends AbstractList<Service> {
        private final Class<T> serviceType;
        private final List<T> delegate;

        private InstanceUnpackingList(Class<T> serviceType, List<T> delegate) {
            this.serviceType = serviceType;
            this.delegate = delegate;
        }

        @Override
        public Service get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(Service provider) {
            return this.delegate.add(this.serviceType.cast(provider.get()));
        }

        @Override
        public int size() {
            return this.delegate.size();
        }
    }

    private static enum State {
        INIT,
        STARTED,
        CLOSED;

    }
}

