/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.tim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.StringLocated;
import net.sourceforge.plantuml.tim.EaterException;
import net.sourceforge.plantuml.tim.EaterExceptionLocated;
import net.sourceforge.plantuml.tim.EaterFunctionCall;
import net.sourceforge.plantuml.tim.TContext;
import net.sourceforge.plantuml.tim.TFunction;
import net.sourceforge.plantuml.tim.TFunctionArgument;
import net.sourceforge.plantuml.tim.TFunctionSignature;
import net.sourceforge.plantuml.tim.TFunctionType;
import net.sourceforge.plantuml.tim.TLineType;
import net.sourceforge.plantuml.tim.TMemory;
import net.sourceforge.plantuml.tim.expression.TValue;

public class TFunctionImpl
implements TFunction {
    private final TFunctionSignature signature;
    private final List<TFunctionArgument> args;
    private final List<StringLocated> body = new ArrayList<StringLocated>();
    private final boolean unquoted;
    private TFunctionType functionType;
    private String legacyDefinition;
    private boolean containsReturn;

    public TFunctionImpl(String functionName, List<TFunctionArgument> args, boolean unquoted, TFunctionType functionType) {
        this.signature = new TFunctionSignature(functionName, args.size());
        this.args = args;
        this.unquoted = unquoted;
        this.functionType = functionType;
    }

    @Override
    public boolean canCover(int nbArg) {
        if (nbArg > this.args.size()) {
            return false;
        }
        for (int i = nbArg; i < this.args.size(); ++i) {
            if (this.args.get(i).getOptionalDefaultValue() != null) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "FUNCTION " + this.signature + " " + this.args;
    }

    public void addBody(StringLocated s) throws EaterExceptionLocated {
        this.body.add(s);
        if (s.getType() == TLineType.RETURN) {
            this.containsReturn = true;
            if (this.functionType == TFunctionType.PROCEDURE) {
                throw EaterExceptionLocated.located("A procedure cannot have !return directive. Declare it as a function instead ?", s);
            }
        }
    }

    @Override
    public void executeProcedure(TContext context, TMemory memory, LineLocation location, String s) throws EaterException, EaterExceptionLocated {
        EaterFunctionCall call = new EaterFunctionCall(new StringLocated(s, location), context.isLegacyDefine(this.signature.getFunctionName()), this.unquoted);
        call.analyze(context, memory);
        String endOfLine = call.getEndOfLine();
        List<TValue> args = call.getValues();
        this.executeProcedureInternal(context, memory, args);
        context.appendEndOfLine(endOfLine);
    }

    @Override
    public void executeProcedureInternal(TContext context, TMemory memory, List<TValue> args) throws EaterException, EaterExceptionLocated {
        if (this.functionType != TFunctionType.PROCEDURE && this.functionType != TFunctionType.LEGACY_DEFINELONG) {
            throw new IllegalStateException();
        }
        TMemory copy = this.getNewMemory(memory, args);
        context.executeLines(copy, this.body, TFunctionType.PROCEDURE, false);
    }

    private TMemory getNewMemory(TMemory memory, List<TValue> values) {
        HashMap<String, TValue> foo = new HashMap<String, TValue>();
        for (int i = 0; i < this.args.size(); ++i) {
            TValue tmp = i < values.size() ? values.get(i) : this.args.get(i).getOptionalDefaultValue();
            foo.put(this.args.get(i).getName(), tmp);
        }
        TMemory copy = memory.forkFromGlobal(foo);
        return copy;
    }

    @Override
    public TValue executeReturnFunction(TContext context, TMemory memory, LineLocation location, List<TValue> args) throws EaterException, EaterExceptionLocated {
        if (this.functionType == TFunctionType.LEGACY_DEFINE) {
            return this.executeReturnLegacyDefine(location, context, memory, args);
        }
        if (this.functionType != TFunctionType.RETURN_FUNCTION) {
            throw EaterException.unlocated("Illegal call here. Is there a return directive in your function?");
        }
        TMemory copy = this.getNewMemory(memory, args);
        TValue result = context.executeLines(copy, this.body, TFunctionType.RETURN_FUNCTION, true);
        if (result == null) {
            throw EaterException.unlocated("No return directive found in your function");
        }
        return result;
    }

    private TValue executeReturnLegacyDefine(LineLocation location, TContext context, TMemory memory, List<TValue> args) throws EaterException, EaterExceptionLocated {
        if (this.legacyDefinition == null) {
            throw new IllegalStateException();
        }
        TMemory copy = this.getNewMemory(memory, args);
        String tmp = context.applyFunctionsAndVariables(copy, location, this.legacyDefinition);
        if (tmp == null) {
            return TValue.fromString("");
        }
        return TValue.fromString(tmp);
    }

    @Override
    public final TFunctionType getFunctionType() {
        return this.functionType;
    }

    @Override
    public final TFunctionSignature getSignature() {
        return this.signature;
    }

    public void setLegacyDefinition(String legacyDefinition) {
        this.legacyDefinition = legacyDefinition;
    }

    @Override
    public boolean isUnquoted() {
        return this.unquoted;
    }

    public boolean hasBody() {
        return this.body.size() > 0;
    }

    public void finalizeEnddefinelong() {
        if (this.functionType != TFunctionType.LEGACY_DEFINELONG) {
            throw new UnsupportedOperationException();
        }
        if (this.body.size() == 1) {
            this.functionType = TFunctionType.LEGACY_DEFINE;
            this.legacyDefinition = this.body.get(0).getString();
        }
    }

    public final boolean doesContainReturn() {
        return this.containsReturn;
    }
}

