/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud.autoscaling.sim;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrResponse;
import org.apache.solr.client.solrj.cloud.SolrCloudManager;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.client.solrj.cloud.autoscaling.PolicyHelper;
import org.apache.solr.client.solrj.cloud.autoscaling.ReplicaInfo;
import org.apache.solr.client.solrj.cloud.autoscaling.Suggester;
import org.apache.solr.client.solrj.cloud.autoscaling.TriggerEventProcessorStage;
import org.apache.solr.client.solrj.cloud.autoscaling.Variable;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.SolrClientCloudManager;
import org.apache.solr.client.solrj.request.GenericSolrRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.client.solrj.request.UpdateRequest;
import org.apache.solr.client.solrj.request.V2Request;
import org.apache.solr.cloud.CloudUtil;
import org.apache.solr.cloud.autoscaling.ActionContext;
import org.apache.solr.cloud.autoscaling.AutoScaling;
import org.apache.solr.cloud.autoscaling.AutoScalingHandler;
import org.apache.solr.cloud.autoscaling.TriggerEvent;
import org.apache.solr.cloud.autoscaling.TriggerListenerBase;
import org.apache.solr.cloud.autoscaling.sim.FakeDocIterator;
import org.apache.solr.cloud.autoscaling.sim.NoopDistributedQueueFactory;
import org.apache.solr.cloud.autoscaling.sim.SimCloudManager;
import org.apache.solr.cloud.autoscaling.sim.SimUtils;
import org.apache.solr.cloud.autoscaling.sim.SnapshotCloudManager;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.common.util.TimeSource;
import org.apache.solr.common.util.Utils;
import org.apache.solr.util.PropertiesUtil;
import org.apache.solr.util.RedactionUtils;
import org.apache.solr.util.TimeOut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimScenario
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String RANDOM_NODE_CTX_PROP = "_random_node_";
    public static final String OVERSEER_LEADER_CTX_PROP = "_overseer_leader_";
    public static final String LIVE_NODES_CTX_PROP = "_live_nodes_";
    public static final String COLLECTIONS_CTX_PROP = "_collections_";
    public static final String SUGGESTIONS_CTX_PROP = "_suggestions_";
    public static final String RESPONSES_CTX_PROP = "_responses_";
    public static final String LOOP_ITER_PROP = "_loop_iter_";
    public static final String TRIGGER_EVENT_PREFIX = "_trigger_event_";
    public SimCloudManager cluster;
    public AutoScalingConfig config;
    public List<SimOp> ops = new ArrayList<SimOp>();
    public Map<String, Object> context = new HashMap<String, Object>();
    public PrintStream console = System.err;
    public boolean verbose;
    public boolean abortLoop;
    public boolean abortScenario;
    public static Map<SimAction, Class<? extends SimOp>> simOps = new HashMap<SimAction, Class<? extends SimOp>>();

    public static SimScenario load(String data) throws Exception {
        SimScenario scenario = new SimScenario();
        String[] lines = data.split("\\r?\\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if ((line = line.trim()).trim().isEmpty() || line.startsWith("#") || line.startsWith("//")) continue;
            String[] comments = line.split("//");
            String expr = comments[0];
            String[] parts = expr.split("\\s+");
            if (parts.length > 2) {
                log.warn("Invalid line - wrong number of parts " + parts.length + ", skipping: " + line);
                continue;
            }
            SimAction action = SimAction.get(parts[0]);
            if (action == null) {
                log.warn("Invalid scenario action " + parts[0] + ", skipping...");
                continue;
            }
            if (action == SimAction.LOOP_END) {
                if (!scenario.context.containsKey("loop")) {
                    throw new IOException("LOOP_END without start!");
                }
                scenario.context.remove("loop");
                continue;
            }
            Class<? extends SimOp> opClass = simOps.get((Object)action);
            SimOp op = opClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            ModifiableSolrParams params = new ModifiableSolrParams();
            if (parts.length > 1) {
                String[] paramsParts;
                String paramsString = parts[1];
                if (parts[1].contains("?")) {
                    String[] urlParts = parts[1].split("\\?");
                    params.set("path", new String[]{urlParts[0]});
                    paramsString = urlParts.length > 1 ? urlParts[1] : "";
                }
                for (String paramPair : paramsParts = paramsString.split("&")) {
                    String[] paramKV = paramPair.split("=");
                    String k = URLDecoder.decode(paramKV[0], "UTF-8");
                    String v = paramKV.length > 1 ? URLDecoder.decode(paramKV[1], "UTF-8") : null;
                    params.add(k, new String[]{v});
                }
            }
            op.init((SolrParams)params);
            if (action == SimAction.LOOP_START) {
                if (scenario.context.containsKey("loop")) {
                    throw new IOException("only one loop level is allowed");
                }
                scenario.context.put("loop", op);
                scenario.ops.add(op);
                continue;
            }
            LoopOp currentLoop = (LoopOp)scenario.context.get("loop");
            if (currentLoop != null) {
                currentLoop.ops.add(op);
                continue;
            }
            scenario.ops.add(op);
        }
        if (scenario.context.containsKey("loop")) {
            throw new IOException("Unterminated loop statement");
        }
        int numSets = 0;
        int numWaits = 0;
        for (SimOp op : scenario.ops) {
            if (op instanceof SetEventListener) {
                ++numSets;
            } else if (op instanceof WaitEvent) {
                ++numWaits;
            }
            if (numWaits <= numSets) continue;
            throw new Exception("Unexpected " + (Object)((Object)SimAction.WAIT_EVENT) + " without previous " + (Object)((Object)SimAction.EVENT_LISTENER));
        }
        if (numSets > numWaits) {
            throw new Exception((Object)((Object)SimAction.EVENT_LISTENER) + " count should be equal to " + (Object)((Object)SimAction.WAIT_EVENT) + " count but was " + numSets + " > " + numWaits);
        }
        return scenario;
    }

    public void run() throws Exception {
        for (int i = 0; i < this.ops.size(); ++i) {
            if (this.abortScenario) {
                log.info("-- abortScenario requested, aborting after " + i + " ops.");
                return;
            }
            SimOp op = this.ops.get(i);
            log.info(i + 1 + ".\t" + op.getClass().getSimpleName() + "\t" + op.initParams.toString());
            if (this.cluster != null && this.cluster.getLiveNodesSet().size() > 0) {
                this.context.put(LIVE_NODES_CTX_PROP, new ArrayList<String>(this.cluster.getLiveNodesSet().get()));
                this.context.put(RANDOM_NODE_CTX_PROP, this.cluster.getSimClusterStateProvider().simGetRandomNode());
                this.context.put(COLLECTIONS_CTX_PROP, this.cluster.getSimClusterStateProvider().simListCollections());
                this.context.put(OVERSEER_LEADER_CTX_PROP, this.cluster.getSimClusterStateProvider().simGetOverseerLeader());
            } else {
                this.context.remove(LIVE_NODES_CTX_PROP);
                this.context.remove(COLLECTIONS_CTX_PROP);
                this.context.remove(RANDOM_NODE_CTX_PROP);
                this.context.remove(SUGGESTIONS_CTX_PROP);
                this.context.remove(OVERSEER_LEADER_CTX_PROP);
            }
            op.prepareCurrentParams(this);
            log.info("\t\t" + op.getClass().getSimpleName() + "\t" + op.params.toString());
            op.execute(this);
        }
    }

    @Override
    public void close() throws Exception {
        if (this.cluster != null) {
            this.cluster.close();
            this.cluster = null;
        }
    }

    static {
        simOps.put(SimAction.CREATE_CLUSTER, CreateCluster.class);
        simOps.put(SimAction.LOAD_SNAPSHOT, LoadSnapshot.class);
        simOps.put(SimAction.SAVE_SNAPSHOT, SaveSnapshot.class);
        simOps.put(SimAction.LOAD_AUTOSCALING, LoadAutoscaling.class);
        simOps.put(SimAction.CALCULATE_SUGGESTIONS, CalculateSuggestions.class);
        simOps.put(SimAction.APPLY_SUGGESTIONS, ApplySuggestions.class);
        simOps.put(SimAction.KILL_NODES, KillNodes.class);
        simOps.put(SimAction.ADD_NODES, AddNodes.class);
        simOps.put(SimAction.LOOP_START, LoopOp.class);
        simOps.put(SimAction.LOOP_END, null);
        simOps.put(SimAction.SET_OP_DELAYS, SetOpDelays.class);
        simOps.put(SimAction.SOLR_REQUEST, RunSolrRequest.class);
        simOps.put(SimAction.RUN, RunSimulator.class);
        simOps.put(SimAction.WAIT_COLLECTION, WaitCollection.class);
        simOps.put(SimAction.EVENT_LISTENER, SetEventListener.class);
        simOps.put(SimAction.WAIT_EVENT, WaitEvent.class);
        simOps.put(SimAction.CTX_SET, CtxSet.class);
        simOps.put(SimAction.CTX_REMOVE, CtxRemove.class);
        simOps.put(SimAction.DUMP, Dump.class);
        simOps.put(SimAction.SET_NODE_METRICS, SetNodeMetrics.class);
        simOps.put(SimAction.SET_SHARD_METRICS, SetShardMetrics.class);
        simOps.put(SimAction.INDEX_DOCS, IndexDocs.class);
        simOps.put(SimAction.ASSERT, Assert.class);
    }

    public static enum SimAction {
        CREATE_CLUSTER,
        LOAD_SNAPSHOT,
        SAVE_SNAPSHOT,
        CALCULATE_SUGGESTIONS,
        APPLY_SUGGESTIONS,
        KILL_NODES,
        ADD_NODES,
        LOAD_AUTOSCALING,
        LOOP_START,
        LOOP_END,
        SET_OP_DELAYS,
        SOLR_REQUEST,
        WAIT_COLLECTION,
        EVENT_LISTENER,
        WAIT_EVENT,
        RUN,
        DUMP,
        CTX_SET,
        CTX_REMOVE,
        SET_NODE_METRICS,
        SET_SHARD_METRICS,
        INDEX_DOCS,
        ASSERT;


        public static SimAction get(String str) {
            if (str != null) {
                try {
                    return SimAction.valueOf(str.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    return null;
                }
            }
            return null;
        }

        public String toLower() {
            return this.toString().toLowerCase(Locale.ROOT);
        }
    }

    public static abstract class SimOp {
        ModifiableSolrParams initParams;
        ModifiableSolrParams params;

        public void init(SolrParams params) {
            this.initParams = new ModifiableSolrParams(params);
        }

        public void prepareCurrentParams(SimScenario scenario) {
            Properties props = new Properties();
            scenario.context.forEach((k, v) -> {
                if (v instanceof String[]) {
                    v = String.join((CharSequence)",", (String[])v);
                } else if (v instanceof Collection) {
                    StringBuilder sb = new StringBuilder();
                    for (Object o : (Collection)v) {
                        if (sb.length() > 0) {
                            sb.append(',');
                        }
                        if (o instanceof String || o instanceof Number) {
                            sb.append(o);
                            continue;
                        }
                        return;
                    }
                    v = sb.toString();
                } else if (!(v instanceof String) && !(v instanceof Number)) {
                    return;
                }
                props.put(k, v);
            });
            ModifiableSolrParams currentParams = new ModifiableSolrParams();
            this.initParams.forEach(e -> {
                String[] newValues;
                String newKey = PropertiesUtil.substituteProperty((String)e.getKey(), props);
                if (newKey == null) {
                    newKey = (String)e.getKey();
                }
                if (e.getValue() != null && ((String[])e.getValue()).length > 0) {
                    String[] values = (String[])e.getValue();
                    newValues = new String[values.length];
                    for (int k = 0; k < values.length; ++k) {
                        String newVal = PropertiesUtil.substituteProperty(values[k], props);
                        if (newVal == null) {
                            newVal = values[k];
                        }
                        newValues[k] = newVal;
                    }
                } else {
                    newValues = (String[])e.getValue();
                }
                currentParams.add(newKey, newValues);
            });
            this.params = currentParams;
        }

        public abstract void execute(SimScenario var1) throws Exception;
    }

    public static class LoopOp
    extends SimOp {
        List<SimOp> ops = new ArrayList<SimOp>();
        int iterations;

        @Override
        public void execute(SimScenario scenario) throws Exception {
            this.iterations = Integer.parseInt(this.params.get("iterations", "10"));
            for (int i = 0; i < this.iterations; ++i) {
                if (scenario.abortLoop) {
                    log.info("        -- abortLoop requested, aborting after " + i + " iterations.");
                    return;
                }
                scenario.context.put(SimScenario.LOOP_ITER_PROP, String.valueOf(i));
                log.info("   * iter " + (i + 1) + ":");
                for (SimOp op : this.ops) {
                    op.prepareCurrentParams(scenario);
                    log.info("     - " + op.getClass().getSimpleName() + "\t" + op.params.toString());
                    op.execute(scenario);
                    if (!scenario.abortLoop) continue;
                    log.info("        -- abortLoop requested, aborting after " + i + " iterations.");
                    return;
                }
            }
        }
    }

    public static class SetEventListener
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String[] stages;
            String trigger = this.params.required().get("trigger");
            HashMap<String, String> cfgMap = new HashMap<String, String>();
            String name = ".sim_wait_event_" + trigger;
            cfgMap.put("name", name);
            cfgMap.put("trigger", trigger);
            String[] beforeActions = this.params.getParams("beforeAction");
            String[] afterActions = this.params.getParams("afterAction");
            if (beforeActions != null) {
                for (String beforeAction : beforeActions) {
                    ((List)cfgMap.computeIfAbsent("beforeAction", Utils.NEW_ARRAYLIST_FUN)).add(beforeAction);
                }
            }
            if (afterActions != null) {
                for (String afterAction : afterActions) {
                    ((List)cfgMap.computeIfAbsent("afterAction", Utils.NEW_ARRAYLIST_FUN)).add(afterAction);
                }
            }
            for (String stage : stages = this.params.required().getParams("stage")) {
                String[] lst;
                for (String val : lst = stage.split("[,\\s]+")) {
                    try {
                        TriggerEventProcessorStage.valueOf((String)val);
                        ((List)cfgMap.computeIfAbsent("stage", Utils.NEW_ARRAYLIST_FUN)).add(val);
                    }
                    catch (IllegalArgumentException e) {
                        throw new IOException("Invalid stage name '" + val + "'");
                    }
                }
            }
            AutoScalingConfig.TriggerListenerConfig listenerConfig = new AutoScalingConfig.TriggerListenerConfig(name, cfgMap);
            SimWaitListener listener = new SimWaitListener(scenario.cluster.getTimeSource(), listenerConfig);
            if (scenario.context.containsKey("_sim_waitListener_" + trigger)) {
                throw new IOException("currently only one listener can be set per trigger. Trigger name: " + trigger);
            }
            scenario.context.put("_sim_waitListener_" + trigger, listener);
            scenario.cluster.getOverseerTriggerThread().getScheduledTriggers().addAdditionalListener(listener);
        }
    }

    public static class WaitEvent
    extends SimOp {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String trigger = this.params.required().get("trigger");
            int waitSec = Integer.parseInt(this.params.get("wait", "90"));
            SimWaitListener listener = (SimWaitListener)scenario.context.remove("_sim_waitListener_" + trigger);
            if (listener == null) {
                throw new IOException((Object)((Object)SimAction.WAIT_EVENT) + " must be preceded by " + (Object)((Object)SimAction.EVENT_LISTENER) + " for trigger " + trigger);
            }
            try {
                listener.wait(waitSec);
                scenario.context.remove(SimScenario.TRIGGER_EVENT_PREFIX + trigger);
                if (listener.getEvent() != null) {
                    Map ev = listener.getEvent().toMap(new LinkedHashMap());
                    scenario.context.put(SimScenario.TRIGGER_EVENT_PREFIX + trigger, ev);
                }
            }
            finally {
                scenario.cluster.getOverseerTriggerThread().getScheduledTriggers().removeAdditionalListener(listener);
            }
        }
    }

    public static class CreateCluster
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            int numNodes = Integer.parseInt(this.params.get("numNodes", "5"));
            boolean disableMetricsHistory = Boolean.parseBoolean(this.params.get("disableMetricsHistory", "false"));
            String timeSourceStr = this.params.get("timeSource", "simTime:50");
            if (scenario.cluster != null) {
                IOUtils.closeQuietly((Closeable)((Object)scenario.cluster));
                scenario.context.clear();
            }
            scenario.cluster = SimCloudManager.createCluster(numNodes, TimeSource.get((String)timeSourceStr));
            if (disableMetricsHistory) {
                scenario.cluster.disableMetricsHistory();
            }
            scenario.config = scenario.cluster.getDistribStateManager().getAutoScalingConfig();
        }
    }

    public static class LoadSnapshot
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            SnapshotCloudManager snapshotCloudManager;
            block13: {
                String path = this.params.get("path");
                if (path == null) {
                    String zkHost = this.params.get("zkHost");
                    if (zkHost == null) {
                        throw new IOException((Object)((Object)SimAction.LOAD_SNAPSHOT) + " must specify 'path' or 'zkHost'");
                    }
                    try (CloudSolrClient cloudSolrClient = new CloudSolrClient.Builder(Collections.singletonList(zkHost), Optional.empty()).build();){
                        cloudSolrClient.connect();
                        try (SolrClientCloudManager realCloudManager = new SolrClientCloudManager(NoopDistributedQueueFactory.INSTANCE, cloudSolrClient);){
                            snapshotCloudManager = new SnapshotCloudManager((SolrCloudManager)realCloudManager, null);
                            break block13;
                        }
                    }
                }
                snapshotCloudManager = SnapshotCloudManager.readSnapshot(new File(path));
            }
            scenario.cluster = SimCloudManager.createCluster(snapshotCloudManager, null, snapshotCloudManager.getTimeSource());
            scenario.config = scenario.cluster.getDistribStateManager().getAutoScalingConfig();
        }
    }

    public static class SaveSnapshot
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String path = this.params.get("path");
            if (path == null) {
                throw new IOException((Object)((Object)SimAction.SAVE_SNAPSHOT) + " must specify 'path'");
            }
            boolean redact = Boolean.parseBoolean(this.params.get("redact", "false"));
            SnapshotCloudManager snapshotCloudManager = new SnapshotCloudManager(scenario.cluster, null);
            snapshotCloudManager.saveSnapshot(new File(path), true, redact);
        }
    }

    public static class LoadAutoscaling
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            Map map;
            boolean addDefaults = Boolean.parseBoolean(this.params.get("withDefaultTriggers", "true"));
            int defaultWaitFor = Integer.parseInt(this.params.get("defaultWaitFor", "120"));
            String path = this.params.get("path");
            if (path == null) {
                String json = this.params.get("json");
                if (json == null) {
                    throw new IOException((Object)((Object)SimAction.LOAD_AUTOSCALING) + " must specify either 'path' or 'json'");
                }
                map = (Map)Utils.fromJSONString((String)json);
            } else {
                InputStreamReader r;
                File f = new File(path);
                if (f.exists()) {
                    r = new InputStreamReader((InputStream)new FileInputStream(f), Charset.forName("UTF-8"));
                } else {
                    InputStream is = this.getClass().getResourceAsStream(path);
                    if (is == null) {
                        throw new IOException("path " + path + " does not exist and it's not a resource");
                    }
                    r = new InputStreamReader(is, Charset.forName("UTF-8"));
                }
                map = (Map)Utils.fromJSON((Reader)r);
            }
            AutoScalingConfig config = new AutoScalingConfig(map);
            if (addDefaults) {
                if (!config.getTriggerConfigs().containsKey(".auto_add_replicas")) {
                    HashMap<String, Object> props = new HashMap<String, Object>(AutoScaling.AUTO_ADD_REPLICAS_TRIGGER_PROPS);
                    props.put("waitFor", defaultWaitFor);
                    AutoScalingConfig.TriggerConfig trigger = new AutoScalingConfig.TriggerConfig(".auto_add_replicas", props);
                    config = config.withTriggerConfig(trigger);
                    config = AutoScalingHandler.withSystemLogListener(config, ".auto_add_replicas");
                }
                if (!config.getTriggerConfigs().containsKey(".scheduled_maintenance")) {
                    AutoScalingConfig.TriggerConfig trigger = new AutoScalingConfig.TriggerConfig(".scheduled_maintenance", AutoScaling.SCHEDULED_MAINTENANCE_TRIGGER_PROPS);
                    config = config.withTriggerConfig(trigger);
                    config = AutoScalingHandler.withSystemLogListener(config, ".scheduled_maintenance");
                }
            }
            scenario.config = config;
            scenario.cluster.getSimDistribStateManager().simSetAutoScalingConfig(config);
            new TimeOut(30L, TimeUnit.SECONDS, scenario.cluster.getTimeSource()).waitFor("OverseerTriggerThread never caught up to the latest znodeVersion", () -> {
                try {
                    AutoScalingConfig autoscalingConfig = scenario.cluster.getDistribStateManager().getAutoScalingConfig();
                    return autoscalingConfig.getZkVersion() == scenario.cluster.getOverseerTriggerThread().getProcessedZnodeVersion();
                }
                catch (Exception e) {
                    throw new RuntimeException("FAILED", e);
                }
            });
        }
    }

    public static class CalculateSuggestions
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            List suggestions = PolicyHelper.getSuggestions((AutoScalingConfig)scenario.config, (SolrCloudManager)scenario.cluster);
            scenario.context.put(SimScenario.SUGGESTIONS_CTX_PROP, suggestions);
            log.info("        - " + suggestions.size() + " suggestions");
            if (suggestions.isEmpty()) {
                scenario.abortLoop = true;
            }
        }
    }

    public static class ApplySuggestions
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            List suggestions = scenario.context.getOrDefault(SimScenario.SUGGESTIONS_CTX_PROP, Collections.emptyList());
            int unresolvedCount = 0;
            for (Suggester.SuggestionInfo suggestion : suggestions) {
                SolrRequest operation = suggestion.getOperation();
                if (operation == null) {
                    ++unresolvedCount;
                    if (suggestion.getViolation() != null) continue;
                    log.error("       -- ignoring suggestion without violation and without operation: " + suggestion);
                    continue;
                }
                SolrParams params = operation.getParams();
                if (operation instanceof V2Request) {
                    params = SimUtils.v2AdminRequestToV1Params((V2Request)operation);
                }
                LinkedHashMap<String, Object> paramsMap = new LinkedHashMap<String, Object>();
                params.toMap(paramsMap);
                ReplicaInfo info = scenario.cluster.getSimClusterStateProvider().simGetReplicaInfo(params.get("collection"), params.get("replica"));
                if (info == null) {
                    log.error("Could not find ReplicaInfo for params: " + params);
                } else if (scenario.verbose) {
                    paramsMap.put("replicaInfo", info);
                } else if (info.getVariable(Variable.Type.CORE_IDX.tagName) != null) {
                    paramsMap.put(Variable.Type.CORE_IDX.tagName, info.getVariable(Variable.Type.CORE_IDX.tagName));
                }
                try {
                    scenario.cluster.request(operation);
                }
                catch (Exception e) {
                    log.error("Aborting - error executing suggestion " + suggestion, (Throwable)e);
                    break;
                }
            }
            if (suggestions.size() > 0 && unresolvedCount == suggestions.size()) {
                log.info("        -- aborting simulation, only " + unresolvedCount + " unresolved violations remain");
                scenario.abortLoop = true;
            }
        }
    }

    public static class KillNodes
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            if (this.params.get("numNodes") != null) {
                int numNodes = Integer.parseInt(this.params.get("numNodes"));
                scenario.cluster.simRemoveRandomNodes(numNodes, false, scenario.cluster.getRandom());
            } else if (this.params.get("nodes") != null || this.params.get("node") != null) {
                HashSet<String> nodes = new HashSet<String>();
                String[] nodesValues = this.params.getParams("nodes");
                if (nodesValues != null) {
                    for (String nodesValue : nodesValues) {
                        String[] vals = nodesValue.split(",");
                        nodes.addAll(Arrays.asList(vals));
                    }
                }
                if ((nodesValues = this.params.getParams("node")) != null) {
                    nodes.addAll(Arrays.asList(nodesValues));
                }
                for (String node : nodes) {
                    scenario.cluster.simRemoveNode(node, false);
                }
            }
        }
    }

    public static class AddNodes
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            int numNodes = Integer.parseInt(this.params.get("numNodes"));
            for (int i = 0; i < numNodes; ++i) {
                scenario.cluster.simAddNode();
            }
        }
    }

    public static class SetOpDelays
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String[] collections = this.params.remove("collection");
            if (collections == null || collections.length == 0) {
                throw new IOException("'collection' param is required but missing: " + this.params);
            }
            HashMap<String, Long> delays = new HashMap<String, Long>();
            this.params.forEach(e -> {
                String key = (String)e.getKey();
                CollectionParams.CollectionAction a = CollectionParams.CollectionAction.get((String)key);
                if (a == null) {
                    log.warn("Invalid collection action " + key + ", skipping...");
                    return;
                }
                String[] values = (String[])e.getValue();
                if (values == null || values[0].trim().isEmpty()) {
                    delays.put(a.name(), null);
                } else {
                    Long value = Long.parseLong(values[0]);
                    delays.put(a.name(), value);
                }
            });
            for (String collection : collections) {
                scenario.cluster.getSimClusterStateProvider().simSetOpDelays(collection, delays);
            }
        }
    }

    public static class RunSolrRequest
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String path = this.params.get("path", "/");
            SolrRequest.METHOD m = SolrRequest.METHOD.valueOf((String)this.params.get("httpMethod", "GET"));
            this.params.remove("httpMethod");
            String streamBody = this.params.get("stream.body");
            this.params.remove("stream.body");
            GenericSolrRequest req = new GenericSolrRequest(m, path, (SolrParams)this.params);
            if (streamBody != null) {
                req.setContentWriter((RequestWriter.ContentWriter)new RequestWriter.StringPayloadContentWriter(streamBody, "application/json"));
            }
            SolrResponse rsp = scenario.cluster.request((SolrRequest)req);
            List responses = (List)scenario.context.computeIfAbsent(SimScenario.RESPONSES_CTX_PROP, Utils.NEW_ARRAYLIST_FUN);
            responses.add(rsp);
        }
    }

    public static class RunSimulator
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            int timeMs = Integer.parseInt(this.params.get("time", "60000"));
            scenario.cluster.getTimeSource().sleep((long)timeMs);
        }
    }

    public static class WaitCollection
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String collection = this.params.required().get("collection");
            int shards = Integer.parseInt(this.params.required().get("shards"));
            int replicas = Integer.parseInt(this.params.required().get("replicas"));
            boolean withInactive = Boolean.parseBoolean(this.params.get("withInactive", "false"));
            boolean requireLeaders = Boolean.parseBoolean(this.params.get("requireLeaders", "true"));
            int waitSec = Integer.parseInt(this.params.required().get("wait", "90"));
            CloudUtil.waitForState(scenario.cluster, collection, waitSec, TimeUnit.SECONDS, CloudUtil.clusterShape(shards, replicas, withInactive, requireLeaders));
        }
    }

    public static class CtxSet
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String key = this.params.required().get("key");
            String[] values = this.params.required().getParams("value");
            if (values != null) {
                scenario.context.put(key, Arrays.asList(values));
            } else {
                scenario.context.remove(key);
            }
        }
    }

    public static class CtxRemove
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String key = this.params.required().get("key");
            scenario.context.remove(key);
        }
    }

    public static class Dump
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            boolean redact = Boolean.parseBoolean(this.params.get("redact", "false"));
            boolean withData = Boolean.parseBoolean(this.params.get("withData", "false"));
            boolean withStats = Boolean.parseBoolean(this.params.get("withStats", "false"));
            boolean withSuggestions = Boolean.parseBoolean(this.params.get("withSuggestions", "true"));
            boolean withDiagnostics = Boolean.parseBoolean(this.params.get("withDiagnostics", "false"));
            boolean withNodeState = Boolean.parseBoolean(this.params.get("withNodeState", "false"));
            boolean withClusterState = Boolean.parseBoolean(this.params.get("withClusterState", "false"));
            boolean withManagerState = Boolean.parseBoolean(this.params.get("withManagerState", "false"));
            SnapshotCloudManager snapshotCloudManager = new SnapshotCloudManager(scenario.cluster, null);
            Map<String, Object> snapshot = snapshotCloudManager.getSnapshot(true, redact);
            if (!withData) {
                snapshot.remove("distribState");
            }
            if (!withNodeState) {
                snapshot.remove("nodeState");
            }
            if (!withClusterState) {
                snapshot.remove("clusterState");
            }
            if (!withStats) {
                snapshot.remove("statistics");
            }
            if (!withManagerState) {
                snapshot.remove("managerState");
            }
            if (!withDiagnostics) {
                ((Map)snapshot.get("autoscalingState")).remove("diagnostics");
            }
            if (!withSuggestions) {
                ((Map)snapshot.get("autoscalingState")).remove("suggestions");
            }
            String data = Utils.toJSONString(snapshot);
            if (redact) {
                RedactionUtils.RedactionContext ctx = SimUtils.getRedactionContext(snapshotCloudManager.getClusterStateProvider().getClusterState());
                data = RedactionUtils.redactNames(ctx.getRedactions(), data);
            }
            scenario.console.println(data);
        }
    }

    public static class SetNodeMetrics
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String nodeset = this.params.required().get("nodeset");
            HashSet<String> nodes = new HashSet<String>();
            if (nodeset.equals("#ANY")) {
                nodes.addAll(scenario.cluster.getLiveNodesSet().get());
            } else {
                String[] list = nodeset.split("[,\\s]+");
                for (String node : list) {
                    if (node.trim().isEmpty()) continue;
                    nodes.add(node);
                }
            }
            HashMap<String, Object> values = new HashMap<String, Object>();
            this.params.remove("nodeset");
            for (String key : this.params.getParameterNames()) {
                Object val;
                String strVal = this.params.get(key);
                try {
                    val = Long.parseLong(strVal);
                }
                catch (NumberFormatException nfe) {
                    try {
                        val = Double.parseDouble(strVal);
                    }
                    catch (NumberFormatException nfe1) {
                        val = strVal;
                    }
                }
                values.put(key, val);
            }
            for (String node : nodes) {
                scenario.cluster.getSimNodeStateProvider().simSetNodeValues(node, values);
            }
        }
    }

    public static class SetShardMetrics
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String collection = this.params.required().get("collection");
            String shard = this.params.get("shard");
            boolean delta = this.params.getBool("delta", false);
            boolean divide = this.params.getBool("divide", false);
            this.params.remove("collection");
            this.params.remove("shard");
            this.params.remove("delta");
            this.params.remove("divide");
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (String key : this.params.getParameterNames()) {
                try {
                    Integer i = Integer.valueOf(this.params.get(key));
                    values.put(key, i);
                }
                catch (NumberFormatException nfe) {
                    try {
                        Double d = Double.valueOf(this.params.get(key));
                        values.put(key, d);
                    }
                    catch (NumberFormatException nfe1) {
                        values.put(key, this.params.get(key));
                    }
                }
            }
            values.forEach((k, v) -> {
                try {
                    scenario.cluster.getSimClusterStateProvider().simSetShardValue(collection, shard, (String)k, v, delta, divide);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error setting shard value", e);
                }
            });
        }
    }

    public static class IndexDocs
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String collection = this.params.required().get("collection");
            long numDocs = this.params.required().getLong("numDocs");
            long start = this.params.getLong("start", 0L);
            UpdateRequest ureq = new UpdateRequest();
            ureq.setParam("collection", collection);
            ureq.setDocIterator((Iterator)new FakeDocIterator(start, numDocs));
            scenario.cluster.simGetSolrClient().request((SolrRequest)ureq);
        }
    }

    public static class Assert
    extends SimOp {
        @Override
        public void execute(SimScenario scenario) throws Exception {
            String key = this.params.get("key");
            Condition condition = Condition.get(this.params.required().get("condition"));
            if (condition == null) {
                throw new IOException("Invalid 'condition' in params: " + this.params);
            }
            String expected = this.params.get("expected");
            if (condition != Condition.NOT_NULL && condition != Condition.NULL && expected == null) {
                throw new IOException("'expected' param is required when condition is " + (Object)((Object)condition));
            }
            Object value = key != null ? (key.contains("/") ? Utils.getObjectByPath(scenario.context, (boolean)true, (String)key) : scenario.context.get(key)) : this.params.required().get("value");
            switch (condition) {
                case NULL: {
                    if (value == null) break;
                    throw new IOException("expected value should be null but was '" + value + "'");
                }
                case NOT_NULL: {
                    if (value != null) break;
                    throw new IOException("expected value should not be null");
                }
                case EQUALS: {
                    if (expected.equals(String.valueOf(value))) break;
                    throw new IOException("expected value is '" + expected + "' but actual value is '" + value + "'");
                }
                case NOT_EQUALS: {
                    if (!expected.equals(String.valueOf(value))) break;
                    throw new IOException("expected value is '" + expected + "' and actual value is the same while it should be different");
                }
            }
        }
    }

    public static enum Condition {
        EQUALS,
        NOT_EQUALS,
        NULL,
        NOT_NULL;


        public static Condition get(String p) {
            if (p == null) {
                return null;
            }
            try {
                return Condition.valueOf(p.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    private static class SimWaitListener
    extends TriggerListenerBase {
        private final TimeSource timeSource;
        private final AutoScalingConfig.TriggerListenerConfig config;
        private CountDownLatch triggerFired = new CountDownLatch(1);
        private TriggerEvent event;

        SimWaitListener(TimeSource timeSource, AutoScalingConfig.TriggerListenerConfig config) {
            this.timeSource = timeSource;
            this.config = config;
        }

        @Override
        public AutoScalingConfig.TriggerListenerConfig getConfig() {
            return this.config;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }

        @Override
        public void onEvent(TriggerEvent event, TriggerEventProcessorStage stage, String actionName, ActionContext context, Throwable error, String message) throws Exception {
            this.triggerFired.countDown();
            this.event = event;
        }

        public TriggerEvent getEvent() {
            return this.event;
        }

        public void wait(int waitSec) throws Exception {
            long waitTime = this.timeSource.convertDelay(TimeUnit.SECONDS, (long)waitSec, TimeUnit.MILLISECONDS);
            boolean await = this.triggerFired.await(waitTime, TimeUnit.MILLISECONDS);
            if (!await) {
                throw new IOException("Timed out waiting for trigger " + this.config.trigger + " to fire after simulated " + waitSec + "s (real " + waitTime + "ms).");
            }
        }
    }
}

