/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.prometheus.exporter;

import io.prometheus.client.Collector;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.HTTPServer;
import java.io.Closeable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.ArgumentParserException;
import net.sourceforge.argparse4j.inf.Namespace;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.IOUtils;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.core.XmlConfigFile;
import org.apache.solr.prometheus.collector.MetricsCollectorFactory;
import org.apache.solr.prometheus.collector.SchedulerMetricsCollector;
import org.apache.solr.prometheus.exporter.CachedPrometheusCollector;
import org.apache.solr.prometheus.exporter.MetricsConfiguration;
import org.apache.solr.prometheus.exporter.PrometheusExporterSettings;
import org.apache.solr.prometheus.exporter.SolrClientFactory;
import org.apache.solr.prometheus.exporter.SolrScrapeConfiguration;
import org.apache.solr.prometheus.scraper.SolrCloudScraper;
import org.apache.solr.prometheus.scraper.SolrScraper;
import org.apache.solr.prometheus.scraper.SolrStandaloneScraper;
import org.apache.solr.util.DefaultSolrThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrExporter {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String[] ARG_PORT_FLAGS = new String[]{"-p", "--port"};
    private static final String ARG_PORT_METAVAR = "PORT";
    private static final String ARG_PORT_DEST = "port";
    private static final int ARG_PORT_DEFAULT = 9983;
    private static final String ARG_PORT_HELP = "Specify the solr-exporter HTTP listen port; default is 9983.";
    private static final String[] ARG_BASE_URL_FLAGS = new String[]{"-b", "--baseurl"};
    private static final String ARG_BASE_URL_METAVAR = "BASE_URL";
    private static final String ARG_BASE_URL_DEST = "baseUrl";
    private static final String ARG_BASE_URL_DEFAULT = "http://localhost:8983/solr";
    private static final String ARG_BASE_URL_HELP = "Specify the Solr base URL when connecting to Solr in standalone mode. If omitted both the -b parameter and the -z parameter, connect to http://localhost:8983/solr. For example 'http://localhost:8983/solr'.";
    private static final String[] ARG_ZK_HOST_FLAGS = new String[]{"-z", "--zkhost"};
    private static final String ARG_ZK_HOST_METAVAR = "ZK_HOST";
    private static final String ARG_ZK_HOST_DEST = "zkHost";
    private static final String ARG_ZK_HOST_DEFAULT = "";
    private static final String ARG_ZK_HOST_HELP = "Specify the ZooKeeper connection string when connecting to Solr in SolrCloud mode. If omitted both the -b parameter and the -z parameter, connect to http://localhost:8983/solr. For example 'localhost:2181/solr'.";
    private static final String[] ARG_CONFIG_FLAGS = new String[]{"-f", "--config-file"};
    private static final String ARG_CONFIG_METAVAR = "CONFIG";
    private static final String ARG_CONFIG_DEST = "configFile";
    private static final String ARG_CONFIG_DEFAULT = "./conf/solr-exporter-config.xml";
    private static final String ARG_CONFIG_HELP = "Specify the configuration file; the default is ./conf/solr-exporter-config.xml.";
    private static final String[] ARG_SCRAPE_INTERVAL_FLAGS = new String[]{"-s", "--scrape-interval"};
    private static final String ARG_SCRAPE_INTERVAL_METAVAR = "SCRAPE_INTERVAL";
    private static final String ARG_SCRAPE_INTERVAL_DEST = "scrapeInterval";
    private static final int ARG_SCRAPE_INTERVAL_DEFAULT = 60;
    private static final String ARG_SCRAPE_INTERVAL_HELP = "Specify the delay between scraping Solr metrics; the default is 60 seconds.";
    private static final String[] ARG_NUM_THREADS_FLAGS = new String[]{"-n", "--num-threads"};
    private static final String ARG_NUM_THREADS_METAVAR = "NUM_THREADS";
    private static final String ARG_NUM_THREADS_DEST = "numThreads";
    private static final Integer ARG_NUM_THREADS_DEFAULT = 1;
    private static final String ARG_NUM_THREADS_HELP = "Specify the number of threads. solr-exporter creates a thread pools for request to Solr. If you need to improve request latency via solr-exporter, you can increase the number of threads; the default is " + ARG_NUM_THREADS_DEFAULT + ".";
    public static final CollectorRegistry defaultRegistry = new CollectorRegistry();
    private final int port;
    private final CachedPrometheusCollector prometheusCollector;
    private final SchedulerMetricsCollector metricsCollector;
    private final SolrScraper solrScraper;
    private final ExecutorService metricCollectorExecutor;
    private final ExecutorService requestExecutor;
    private HTTPServer httpServer;

    public SolrExporter(int port, int numberThreads, int scrapeInterval, SolrScrapeConfiguration scrapeConfiguration, MetricsConfiguration metricsConfiguration) {
        this.port = port;
        this.metricCollectorExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)numberThreads, (ThreadFactory)new DefaultSolrThreadFactory("solr-exporter-collectors"));
        this.requestExecutor = ExecutorUtil.newMDCAwareFixedThreadPool((int)numberThreads, (ThreadFactory)new DefaultSolrThreadFactory("solr-exporter-requests"));
        this.solrScraper = this.createScraper(scrapeConfiguration, metricsConfiguration.getSettings());
        this.metricsCollector = new MetricsCollectorFactory(this.metricCollectorExecutor, scrapeInterval, this.solrScraper, metricsConfiguration).create();
        this.prometheusCollector = new CachedPrometheusCollector();
    }

    void start() throws IOException {
        defaultRegistry.register((Collector)this.prometheusCollector);
        this.metricsCollector.addObserver(this.prometheusCollector);
        this.metricsCollector.start();
        this.httpServer = new HTTPServer(new InetSocketAddress(this.port), defaultRegistry);
    }

    void stop() {
        this.httpServer.stop();
        this.metricsCollector.removeObserver(this.prometheusCollector);
        this.requestExecutor.shutdownNow();
        this.metricCollectorExecutor.shutdownNow();
        IOUtils.closeQuietly((Closeable)this.metricsCollector);
        IOUtils.closeQuietly((Closeable)this.solrScraper);
        defaultRegistry.unregister((Collector)this.prometheusCollector);
    }

    private SolrScraper createScraper(SolrScrapeConfiguration configuration, PrometheusExporterSettings settings) {
        SolrClientFactory factory = new SolrClientFactory(settings);
        switch (configuration.getType()) {
            case STANDALONE: {
                return new SolrStandaloneScraper(factory.createStandaloneSolrClient(configuration.getSolrHost().get()), this.requestExecutor);
            }
            case CLOUD: {
                return new SolrCloudScraper(factory.createCloudSolrClient(configuration.getZookeeperConnectionString().get()), this.requestExecutor, factory);
            }
        }
        throw new RuntimeException(String.format(Locale.ROOT, "Invalid type: %s", new Object[]{configuration.getType()}));
    }

    public static void main(String[] args) {
        ArgumentParser parser = ArgumentParsers.newFor((String)SolrExporter.class.getSimpleName()).build().description("Prometheus exporter for Apache Solr.");
        parser.addArgument(ARG_PORT_FLAGS).metavar(new String[]{ARG_PORT_METAVAR}).dest(ARG_PORT_DEST).type(Integer.class).setDefault((Object)9983).help(ARG_PORT_HELP);
        parser.addArgument(ARG_BASE_URL_FLAGS).metavar(new String[]{ARG_BASE_URL_METAVAR}).dest(ARG_BASE_URL_DEST).type(String.class).setDefault((Object)ARG_BASE_URL_DEFAULT).help(ARG_BASE_URL_HELP);
        parser.addArgument(ARG_ZK_HOST_FLAGS).metavar(new String[]{ARG_ZK_HOST_METAVAR}).dest(ARG_ZK_HOST_DEST).type(String.class).setDefault((Object)ARG_ZK_HOST_DEFAULT).help(ARG_ZK_HOST_HELP);
        parser.addArgument(ARG_CONFIG_FLAGS).metavar(new String[]{ARG_CONFIG_METAVAR}).dest(ARG_CONFIG_DEST).type(String.class).setDefault((Object)ARG_CONFIG_DEFAULT).help(ARG_CONFIG_HELP);
        parser.addArgument(ARG_SCRAPE_INTERVAL_FLAGS).metavar(new String[]{ARG_SCRAPE_INTERVAL_METAVAR}).dest(ARG_SCRAPE_INTERVAL_DEST).type(Integer.class).setDefault((Object)60).help(ARG_SCRAPE_INTERVAL_HELP);
        parser.addArgument(ARG_NUM_THREADS_FLAGS).metavar(new String[]{ARG_NUM_THREADS_METAVAR}).dest(ARG_NUM_THREADS_DEST).type(Integer.class).setDefault((Object)ARG_NUM_THREADS_DEFAULT).help(ARG_NUM_THREADS_HELP);
        try {
            Namespace res = parser.parseArgs(args);
            SolrScrapeConfiguration scrapeConfiguration = null;
            if (!res.getString(ARG_ZK_HOST_DEST).equals(ARG_ZK_HOST_DEFAULT)) {
                scrapeConfiguration = SolrScrapeConfiguration.solrCloud(res.getString(ARG_ZK_HOST_DEST));
            } else if (!res.getString(ARG_BASE_URL_DEST).equals(ARG_ZK_HOST_DEFAULT)) {
                scrapeConfiguration = SolrScrapeConfiguration.standalone(res.getString(ARG_BASE_URL_DEST));
            }
            if (scrapeConfiguration == null) {
                log.error("Must provide either {} or {}", (Object)ARG_BASE_URL_FLAGS, (Object)ARG_ZK_HOST_FLAGS);
            }
            SolrExporter solrExporter = new SolrExporter(res.getInt(ARG_PORT_DEST), res.getInt(ARG_NUM_THREADS_DEST), res.getInt(ARG_SCRAPE_INTERVAL_DEST), scrapeConfiguration, SolrExporter.loadMetricsConfiguration(Paths.get(res.getString(ARG_CONFIG_DEST), new String[0])));
            log.info("Starting Solr Prometheus Exporting");
            solrExporter.start();
            log.info("Solr Prometheus Exporter is running");
        }
        catch (IOException e) {
            log.error("Failed to start Solr Prometheus Exporter: " + e.toString());
        }
        catch (ArgumentParserException e) {
            parser.handleError(e);
        }
    }

    private static MetricsConfiguration loadMetricsConfiguration(Path configPath) {
        MetricsConfiguration metricsConfiguration;
        SolrResourceLoader loader = new SolrResourceLoader(configPath.getParent());
        try {
            XmlConfigFile config = new XmlConfigFile(loader, configPath.getFileName().toString());
            metricsConfiguration = MetricsConfiguration.from(config);
        }
        catch (Throwable throwable) {
            try {
                try {
                    loader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Could not load scrape configuration from {}", (Object)configPath.toAbsolutePath());
                throw new RuntimeException(e);
            }
        }
        loader.close();
        return metricsConfiguration;
    }
}

