/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.Arrays;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.facet.SortedSetDVAcc;

abstract class LongSortedSetDVAcc
extends SortedSetDVAcc {
    long[] result;
    long initialValue;

    public LongSortedSetDVAcc(FacetContext fcontext, SchemaField sf, int numSlots, long initialValue) throws IOException {
        super(fcontext, sf, numSlots);
        this.result = new long[numSlots];
        this.initialValue = initialValue;
        if (initialValue != 0L) {
            Arrays.fill(this.result, initialValue);
        }
    }

    @Override
    public int compare(int slotA, int slotB) {
        return Long.compare(this.result[slotA], this.result[slotB]);
    }

    @Override
    public Object getValue(int slotNum) throws IOException {
        return this.result[slotNum];
    }

    @Override
    public void reset() throws IOException {
        Arrays.fill(this.result, this.initialValue);
    }

    @Override
    public void resize(SlotAcc.Resizer resizer) {
        resizer.resize(this.result, this.initialValue);
    }
}

