/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.suggest.analyzing;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.TokenStreamToAutomaton;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.FSTUtil;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.CharsRefBuilder;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.OfflineSorter;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.LimitedFiniteStringsIterator;
import org.apache.lucene.util.automaton.Operations;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.Builder;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.PairOutputs;
import org.apache.lucene.util.fst.PositiveIntOutputs;
import org.apache.lucene.util.fst.Util;

public class AnalyzingSuggester
extends Lookup
implements Accountable {
    private FST<PairOutputs.Pair<Long, BytesRef>> fst = null;
    private final Analyzer indexAnalyzer;
    private final Analyzer queryAnalyzer;
    private final boolean exactFirst;
    private final boolean preserveSep;
    public static final int EXACT_FIRST = 1;
    public static final int PRESERVE_SEP = 2;
    private static final int SEP_LABEL = 31;
    private static final int END_BYTE = 0;
    private final int maxSurfaceFormsPerAnalyzedForm;
    private final int maxGraphExpansions;
    private final Directory tempDir;
    private final String tempFileNamePrefix;
    private int maxAnalyzedPathsForOneInput;
    private boolean hasPayloads;
    private static final int PAYLOAD_SEP = 31;
    private boolean preservePositionIncrements;
    private long count = 0L;
    static final Comparator<PairOutputs.Pair<Long, BytesRef>> weightComparator = new Comparator<PairOutputs.Pair<Long, BytesRef>>(){

        @Override
        public int compare(PairOutputs.Pair<Long, BytesRef> left, PairOutputs.Pair<Long, BytesRef> right) {
            return ((Long)left.output1).compareTo((Long)right.output1);
        }
    };

    public AnalyzingSuggester(Directory tempDir, String tempFileNamePrefix, Analyzer analyzer) {
        this(tempDir, tempFileNamePrefix, analyzer, analyzer, 3, 256, -1, true);
    }

    public AnalyzingSuggester(Directory tempDir, String tempFileNamePrefix, Analyzer indexAnalyzer, Analyzer queryAnalyzer) {
        this(tempDir, tempFileNamePrefix, indexAnalyzer, queryAnalyzer, 3, 256, -1, true);
    }

    public AnalyzingSuggester(Directory tempDir, String tempFileNamePrefix, Analyzer indexAnalyzer, Analyzer queryAnalyzer, int options, int maxSurfaceFormsPerAnalyzedForm, int maxGraphExpansions, boolean preservePositionIncrements) {
        this.indexAnalyzer = indexAnalyzer;
        this.queryAnalyzer = queryAnalyzer;
        if ((options & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("options should only contain EXACT_FIRST and PRESERVE_SEP; got " + options);
        }
        this.exactFirst = (options & 1) != 0;
        boolean bl = this.preserveSep = (options & 2) != 0;
        if (maxSurfaceFormsPerAnalyzedForm <= 0 || maxSurfaceFormsPerAnalyzedForm > 256) {
            throw new IllegalArgumentException("maxSurfaceFormsPerAnalyzedForm must be > 0 and < 256 (got: " + maxSurfaceFormsPerAnalyzedForm + ")");
        }
        this.maxSurfaceFormsPerAnalyzedForm = maxSurfaceFormsPerAnalyzedForm;
        if (maxGraphExpansions < 1 && maxGraphExpansions != -1) {
            throw new IllegalArgumentException("maxGraphExpansions must -1 (no limit) or > 0 (got: " + maxGraphExpansions + ")");
        }
        this.maxGraphExpansions = maxGraphExpansions;
        this.preservePositionIncrements = preservePositionIncrements;
        this.tempDir = tempDir;
        this.tempFileNamePrefix = tempFileNamePrefix;
    }

    public long ramBytesUsed() {
        return this.fst == null ? 0L : this.fst.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        if (this.fst == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Accountables.namedAccountable((String)"fst", this.fst));
    }

    private Automaton replaceSep(Automaton a) {
        int numStates = a.getNumStates();
        Automaton.Builder result = new Automaton.Builder(numStates, a.getNumTransitions());
        result.copyStates(a);
        Transition t = new Transition();
        int[] topoSortStates = Operations.topoSortStates((Automaton)a);
        for (int i = 0; i < topoSortStates.length; ++i) {
            int state = topoSortStates[topoSortStates.length - 1 - i];
            int count = a.initTransition(state, t);
            for (int j = 0; j < count; ++j) {
                a.getNextTransition(t);
                if (t.min == 31) {
                    assert (t.max == 31);
                    if (this.preserveSep) {
                        result.addTransition(state, t.dest, 31);
                        continue;
                    }
                    result.addEpsilon(state, t.dest);
                    continue;
                }
                if (t.min == 30) {
                    assert (t.max == 30);
                    result.addEpsilon(state, t.dest);
                    continue;
                }
                result.addTransition(state, t.dest, t.min, t.max);
            }
        }
        return result.finish();
    }

    protected Automaton convertAutomaton(Automaton a) {
        return a;
    }

    TokenStreamToAutomaton getTokenStreamToAutomaton() {
        TokenStreamToAutomaton tsta = new TokenStreamToAutomaton();
        tsta.setPreservePositionIncrements(this.preservePositionIncrements);
        tsta.setFinalOffsetGapAsHole(true);
        return tsta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void build(InputIterator iterator) throws IOException {
        if (iterator.hasContexts()) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        this.hasPayloads = iterator.hasPayloads();
        OfflineSorter sorter = new OfflineSorter(this.tempDir, this.tempFileNamePrefix, (Comparator)new AnalyzingComparator(this.hasPayloads));
        IndexOutput tempInput = this.tempDir.createTempOutput(this.tempFileNamePrefix, "input", IOContext.DEFAULT);
        OfflineSorter.ByteSequencesWriter writer = new OfflineSorter.ByteSequencesWriter(tempInput);
        OfflineSorter.ByteSequencesReader reader = null;
        BytesRefBuilder scratch = new BytesRefBuilder();
        TokenStreamToAutomaton ts2a = this.getTokenStreamToAutomaton();
        String tempSortedFileName = null;
        this.count = 0L;
        byte[] buffer = new byte[8];
        try {
            BytesRef bytes;
            BytesRef surfaceForm;
            ByteArrayDataOutput output = new ByteArrayDataOutput(buffer);
            while ((surfaceForm = iterator.next()) != null) {
                IntsRef string;
                LimitedFiniteStringsIterator finiteStrings = new LimitedFiniteStringsIterator(this.toAutomaton(surfaceForm, ts2a), this.maxGraphExpansions);
                while ((string = finiteStrings.next()) != null) {
                    BytesRef payload;
                    Util.toBytesRef((IntsRef)string, (BytesRefBuilder)scratch);
                    if (scratch.length() > 32765) {
                        throw new IllegalArgumentException("cannot handle analyzed forms > 32765 in length (got " + scratch.length() + ")");
                    }
                    short analyzedLength = (short)scratch.length();
                    int requiredLength = analyzedLength + 4 + surfaceForm.length + 2;
                    if (this.hasPayloads) {
                        if (surfaceForm.length > 32765) {
                            throw new IllegalArgumentException("cannot handle surface form > 32765 in length (got " + surfaceForm.length + ")");
                        }
                        payload = iterator.payload();
                        requiredLength += payload.length + 2;
                    } else {
                        payload = null;
                    }
                    buffer = ArrayUtil.grow((byte[])buffer, (int)requiredLength);
                    output.reset(buffer);
                    output.writeShort(analyzedLength);
                    output.writeBytes(scratch.bytes(), 0, scratch.length());
                    output.writeInt(AnalyzingSuggester.encodeWeight(iterator.weight()));
                    if (this.hasPayloads) {
                        for (int i = 0; i < surfaceForm.length; ++i) {
                            if (surfaceForm.bytes[i] != 31) continue;
                            throw new IllegalArgumentException("surface form cannot contain unit separator character U+001F; this character is reserved");
                        }
                        output.writeShort((short)surfaceForm.length);
                        output.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
                        output.writeBytes(payload.bytes, payload.offset, payload.length);
                    } else {
                        output.writeBytes(surfaceForm.bytes, surfaceForm.offset, surfaceForm.length);
                    }
                    assert (output.getPosition() == requiredLength) : output.getPosition() + " vs " + requiredLength;
                    writer.write(buffer, 0, output.getPosition());
                    ++this.count;
                }
                this.maxAnalyzedPathsForOneInput = Math.max(this.maxAnalyzedPathsForOneInput, finiteStrings.size());
            }
            CodecUtil.writeFooter((IndexOutput)tempInput);
            writer.close();
            tempSortedFileName = sorter.sort(tempInput.getName());
            this.tempDir.deleteFile(tempInput.getName());
            reader = new OfflineSorter.ByteSequencesReader(this.tempDir.openChecksumInput(tempSortedFileName, IOContext.READONCE), tempSortedFileName);
            PairOutputs outputs = new PairOutputs((Outputs)PositiveIntOutputs.getSingleton(), (Outputs)ByteSequenceOutputs.getSingleton());
            Builder builder = new Builder(FST.INPUT_TYPE.BYTE1, (Outputs)outputs);
            BytesRefBuilder previousAnalyzed = null;
            BytesRefBuilder analyzed = new BytesRefBuilder();
            BytesRef surface = new BytesRef();
            IntsRefBuilder scratchInts = new IntsRefBuilder();
            ByteArrayDataInput input = new ByteArrayDataInput();
            HashSet<BytesRef> seenSurfaceForms = new HashSet<BytesRef>();
            int dedup = 0;
            while ((bytes = reader.next()) != null) {
                input.reset(bytes.bytes, bytes.offset, bytes.length);
                short analyzedLength = input.readShort();
                analyzed.grow(analyzedLength + 2);
                input.readBytes(analyzed.bytes(), 0, (int)analyzedLength);
                analyzed.setLength((int)analyzedLength);
                long cost = input.readInt();
                surface.bytes = bytes.bytes;
                if (this.hasPayloads) {
                    surface.length = input.readShort();
                    surface.offset = input.getPosition();
                } else {
                    surface.offset = input.getPosition();
                    surface.length = bytes.length - surface.offset;
                }
                if (previousAnalyzed == null) {
                    previousAnalyzed = new BytesRefBuilder();
                    previousAnalyzed.copyBytes(analyzed.get());
                    seenSurfaceForms.add(BytesRef.deepCopyOf((BytesRef)surface));
                } else if (analyzed.get().equals((Object)previousAnalyzed.get())) {
                    if (++dedup >= this.maxSurfaceFormsPerAnalyzedForm || seenSurfaceForms.contains(surface)) continue;
                    seenSurfaceForms.add(BytesRef.deepCopyOf((BytesRef)surface));
                } else {
                    dedup = 0;
                    previousAnalyzed.copyBytes(analyzed);
                    seenSurfaceForms.clear();
                    seenSurfaceForms.add(BytesRef.deepCopyOf((BytesRef)surface));
                }
                analyzed.append((byte)0);
                analyzed.append((byte)dedup);
                Util.toIntsRef((BytesRef)analyzed.get(), (IntsRefBuilder)scratchInts);
                if (!this.hasPayloads) {
                    builder.add(scratchInts.get(), (Object)outputs.newPair((Object)cost, (Object)BytesRef.deepCopyOf((BytesRef)surface)));
                    continue;
                }
                int payloadOffset = input.getPosition() + surface.length;
                int payloadLength = bytes.length - payloadOffset;
                BytesRef br = new BytesRef(surface.length + 1 + payloadLength);
                System.arraycopy(surface.bytes, surface.offset, br.bytes, 0, surface.length);
                br.bytes[surface.length] = 31;
                System.arraycopy(bytes.bytes, payloadOffset, br.bytes, surface.length + 1, payloadLength);
                br.length = br.bytes.length;
                builder.add(scratchInts.get(), (Object)outputs.newPair((Object)cost, (Object)br));
            }
            this.fst = builder.finish();
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, writer});
            IOUtils.deleteFilesIgnoringExceptions((Directory)this.tempDir, (String[])new String[]{tempInput.getName(), tempSortedFileName});
            throw throwable;
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{reader, writer});
        IOUtils.deleteFilesIgnoringExceptions((Directory)this.tempDir, (String[])new String[]{tempInput.getName(), tempSortedFileName});
    }

    @Override
    public boolean store(DataOutput output) throws IOException {
        output.writeVLong(this.count);
        if (this.fst == null) {
            return false;
        }
        this.fst.save(output);
        output.writeVInt(this.maxAnalyzedPathsForOneInput);
        output.writeByte((byte)(this.hasPayloads ? 1 : 0));
        return true;
    }

    @Override
    public boolean load(DataInput input) throws IOException {
        this.count = input.readVLong();
        this.fst = new FST(input, (Outputs)new PairOutputs((Outputs)PositiveIntOutputs.getSingleton(), (Outputs)ByteSequenceOutputs.getSingleton()));
        this.maxAnalyzedPathsForOneInput = input.readVInt();
        this.hasPayloads = input.readByte() == 1;
        return true;
    }

    private Lookup.LookupResult getLookupResult(Long output1, BytesRef output2, CharsRefBuilder spare) {
        Lookup.LookupResult result;
        if (this.hasPayloads) {
            int sepIndex = -1;
            for (int i = 0; i < output2.length; ++i) {
                if (output2.bytes[output2.offset + i] != 31) continue;
                sepIndex = i;
                break;
            }
            assert (sepIndex != -1);
            spare.grow(sepIndex);
            int payloadLen = output2.length - sepIndex - 1;
            spare.copyUTF8Bytes(output2.bytes, output2.offset, sepIndex);
            BytesRef payload = new BytesRef(payloadLen);
            System.arraycopy(output2.bytes, sepIndex + 1, payload.bytes, 0, payloadLen);
            payload.length = payloadLen;
            result = new Lookup.LookupResult((CharSequence)spare.toString(), (long)AnalyzingSuggester.decodeWeight(output1), payload);
        } else {
            spare.grow(output2.length);
            spare.copyUTF8Bytes(output2);
            result = new Lookup.LookupResult(spare.toString(), AnalyzingSuggester.decodeWeight(output1));
        }
        return result;
    }

    private boolean sameSurfaceForm(BytesRef key, BytesRef output2) {
        if (this.hasPayloads) {
            if (key.length >= output2.length) {
                return false;
            }
            for (int i = 0; i < key.length; ++i) {
                if (key.bytes[key.offset + i] == output2.bytes[output2.offset + i]) continue;
                return false;
            }
            return output2.bytes[output2.offset + key.length] == 31;
        }
        return key.bytesEquals(output2);
    }

    @Override
    public List<Lookup.LookupResult> lookup(CharSequence key, Set<BytesRef> contexts, boolean onlyMorePopular, int num) {
        assert (num > 0);
        if (onlyMorePopular) {
            throw new IllegalArgumentException("this suggester only works with onlyMorePopular=false");
        }
        if (contexts != null) {
            throw new IllegalArgumentException("this suggester doesn't support contexts");
        }
        if (this.fst == null) {
            return Collections.emptyList();
        }
        for (int i = 0; i < key.length(); ++i) {
            if (key.charAt(i) == '\u001e') {
                throw new IllegalArgumentException("lookup key cannot contain HOLE character U+001E; this character is reserved");
            }
            if (key.charAt(i) != '\u001f') continue;
            throw new IllegalArgumentException("lookup key cannot contain unit separator character U+001F; this character is reserved");
        }
        final BytesRef utf8Key = new BytesRef(key);
        try {
            Automaton lookupAutomaton = this.toLookupAutomaton(key);
            CharsRefBuilder spare = new CharsRefBuilder();
            FST.BytesReader bytesReader = this.fst.getBytesReader();
            FST.Arc scratchArc = new FST.Arc();
            final ArrayList<Lookup.LookupResult> results = new ArrayList<Lookup.LookupResult>();
            List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths = FSTUtil.intersectPrefixPaths(this.convertAutomaton(lookupAutomaton), this.fst);
            if (this.exactFirst) {
                int count = 0;
                for (FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>> path : prefixPaths) {
                    if (this.fst.findTargetArc(0, path.fstNode, scratchArc, bytesReader) == null) continue;
                    ++count;
                }
                Util.TopNSearcher searcher = new Util.TopNSearcher(this.fst, count * this.maxSurfaceFormsPerAnalyzedForm, count * this.maxSurfaceFormsPerAnalyzedForm, weightComparator);
                for (FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>> path : prefixPaths) {
                    if (this.fst.findTargetArc(0, path.fstNode, scratchArc, bytesReader) == null) continue;
                    searcher.addStartPaths(scratchArc, (Object)((PairOutputs.Pair)this.fst.outputs.add((Object)((PairOutputs.Pair)path.output), (Object)((PairOutputs.Pair)scratchArc.output()))), false, path.input);
                }
                Util.TopResults topResults = searcher.search();
                assert (topResults.isComplete);
                for (Util.Result completion : topResults) {
                    BytesRef output2 = (BytesRef)((PairOutputs.Pair)completion.output).output2;
                    if (!this.sameSurfaceForm(utf8Key, output2)) continue;
                    results.add(this.getLookupResult((Long)((PairOutputs.Pair)completion.output).output1, output2, spare));
                    break;
                }
                if (results.size() == num) {
                    return results;
                }
            }
            Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>> searcher = new Util.TopNSearcher<PairOutputs.Pair<Long, BytesRef>>(this.fst, num - results.size(), num * this.maxAnalyzedPathsForOneInput, weightComparator){
                private final Set<BytesRef> seen;
                {
                    super(arg0, arg1, arg2, arg3);
                    this.seen = new HashSet<BytesRef>();
                }

                protected boolean acceptResult(IntsRef input, PairOutputs.Pair<Long, BytesRef> output) {
                    if (this.seen.contains(output.output2)) {
                        return false;
                    }
                    this.seen.add((BytesRef)output.output2);
                    if (!AnalyzingSuggester.this.exactFirst) {
                        return true;
                    }
                    if (AnalyzingSuggester.this.sameSurfaceForm(utf8Key, (BytesRef)output.output2)) {
                        assert (results.size() == 1);
                        return false;
                    }
                    return true;
                }
            };
            prefixPaths = this.getFullPrefixPaths(prefixPaths, lookupAutomaton, this.fst);
            for (FSTUtil.Path path : prefixPaths) {
                searcher.addStartPaths(path.fstNode, (Object)((PairOutputs.Pair)path.output), true, path.input);
            }
            Util.TopResults completions = searcher.search();
            assert (completions.isComplete);
            for (Util.Result result : completions) {
                Lookup.LookupResult result2 = this.getLookupResult((Long)((PairOutputs.Pair)result.output).output1, (BytesRef)((PairOutputs.Pair)result.output).output2, spare);
                results.add(result2);
                if (results.size() != num) continue;
                break;
            }
            return results;
        }
        catch (IOException bogus) {
            throw new RuntimeException(bogus);
        }
    }

    @Override
    public long getCount() {
        return this.count;
    }

    protected List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> getFullPrefixPaths(List<FSTUtil.Path<PairOutputs.Pair<Long, BytesRef>>> prefixPaths, Automaton lookupAutomaton, FST<PairOutputs.Pair<Long, BytesRef>> fst) throws IOException {
        return prefixPaths;
    }

    final Automaton toAutomaton(BytesRef surfaceForm, TokenStreamToAutomaton ts2a) throws IOException {
        Automaton automaton;
        try (TokenStream ts = this.indexAnalyzer.tokenStream("", surfaceForm.utf8ToString());){
            automaton = ts2a.toAutomaton(ts);
        }
        automaton = this.replaceSep(automaton);
        automaton = this.convertAutomaton(automaton);
        return automaton;
    }

    final Automaton toLookupAutomaton(CharSequence key) throws IOException {
        Automaton automaton = null;
        try (TokenStream ts = this.queryAnalyzer.tokenStream("", key.toString());){
            automaton = this.getTokenStreamToAutomaton().toAutomaton(ts);
        }
        automaton = this.replaceSep(automaton);
        automaton = Operations.determinize((Automaton)automaton, (int)10000);
        return automaton;
    }

    public Object get(CharSequence key) {
        throw new UnsupportedOperationException();
    }

    private static int decodeWeight(long encoded) {
        return (int)(Integer.MAX_VALUE - encoded);
    }

    private static int encodeWeight(long value) {
        if (value < 0L || value > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("cannot encode value: " + value);
        }
        return Integer.MAX_VALUE - (int)value;
    }

    private static class AnalyzingComparator
    implements Comparator<BytesRef> {
        private final boolean hasPayloads;
        private final ByteArrayDataInput readerA = new ByteArrayDataInput();
        private final ByteArrayDataInput readerB = new ByteArrayDataInput();
        private final BytesRef scratchA = new BytesRef();
        private final BytesRef scratchB = new BytesRef();

        public AnalyzingComparator(boolean hasPayloads) {
            this.hasPayloads = hasPayloads;
        }

        @Override
        public int compare(BytesRef a, BytesRef b) {
            this.readerA.reset(a.bytes, a.offset, a.length);
            this.scratchA.length = this.readerA.readShort();
            this.scratchA.bytes = a.bytes;
            this.scratchA.offset = this.readerA.getPosition();
            this.readerB.reset(b.bytes, b.offset, b.length);
            this.scratchB.bytes = b.bytes;
            this.scratchB.length = this.readerB.readShort();
            this.scratchB.offset = this.readerB.getPosition();
            int cmp = this.scratchA.compareTo(this.scratchB);
            if (cmp != 0) {
                return cmp;
            }
            this.readerA.skipBytes((long)this.scratchA.length);
            this.readerB.skipBytes((long)this.scratchB.length);
            long aCost = this.readerA.readInt();
            long bCost = this.readerB.readInt();
            assert (AnalyzingSuggester.decodeWeight(aCost) >= 0);
            assert (AnalyzingSuggester.decodeWeight(bCost) >= 0);
            if (aCost < bCost) {
                return -1;
            }
            if (aCost > bCost) {
                return 1;
            }
            if (this.hasPayloads) {
                this.scratchA.length = this.readerA.readShort();
                this.scratchB.length = this.readerB.readShort();
                this.scratchA.offset = this.readerA.getPosition();
                this.scratchB.offset = this.readerB.getPosition();
            } else {
                this.scratchA.offset = this.readerA.getPosition();
                this.scratchB.offset = this.readerB.getPosition();
                this.scratchA.length = this.readerA.length() - this.readerA.getPosition();
                this.scratchB.length = this.readerB.length() - this.readerB.getPosition();
            }
            assert (this.scratchA.isValid());
            assert (this.scratchB.isValid());
            return this.scratchA.compareTo(this.scratchB);
        }
    }
}

