/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.util.ArrayList;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.digester.CallMethodRule;
import org.xml.sax.SAXException;

final class CallMethodMultiRule
extends CallMethodRule {
    int multiParamIndex = 0;

    public CallMethodMultiRule(String methodName, int paramCount, int multiParamIndex) {
        super(methodName, paramCount);
        this.multiParamIndex = multiParamIndex;
    }

    public void end(String namespace, String name) throws Exception {
        Object[] parameters = null;
        if (this.paramCount > 0) {
            parameters = (Object[])this.digester.popParams();
        } else {
            parameters = new Object[]{};
            super.end(namespace, name);
        }
        ArrayList multiParams = (ArrayList)parameters[this.multiParamIndex];
        Object[] paramValues = new Object[this.paramTypes.length];
        for (int i = 0; i < this.paramTypes.length; ++i) {
            if (i == this.multiParamIndex) continue;
            paramValues[i] = parameters[i] == null || parameters[i] instanceof String && !String.class.isAssignableFrom(this.paramTypes[i]) ? IntrospectionUtils.convert((String)((String)parameters[i]), (Class)this.paramTypes[i]) : parameters[i];
        }
        Object target = this.targetOffset >= 0 ? this.digester.peek(this.targetOffset) : this.digester.peek(this.digester.getCount() + this.targetOffset);
        if (target == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("[CallMethodRule]{");
            sb.append("");
            sb.append("} Call target is null (");
            sb.append("targetOffset=");
            sb.append(this.targetOffset);
            sb.append(",stackdepth=");
            sb.append(this.digester.getCount());
            sb.append(")");
            throw new SAXException(sb.toString());
        }
        if (multiParams == null) {
            paramValues[this.multiParamIndex] = null;
            IntrospectionUtils.callMethodN((Object)target, (String)this.methodName, (Object[])paramValues, (Class[])this.paramTypes);
            return;
        }
        for (Object param : multiParams) {
            paramValues[this.multiParamIndex] = param == null || param instanceof String && !String.class.isAssignableFrom(this.paramTypes[this.multiParamIndex]) ? IntrospectionUtils.convert((String)((String)param), (Class)this.paramTypes[this.multiParamIndex]) : param;
            IntrospectionUtils.callMethodN((Object)target, (String)this.methodName, (Object[])paramValues, (Class[])this.paramTypes);
        }
    }
}

