/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.options.keymap.api;

import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.openide.util.Lookup;
import org.openide.util.Utilities;

public class KeyStrokeUtils {
    private static final Logger LOG = Logger.getLogger(KeyStrokeUtils.class.getName());
    private static final String EMACS_CTRL = "Ctrl+";
    private static final String EMACS_ALT = "Alt+";
    private static final String EMACS_SHIFT = "Shift+";
    private static final String EMACS_META = "Meta+";
    private static final String STRING_META;
    private static final String STRING_ALT;

    public static String getKeyStrokesAsText(@NullAllowed KeyStroke[] keyStrokeArray, @NonNull String string) {
        if (keyStrokeArray == null) {
            return "";
        }
        if (keyStrokeArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(KeyStrokeUtils.getKeyStrokeAsText(keyStrokeArray[0]));
        int n = keyStrokeArray.length;
        for (int i = 1; i < n; ++i) {
            stringBuilder.append(string).append(KeyStrokeUtils.getKeyStrokeAsText(keyStrokeArray[i]));
        }
        return new String(stringBuilder);
    }

    @CheckForNull
    public static KeyStroke getKeyStroke(@NonNull String string) {
        int n = 0;
        while (true) {
            if (string.startsWith(EMACS_CTRL)) {
                n |= 0x80;
                string = string.substring(EMACS_CTRL.length());
                continue;
            }
            if (string.startsWith(EMACS_ALT)) {
                n |= 0x200;
                string = string.substring(EMACS_ALT.length());
                continue;
            }
            if (string.startsWith(EMACS_SHIFT)) {
                n |= 0x40;
                string = string.substring(EMACS_SHIFT.length());
                continue;
            }
            if (string.startsWith(EMACS_META)) {
                n |= 0x100;
                string = string.substring(EMACS_META.length());
                continue;
            }
            if (string.startsWith(STRING_ALT)) {
                n |= 0x200;
                string = string.substring(STRING_ALT.length());
                continue;
            }
            if (!string.startsWith(STRING_META)) break;
            n |= 0x100;
            string = string.substring(STRING_META.length());
        }
        KeyStroke keyStroke = Utilities.stringToKey((String)string);
        if (keyStroke == null) {
            return null;
        }
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(keyStroke.getKeyCode(), n);
        return keyStroke2;
    }

    public static String getKeyStrokeAsText(@NonNull KeyStroke keyStroke) {
        int n = keyStroke.getModifiers();
        StringBuilder stringBuilder = new StringBuilder();
        if ((n & 0x80) > 0) {
            stringBuilder.append(EMACS_CTRL);
        }
        if ((n & 0x200) > 0) {
            stringBuilder.append(STRING_ALT);
        }
        if ((n & 0x40) > 0) {
            stringBuilder.append(EMACS_SHIFT);
        }
        if ((n & 0x100) > 0) {
            stringBuilder.append(STRING_META);
        }
        if (keyStroke.getKeyCode() != 16 && keyStroke.getKeyCode() != 17 && keyStroke.getKeyCode() != 157 && keyStroke.getKeyCode() != 18 && keyStroke.getKeyCode() != 65406) {
            stringBuilder.append(Utilities.keyToString((KeyStroke)KeyStroke.getKeyStroke(keyStroke.getKeyCode(), 0)));
        }
        return stringBuilder.toString();
    }

    @CheckForNull
    public static KeyStroke[] getKeyStrokes(@NonNull String string) {
        assert (string != null) : "The parameter key must not be null";
        ArrayList<KeyStroke> arrayList = new ArrayList<KeyStroke>();
        String string2 = " ";
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            KeyStroke keyStroke = KeyStrokeUtils.getKeyStroke(string3);
            if (keyStroke != null) {
                arrayList.add(keyStroke);
                continue;
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.log(Level.FINE, "Invalid keystroke string: ''{0}''", string3);
            }
            return null;
        }
        return arrayList.toArray(new KeyStroke[arrayList.size()]);
    }

    public static List<KeyStroke[]> getKeyStrokesForAction(@NonNull String string, @NullAllowed KeyStroke keyStroke) {
        for (ShortcutsFinder shortcutsFinder : Lookup.getDefault().lookupAll(ShortcutsFinder.class)) {
            String[] stringArray;
            ShortcutAction shortcutAction = shortcutsFinder.findActionForId(string);
            if (shortcutAction == null || (stringArray = shortcutsFinder.getShortcuts(shortcutAction)) == null || stringArray.length <= 0) continue;
            LinkedList<KeyStroke[]> linkedList = new LinkedList<KeyStroke[]>();
            for (int i = 0; i < stringArray.length; ++i) {
                KeyStroke[] keyStrokeArray;
                if (stringArray[i] == null || (keyStrokeArray = KeyStrokeUtils.getKeyStrokes(stringArray[i])) == null) continue;
                linkedList.add(keyStrokeArray);
            }
            return KeyStrokeUtils.sortKeyStrokesByPreference(linkedList);
        }
        return keyStroke == null ? Collections.emptyList() : Collections.singletonList(new KeyStroke[]{keyStroke});
    }

    private static List<KeyStroke[]> sortKeyStrokesByPreference(List<KeyStroke[]> list) {
        if (list.size() < 2) {
            return list;
        }
        KeyStroke[] keyStrokeArray = null;
        boolean bl = Utilities.getOperatingSystem() == 8;
        for (int i = 0; i < list.size(); ++i) {
            boolean bl2;
            KeyStroke[] keyStrokeArray2 = list.get(i);
            if (keyStrokeArray2.length > 1) continue;
            boolean bl3 = bl2 = keyStrokeArray2[0].getKeyCode() >= 65480 && keyStrokeArray2[0].getKeyCode() <= 65489;
            if (bl != bl2 || keyStrokeArray != null && keyStrokeArray[0].getKeyCode() <= keyStrokeArray2[0].getKeyCode()) continue;
            keyStrokeArray = keyStrokeArray2;
        }
        if (keyStrokeArray != null) {
            list.remove(keyStrokeArray);
            list.add(0, keyStrokeArray);
        }
        return list;
    }

    public static void refreshActionCache() {
        for (ShortcutsFinder shortcutsFinder : Lookup.getDefault().lookupAll(ShortcutsFinder.class)) {
            shortcutsFinder.refreshActions();
        }
    }

    static {
        if (Utilities.isMac()) {
            STRING_META = KeyEvent.getKeyText(157).concat("+");
            STRING_ALT = KeyEvent.getKeyText(18).concat("+");
        } else {
            STRING_META = EMACS_META;
            STRING_ALT = EMACS_ALT;
        }
    }
}

