;;; http-methods.el --- Look up the meaning of HTTP methods
;;
;; This file was automatically generated by
;; https://github.com/for-GET/know-your-http-well
;;
;;; Commentary:
;;; Code goes here:

(defconst http-methods
  '(("CONNECT" ("requests that the recipient establish a tunnel to the destination origin server identified by the request-target and, if successful, thereafter restrict its behavior to blind forwarding of packets, in both directions, until the connection is closed."))
("DELETE" ("requests that the origin server remove the association between the target resource and its current functionality."))
("GET" ("requests transfer of a current selected representation for the target resource."))
("HEAD" ("is identical to GET except that the server MUST NOT send a message body in the response (i.e., the response terminates at the end of the header block)."))
("OPTIONS" ("requests information about the communication options available on the request/response chain identified by the effective request URI."))
("POST" ("requests that the target resource process the representation enclosed in the request according to the resource's own specific semantics."))
("PUT" ("requests that the state of the target resource be created or replaced with the state defined by the representation enclosed in the request message payload."))
("TRACE" ("is used to invoke a remote, application-layer loopback of the request message."))
("PATCH" ("requests that a set of changes described in the request entity be applied to the resource identified by the Request-URI."))))

;;;###autoload
(defun http-method (method)
  "Display the meaning of an HTTP method"
  (interactive
   (list (completing-read "Enter HTTP method: " http-methods)))
  (let* ((uppercased-method (upcase method))
        (found (assoc uppercased-method http-methods)))
    (if found
        (let ((description (car (cdr found))))
          (message
           "%s - HTTP method\n%s"
           uppercased-method (car description) ))
      (message "%s - HTTP method\nUNKNOWN" uppercased-method))
    ))

(provide 'http-methods)

;;; http-methods.el ends here

