/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.List;
import org.testng.IClass;
import org.testng.ITest;
import org.testng.ITestClass;
import org.testng.ITestMethodFinder;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Objects;
import org.testng.internal.ConfigurationMethod;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.RunInfo;
import org.testng.internal.TestNGMethod;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.log4testng.Logger;
import org.testng.xml.XmlClass;
import org.testng.xml.XmlTest;

class TestClass
extends NoOpTestClass
implements ITestClass {
    private IAnnotationFinder annotationFinder = null;
    private ITestMethodFinder testMethodFinder = null;
    private IClass iClass = null;
    private String testName;
    private XmlTest xmlTest;
    private XmlClass xmlClass;
    private static final Logger LOG = Logger.getLogger(TestClass.class);

    protected TestClass(IClass iClass, ITestMethodFinder iTestMethodFinder, IAnnotationFinder iAnnotationFinder, RunInfo runInfo, XmlTest xmlTest, XmlClass xmlClass) {
        this.init(iClass, iTestMethodFinder, iAnnotationFinder, xmlTest, xmlClass);
    }

    @Override
    public String getTestName() {
        return this.testName;
    }

    @Override
    public XmlTest getXmlTest() {
        return this.xmlTest;
    }

    @Override
    public XmlClass getXmlClass() {
        return this.xmlClass;
    }

    public IAnnotationFinder getAnnotationFinder() {
        return this.annotationFinder;
    }

    private void init(IClass iClass, ITestMethodFinder iTestMethodFinder, IAnnotationFinder iAnnotationFinder, XmlTest xmlTest, XmlClass xmlClass) {
        this.log(3, "Creating TestClass for " + iClass);
        this.iClass = iClass;
        this.m_testClass = iClass.getRealClass();
        this.xmlTest = xmlTest;
        this.xmlClass = xmlClass;
        this.testMethodFinder = iTestMethodFinder;
        this.annotationFinder = iAnnotationFinder;
        this.initTestClassesAndInstances();
        this.initMethods();
    }

    private void initTestClassesAndInstances() {
        Object[] objectArray;
        for (Object object : objectArray = this.getInstances(false)) {
            if (!(object instanceof ITest)) continue;
            this.testName = ((ITest)object).getTestName();
            break;
        }
        if (this.testName == null) {
            this.testName = this.iClass.getTestName();
        }
    }

    @Override
    public Object[] getInstances(boolean bl) {
        return this.iClass.getInstances(bl);
    }

    @Override
    public long[] getInstanceHashCodes() {
        return this.iClass.getInstanceHashCodes();
    }

    @Override
    @Deprecated
    public int getInstanceCount() {
        return this.iClass.getInstanceCount();
    }

    @Override
    public void addInstance(Object object) {
        this.iClass.addInstance(object);
    }

    private void initMethods() {
        ITestNGMethod[] iTestNGMethodArray = this.testMethodFinder.getTestMethods(this.m_testClass, this.xmlTest);
        this.m_testMethods = this.createTestMethods(iTestNGMethodArray);
        for (Object object : this.iClass.getInstances(false)) {
            this.m_beforeSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.testMethodFinder.getBeforeSuiteMethods(this.m_testClass), this.annotationFinder, true, object);
            this.m_afterSuiteMethods = ConfigurationMethod.createSuiteConfigurationMethods(this.testMethodFinder.getAfterSuiteMethods(this.m_testClass), this.annotationFinder, false, object);
            this.m_beforeTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.testMethodFinder.getBeforeTestConfigurationMethods(this.m_testClass), this.annotationFinder, true, object);
            this.m_afterTestConfMethods = ConfigurationMethod.createTestConfigurationMethods(this.testMethodFinder.getAfterTestConfigurationMethods(this.m_testClass), this.annotationFinder, false, object);
            this.m_beforeClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.testMethodFinder.getBeforeClassMethods(this.m_testClass), this.annotationFinder, true, object);
            this.m_afterClassMethods = ConfigurationMethod.createClassConfigurationMethods(this.testMethodFinder.getAfterClassMethods(this.m_testClass), this.annotationFinder, false, object);
            this.m_beforeGroupsMethods = ConfigurationMethod.createBeforeConfigurationMethods(this.testMethodFinder.getBeforeGroupsConfigurationMethods(this.m_testClass), this.annotationFinder, true, object);
            this.m_afterGroupsMethods = ConfigurationMethod.createAfterConfigurationMethods(this.testMethodFinder.getAfterGroupsConfigurationMethods(this.m_testClass), this.annotationFinder, false, object);
            this.m_beforeTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.testMethodFinder.getBeforeTestMethods(this.m_testClass), this.annotationFinder, true, object);
            this.m_afterTestMethods = ConfigurationMethod.createTestMethodConfigurationMethods(this.testMethodFinder.getAfterTestMethods(this.m_testClass), this.annotationFinder, false, object);
        }
    }

    private ITestNGMethod[] createTestMethods(ITestNGMethod[] iTestNGMethodArray) {
        List list = Lists.newArrayList();
        for (ITestNGMethod iTestNGMethod : iTestNGMethodArray) {
            ConstructorOrMethod constructorOrMethod = iTestNGMethod.getConstructorOrMethod();
            if (constructorOrMethod.getDeclaringClass().isAssignableFrom(this.m_testClass)) {
                for (Object object : this.iClass.getInstances(false)) {
                    this.log(4, "Adding method " + iTestNGMethod + " on TestClass " + this.m_testClass);
                    list.add(new TestNGMethod(constructorOrMethod.getMethod(), this.annotationFinder, this.xmlTest, object));
                }
                continue;
            }
            this.log(4, "Rejecting method " + iTestNGMethod + " for TestClass " + this.m_testClass);
        }
        return list.toArray(new ITestNGMethod[list.size()]);
    }

    public ITestMethodFinder getTestMethodFinder() {
        return this.testMethodFinder;
    }

    private void log(int n, String string) {
        Utils.log("TestClass", n, string);
    }

    protected void dump() {
        LOG.info("===== Test class\n" + this.m_testClass.getName());
        for (ITestNGMethod iTestNGMethod : this.m_beforeClassMethods) {
            LOG.info("  @BeforeClass " + iTestNGMethod);
        }
        for (ITestNGMethod iTestNGMethod : this.m_beforeTestMethods) {
            LOG.info("  @BeforeMethod " + iTestNGMethod);
        }
        for (ITestNGMethod iTestNGMethod : this.m_testMethods) {
            LOG.info("    @Test " + iTestNGMethod);
        }
        for (ITestNGMethod iTestNGMethod : this.m_afterTestMethods) {
            LOG.info("  @AfterMethod " + iTestNGMethod);
        }
        for (ITestNGMethod iTestNGMethod : this.m_afterClassMethods) {
            LOG.info("  @AfterClass " + iTestNGMethod);
        }
        LOG.info("======");
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("name", this.m_testClass).toString();
    }

    public IClass getIClass() {
        return this.iClass;
    }
}

