"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const logging_1 = __importStar(require("../logging"));
const crypto_1 = __importDefault(require("crypto"));
const rootLogger = logging_1.default("ProvisionRequest");
class ProvisionRequest {
    constructor(req, fnName) {
        this.req = req;
        this.id = crypto_1.default.randomBytes(4).toString('hex');
        this.log = logging_1.newRequestLogger(rootLogger, `${this.id} ${fnName}`, false);
    }
    get body() {
        return this.req.body;
    }
    get params() {
        return this.req.params;
    }
    static createFake(fnName, log) {
        // This is a DANGEROUS operation, used to create a fake request object
        // to make internal requests to the provisioner.
        // eslint-disable-next-line @typescript-eslint/no-explicit-any
        const r = new ProvisionRequest(null, fnName);
        r.log = log;
        return r;
    }
}
exports.ProvisionRequest = ProvisionRequest;
//# sourceMappingURL=ProvisionRequest.js.map