/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.actions;

import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.osmand.PlatformUtil;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.data.persistence.ComponentLocationStorage;
import net.sourceforge.offroad.ui.StayOpenCheckBoxMenuItem;
import org.apache.commons.logging.Log;

public abstract class OffRoadAction
extends AbstractAction {
    protected static final Log log = PlatformUtil.getLog(OffRoadAction.class);
    protected OsmWindow mContext;
    protected JDialog mDialog;

    public OffRoadAction(OsmWindow pContext) {
        this(pContext, null, null);
    }

    public OffRoadAction(OsmWindow pContext, String name, Icon icon) {
        super(name, icon);
        this.mContext = pContext;
    }

    public static void addEscapeActionToDialog(JDialog dialog, Action action) {
        OffRoadAction.addKeyActionToDialog(dialog, action, "ESCAPE", "end_dialog");
    }

    public static void addKeyActionToDialog(JDialog dialog, Action action, String keyStroke, String actionId) {
        action.putValue("Name", actionId);
        dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(keyStroke), action.getValue("Name"));
        dialog.getRootPane().getActionMap().put(action.getValue("Name"), action);
    }

    protected void setWaitingCursor() {
        this.mDialog.setCursor(Cursor.getPredefinedCursor(3));
        this.mContext.setWaitingCursor(true);
    }

    protected void removeWaitingCursor() {
        this.mDialog.setCursor(Cursor.getDefaultCursor());
        this.mContext.setWaitingCursor(false);
    }

    protected void disposeDialog() {
        this.save();
        this.mDialog.setVisible(false);
        this.mDialog.dispose();
    }

    public void save() {
        if (this.mDialog != null) {
            ComponentLocationStorage.storeDialogPositions(this.mContext, this.mDialog, this.createComponentLocationStorage(), this.getComponentLocationStorageProperty());
        }
    }

    protected ComponentLocationStorage createComponentLocationStorage() {
        return new ComponentLocationStorage();
    }

    protected String getComponentLocationStorageProperty() {
        return this.getClass().getName();
    }

    protected String getResourceString(String pWindowTitle) {
        return this.mContext.getOffRoadString(pWindowTitle);
    }

    public void createDialog() {
        this.mDialog = new JDialog(this.mContext.getWindow(), true);
        this.mDialog.setDefaultCloseOperation(0);
        this.mDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent event) {
                OffRoadAction.this.disposeDialog();
            }
        });
        OffRoadAction.addEscapeActionToDialog(this.mDialog, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OffRoadAction.this.disposeDialog();
            }
        });
    }

    protected void decorateDialog() {
        ComponentLocationStorage.decorateDialog(this.mContext, this.mDialog, this.getComponentLocationStorageProperty());
    }

    public boolean isSelected() {
        return true;
    }

    protected File getSaveFile() {
        JFileChooser chooser = new JFileChooser();
        int showSaveDialog = chooser.showSaveDialog(this.mContext.getWindow());
        if (showSaveDialog == 0) {
            File selectedFile = chooser.getSelectedFile();
            if (selectedFile.exists()) {
                String overwriteText = this.mContext.getOffRoadString("file_already_exists", selectedFile.toString());
                int overwriteMap = JOptionPane.showConfirmDialog(this.mContext.getWindow(), overwriteText, overwriteText, 0);
                if (overwriteMap != 0) {
                    return null;
                }
            }
            return selectedFile;
        }
        return null;
    }

    public static class OffRoadMenuItem
    extends StayOpenCheckBoxMenuItem {
        private JMenu mMenu;

        public OffRoadMenuItem(OffRoadAction pPoiFilterAction, JMenu pMenu) {
            super(pPoiFilterAction);
            this.mMenu = pMenu;
            this.mMenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent pE) {
                    this.setSelected(this.isSelected());
                }

                @Override
                public void menuDeselected(MenuEvent pE) {
                }

                @Override
                public void menuCanceled(MenuEvent pE) {
                }
            });
        }

        @Override
        public boolean isSelected() {
            Action action = this.getAction();
            if (action instanceof SelectableAction && action instanceof OffRoadAction) {
                OffRoadAction ora = (OffRoadAction)action;
                return ora.isSelected();
            }
            return super.isSelected();
        }
    }

    public static interface SelectableAction {
    }
}

