/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.offroad.ui;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Timer;
import net.osmand.data.RotatedTileBox;
import net.osmand.plus.views.OsmandMapLayer;
import net.sourceforge.offroad.R;
import net.sourceforge.offroad.ui.DirectOffroadLayer;
import net.sourceforge.offroad.ui.DirectSearchLayer;
import net.sourceforge.offroad.ui.OsmBitmapPanel;

public class DirectSearchSelectionLayer
extends DirectSearchLayer
implements DirectOffroadLayer {
    private static final int INACTIVITY_TIME_IN_MILLISECONDS = 2000;
    private float mStrokeWidth;
    protected boolean mSelectedColor;

    public DirectSearchSelectionLayer() {
        AbstractAction updatePaintAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean bl = DirectSearchSelectionLayer.this.mSelectedColor = !DirectSearchSelectionLayer.this.mSelectedColor;
                if (DirectSearchSelectionLayer.this.mSelectedColor) {
                    DirectSearchSelectionLayer.this.highlightYellow.setColor(R.color.region_selected);
                } else {
                    DirectSearchSelectionLayer.this.highlightYellow.setColor(R.color.poi_background);
                }
                DirectSearchSelectionLayer.this.mView.repaint();
            }
        };
        new Timer(2000, updatePaintAction).start();
    }

    @Override
    public void initLayer(OsmBitmapPanel pView) {
        super.initLayer(pView);
        this.highlightYellow.setColor(R.color.region_selected);
        this.mStrokeWidth = this.highlightYellow.getStrokeWidth();
    }

    @Override
    public void onDraw(Graphics2D pCanvas, RotatedTileBox pTileBox, OsmandMapLayer.DrawSettings pSettings) {
        this.highlightYellow.setStrokeWidth(this.mStrokeWidth * 2.0f);
        super.onDraw(pCanvas, pTileBox, pSettings);
    }
}

