/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.color.ColorParser;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class CommandRepeat3
extends SingleLineCommand2<ActivityDiagram3> {
    public CommandRepeat3() {
        super(CommandRepeat3.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandRepeat3.class.getName(), RegexLeaf.start(), new RegexLeaf("STEREO", "(\\<{2}.*\\>{2})?"), ColorParser.exp4(), new RegexLeaf("repeat"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("LABEL", ":(.*?)")), new RegexOptional((IRegex)new RegexLeaf("STYLE", "(;|\\\\\\\\|(?<![/|<>}\\]])(?:[/<}\\]])|(?<!\\</?\\w{1,5})(?<!\\<img[^>]{1,999})(?<!\\<[&$]\\w{1,999})(?<!\\>)(?:\\>)|(?<!\\|.{1,999})(?:\\|))")), RegexLeaf.end());
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    protected CommandExecutionResult executeArg(ActivityDiagram3 diagram, LineLocation location, RegexResult arg) {
        HColor color = diagram.getSkinParam().getIHtmlColorSet().getColorIfValid(arg.get("COLOR", 0));
        Display label = Display.getWithNewlines(arg.get("LABEL", 0));
        String styleString = arg.get("STYLE", 0);
        BoxStyle boxStyle = styleString == null ? BoxStyle.PLAIN : BoxStyle.fromChar(styleString.charAt(0));
        Colors colors = CommandRepeat3.color().getColor(arg, diagram.getSkinParam().getIHtmlColorSet());
        String stereo = arg.get("STEREO", 0);
        if (stereo != null) {
            Stereotype stereotype = new Stereotype(stereo);
            colors = colors.applyStereotype(stereotype, diagram.getSkinParam(), ColorParam.activityBackground);
        }
        diagram.startRepeat(color, label, boxStyle, colors);
        return CommandExecutionResult.ok();
    }
}

