/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UBackground;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorUtils;

public class CollisionDetector
implements UGraphic {
    private final StringBounder stringBounder;
    private final UTranslate translate;
    private final Context context;

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new CollisionDetector(this.stringBounder, this.translate.compose((UTranslate)change), this.context);
        }
        if (change instanceof UStroke) {
            return new CollisionDetector(this);
        }
        if (change instanceof UBackground) {
            return new CollisionDetector(this);
        }
        if (change instanceof HColor) {
            return new CollisionDetector(this);
        }
        throw new UnsupportedOperationException();
    }

    private static boolean collisionCheck(MinMax rect, Line2D hline) {
        if (hline.getY1() != hline.getY2()) {
            throw new IllegalArgumentException();
        }
        if (hline.getY1() < rect.getMinY()) {
            return false;
        }
        if (hline.getY1() > rect.getMaxY()) {
            return false;
        }
        double x1 = Math.min(hline.getX1(), hline.getX2());
        double x2 = Math.max(hline.getX1(), hline.getX2());
        if (x2 < rect.getMinX()) {
            return false;
        }
        return !(x1 > rect.getMaxX());
    }

    public CollisionDetector(StringBounder stringBounder) {
        this(stringBounder, new UTranslate(), new Context());
    }

    private CollisionDetector(StringBounder stringBounder, UTranslate translate, Context context) {
        this.stringBounder = stringBounder;
        this.translate = translate;
        this.context = context;
    }

    private CollisionDetector(CollisionDetector other) {
        this(other.stringBounder, other.translate, other.context);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public UParam getParam() {
        return new UParamNull();
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof UPolygon) {
            this.drawPolygone((UPolygon)shape);
        } else if (shape instanceof URectangle) {
            this.drawRectangle((URectangle)shape);
        } else if (shape instanceof Snake) {
            this.drawSnake((Snake)shape);
        }
    }

    private void drawSnake(Snake shape) {
        if (this.context.manageSnakes) {
            this.context.snakes.add(shape.translate(this.translate));
        }
    }

    private void drawRectangle(URectangle shape) {
        this.context.rectangles.add(shape.getMinMax().translate(this.translate));
    }

    private void drawPolygone(UPolygon shape) {
        this.context.rectangles.add(shape.getMinMax().translate(this.translate));
    }

    @Override
    public ColorMapper getColorMapper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startUrl(Url url) {
    }

    @Override
    public void closeAction() {
    }

    @Override
    public void flushUg() {
    }

    public void drawDebug(UGraphic ug) {
        this.context.drawDebug(ug);
    }

    public final void setManageSnakes(boolean manageSnakes) {
        this.context.manageSnakes = manageSnakes;
    }

    @Override
    public boolean matchesProperty(String propertyName) {
        return false;
    }

    public double dpiFactor() {
        return 1.0;
    }

    static class Context {
        private final List<MinMax> rectangles = new ArrayList<MinMax>();
        private final List<Snake> snakes = new ArrayList<Snake>();
        private boolean manageSnakes;

        Context() {
        }

        public void drawDebug(UGraphic ug) {
            for (MinMax minmax : this.rectangles) {
                if (!this.collision(minmax)) continue;
                minmax.drawGrey(ug);
            }
            HColor color = HColorUtils.BLACK;
            ug = ug.apply(color).apply(new UStroke(5.0));
            for (Snake snake : this.snakes) {
                for (Line2D line : snake.getHorizontalLines()) {
                    if (!this.collision(line)) continue;
                    this.drawLine(ug, line);
                }
            }
        }

        private void drawLine(UGraphic ug, Line2D line) {
            ug = ug.apply(new UTranslate(line.getX1(), line.getY1()));
            ug.draw(new ULine(line.getX2() - line.getX1(), line.getY2() - line.getY1()));
        }

        private boolean collision(Line2D hline) {
            for (MinMax r : this.rectangles) {
                if (!CollisionDetector.collisionCheck(r, hline)) continue;
                return true;
            }
            return false;
        }

        private boolean collision(MinMax r) {
            for (Snake snake : this.snakes) {
                for (Line2D hline : snake.getHorizontalLines()) {
                    if (!CollisionDetector.collisionCheck(r, hline)) continue;
                    return true;
                }
            }
            return false;
        }
    }
}

