/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vcompact;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactoryDelegator;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileHeightFixed;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.AbstractParallelFtilesBuilder;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileForkInnerOverlapped;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.ParallelBuilderFork;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.ParallelBuilderMerge;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.ParallelBuilderSplit;

public class FtileFactoryDelegatorCreateParallel
extends FtileFactoryDelegator {
    private final double spaceArroundBlackBar = 20.0;
    private final double xMargin = 14.0;

    public FtileFactoryDelegatorCreateParallel(FtileFactory factory) {
        super(factory);
    }

    private Ftile allOverlapped(Swimlane swimlane, List<Ftile> all, ForkStyle style, String label) {
        return new FtileForkInnerOverlapped(all);
    }

    @Override
    public Ftile createParallel(List<Ftile> all, ForkStyle style, String label, Swimlane in, Swimlane out) {
        AbstractParallelFtilesBuilder builder;
        FtileGeometry dimSuper = super.createParallel(all, style, label, in, out).calculateDimension(this.getStringBounder());
        double height1 = ((Dimension2D)dimSuper).getHeight() + 40.0;
        ArrayList<Ftile> list = new ArrayList<Ftile>();
        for (Ftile tmp : all) {
            list.add(new FtileHeightFixed(FtileUtils.addHorizontalMargin(tmp, 14.0), height1));
        }
        Ftile inner = super.createParallel(list, style, label, in, out);
        if (style == ForkStyle.SPLIT) {
            builder = new ParallelBuilderSplit(this.skinParam(), this.getStringBounder(), list, inner);
        } else if (style == ForkStyle.MERGE) {
            builder = new ParallelBuilderMerge(this.skinParam(), this.getStringBounder(), list, inner);
        } else if (style == ForkStyle.FORK) {
            builder = new ParallelBuilderFork(this.skinParam(), this.getStringBounder(), list, inner, label, in, out);
        } else {
            throw new IllegalStateException();
        }
        return builder.build();
    }
}

