/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.creole.command.CommandCreoleImg;

public class CommandCreoleQrcode
implements Command {
    private final Pattern2 pattern;

    private CommandCreoleQrcode(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    public static Command create() {
        return new CommandCreoleQrcode("^(?i)(\\<qrcode[\\s:]+([^>{}]+)(\\{scale=(?:[0-9.]+)\\})?\\>)");
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        String src = m.group(2);
        double scale = CommandCreoleImg.getScale(m.group(3), 3.0);
        stripe.addQrcode(src, scale);
        return line.substring(m.group(1).length());
    }
}

