/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.math;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.math.ScientificEquationSafe;
import net.sourceforge.plantuml.ugraphic.color.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class PSystemMath
extends AbstractPSystem {
    private String math = "";
    private float scale = 1.0f;
    private Color color = Color.BLACK;
    private Color backColor = Color.WHITE;

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescription("(Math)");
    }

    @Override
    protected final ImageData exportDiagramNow(OutputStream os, int num, FileFormatOption fileFormat, long seed) throws IOException {
        ScientificEquationSafe asciiMath = ScientificEquationSafe.fromAsciiMath(this.math);
        return asciiMath.export(os, fileFormat, this.scale, this.color, this.backColor);
    }

    public void doCommandLine(String line) {
        String lineLower = StringUtils.trin(StringUtils.goLowerCase(line));
        String colorParam = "color ";
        String backParam = "backgroundcolor ";
        if (lineLower.startsWith("color ")) {
            Color col3 = this.getColor(line.substring("color ".length()));
            if (col3 != null) {
                this.color = col3;
            }
        } else if (lineLower.startsWith("backgroundcolor ")) {
            Color col3 = this.getColor(line.substring("backgroundcolor ".length()));
            if (col3 != null) {
                this.backColor = col3;
            }
        } else if (lineLower.startsWith("scale ")) {
            String value = line.substring("scale ".length());
            try {
                float scale1 = Float.parseFloat(value);
                if (scale1 > 0.0f) {
                    this.scale = scale1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (lineLower.startsWith("dpi ")) {
            String value = line.substring("dpi ".length());
            try {
                float dpi1 = Float.parseFloat(value);
                if (dpi1 > 0.0f) {
                    this.scale = dpi1 / 96.0f;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.math = line;
        }
    }

    private Color getColor(String col) {
        HColor col2 = HColorSet.instance().getColorIfValid(col);
        Color col3 = new ColorMapperIdentity().getMappedColor(col2);
        return col3;
    }
}

