/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.nwdiag;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sourceforge.plantuml.nwdiag.DiagElement;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class Network {
    private final String name;
    private final Map<DiagElement, String> localElements = new LinkedHashMap<DiagElement, String>();
    private HColor color;
    private String ownAdress;

    public String toString() {
        return this.name;
    }

    public Network(String name) {
        this.name = name;
    }

    public String getAdress(DiagElement element) {
        return this.localElements.get(element);
    }

    public void addElement(DiagElement element, Map<String, String> props) {
        String address = props.get("address");
        if (address == null) {
            address = "";
        }
        if (address.length() == 0 && this.localElements.containsKey(element)) {
            return;
        }
        this.localElements.put(element, address);
    }

    public boolean constainsLocally(String name) {
        for (DiagElement element : this.localElements.keySet()) {
            if (!element.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public final String getOwnAdress() {
        return this.ownAdress;
    }

    public final void setOwnAdress(String ownAdress) {
        this.ownAdress = ownAdress;
    }

    public final String getName() {
        return this.name;
    }

    public final HColor getColor() {
        return this.color;
    }

    public final void setColor(HColor color) {
        this.color = color;
    }
}

