/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.style;

import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.style.AutomaticCounter;
import net.sourceforge.plantuml.style.Value;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class ValueImpl
implements Value {
    private final String value;
    private final int priority;

    public ValueImpl(String value, AutomaticCounter counter) {
        this.value = value;
        this.priority = counter.getNextInt();
    }

    public String toString() {
        return this.value + " (" + this.priority + ")";
    }

    @Override
    public String asString() {
        return this.value;
    }

    @Override
    public HColor asColor(HColorSet set) {
        if ("none".equalsIgnoreCase(this.value) || "transparent".equalsIgnoreCase(this.value)) {
            return null;
        }
        return set.getColorIfValid(this.value);
    }

    @Override
    public boolean asBoolean() {
        return "true".equalsIgnoreCase(this.value);
    }

    @Override
    public int asInt() {
        return Integer.parseInt(this.value);
    }

    @Override
    public double asDouble() {
        return Double.parseDouble(this.value);
    }

    @Override
    public int asFontStyle() {
        if (this.value.equalsIgnoreCase("bold")) {
            return 1;
        }
        if (this.value.equalsIgnoreCase("italic")) {
            return 2;
        }
        return 0;
    }

    @Override
    public HorizontalAlignment asHorizontalAlignment() {
        return HorizontalAlignment.fromString(this.asString());
    }

    @Override
    public int getPriority() {
        return this.priority;
    }
}

