/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.ugraphic.MinMaxMutable;
import net.sourceforge.plantuml.ugraphic.UBackground;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UParamNull;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class TextLimitFinder
implements UGraphic {
    private final StringBounder stringBounder;
    private final UTranslate translate;
    private final MinMaxMutable minmax;

    @Override
    public boolean matchesProperty(String propertyName) {
        return false;
    }

    public double dpiFactor() {
        return 1.0;
    }

    @Override
    public UGraphic apply(UChange change) {
        if (change instanceof UTranslate) {
            return new TextLimitFinder(this.stringBounder, this.minmax, this.translate.compose((UTranslate)change));
        }
        if (change instanceof UStroke) {
            return new TextLimitFinder(this);
        }
        if (change instanceof UBackground) {
            return new TextLimitFinder(this);
        }
        if (change instanceof HColor) {
            return new TextLimitFinder(this);
        }
        throw new UnsupportedOperationException();
    }

    public TextLimitFinder(StringBounder stringBounder, boolean initToZero) {
        this(stringBounder, MinMaxMutable.getEmpty(initToZero), new UTranslate());
    }

    private TextLimitFinder(StringBounder stringBounder, MinMaxMutable minmax, UTranslate translate) {
        this.stringBounder = stringBounder;
        this.minmax = minmax;
        this.translate = translate;
    }

    private TextLimitFinder(TextLimitFinder other) {
        this(other.stringBounder, other.minmax, other.translate);
    }

    @Override
    public StringBounder getStringBounder() {
        return this.stringBounder;
    }

    @Override
    public UParam getParam() {
        return new UParamNull();
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof UText) {
            double x = this.translate.getDx();
            double y = this.translate.getDy();
            this.drawText(x, y, (UText)shape);
        }
    }

    @Override
    public ColorMapper getColorMapper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void startUrl(Url url) {
    }

    @Override
    public void closeAction() {
    }

    private void drawText(double x, double y, UText text) {
        Dimension2D dim = this.stringBounder.calculateDimension(text.getFontConfiguration().getFont(), text.getText());
        this.minmax.addPoint(x, y -= dim.getHeight() - 1.5);
        this.minmax.addPoint(x, y + dim.getHeight());
        this.minmax.addPoint(x + dim.getWidth(), y);
        this.minmax.addPoint(x + dim.getWidth(), y + dim.getHeight());
    }

    public double getMaxX() {
        return this.minmax.getMaxX();
    }

    public double getMaxY() {
        return this.minmax.getMaxY();
    }

    public double getMinX() {
        return this.minmax.getMinX();
    }

    public double getMinY() {
        return this.minmax.getMinY();
    }

    @Override
    public void flushUg() {
    }
}

