/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.api;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.MergeCommand;
import org.eclipse.jgit.api.RebaseCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.CheckoutConflictException;
import org.eclipse.jgit.api.errors.ConcurrentRefUpdateException;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidConfigurationException;
import org.eclipse.jgit.api.errors.InvalidMergeHeadsException;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.api.errors.NoHeadException;
import org.eclipse.jgit.api.errors.NoMessageException;
import org.eclipse.jgit.api.errors.RefNotFoundException;
import org.eclipse.jgit.api.errors.WrongRepositoryStateException;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.merge.MergeStrategy;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;

public class SubmoduleUpdateCommand
extends TransportCommand<SubmoduleUpdateCommand, Collection<String>> {
    private ProgressMonitor monitor;
    private final Collection<String> paths;
    private MergeStrategy strategy = MergeStrategy.RECURSIVE;
    private CloneCommand.Callback callback;
    private FetchCommand.Callback fetchCallback;
    private boolean fetch = false;

    public SubmoduleUpdateCommand(Repository repo) {
        super(repo);
        this.paths = new ArrayList<String>();
    }

    public SubmoduleUpdateCommand setProgressMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
        return this;
    }

    public SubmoduleUpdateCommand setFetch(boolean fetch) {
        this.fetch = fetch;
        return this;
    }

    public SubmoduleUpdateCommand addPath(String path2) {
        this.paths.add(path2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> call() throws InvalidConfigurationException, NoHeadException, ConcurrentRefUpdateException, CheckoutConflictException, InvalidMergeHeadsException, WrongRepositoryStateException, NoMessageException, NoHeadException, RefNotFoundException, GitAPIException {
        this.checkCallable();
        try (SubmoduleWalk generator = SubmoduleWalk.forIndex(this.repo);){
            if (!this.paths.isEmpty()) {
                generator.setFilter(PathFilterGroup.createFromStrings(this.paths));
            }
            ArrayList<String> updated = new ArrayList<String>();
            while (generator.next()) {
                block29: {
                    String url;
                    if (generator.getModulesPath() == null || (url = generator.getConfigUrl()) == null) continue;
                    Repository submoduleRepo = generator.getRepository();
                    if (submoduleRepo == null) {
                        if (this.callback != null) {
                            this.callback.cloningSubmodule(generator.getPath());
                        }
                        CloneCommand clone = Git.cloneRepository();
                        this.configure(clone);
                        clone.setURI(url);
                        clone.setDirectory(generator.getDirectory());
                        clone.setGitDir(new File(new File(this.repo.getDirectory(), "modules"), generator.getPath()));
                        if (this.monitor != null) {
                            clone.setProgressMonitor(this.monitor);
                        }
                        submoduleRepo = clone.call().getRepository();
                    } else if (this.fetch) {
                        if (this.fetchCallback != null) {
                            this.fetchCallback.fetchingSubmodule(generator.getPath());
                        }
                        FetchCommand fetchCommand = Git.wrap(submoduleRepo).fetch();
                        if (this.monitor != null) {
                            fetchCommand.setProgressMonitor(this.monitor);
                        }
                        this.configure(fetchCommand);
                        fetchCommand.call();
                    }
                    try (RevWalk walk2 = new RevWalk(submoduleRepo);){
                        RevCommit commit = walk2.parseCommit(generator.getObjectId());
                        String update2 = generator.getConfigUpdate();
                        if ("merge".equals(update2)) {
                            MergeCommand merge2 = new MergeCommand(submoduleRepo);
                            merge2.include(commit);
                            merge2.setProgressMonitor(this.monitor);
                            merge2.setStrategy(this.strategy);
                            merge2.call();
                            break block29;
                        }
                        if ("rebase".equals(update2)) {
                            RebaseCommand rebase = new RebaseCommand(submoduleRepo);
                            rebase.setUpstream(commit);
                            rebase.setProgressMonitor(this.monitor);
                            rebase.setStrategy(this.strategy);
                            rebase.call();
                            break block29;
                        }
                        DirCacheCheckout co = new DirCacheCheckout(submoduleRepo, submoduleRepo.lockDirCache(), commit.getTree());
                        co.setFailOnConflict(true);
                        co.checkout();
                        RefUpdate refUpdate = submoduleRepo.updateRef("HEAD", true);
                        refUpdate.setNewObjectId(commit);
                        refUpdate.forceUpdate();
                        if (this.callback != null) {
                            this.callback.checkingOut(commit, generator.getPath());
                        }
                    }
                    finally {
                        submoduleRepo.close();
                    }
                }
                updated.add(generator.getPath());
            }
            ArrayList<String> arrayList = updated;
            return arrayList;
        }
        catch (IOException e2) {
            throw new JGitInternalException(e2.getMessage(), e2);
        }
        catch (ConfigInvalidException e3) {
            throw new InvalidConfigurationException(e3.getMessage(), e3);
        }
    }

    public SubmoduleUpdateCommand setStrategy(MergeStrategy strategy) {
        this.strategy = strategy;
        return this;
    }

    public SubmoduleUpdateCommand setCallback(CloneCommand.Callback callback) {
        this.callback = callback;
        return this;
    }

    public SubmoduleUpdateCommand setFetchCallback(FetchCommand.Callback callback) {
        this.fetchCallback = callback;
        return this;
    }
}

