class Clojure < Formula
  desc "The Clojure Programming Language"
  homepage "https://clojure.org"
  url "https://download.clojure.org/install/clojure-tools-1.10.1.530.tar.gz"
  sha256 "9fdd7c2e1832cda660bd6ca65eee44fc71dc35fcaf74fd5145be56eb5d4525ad"

  devel do
    url "https://download.clojure.org/install/clojure-tools-1.10.1.536.tar.gz"
    sha256 "SHA"
    version "1.10.1.536"
  end

  bottle :unneeded

  depends_on "rlwrap"

  uses_from_macos "ruby" => :build

  def install
    system "./install.sh", prefix
  end

  test do
    ENV["TERM"] = "xterm"
    system("#{bin}/clj -e nil")
    %w[clojure clj].each do |clj|
      assert_equal "2", shell_output("#{bin}/#{clj} -e \"(+ 1 1)\"").strip
    end
  end
end
