/*
 * Decompiled with CFR 0.152.
 */
package com.tigervnc.network;

import com.tigervnc.network.FileDescriptor;
import com.tigervnc.rdr.Exception;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;

public class SocketDescriptor
implements FileDescriptor {
    protected SocketChannel channel;
    protected Selector writeSelector;
    protected Selector readSelector;

    public SocketDescriptor() throws Exception {
        SocketDescriptor.DefaultSelectorProvider();
        try {
            this.channel = SocketChannel.open();
            this.channel.configureBlocking(false);
            this.writeSelector = Selector.open();
            this.readSelector = Selector.open();
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        try {
            this.channel.register(this.writeSelector, 4);
            this.channel.register(this.readSelector, 1);
        }
        catch (ClosedChannelException closedChannelException) {
            throw new Exception(closedChannelException.getMessage());
        }
    }

    public void shutdown() throws IOException {
        try {
            this.channel.socket().shutdownInput();
            this.channel.socket().shutdownOutput();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.channel.close();
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
    }

    private static SelectorProvider DefaultSelectorProvider() {
        String string = System.getProperty("os.name");
        if (string.startsWith("Mac OS X")) {
            System.setProperty("java.nio.channels.spi.SelectorProvider", "sun.nio.ch.PollSelectorProvider");
        }
        return SelectorProvider.provider();
    }

    @Override
    public synchronized int select(int n, Integer n2) throws Exception {
        int n3;
        Selector selector = (n & 1) != 0 ? this.readSelector : this.writeSelector;
        selector.selectedKeys().clear();
        try {
            if (n2 == null) {
                n3 = selector.select();
            } else {
                int n4 = n2;
                switch (n4) {
                    case 0: {
                        n3 = selector.selectNow();
                        break;
                    }
                    default: {
                        n3 = selector.select(n4);
                    }
                }
            }
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        return n3;
    }

    @Override
    public int write(ByteBuffer byteBuffer, int n) throws Exception {
        try {
            int n2 = this.channel.write((ByteBuffer)byteBuffer.slice().limit(n));
            byteBuffer.position(byteBuffer.position() + n2);
            return n2;
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer, int n) throws Exception {
        try {
            int n2 = this.channel.read((ByteBuffer)byteBuffer.slice().limit(n));
            byteBuffer.position(byteBuffer.position() + n2);
            return n2 < 0 ? 0 : n2;
        }
        catch (java.lang.Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    public Socket socket() {
        return this.channel.socket();
    }

    public SocketAddress getRemoteAddress() throws IOException {
        if (this.isConnected()) {
            return this.channel.socket().getRemoteSocketAddress();
        }
        return null;
    }

    public SocketAddress getLocalAddress() throws IOException {
        if (this.isConnected()) {
            return this.channel.socket().getLocalSocketAddress();
        }
        return null;
    }

    public boolean isConnectionPending() {
        return this.channel.isConnectionPending();
    }

    public boolean connect(SocketAddress socketAddress) throws IOException {
        return this.channel.connect(socketAddress);
    }

    public boolean finishConnect() throws IOException {
        return this.channel.finishConnect();
    }

    public boolean isConnected() {
        return this.channel.isConnected();
    }

    protected void setChannel(SocketChannel socketChannel) {
        try {
            if (this.channel != null) {
                this.channel.close();
            }
            if (this.readSelector != null) {
                this.readSelector.close();
            }
            if (this.writeSelector != null) {
                this.writeSelector.close();
            }
            this.channel = socketChannel;
            this.channel.configureBlocking(false);
            this.writeSelector = Selector.open();
            this.readSelector = Selector.open();
        }
        catch (IOException iOException) {
            throw new Exception(iOException.getMessage());
        }
        try {
            this.channel.register(this.writeSelector, 4);
            this.channel.register(this.readSelector, 1);
        }
        catch (ClosedChannelException closedChannelException) {
            System.out.println(closedChannelException.toString());
        }
    }
}

