/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.Utils;

public class ConfigurationGroupMethods {
    private final Map<String, List<ITestNGMethod>> m_beforeGroupsMethods;
    private final Map<String, List<ITestNGMethod>> m_afterGroupsMethods;
    private final ITestNGMethod[] m_allMethods;
    private volatile Map<String, List<ITestNGMethod>> m_afterGroupsMap = null;

    public ConfigurationGroupMethods(ITestNGMethod[] iTestNGMethodArray, Map<String, List<ITestNGMethod>> map, Map<String, List<ITestNGMethod>> map2) {
        this.m_allMethods = iTestNGMethodArray;
        this.m_beforeGroupsMethods = new ConcurrentHashMap<String, List<ITestNGMethod>>(map);
        this.m_afterGroupsMethods = new ConcurrentHashMap<String, List<ITestNGMethod>>(map2);
    }

    public ITestNGMethod[] getAllTestMethods() {
        return this.m_allMethods;
    }

    public Map<String, List<ITestNGMethod>> getBeforeGroupsMethods() {
        return this.m_beforeGroupsMethods;
    }

    public Map<String, List<ITestNGMethod>> getAfterGroupsMethods() {
        return this.m_afterGroupsMethods;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLastMethodForGroup(String string, ITestNGMethod iTestNGMethod) {
        Object object;
        if (iTestNGMethod.hasMoreInvocation()) {
            return false;
        }
        if (this.m_afterGroupsMap == null) {
            object = this;
            synchronized (object) {
                if (this.m_afterGroupsMap == null) {
                    this.m_afterGroupsMap = this.initializeAfterGroupsMap();
                }
            }
        }
        if (null == (object = this.m_afterGroupsMap.get(string)) || object.isEmpty()) {
            return false;
        }
        object.remove(iTestNGMethod);
        return object.isEmpty();
    }

    private Map<String, List<ITestNGMethod>> initializeAfterGroupsMap() {
        Map<String, List<ITestNGMethod>> map = Maps.newConcurrentMap();
        for (ITestNGMethod iTestNGMethod : this.m_allMethods) {
            String[] stringArray;
            for (String string : stringArray = iTestNGMethod.getGroups()) {
                List<ITestNGMethod> list = map.get(string);
                if (null == list) {
                    list = Lists.newArrayList();
                    map.put(string, list);
                }
                list.add(iTestNGMethod);
            }
        }
        return map;
    }

    public void removeBeforeMethod(String string, ITestNGMethod iTestNGMethod) {
        List<ITestNGMethod> list = this.m_beforeGroupsMethods.get(string);
        if (list != null) {
            Boolean bl = list.remove(iTestNGMethod);
            if (bl == null) {
                this.log("Couldn't remove beforeGroups method " + iTestNGMethod + " for group " + string);
            }
        } else {
            this.log("Couldn't find any beforeGroups method for group " + string);
        }
    }

    private void log(String string) {
        Utils.log("ConfigurationGroupMethods", 2, string);
    }

    public Map<String, List<ITestNGMethod>> getBeforeGroupsMap() {
        return this.m_beforeGroupsMethods;
    }

    public Map<String, List<ITestNGMethod>> getAfterGroupsMap() {
        return this.m_afterGroupsMethods;
    }

    public void removeBeforeGroups(String[] stringArray) {
        for (String string : stringArray) {
            this.m_beforeGroupsMethods.remove(string);
        }
    }

    public void removeAfterGroups(Collection<String> collection) {
        for (String string : collection) {
            this.m_afterGroupsMethods.remove(string);
        }
    }
}

