/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries.ui;

import cc.arduino.contributions.DownloadableContribution;
import cc.arduino.contributions.DownloadableContributionVersionComparator;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.ContributedLibraryReleases;
import cc.arduino.contributions.ui.InstallerTableCell;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Optional;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import processing.app.Base;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Theme;

public class ContributedLibraryTableCellJPanel
extends JPanel {
    final JButton moreInfoButton;
    final JButton installButton;
    final Component installButtonPlaceholder;
    final JComboBox downgradeChooser;
    final JComboBox versionToInstallChooser;
    final JButton downgradeButton;
    final JPanel buttonsPanel;
    final JPanel inactiveButtonsPanel;
    final JLabel statusLabel;
    final JTextPane description;
    private final String moreInfoLbl = I18n.tr((String)"More info");

    public ContributedLibraryTableCellJPanel(JTable parentTable, Object value, boolean isSelected) {
        boolean upgradable;
        boolean installable;
        this.setLayout(new BoxLayout(this, 1));
        this.moreInfoButton = new JButton(this.moreInfoLbl);
        this.moreInfoButton.setVisible(false);
        this.installButton = new JButton(I18n.tr((String)"Install"));
        int width = this.installButton.getPreferredSize().width;
        this.installButtonPlaceholder = Box.createRigidArea(new Dimension(width, 1));
        this.downgradeButton = new JButton(I18n.tr((String)"Install"));
        this.downgradeChooser = new JComboBox();
        this.downgradeChooser.addItem("-");
        this.downgradeChooser.setMaximumSize(new Dimension((int)this.downgradeChooser.getPreferredSize().getWidth() + 50, (int)this.downgradeChooser.getPreferredSize().getHeight()));
        this.downgradeChooser.setMinimumSize(new Dimension((int)this.downgradeChooser.getPreferredSize().getWidth() + 50, (int)this.downgradeChooser.getPreferredSize().getHeight()));
        this.downgradeChooser.addActionListener(e -> {
            Object selectVersionItem = this.downgradeChooser.getItemAt(0);
            boolean disableDowngrade = this.downgradeChooser.getSelectedItem() == selectVersionItem;
            this.downgradeButton.setEnabled(!disableDowngrade);
            if (!disableDowngrade) {
                InstallerTableCell.dropdownSelected(true);
            }
        });
        this.versionToInstallChooser = new JComboBox();
        this.versionToInstallChooser.addItem("-");
        this.versionToInstallChooser.setMaximumSize(new Dimension((int)this.versionToInstallChooser.getPreferredSize().getWidth() + 50, (int)this.versionToInstallChooser.getPreferredSize().getHeight()));
        this.versionToInstallChooser.setMinimumSize(new Dimension((int)this.versionToInstallChooser.getPreferredSize().getWidth() + 50, (int)this.versionToInstallChooser.getPreferredSize().getHeight()));
        this.description = this.makeNewDescription();
        this.add(this.description);
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setLayout(new BoxLayout(this.buttonsPanel, 0));
        this.buttonsPanel.setOpaque(false);
        this.buttonsPanel.add(Box.createHorizontalStrut(7));
        if (PreferencesData.getBoolean((String)"ide.accessible")) {
            this.buttonsPanel.add(this.moreInfoButton);
            this.buttonsPanel.add(Box.createHorizontalStrut(5));
            this.buttonsPanel.add(Box.createHorizontalStrut(15));
        }
        this.buttonsPanel.add(this.downgradeChooser);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.downgradeButton);
        this.buttonsPanel.add(Box.createHorizontalGlue());
        this.buttonsPanel.add(this.versionToInstallChooser);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(this.installButton);
        this.buttonsPanel.add(Box.createHorizontalStrut(5));
        this.buttonsPanel.add(Box.createHorizontalStrut(15));
        this.add(this.buttonsPanel);
        this.inactiveButtonsPanel = new JPanel();
        this.inactiveButtonsPanel.setLayout(new BoxLayout(this.inactiveButtonsPanel, 0));
        this.inactiveButtonsPanel.setOpaque(false);
        int height = this.installButton.getMinimumSize().height;
        this.inactiveButtonsPanel.add(Box.createVerticalStrut(height));
        this.inactiveButtonsPanel.add(Box.createGlue());
        this.statusLabel = new JLabel(" ");
        this.inactiveButtonsPanel.add(this.statusLabel);
        this.inactiveButtonsPanel.add(Box.createHorizontalStrut(15));
        this.add(this.inactiveButtonsPanel);
        this.add(Box.createVerticalStrut(15));
        ContributedLibraryReleases releases = (ContributedLibraryReleases)value;
        if (releases == null) {
            return;
        }
        ContributedLibrary selected = releases.getSelected();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(selected.getName());
        titledBorder.setTitleFont(this.getFont().deriveFont(1));
        this.setBorder(titledBorder);
        Optional mayInstalled = releases.getInstalled();
        if (!mayInstalled.isPresent()) {
            installable = true;
            upgradable = false;
        } else {
            installable = false;
            boolean bl = upgradable = new DownloadableContributionVersionComparator().compare((DownloadableContribution)selected, (DownloadableContribution)mayInstalled.get()) > 0;
        }
        if (installable) {
            this.installButton.setText(I18n.tr((String)"Install"));
        }
        if (upgradable) {
            this.installButton.setText(I18n.tr((String)"Update"));
        }
        this.installButton.setVisible(installable || upgradable);
        this.installButtonPlaceholder.setVisible(!installable && !upgradable);
        String name = selected.getName();
        String author = selected.getAuthor();
        String website = selected.getWebsite();
        String sentence = selected.getSentence();
        String paragraph = selected.getParagraph();
        String midcolor = isSelected ? "#000000" : "#888888";
        String desc = "<html><body>";
        if (mayInstalled.isPresent() && ((ContributedLibrary)mayInstalled.get()).isIDEBuiltIn()) {
            desc = desc + " Built-In ";
        }
        desc = desc + I18n.format((String)"<font color=\"{0}\">", (Object[])new Object[]{midcolor});
        if (author != null && !author.isEmpty()) {
            desc = desc + I18n.format((String)" by <b>{0}</b>", (Object[])new Object[]{author});
        }
        if (mayInstalled.isPresent()) {
            String installedVer = ((ContributedLibrary)mayInstalled.get()).getParsedVersion();
            desc = installedVer == null ? desc + " " + I18n.tr((String)"Version unknown") : desc + " " + I18n.format((String)I18n.tr((String)"Version <b>{0}</b>"), (Object[])new Object[]{installedVer});
        }
        desc = desc + "</font>";
        if (mayInstalled.isPresent()) {
            desc = desc + " <strong><font color=\"#00979D\">INSTALLED</font></strong>";
        }
        desc = desc + "<br/>";
        if (sentence != null) {
            desc = desc + I18n.format((String)"<b>{0}</b> ", (Object[])new Object[]{sentence});
            if (paragraph != null && !paragraph.isEmpty()) {
                desc = desc + I18n.format((String)"{0}", (Object[])new Object[]{paragraph});
            }
            desc = desc + "<br />";
        }
        if (author != null && !author.isEmpty()) {
            desc = this.setButtonOrLink(this.moreInfoButton, desc, this.moreInfoLbl, website);
        }
        desc = desc + "</body></html>";
        this.description.setText(desc);
        this.description.getAccessibleContext().setAccessibleDescription(desc);
        InstallerTableCell.setJTextPaneDimensionToFitContainedText(this.description, parentTable.getBounds().width);
    }

    private String setButtonOrLink(JButton button, String desc, String label, String url) {
        boolean accessibleIDE = PreferencesData.getBoolean((String)"ide.accessible");
        String retString = desc;
        if (accessibleIDE) {
            button.setVisible(true);
            button.addActionListener(e -> Base.openURL(url));
        } else {
            retString = retString + I18n.format((String)"<a href=\"{0}\">{1}</a><br/>", (Object[])new Object[]{url, label});
        }
        return retString;
    }

    private JTextPane makeNewDescription() {
        JTextPane description = new JTextPane();
        description.setInheritsPopupMenu(true);
        Insets margin = description.getMargin();
        margin.bottom = 0;
        description.setMargin(margin);
        description.setContentType("text/html");
        Document doc = description.getDocument();
        if (doc instanceof HTMLDocument) {
            HTMLDocument html = (HTMLDocument)doc;
            StyleSheet s = html.getStyleSheet();
            s.addRule("body { margin: 0; padding: 0;font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;color: black;font-size: " + 10 * Theme.getScale() / 100 + "; }");
        }
        description.setOpaque(false);
        description.setBorder(new EmptyBorder(4, 7, 7, 7));
        description.setHighlighter(null);
        description.setEditable(false);
        description.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                Base.openURL(e.getDescription());
            }
        });
        return description;
    }

    public void setButtonsVisible(boolean enabled) {
        this.installButton.setEnabled(enabled);
        this.buttonsPanel.setVisible(enabled);
        this.inactiveButtonsPanel.setVisible(!enabled);
    }

    @Override
    public void setForeground(Color c) {
        super.setForeground(c);
        if (this.description != null) {
            this.description.setForeground(c);
        }
    }
}

