/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.settings;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tim.prune.App;
import tim.prune.ExternalTools;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.config.Config;

public class SetPathsFunction
extends GenericFunction {
    private JDialog _dialog = null;
    private JTextField[] _editFields = null;
    private JLabel[] _installedLabels = null;
    private static final String[] CONFIG_KEYS = new String[]{"prune.gpsbabelpath", "prune.gnuplotpath", "prune.exiftoolpath"};
    private static final String[] LABEL_KEYS = new String[]{"gpsbabel", "gnuplot", "exiftool"};
    private static final int NUM_KEYS = CONFIG_KEYS.length;

    public SetPathsFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.setpaths";
    }

    @Override
    public void begin() {
        if (this._dialog == null) {
            this._dialog = new JDialog(this._parentFrame, I18nManager.getText(this.getNameKey()), true);
            this._dialog.setLocationRelativeTo(this._parentFrame);
            this._dialog.setDefaultCloseOperation(2);
            this._dialog.getContentPane().add(this.makeDialogComponents());
            this._dialog.pack();
        }
        this.checkPaths();
        this._dialog.setVisible(true);
    }

    private JPanel makeDialogComponents() {
        Object object;
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.setpaths.intro")), "North");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(NUM_KEYS + 1, 3, 10, 1));
        jPanel2.add(new JLabel(" "));
        jPanel2.add(new JLabel(" "));
        jPanel2.add(new JLabel(I18nManager.getText("dialog.setpaths.found")));
        this._editFields = new JTextField[NUM_KEYS];
        this._installedLabels = new JLabel[NUM_KEYS];
        int n = 0;
        while (n < NUM_KEYS) {
            jComponent = new JLabel(I18nManager.getText("dialog.paths.prune." + LABEL_KEYS[n] + "path"));
            ((JLabel)jComponent).setHorizontalAlignment(4);
            jPanel2.add(jComponent);
            object = Config.getConfigString(CONFIG_KEYS[n]);
            if (object == null) {
                object = "";
            }
            this._editFields[n] = new JTextField((String)object);
            jPanel2.add(this._editFields[n]);
            this._installedLabels[n] = new JLabel("...");
            jPanel2.add(this._installedLabels[n]);
            ++n;
        }
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(2));
        jComponent = new JButton(I18nManager.getText("button.check"));
        ((AbstractButton)jComponent).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetPathsFunction.this.checkPaths();
            }
        });
        jPanel3.add(jComponent);
        object = new JButton(I18nManager.getText("button.ok"));
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetPathsFunction.this.finish();
            }
        };
        ((AbstractButton)object).addActionListener(actionListener);
        jPanel3.add((Component)object);
        JButton jButton = new JButton(I18nManager.getText("button.cancel"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SetPathsFunction.this._dialog.dispose();
            }
        });
        jPanel3.add(jButton);
        jPanel.add((Component)jPanel3, "South");
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 15));
        return jPanel;
    }

    private void checkPaths() {
        String string = I18nManager.getText("dialog.about.yes");
        String string2 = I18nManager.getText("dialog.about.no");
        int n = 0;
        while (n < NUM_KEYS) {
            String string3 = this._editFields[n].getText();
            this._installedLabels[n].setText("   " + (ExternalTools.isToolInstalled(n, string3) ? string : string2));
            ++n;
        }
    }

    private void finish() {
        int n = 0;
        while (n < NUM_KEYS) {
            String string = this._editFields[n].getText();
            Config.setConfigString(CONFIG_KEYS[n], string);
            ++n;
        }
        this._dialog.dispose();
    }
}

