/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.pdftk_java;

import com.gitlab.pdftk_java.ErrorCode;
import com.gitlab.pdftk_java.InputPdf;
import com.gitlab.pdftk_java.PageRange;
import com.gitlab.pdftk_java.PdfBookmark;
import com.gitlab.pdftk_java.attachments;
import com.gitlab.pdftk_java.bookmarks;
import com.gitlab.pdftk_java.data_import;
import com.gitlab.pdftk_java.passwords;
import com.gitlab.pdftk_java.pdftk;
import com.gitlab.pdftk_java.report;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pdftk.com.lowagie.text.Document;
import pdftk.com.lowagie.text.DocumentException;
import pdftk.com.lowagie.text.Rectangle;
import pdftk.com.lowagie.text.pdf.AcroFields;
import pdftk.com.lowagie.text.pdf.FdfReader;
import pdftk.com.lowagie.text.pdf.FdfWriter;
import pdftk.com.lowagie.text.pdf.PdfAnnotation;
import pdftk.com.lowagie.text.pdf.PdfArray;
import pdftk.com.lowagie.text.pdf.PdfBoolean;
import pdftk.com.lowagie.text.pdf.PdfContentByte;
import pdftk.com.lowagie.text.pdf.PdfCopy;
import pdftk.com.lowagie.text.pdf.PdfDictionary;
import pdftk.com.lowagie.text.pdf.PdfFileSpecification;
import pdftk.com.lowagie.text.pdf.PdfImportedPage;
import pdftk.com.lowagie.text.pdf.PdfIndirectReference;
import pdftk.com.lowagie.text.pdf.PdfName;
import pdftk.com.lowagie.text.pdf.PdfNameTree;
import pdftk.com.lowagie.text.pdf.PdfNumber;
import pdftk.com.lowagie.text.pdf.PdfObject;
import pdftk.com.lowagie.text.pdf.PdfReader;
import pdftk.com.lowagie.text.pdf.PdfStamperImp;
import pdftk.com.lowagie.text.pdf.PdfWriter;
import pdftk.com.lowagie.text.pdf.XfdfReader;

class TK_Session {
    boolean m_valid_b = false;
    boolean m_authorized_b = true;
    boolean m_input_pdf_readers_opened_b = false;
    boolean m_verbose_reporting_b = false;
    boolean m_ask_about_warnings_b = false;
    ArrayList<InputPdf> m_input_pdf = new ArrayList();
    HashMap<String, Integer> m_input_pdf_index = new HashMap();
    ArrayList<String> m_input_attach_file_filename = new ArrayList();
    int m_input_attach_file_pagenum = 0;
    String m_update_info_filename = "";
    boolean m_update_info_utf8_b = false;
    String m_update_xmp_filename = "";
    keyword m_operation = keyword.none_k;
    ArrayList<ArrayList<PageRef>> m_page_seq = new ArrayList();
    String m_form_data_filename = "";
    String m_background_filename = "";
    String m_stamp_filename = "";
    String m_output_filename = "";
    boolean m_output_utf8_b = false;
    String m_output_owner_pw = "";
    String m_output_user_pw = "";
    int m_output_user_perms = 0;
    boolean m_multistamp_b = false;
    boolean m_multibackground_b = false;
    boolean m_output_uncompress_b = false;
    boolean m_output_compress_b = false;
    boolean m_output_flatten_b = false;
    boolean m_output_need_appearances_b = false;
    boolean m_output_drop_xfa_b = false;
    boolean m_output_drop_xmp_b = false;
    boolean m_output_keep_first_id_b = false;
    boolean m_output_keep_final_id_b = false;
    boolean m_cat_full_pdfs_b = true;
    encryption_strength m_output_encryption_strength = encryption_strength.none_enc;
    static final String g_page_marker = "pdftk_PageNum";

    InputPdf.PagesReader add_reader(InputPdf input_pdf_p, boolean keep_artifacts_b) {
        InputPdf.PagesReader ret_val = input_pdf_p.add_reader(keep_artifacts_b, this.m_ask_about_warnings_b);
        this.m_authorized_b = this.m_authorized_b && input_pdf_p.m_authorized_b;
        return ret_val;
    }

    InputPdf.PagesReader add_reader(InputPdf input_pdf_p) {
        return this.add_reader(input_pdf_p, false);
    }

    boolean open_input_pdf_readers() {
        boolean open_success_b = true;
        if (!this.m_input_pdf_readers_opened_b) {
            if (this.m_operation == keyword.filter_k && this.m_input_pdf.size() == 1) {
                open_success_b = this.add_reader(this.m_input_pdf.get(0), true) != null;
            } else {
                for (InputPdf it : this.m_input_pdf) {
                    open_success_b = this.add_reader(it) != null && open_success_b;
                }
            }
            this.m_input_pdf_readers_opened_b = open_success_b;
        }
        return open_success_b;
    }

    static keyword is_keyword(String ss) {
        if ((ss = ss.toLowerCase()).equals("cat")) {
            return keyword.cat_k;
        }
        if (ss.equals("shuffle")) {
            return keyword.shuffle_k;
        }
        if (ss.equals("burst")) {
            return keyword.burst_k;
        }
        if (ss.equals("filter")) {
            return keyword.filter_k;
        }
        if (ss.equals("dump_data") || ss.equals("dumpdata") || ss.equals("data_dump") || ss.equals("datadump")) {
            return keyword.dump_data_k;
        }
        if (ss.equals("dump_data_utf8")) {
            return keyword.dump_data_utf8_k;
        }
        if (ss.equals("dump_data_fields")) {
            return keyword.dump_data_fields_k;
        }
        if (ss.equals("dump_data_fields_utf8")) {
            return keyword.dump_data_fields_utf8_k;
        }
        if (ss.equals("dump_data_annots")) {
            return keyword.dump_data_annots_k;
        }
        if (ss.equals("generate_fdf") || ss.equals("fdfgen") || ss.equals("fdfdump") || ss.equals("dump_data_fields_fdf")) {
            return keyword.generate_fdf_k;
        }
        if (ss.equals("fill_form") || ss.equals("fillform")) {
            return keyword.fill_form_k;
        }
        if (ss.equals("attach_file") || ss.equals("attach_files") || ss.equals("attachfile")) {
            return keyword.attach_file_k;
        }
        if (ss.equals("unpack_file") || ss.equals("unpack_files") || ss.equals("unpackfiles")) {
            return keyword.unpack_files_k;
        }
        if (ss.equals("update_info") || ss.equals("updateinfo")) {
            return keyword.update_info_k;
        }
        if (ss.equals("update_info_utf8") || ss.equals("updateinfoutf8")) {
            return keyword.update_info_utf8_k;
        }
        if (ss.equals("background")) {
            return keyword.background_k;
        }
        if (ss.equals("multibackground")) {
            return keyword.multibackground_k;
        }
        if (ss.equals("multistamp")) {
            return keyword.multistamp_k;
        }
        if (ss.equals("stamp")) {
            return keyword.stamp_k;
        }
        if (ss.equals("rotate")) {
            return keyword.rotate_k;
        }
        if (ss.startsWith("even")) {
            return keyword.even_k;
        }
        if (ss.startsWith("odd")) {
            return keyword.odd_k;
        }
        if (ss.equals("to_page") || ss.equals("topage")) {
            return keyword.attach_file_to_page_k;
        }
        if (ss.equals("output")) {
            return keyword.output_k;
        }
        if (ss.equals("owner_pw") || ss.equals("ownerpw")) {
            return keyword.owner_pw_k;
        }
        if (ss.equals("user_pw") || ss.equals("userpw")) {
            return keyword.user_pw_k;
        }
        if (ss.equals("input_pw") || ss.equals("inputpw")) {
            return keyword.input_pw_k;
        }
        if (ss.equals("allow")) {
            return keyword.user_perms_k;
        }
        if (ss.equals("encrypt_40bit") || ss.equals("encrypt_40bits") || ss.equals("encrypt40bit") || ss.equals("encrypt40bits") || ss.equals("encrypt40_bit") || ss.equals("encrypt40_bits") || ss.equals("encrypt_40_bit") || ss.equals("encrypt_40_bits")) {
            return keyword.encrypt_40bit_k;
        }
        if (ss.equals("encrypt_128bit") || ss.equals("encrypt_128bits") || ss.equals("encrypt128bit") || ss.equals("encrypt128bits") || ss.equals("encrypt128_bit") || ss.equals("encrypt128_bits") || ss.equals("encrypt_128_bit") || ss.equals("encrypt_128_bits")) {
            return keyword.encrypt_128bit_k;
        }
        if (ss.equals("printing")) {
            return keyword.perm_printing_k;
        }
        if (ss.equals("modifycontents")) {
            return keyword.perm_modify_contents_k;
        }
        if (ss.equals("copycontents")) {
            return keyword.perm_copy_contents_k;
        }
        if (ss.equals("modifyannotations")) {
            return keyword.perm_modify_annotations_k;
        }
        if (ss.equals("fillin")) {
            return keyword.perm_fillin_k;
        }
        if (ss.equals("screenreaders")) {
            return keyword.perm_screen_readers_k;
        }
        if (ss.equals("assembly")) {
            return keyword.perm_assembly_k;
        }
        if (ss.equals("degradedprinting")) {
            return keyword.perm_degraded_printing_k;
        }
        if (ss.equals("allfeatures")) {
            return keyword.perm_all_k;
        }
        if (ss.equals("uncompress")) {
            return keyword.filt_uncompress_k;
        }
        if (ss.equals("compress")) {
            return keyword.filt_compress_k;
        }
        if (ss.equals("flatten")) {
            return keyword.flatten_k;
        }
        if (ss.equals("need_appearances")) {
            return keyword.need_appearances_k;
        }
        if (ss.equals("drop_xfa")) {
            return keyword.drop_xfa_k;
        }
        if (ss.equals("drop_xmp")) {
            return keyword.drop_xmp_k;
        }
        if (ss.equals("keep_first_id")) {
            return keyword.keep_first_id_k;
        }
        if (ss.equals("keep_final_id")) {
            return keyword.keep_final_id_k;
        }
        if (ss.equals("verbose")) {
            return keyword.verbose_k;
        }
        if (ss.equals("dont_ask") || ss.equals("dontask")) {
            return keyword.dont_ask_k;
        }
        if (ss.equals("do_ask")) {
            return keyword.do_ask_k;
        }
        if (ss.equals("north")) {
            return keyword.rot_north_k;
        }
        if (ss.equals("south")) {
            return keyword.rot_south_k;
        }
        if (ss.equals("east")) {
            return keyword.rot_east_k;
        }
        if (ss.equals("west")) {
            return keyword.rot_west_k;
        }
        if (ss.equals("left")) {
            return keyword.rot_left_k;
        }
        if (ss.equals("right")) {
            return keyword.rot_right_k;
        }
        if (ss.equals("down")) {
            return keyword.rot_upside_down_k;
        }
        return keyword.none_k;
    }

    static keyword consume_keyword(StringBuilder ssb) {
        String ss = new String(ssb).toLowerCase();
        if (ss.startsWith("even")) {
            ssb.delete(0, 4);
            return keyword.even_k;
        }
        if (ss.startsWith("odd")) {
            ssb.delete(0, 3);
            return keyword.odd_k;
        }
        ssb.setLength(0);
        return TK_Session.is_keyword(ss);
    }

    TK_Session(String[] args) {
        ArgState arg_state = ArgState.input_files_e;
        boolean password_using_handles_not_b = false;
        boolean password_using_handles_b = false;
        int password_input_pdf_index = 0;
        boolean fail_b = false;
        for (String argv : args) {
            keyword kw = TK_Session.is_keyword(argv);
            if (kw == keyword.dont_ask_k) {
                this.m_ask_about_warnings_b = false;
                continue;
            }
            if (kw != keyword.do_ask_k) continue;
            this.m_ask_about_warnings_b = true;
        }
        block30: for (String argv : args) {
            if (fail_b || arg_state == ArgState.done_e) break;
            keyword arg_keyword = TK_Session.is_keyword(argv);
            if (arg_keyword == keyword.even_k || arg_keyword == keyword.odd_k) {
                arg_keyword = keyword.none_k;
            }
            switch (arg_state) {
                case input_files_e: 
                case input_pw_e: {
                    Matcher m;
                    Pattern p;
                    if (arg_keyword == keyword.input_pw_k) {
                        arg_state = ArgState.input_pw_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.cat_k) {
                        this.m_operation = keyword.cat_k;
                        arg_state = ArgState.page_seq_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.shuffle_k) {
                        this.m_operation = keyword.shuffle_k;
                        arg_state = ArgState.page_seq_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.burst_k) {
                        this.m_operation = keyword.burst_k;
                        arg_state = ArgState.output_args_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.filter_k) {
                        this.m_operation = keyword.filter_k;
                        arg_state = ArgState.output_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.dump_data_k) {
                        this.m_operation = keyword.dump_data_k;
                        arg_state = ArgState.output_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.dump_data_utf8_k) {
                        this.m_operation = keyword.dump_data_k;
                        this.m_output_utf8_b = true;
                        arg_state = ArgState.output_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.dump_data_fields_k) {
                        this.m_operation = keyword.dump_data_fields_k;
                        arg_state = ArgState.output_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.dump_data_fields_utf8_k) {
                        this.m_operation = keyword.dump_data_fields_k;
                        this.m_output_utf8_b = true;
                        arg_state = ArgState.output_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.dump_data_k) {
                        this.m_operation = keyword.dump_data_k;
                        arg_state = ArgState.output_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.dump_data_annots_k) {
                        this.m_operation = keyword.dump_data_annots_k;
                        arg_state = ArgState.output_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.generate_fdf_k) {
                        this.m_operation = keyword.generate_fdf_k;
                        this.m_output_utf8_b = true;
                        arg_state = ArgState.output_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.fill_form_k) {
                        this.m_operation = keyword.filter_k;
                        arg_state = ArgState.form_data_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.attach_file_k) {
                        this.m_operation = keyword.filter_k;
                        arg_state = ArgState.attach_file_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.attach_file_to_page_k) {
                        arg_state = ArgState.attach_file_pagenum_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.unpack_files_k) {
                        this.m_operation = keyword.unpack_files_k;
                        arg_state = ArgState.output_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.update_info_k) {
                        this.m_operation = keyword.filter_k;
                        this.m_update_info_utf8_b = false;
                        arg_state = ArgState.update_info_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.update_info_utf8_k) {
                        this.m_operation = keyword.filter_k;
                        this.m_update_info_utf8_b = true;
                        arg_state = ArgState.update_info_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.background_k) {
                        this.m_operation = keyword.filter_k;
                        arg_state = ArgState.background_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.multibackground_k) {
                        this.m_operation = keyword.filter_k;
                        this.m_multibackground_b = true;
                        arg_state = ArgState.background_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.stamp_k) {
                        this.m_operation = keyword.filter_k;
                        arg_state = ArgState.stamp_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.multistamp_k) {
                        this.m_operation = keyword.filter_k;
                        this.m_multistamp_b = true;
                        arg_state = ArgState.stamp_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.rotate_k) {
                        this.m_operation = keyword.filter_k;
                        arg_state = ArgState.page_seq_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.output_k) {
                        arg_state = ArgState.output_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.none_k) {
                        p = Pattern.compile("(?:([A-Z]+)=)?(.*)", 32);
                        m = p.matcher(argv);
                        m.matches();
                        String handle = m.group(1);
                        String data = m.group(2);
                        if (arg_state == ArgState.input_files_e) {
                            InputPdf input_pdf = new InputPdf();
                            input_pdf.m_filename = data;
                            if (handle == null) {
                                this.m_input_pdf.add(input_pdf);
                                continue block30;
                            }
                            Integer it = this.m_input_pdf_index.get(handle);
                            if (it != null) {
                                System.err.println("Error: Handle given here: ");
                                System.err.println("      " + argv);
                                System.err.println("   is already associated with: ");
                                System.err.println("      " + this.m_input_pdf.get((int)it.intValue()).m_filename);
                                System.err.println("   Exiting.");
                                fail_b = true;
                                continue block30;
                            }
                            this.m_input_pdf.add(input_pdf);
                            this.m_input_pdf_index.put(handle, this.m_input_pdf.size() - 1);
                            continue block30;
                        }
                        if (arg_state == ArgState.input_pw_e) {
                            if (this.m_input_pdf_index.size() == 0) {
                                handle = null;
                                data = argv;
                            }
                            if (handle == null) {
                                if (password_using_handles_b) {
                                    System.err.println("Error: Expected a user-supplied handle for this input");
                                    System.err.println("   PDF password: " + argv);
                                    System.err.println();
                                    System.err.println("   Handles must be supplied with ~all~ input");
                                    System.err.println("   PDF passwords, or with ~no~ input PDF passwords.");
                                    System.err.println("   If no handles are supplied, then passwords are applied");
                                    System.err.println("   according to input PDF order.");
                                    System.err.println();
                                    System.err.println("   Handles are given like this: <handle>=<password>, and");
                                    System.err.println("   they must be one or more upper-case letters.");
                                    fail_b = true;
                                    continue block30;
                                }
                                password_using_handles_not_b = true;
                                if (password_input_pdf_index < this.m_input_pdf.size()) {
                                    this.m_input_pdf.get((int)password_input_pdf_index).m_password = argv;
                                    ++password_input_pdf_index;
                                    continue block30;
                                }
                                System.err.println("Error: more input passwords than input PDF documents.");
                                System.err.println("   Exiting.");
                                fail_b = true;
                                continue block30;
                            }
                            if (password_using_handles_not_b) {
                                System.err.println("Error: Expected ~no~ user-supplied handle for this input");
                                System.err.println("   PDF password: " + argv);
                                System.err.println();
                                System.err.println("   Handles must be supplied with ~all~ input");
                                System.err.println("   PDF passwords, or with ~no~ input PDF passwords.");
                                System.err.println("   If no handles are supplied, then passwords are applied");
                                System.err.println("   according to input PDF order.");
                                System.err.println();
                                System.err.println("   Handles are given like this: <handle>=<password>, and");
                                System.err.println("   they must be one or more upper-case letters.");
                                fail_b = true;
                                continue block30;
                            }
                            password_using_handles_b = true;
                            Integer it = this.m_input_pdf_index.get(handle);
                            if (it != null) {
                                if (this.m_input_pdf.get((int)it.intValue()).m_password.isEmpty()) {
                                    this.m_input_pdf.get((int)it.intValue()).m_password = data;
                                    continue block30;
                                }
                                System.err.println("Error: Handle given here: ");
                                System.err.println("      " + argv);
                                System.err.println("   is already associated with this password: ");
                                System.err.println("      " + this.m_input_pdf.get((int)it.intValue()).m_password);
                                System.err.println("   Exiting.");
                                fail_b = true;
                                continue block30;
                            }
                            System.err.println("Error: Password handle: " + argv);
                            System.err.println("   is not associated with an input PDF file.");
                            System.err.println("   Exiting.");
                            fail_b = true;
                            continue block30;
                        }
                        System.err.println("Error: Internal error: unexpected arg_state.  Exiting.");
                        fail_b = true;
                        continue block30;
                    }
                    System.err.println("Error: Unexpected command-line data: ");
                    System.err.println("      " + argv);
                    if (arg_state == ArgState.input_files_e) {
                        System.err.println("   where we were expecting an input PDF filename,");
                        System.err.println("   operation (e.g. \"cat\") or \"input_pw\".  Exiting.");
                    } else {
                        System.err.println("   where we were expecting an input PDF password");
                        System.err.println("   or operation (e.g. \"cat\").  Exiting.");
                    }
                    fail_b = true;
                    continue block30;
                }
                case page_seq_e: {
                    Matcher m;
                    Pattern p;
                    if (this.m_page_seq.isEmpty()) {
                        if (this.m_input_pdf.isEmpty()) {
                            System.err.println("Error: No input files.  Exiting.");
                            fail_b = true;
                            continue block30;
                        }
                        if (!this.open_input_pdf_readers()) {
                            fail_b = true;
                            continue block30;
                        }
                    }
                    if (arg_keyword == keyword.output_k) {
                        arg_state = ArgState.output_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.none_k) {
                        boolean reverse_sequence_b;
                        PageRange page_num;
                        boolean even_pages_b = false;
                        boolean odd_pages_b = false;
                        p = Pattern.compile("([A-Z]*)(r?)(end|[0-9]*)(-(r?)(end|[0-9]*))?(.*)", 32);
                        m = p.matcher(argv);
                        m.matches();
                        String handle = m.group(1);
                        String pre_reverse = m.group(2);
                        String pre_range = m.group(3);
                        String hyphen = m.group(4);
                        String post_reverse = m.group(5);
                        String post_range = m.group(6);
                        String keywords = m.group(7);
                        int range_pdf_index = 0;
                        if (!handle.isEmpty()) {
                            Integer it = this.m_input_pdf_index.get(handle);
                            if (it == null) {
                                System.err.println("Error: Given handle has no associated file: ");
                                System.err.println("   " + handle + ", used here: " + argv);
                                System.err.println("   Exiting.");
                                fail_b = true;
                                continue block30;
                            }
                            range_pdf_index = it;
                        }
                        if (!(page_num = new PageRange(this.m_input_pdf.get((int)range_pdf_index).m_num_pages, argv)).parse(pre_reverse, pre_range, post_reverse, post_range)) {
                            fail_b = true;
                            continue block30;
                        }
                        PageRotate page_rotate = PageRotate.NORTH;
                        boolean page_rotate_absolute = false;
                        StringBuilder trailing_keywords = new StringBuilder(keywords);
                        while (trailing_keywords.length() > 0) {
                            arg_keyword = TK_Session.consume_keyword(trailing_keywords);
                            if (arg_keyword == keyword.even_k) {
                                even_pages_b = true;
                                continue;
                            }
                            if (arg_keyword == keyword.odd_k) {
                                odd_pages_b = true;
                                continue;
                            }
                            if (arg_keyword == keyword.rot_north_k) {
                                page_rotate = PageRotate.NORTH;
                                page_rotate_absolute = true;
                                continue;
                            }
                            if (arg_keyword == keyword.rot_east_k) {
                                page_rotate = PageRotate.EAST;
                                page_rotate_absolute = true;
                                continue;
                            }
                            if (arg_keyword == keyword.rot_south_k) {
                                page_rotate = PageRotate.SOUTH;
                                page_rotate_absolute = true;
                                continue;
                            }
                            if (arg_keyword == keyword.rot_west_k) {
                                page_rotate = PageRotate.WEST;
                                page_rotate_absolute = true;
                                continue;
                            }
                            if (arg_keyword == keyword.rot_left_k) {
                                page_rotate = PageRotate.WEST;
                                page_rotate_absolute = false;
                                continue;
                            }
                            if (arg_keyword == keyword.rot_right_k) {
                                page_rotate = PageRotate.EAST;
                                page_rotate_absolute = false;
                                continue;
                            }
                            if (arg_keyword == keyword.rot_upside_down_k) {
                                page_rotate = PageRotate.SOUTH;
                                page_rotate_absolute = false;
                                continue;
                            }
                            System.err.println("Error: Unexpected text in page range end, here: ");
                            System.err.println("   " + argv);
                            System.err.println("   Exiting.");
                            System.err.println("   Acceptable keywords, for example: \"even\" or \"odd\".");
                            System.err.println("   To rotate pages, use: \"north\" \"south\" \"east\"");
                            System.err.println("       \"west\" \"left\" \"right\" or \"down\"");
                            fail_b = true;
                            break;
                        }
                        if (page_num.beg == 0 && page_num.end == 0) {
                            page_num.beg = 1;
                            page_num.end = this.m_input_pdf.get((int)range_pdf_index).m_num_pages;
                            this.m_cat_full_pdfs_b = this.m_cat_full_pdfs_b && !even_pages_b && !odd_pages_b;
                        } else {
                            if (page_num.beg == 0 || page_num.end == 0) {
                                System.err.println("Error: Input page numbers include 0 (zero)");
                                System.err.println("   The first PDF page is 1 (one)");
                                System.err.println("   Exiting.");
                                fail_b = true;
                                continue block30;
                            }
                            this.m_cat_full_pdfs_b = false;
                        }
                        ArrayList<PageRef> temp_page_seq = new ArrayList<PageRef>();
                        boolean bl = reverse_sequence_b = page_num.end < page_num.beg;
                        if (reverse_sequence_b) {
                            int temp = page_num.end;
                            page_num.end = page_num.beg;
                            page_num.beg = temp;
                        }
                        for (int kk = page_num.beg; kk <= page_num.end; ++kk) {
                            if (even_pages_b && kk % 2 != 0 || odd_pages_b && kk % 2 != 1) continue;
                            if (kk <= this.m_input_pdf.get((int)range_pdf_index).m_num_pages) {
                                boolean associated = false;
                                for (InputPdf.PagesReader it : this.m_input_pdf.get((int)range_pdf_index).m_readers) {
                                    if (it.first.contains(kk)) continue;
                                    it.first.add(kk);
                                    associated = true;
                                    break;
                                }
                                if (!associated) {
                                    InputPdf.PagesReader new_reader = this.add_reader(this.m_input_pdf.get(range_pdf_index));
                                    if (new_reader != null) {
                                        new_reader.first.add(kk);
                                    } else {
                                        System.err.println("Internal Error: unable to add reader");
                                        fail_b = true;
                                        break;
                                    }
                                }
                                temp_page_seq.add(new PageRef(range_pdf_index, kk, page_rotate, page_rotate_absolute));
                                continue;
                            }
                            System.err.println("Error: Page number: " + kk);
                            System.err.println("   does not exist in file: " + this.m_input_pdf.get((int)range_pdf_index).m_filename);
                            fail_b = true;
                        }
                        if (fail_b) continue block30;
                        if (reverse_sequence_b) {
                            Collections.reverse(temp_page_seq);
                        }
                        this.m_page_seq.add(temp_page_seq);
                        continue block30;
                    }
                    System.err.println("Error: expecting page ranges.  Instead, I got:");
                    System.err.println("   " + argv);
                    fail_b = true;
                    continue block30;
                }
                case form_data_filename_e: {
                    if (arg_keyword == keyword.none_k) {
                        if (!this.m_form_data_filename.isEmpty()) {
                            System.err.println("Error: Multiple fill_form filenames given: ");
                            System.err.println("   " + this.m_form_data_filename + " and " + argv);
                            System.err.println("Exiting.");
                            fail_b = true;
                            continue block30;
                        }
                        this.m_form_data_filename = argv;
                        arg_state = ArgState.output_e;
                        continue block30;
                    }
                    System.err.println("Error: expecting a form data filename,");
                    System.err.println("   instead I got this keyword: " + argv);
                    System.err.println("Exiting.");
                    fail_b = true;
                    continue block30;
                }
                case attach_file_filename_e: {
                    if (arg_keyword == keyword.attach_file_to_page_k) {
                        arg_state = ArgState.attach_file_pagenum_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.output_k) {
                        arg_state = ArgState.output_filename_e;
                        continue block30;
                    }
                    if (arg_keyword == keyword.none_k) {
                        this.m_input_attach_file_filename.add(argv);
                        continue block30;
                    }
                    System.err.println("Error: expecting an attachment filename,");
                    System.err.println("   instead I got this keyword: " + argv);
                    System.err.println("Exiting.");
                    fail_b = true;
                    continue block30;
                }
                case attach_file_pagenum_e: {
                    if (argv.equals("PROMPT")) {
                        this.m_input_attach_file_pagenum = -1;
                    } else if (argv.equals("end")) {
                        this.m_input_attach_file_pagenum = -2;
                    } else {
                        try {
                            this.m_input_attach_file_pagenum = Integer.parseInt(argv);
                        }
                        catch (NumberFormatException e) {
                            System.err.println("Error: expecting a (1-based) page number.  Instead, I got:");
                            System.err.println("   " + argv);
                            System.err.println("Exiting.");
                            fail_b = true;
                        }
                    }
                    arg_state = ArgState.output_e;
                    continue block30;
                }
                case update_info_filename_e: {
                    if (arg_keyword == keyword.none_k) {
                        if (!this.m_update_info_filename.isEmpty()) {
                            System.err.println("Error: Multiple update_info filenames given: ");
                            System.err.println("   " + this.m_update_info_filename + " and " + argv);
                            System.err.println("Exiting.");
                            fail_b = true;
                            continue block30;
                        }
                    } else {
                        System.err.println("Error: expecting an INFO file filename,");
                        System.err.println("   instead I got this keyword: " + argv);
                        System.err.println("Exiting.");
                        fail_b = true;
                        continue block30;
                    }
                    this.m_update_info_filename = argv;
                    arg_state = ArgState.output_e;
                    continue block30;
                }
                case output_e: {
                    if (this.m_input_pdf.isEmpty()) {
                        System.err.println("Error: No input files.  Exiting.");
                        fail_b = true;
                        continue block30;
                    }
                    if (arg_keyword == keyword.output_k) {
                        arg_state = ArgState.output_filename_e;
                        continue block30;
                    }
                    System.err.println("Error: expecting \"output\" keyword.  Instead, I got:");
                    System.err.println("   " + argv);
                    fail_b = true;
                    continue block30;
                }
                case output_filename_e: {
                    if (this.m_operation == keyword.none_k) {
                        this.m_operation = 1 < this.m_input_pdf.size() ? keyword.cat_k : keyword.filter_k;
                    }
                    if (!this.open_input_pdf_readers()) {
                        fail_b = true;
                        continue block30;
                    }
                    if ((this.m_operation == keyword.cat_k || this.m_operation == keyword.shuffle_k) && this.m_page_seq.isEmpty()) {
                        for (int ii = 0; ii < this.m_input_pdf.size(); ++ii) {
                            InputPdf input_pdf = this.m_input_pdf.get(ii);
                            ArrayList<PageRef> temp_page_seq = new ArrayList<PageRef>();
                            for (int jj = 1; jj <= input_pdf.m_num_pages; ++jj) {
                                temp_page_seq.add(new PageRef(ii, jj));
                                input_pdf.m_readers.get((int)(input_pdf.m_readers.size() - 1)).first.add(jj);
                            }
                            this.m_page_seq.add(temp_page_seq);
                        }
                    }
                    if (this.m_output_filename.isEmpty()) {
                        this.m_output_filename = argv;
                        if (!this.m_output_filename.equals("-")) {
                            for (InputPdf it : this.m_input_pdf) {
                                if (!it.m_filename.equals(this.m_output_filename)) continue;
                                System.err.println("Error: The given output filename: " + this.m_output_filename);
                                System.err.println("   matches an input filename.  Exiting.");
                                fail_b = true;
                                break;
                            }
                        }
                    } else {
                        System.err.println("Error: Multiple output filenames given: ");
                        System.err.println("   " + this.m_output_filename + " and " + argv);
                        System.err.println("Exiting.");
                        fail_b = true;
                        continue block30;
                    }
                    arg_state = ArgState.output_args_e;
                    continue block30;
                }
                case output_args_e: {
                    ArgStateMutable arg_state_m = new ArgStateMutable();
                    arg_state_m.value = arg_state;
                    if (this.handle_some_output_options(arg_keyword, arg_state_m)) {
                        arg_state = arg_state_m.value;
                        continue block30;
                    }
                    System.err.println("Error: Unexpected data in output section: ");
                    System.err.println("      " + argv);
                    System.err.println("Exiting.");
                    fail_b = true;
                    continue block30;
                }
                case output_owner_pw_e: {
                    if (this.m_output_owner_pw.isEmpty()) {
                        if (!argv.equals("PROMPT") && argv.equals(this.m_output_user_pw)) {
                            System.err.println("Error: The user and owner passwords are the same.");
                            System.err.println("   PDF Viewers interpret this to mean your PDF has");
                            System.err.println("   no owner password, so they must be different.");
                            System.err.println("   Or, supply no owner password to pdftk if this is");
                            System.err.println("   what you desire.");
                            System.err.println("Exiting.");
                            fail_b = true;
                            continue block30;
                        }
                    } else {
                        System.err.println("Error: Multiple output owner passwords given: ");
                        System.err.println("   " + this.m_output_owner_pw + " and " + argv);
                        System.err.println("Exiting.");
                        fail_b = true;
                        continue block30;
                    }
                    this.m_output_owner_pw = argv;
                    arg_state = ArgState.output_args_e;
                    continue block30;
                }
                case output_user_pw_e: {
                    if (this.m_output_user_pw.isEmpty()) {
                        if (!argv.equals("PROMPT") && this.m_output_owner_pw.equals(argv)) {
                            System.err.println("Error: The user and owner passwords are the same.");
                            System.err.println("   PDF Viewers interpret this to mean your PDF has");
                            System.err.println("   no owner password, so they must be different.");
                            System.err.println("   Or, supply no owner password to pdftk if this is");
                            System.err.println("   what you desire.");
                            System.err.println("Exiting.");
                            fail_b = true;
                            continue block30;
                        }
                    } else {
                        System.err.println("Error: Multiple output user passwords given: ");
                        System.err.println("   " + this.m_output_user_pw + " and " + argv);
                        System.err.println("Exiting.");
                        fail_b = true;
                        continue block30;
                    }
                    this.m_output_user_pw = argv;
                    arg_state = ArgState.output_args_e;
                    continue block30;
                }
                case output_user_perms_e: {
                    ArgStateMutable arg_state_m = new ArgStateMutable();
                    arg_state_m.value = arg_state;
                    if (this.handle_some_output_options(arg_keyword, arg_state_m)) {
                        arg_state = arg_state_m.value;
                        continue block30;
                    }
                    switch (arg_keyword) {
                        case perm_printing_k: {
                            this.m_output_user_perms |= 0x804;
                            continue block30;
                        }
                        case perm_modify_contents_k: {
                            this.m_output_user_perms |= 0x408;
                            continue block30;
                        }
                        case perm_copy_contents_k: {
                            this.m_output_user_perms |= 0x210;
                            continue block30;
                        }
                        case perm_modify_annotations_k: {
                            this.m_output_user_perms |= 0x120;
                            continue block30;
                        }
                        case perm_fillin_k: {
                            this.m_output_user_perms |= 0x100;
                            continue block30;
                        }
                        case perm_screen_readers_k: {
                            this.m_output_user_perms |= 0x200;
                            continue block30;
                        }
                        case perm_assembly_k: {
                            this.m_output_user_perms |= 0x400;
                            continue block30;
                        }
                        case perm_degraded_printing_k: {
                            this.m_output_user_perms |= 4;
                            continue block30;
                        }
                        case perm_all_k: {
                            this.m_output_user_perms = 3900;
                            continue block30;
                        }
                    }
                    System.err.println("Error: Unexpected data in output section: ");
                    System.err.println("      " + argv);
                    System.err.println("Exiting.");
                    fail_b = true;
                    continue block30;
                }
                case background_filename_e: {
                    if (arg_keyword == keyword.none_k) {
                        if (!this.m_background_filename.isEmpty()) {
                            System.err.println("Error: Multiple background filenames given: ");
                            System.err.println("   " + this.m_background_filename + " and " + argv);
                            System.err.println("Exiting.");
                            fail_b = true;
                            continue block30;
                        }
                    } else {
                        System.err.println("Error: expecting a PDF filename for background operation,");
                        System.err.println("   instead I got this keyword: " + argv);
                        System.err.println("Exiting.");
                        fail_b = true;
                        continue block30;
                    }
                    this.m_background_filename = argv;
                    arg_state = ArgState.output_args_e;
                    continue block30;
                }
                case stamp_filename_e: {
                    if (arg_keyword == keyword.none_k) {
                        if (!this.m_stamp_filename.isEmpty()) {
                            System.err.println("Error: Multiple stamp filenames given: ");
                            System.err.println("   " + this.m_stamp_filename + " and " + argv);
                            System.err.println("Exiting.");
                            fail_b = true;
                            continue block30;
                        }
                    } else {
                        System.err.println("Error: expecting a PDF filename for stamp operation,");
                        System.err.println("   instead I got this keyword: " + argv);
                        System.err.println("Exiting.");
                        fail_b = true;
                        continue block30;
                    }
                    this.m_stamp_filename = argv;
                    arg_state = ArgState.output_e;
                    continue block30;
                }
                default: {
                    System.err.println("Internal Error: Unexpected arg_state.  Exiting.");
                    fail_b = true;
                }
            }
        }
        if (fail_b) {
            System.err.println("Errors encountered.  No output created.");
            this.m_valid_b = false;
            this.m_input_pdf.clear();
        } else {
            this.m_valid_b = true;
            if (!this.m_input_pdf_readers_opened_b) {
                this.open_input_pdf_readers();
            }
        }
    }

    boolean is_valid() {
        return !(!this.m_valid_b || this.m_operation != keyword.dump_data_k && this.m_operation != keyword.dump_data_fields_k && this.m_operation != keyword.dump_data_annots_k && this.m_operation != keyword.generate_fdf_k && !this.m_authorized_b || this.m_input_pdf.isEmpty() || !this.m_input_pdf_readers_opened_b || this.m_operation != keyword.cat_k && this.m_operation != keyword.shuffle_k && this.m_operation != keyword.burst_k && this.m_operation != keyword.filter_k && this.m_operation != keyword.dump_data_k && this.m_operation != keyword.dump_data_utf8_k && this.m_operation != keyword.dump_data_fields_k && this.m_operation != keyword.dump_data_fields_utf8_k && this.m_operation != keyword.dump_data_annots_k && this.m_operation != keyword.generate_fdf_k && this.m_operation != keyword.unpack_files_k || (this.m_operation == keyword.burst_k || this.m_operation == keyword.filter_k) && this.m_input_pdf.size() != 1 || this.m_operation != keyword.burst_k && this.m_operation != keyword.dump_data_k && this.m_operation != keyword.dump_data_fields_k && this.m_operation != keyword.dump_data_annots_k && this.m_operation != keyword.generate_fdf_k && this.m_operation != keyword.unpack_files_k && this.m_output_filename.isEmpty());
    }

    void dump_session_data() {
        if (!this.m_verbose_reporting_b) {
            return;
        }
        if (!this.m_input_pdf_readers_opened_b) {
            System.out.println("Input PDF Open Errors");
            return;
        }
        if (this.is_valid()) {
            System.out.println("Command Line Data is valid.");
        } else {
            System.out.println("Command Line Data is NOT valid.");
        }
        System.out.println();
        System.out.println("Input PDF Filenames & Passwords in Order\n( <filename>[, <password>] ) ");
        if (this.m_input_pdf.isEmpty()) {
            System.out.println("   No input PDF filenames have been given.");
        } else {
            for (InputPdf it : this.m_input_pdf) {
                System.out.print("   " + it.m_filename);
                if (!it.m_password.isEmpty()) {
                    System.out.print(", " + it.m_password);
                }
                if (!it.m_authorized_b) {
                    System.out.print(", OWNER OR USER PASSWORD REQUIRED, but not given (or incorrect)");
                }
                System.out.println();
            }
        }
        System.out.println();
        System.out.println("The operation to be performed: ");
        switch (this.m_operation) {
            case cat_k: {
                System.out.println("   cat - Catenate given page ranges into a new PDF.");
                break;
            }
            case shuffle_k: {
                System.out.println("   shuffle - Interleave given page ranges into a new PDF.");
                break;
            }
            case burst_k: {
                System.out.println("   burst - Split a single, input PDF into individual pages.");
                break;
            }
            case filter_k: {
                System.out.println("   filter - Apply 'filters' to a single, input PDF based on output args.");
                System.out.println("      (When the operation is omitted, this is the default.)");
                break;
            }
            case dump_data_k: {
                System.out.println("   dump_data - Report statistics on a single, input PDF.");
                break;
            }
            case dump_data_fields_k: {
                System.out.println("   dump_data_fields - Report form field data on a single, input PDF.");
                break;
            }
            case dump_data_annots_k: {
                System.out.println("   dump_data_annots - Report annotation data on a single, input PDF.");
                break;
            }
            case generate_fdf_k: {
                System.out.println("   generate_fdf - Generate a dummy FDF file from a PDF.");
                break;
            }
            case unpack_files_k: {
                System.out.println("   unpack_files - Copy PDF file attachments into given directory.");
                break;
            }
            case none_k: {
                System.out.println("   NONE - No operation has been given.  See usage instructions.");
                break;
            }
            default: {
                System.out.println("   INTERNAL ERROR - An unexpected operation has been given.");
            }
        }
        System.out.println();
        System.out.println("The output file will be named:");
        if (this.m_output_filename.isEmpty()) {
            System.out.println("   No output filename has been given.");
        } else {
            System.out.println("   " + this.m_output_filename);
        }
        System.out.println();
        boolean output_encrypted_b = this.m_output_encryption_strength != encryption_strength.none_enc || !this.m_output_user_pw.isEmpty() || !this.m_output_owner_pw.isEmpty();
        System.out.println("Output PDF encryption settings:");
        if (output_encrypted_b) {
            System.out.println("   Output PDF will be encrypted.");
            switch (this.m_output_encryption_strength) {
                case none_enc: {
                    System.out.println("   Encryption strength not given. Defaulting to: 128 bits.");
                    break;
                }
                case bits40_enc: {
                    System.out.println("   Given output encryption strength: 40 bits");
                    break;
                }
                case bits128_enc: {
                    System.out.println("   Given output encryption strength: 128 bits");
                }
            }
            System.out.println();
            if (this.m_output_user_pw.isEmpty()) {
                System.out.println("   No user password given.");
            } else {
                System.out.println("   Given user password: " + this.m_output_user_pw);
            }
            if (this.m_output_owner_pw.isEmpty()) {
                System.out.println("   No owner password given.");
            } else {
                System.out.println("   Given owner password: " + this.m_output_owner_pw);
            }
            if ((this.m_output_user_perms & 0x804) == 2052) {
                System.out.println("   ALLOW Top Quality Printing");
            } else if ((this.m_output_user_perms & 0x804) == 4) {
                System.out.println("   ALLOW Degraded Printing (Top-Quality Printing NOT Allowed)");
            } else {
                System.out.println("   Printing NOT Allowed");
            }
            if ((this.m_output_user_perms & 8) == 8) {
                System.out.println("   ALLOW Modifying of Contents");
            } else {
                System.out.println("   Modifying of Contents NOT Allowed");
            }
            if ((this.m_output_user_perms & 0x10) == 16) {
                System.out.println("   ALLOW Copying of Contents");
            } else {
                System.out.println("   Copying of Contents NOT Allowed");
            }
            if ((this.m_output_user_perms & 0x20) == 32) {
                System.out.println("   ALLOW Modifying of Annotations");
            } else {
                System.out.println("   Modifying of Annotations NOT Allowed");
            }
            if ((this.m_output_user_perms & 0x100) == 256) {
                System.out.println("   ALLOW Fill-In");
            } else {
                System.out.println("   Fill-In NOT Allowed");
            }
            if ((this.m_output_user_perms & 0x200) == 512) {
                System.out.println("   ALLOW Screen Readers");
            } else {
                System.out.println("   Screen Readers NOT Allowed");
            }
            if ((this.m_output_user_perms & 0x400) == 1024) {
                System.out.println("   ALLOW Assembly");
            } else {
                System.out.println("   Assembly NOT Allowed");
            }
        } else {
            System.out.println("   Output PDF will not be encrypted.");
        }
        System.out.println();
        if (this.m_operation != keyword.filter_k || output_encrypted_b || !this.m_output_compress_b && !this.m_output_uncompress_b) {
            System.out.println("No compression or uncompression being performed on output.");
        } else if (this.m_output_compress_b) {
            System.out.println("Compression will be applied to some PDF streams.");
        } else {
            System.out.println("Some PDF streams will be uncompressed.");
        }
    }

    void attach_files(PdfReader input_reader_p, PdfWriter writer_p) throws IOException {
        if (!this.m_input_attach_file_filename.isEmpty()) {
            if (this.m_input_attach_file_pagenum == -1) {
                System.out.println("Please enter the page number you want to attach these files to.");
                System.out.println("   The first page is 1.  The final page is \"end\".");
                System.out.println("   To attach files at the document level, just press Enter.");
                Scanner s = new Scanner(System.in);
                String buff = s.nextLine();
                if (buff.isEmpty()) {
                    this.m_input_attach_file_pagenum = 0;
                }
                if (buff.equals("end")) {
                    this.m_input_attach_file_pagenum = input_reader_p.getNumberOfPages();
                } else {
                    Pattern p = Pattern.compile("([0-9]*).*");
                    Matcher m = p.matcher(buff);
                    m.matches();
                    try {
                        this.m_input_attach_file_pagenum = Integer.valueOf(m.group(1));
                    }
                    catch (NumberFormatException e) {
                        this.m_input_attach_file_pagenum = 0;
                    }
                }
            } else if (this.m_input_attach_file_pagenum == -2) {
                this.m_input_attach_file_pagenum = input_reader_p.getNumberOfPages();
            }
            if (this.m_input_attach_file_pagenum != 0) {
                int trans = 27;
                int margin = 18;
                if (0 < this.m_input_attach_file_pagenum && this.m_input_attach_file_pagenum <= input_reader_p.getNumberOfPages()) {
                    PdfDictionary page_p = input_reader_p.getPageN(this.m_input_attach_file_pagenum);
                    if (page_p != null && page_p.isDictionary()) {
                        Rectangle crop_box_p = input_reader_p.getCropBox(this.m_input_attach_file_pagenum);
                        float corner_top = crop_box_p.top() - 18.0f;
                        float corner_left = crop_box_p.left() + 18.0f;
                        PdfObject annots_po = PdfReader.getPdfObject(page_p.get(PdfName.ANNOTS));
                        boolean annots_new_b = false;
                        if (annots_po == null) {
                            annots_po = new PdfArray();
                            annots_new_b = true;
                        }
                        if (annots_po.isArray()) {
                            Object annot_bbox_p;
                            PdfArray annots_p = (PdfArray)annots_po;
                            ArrayList annots_array_p = annots_p.getArrayList();
                            for (PdfObject ii : annots_array_p) {
                                ArrayList bbox_array_p;
                                PdfObject annot_p = PdfReader.getPdfObject(ii);
                                if (annot_p == null || !annot_p.isDictionary()) continue;
                                annot_bbox_p = PdfReader.getPdfObject(((PdfDictionary)annot_p).get(PdfName.RECT));
                                if (annot_bbox_p == null || !((PdfObject)annot_bbox_p).isArray() || (bbox_array_p = ((PdfArray)annot_bbox_p).getArrayList()).size() != 4) continue;
                                corner_top = ((PdfNumber)bbox_array_p.get(1)).floatValue();
                                corner_left = ((PdfNumber)bbox_array_p.get(2)).floatValue();
                            }
                            for (String vit : this.m_input_attach_file_filename) {
                                if (vit.equals("PROMPT")) {
                                    vit = pdftk.prompt_for_filename("Please enter a filename for attachment:");
                                }
                                String filename = attachments.drop_path(vit);
                                if (crop_box_p.right() < corner_left + 27.0f) {
                                    corner_left = crop_box_p.left() + 18.0f;
                                }
                                if (corner_top - 27.0f < crop_box_p.bottom()) {
                                    corner_top = crop_box_p.top() - 18.0f;
                                }
                                annot_bbox_p = new Rectangle(corner_left, corner_top - 27.0f, corner_left + 27.0f, corner_top);
                                PdfAnnotation annot_p = PdfAnnotation.createFileAttachment(writer_p, (Rectangle)annot_bbox_p, filename, null, vit, filename);
                                PdfIndirectReference ref_p = writer_p.addToBody(annot_p).getIndirectReference();
                                annots_p.add(ref_p);
                                corner_left += 27.0f;
                                corner_top -= 27.0f;
                            }
                            if (annots_new_b) {
                                PdfIndirectReference ref_p = writer_p.addToBody(annots_p).getIndirectReference();
                                page_p.put(PdfName.ANNOTS, ref_p);
                            }
                        }
                    } else {
                        System.err.println("Internal Error: unable to get page dictionary");
                    }
                } else {
                    System.err.print("Error: page number " + this.m_input_attach_file_pagenum);
                    System.err.println(" is not present in the input PDF.");
                }
            } else {
                PdfDictionary catalog_p = input_reader_p.catalog;
                if (catalog_p != null && catalog_p.isDictionary()) {
                    PdfObject names_po = PdfReader.getPdfObject(catalog_p.get(PdfName.NAMES));
                    boolean names_new_b = false;
                    if (names_po == null) {
                        names_po = new PdfDictionary();
                        names_new_b = true;
                    }
                    if (names_po != null && names_po.isDictionary()) {
                        PdfDictionary names_p = (PdfDictionary)names_po;
                        PdfObject emb_files_tree_p = PdfReader.getPdfObject(names_p.get(PdfName.EMBEDDEDFILES));
                        HashMap<String, PdfIndirectReference> emb_files_map_p = null;
                        boolean emb_files_tree_new_b = false;
                        if (emb_files_tree_p != null) {
                            emb_files_map_p = PdfNameTree.readTree((PdfDictionary)emb_files_tree_p);
                        } else {
                            emb_files_map_p = new HashMap<String, PdfIndirectReference>();
                            emb_files_tree_new_b = true;
                        }
                        for (String vit : this.m_input_attach_file_filename) {
                            if (vit.equals("PROMPT")) {
                                vit = pdftk.prompt_for_filename("Please enter a filename for attachment:");
                            }
                            String filename = attachments.drop_path(vit);
                            PdfFileSpecification filespec_p = null;
                            try {
                                filespec_p = PdfFileSpecification.fileEmbedded(writer_p, vit, filename, null);
                            }
                            catch (IOException ioe_p) {
                                System.err.println("Error: Failed to open attachment file: ");
                                System.err.println("   " + vit);
                                System.err.println("   Skipping this file.");
                                continue;
                            }
                            PdfIndirectReference ref_p = writer_p.addToBody(filespec_p).getIndirectReference();
                            String key_p = vit;
                            int counter = 1;
                            while (emb_files_map_p.containsKey(key_p)) {
                                key_p = vit + "-" + counter;
                                ++counter;
                            }
                            emb_files_map_p.put(key_p, ref_p);
                        }
                        if (!emb_files_map_p.isEmpty()) {
                            PdfIndirectReference ref_p;
                            PdfDictionary emb_files_tree_new_p = PdfNameTree.writeTree(emb_files_map_p, writer_p);
                            if (emb_files_tree_new_b && emb_files_tree_new_p != null) {
                                ref_p = writer_p.addToBody(emb_files_tree_new_p).getIndirectReference();
                                names_p.put(PdfName.EMBEDDEDFILES, ref_p);
                            } else if (emb_files_tree_p != null && emb_files_tree_new_p != null) {
                                ((PdfDictionary)emb_files_tree_p).merge(emb_files_tree_new_p);
                            } else {
                                System.err.println("Internal Error: no valid EmbeddedFiles tree to add to PDF.");
                            }
                            if (names_new_b) {
                                ref_p = writer_p.addToBody(names_p).getIndirectReference();
                                catalog_p.put(PdfName.NAMES, ref_p);
                            }
                        }
                    } else {
                        System.err.println("Internal Error: couldn't read or create PDF Names dictionary.");
                    }
                } else {
                    System.err.println("Internal Error: couldn't read input PDF Root dictionary.");
                    System.err.println("   File attachment failed; no new files attached to output.");
                }
            }
        }
    }

    void unpack_files(PdfReader input_reader_p) {
        String output_pathname = attachments.normalize_pathname(this.m_output_filename);
        PdfDictionary catalog_p = input_reader_p.catalog;
        if (catalog_p != null && catalog_p.isDictionary()) {
            PdfObject names_p = PdfReader.getPdfObject(catalog_p.get(PdfName.NAMES));
            if (names_p != null && names_p.isDictionary()) {
                PdfObject emb_files_tree_p = PdfReader.getPdfObject(((PdfDictionary)names_p).get(PdfName.EMBEDDEDFILES));
                HashMap emb_files_map_p = null;
                if (emb_files_tree_p != null && emb_files_tree_p.isDictionary()) {
                    emb_files_map_p = PdfNameTree.readTree((PdfDictionary)emb_files_tree_p);
                    for (PdfObject value_p : emb_files_map_p.values()) {
                        PdfObject filespec_p = PdfReader.getPdfObject(value_p);
                        if (filespec_p == null || !filespec_p.isDictionary()) continue;
                        attachments.unpack_file(input_reader_p, (PdfDictionary)filespec_p, output_pathname, this.m_ask_about_warnings_b);
                    }
                }
            }
        }
        int num_pages = input_reader_p.getNumberOfPages();
        for (int ii = 1; ii <= num_pages; ++ii) {
            PdfDictionary page_p = input_reader_p.getPageN(ii);
            if (page_p == null || !page_p.isDictionary()) continue;
            PdfObject annots_p = PdfReader.getPdfObject(page_p.get(PdfName.ANNOTS));
            if (annots_p == null || !annots_p.isArray()) continue;
            ArrayList annots_array_p = ((PdfArray)annots_p).getArrayList();
            for (PdfObject jj : annots_array_p) {
                PdfObject annot_po = PdfReader.getPdfObject(jj);
                if (annot_po == null || !annot_po.isDictionary()) continue;
                PdfDictionary annot_p = (PdfDictionary)annot_po;
                PdfObject subtype_p = PdfReader.getPdfObject(annot_p.get(PdfName.SUBTYPE));
                if (subtype_p == null || !subtype_p.equals(PdfName.FILEATTACHMENT)) continue;
                PdfObject filespec_p = PdfReader.getPdfObject(annot_p.get(PdfName.FS));
                if (filespec_p == null || !filespec_p.isDictionary()) continue;
                attachments.unpack_file(input_reader_p, (PdfDictionary)filespec_p, output_pathname, this.m_ask_about_warnings_b);
            }
        }
    }

    static void add_mark_to_page(PdfReader reader_p, int page_index, int page_num) {
        PdfName page_marker_p = new PdfName(g_page_marker);
        PdfDictionary page_p = reader_p.getPageN(page_index);
        if (page_p != null && page_p.isDictionary()) {
            page_p.put(page_marker_p, new PdfNumber(page_num));
        }
    }

    static void add_marks_to_pages(PdfReader reader_p) {
        int num_pages = reader_p.getNumberOfPages();
        for (int ii = 1; ii <= num_pages; ++ii) {
            TK_Session.add_mark_to_page(reader_p, ii, ii);
        }
    }

    static void remove_mark_from_page(PdfReader reader_p, int page_num) {
        PdfName page_marker_p = new PdfName(g_page_marker);
        PdfDictionary page_p = reader_p.getPageN(page_num);
        if (page_p != null && page_p.isDictionary()) {
            page_p.remove(page_marker_p);
        }
    }

    static void remove_marks_from_pages(PdfReader reader_p) {
        int num_pages = reader_p.getNumberOfPages();
        for (int ii = 1; ii <= num_pages; ++ii) {
            TK_Session.remove_mark_from_page(reader_p, ii);
        }
    }

    static void apply_rotation_to_page(PdfReader reader_p, int page_num, int rotation, boolean absolute) {
        PdfDictionary page_p = reader_p.getPageN(page_num);
        if (!absolute) {
            rotation = reader_p.getPageRotation(page_num) + rotation;
        }
        page_p.remove(PdfName.ROTATE);
        if ((rotation %= 360) != PageRotate.NORTH.value) {
            page_p.put(PdfName.ROTATE, new PdfNumber(rotation));
        }
    }

    ErrorCode create_output_page(PdfCopy writer_p, PageRef page_ref, int output_page_count) {
        ErrorCode ret_val = ErrorCode.NO_ERROR;
        if (page_ref.m_input_pdf_index < this.m_input_pdf.size()) {
            InputPdf page_pdf = this.m_input_pdf.get(page_ref.m_input_pdf_index);
            if (this.m_verbose_reporting_b) {
                System.out.print("   Adding page " + page_ref.m_page_num + " X" + (Object)((Object)page_ref.m_page_rot) + "X ");
                System.out.println(" from " + page_pdf.m_filename);
            }
            PdfReader input_reader_p = null;
            for (InputPdf.PagesReader mt : page_pdf.m_readers) {
                if (!mt.first.contains(page_ref.m_page_num)) continue;
                input_reader_p = mt.second;
                mt.first.remove(page_ref.m_page_num);
                break;
            }
            if (input_reader_p != null) {
                if (this.m_output_uncompress_b) {
                    TK_Session.add_mark_to_page(input_reader_p, page_ref.m_page_num, output_page_count + 1);
                } else if (this.m_output_compress_b) {
                    TK_Session.remove_mark_from_page(input_reader_p, page_ref.m_page_num);
                }
                TK_Session.apply_rotation_to_page(input_reader_p, page_ref.m_page_num, page_ref.m_page_rot.value, page_ref.m_page_abs);
                try {
                    PdfImportedPage page_p = writer_p.getImportedPage(input_reader_p, page_ref.m_page_num);
                    try {
                        writer_p.addPage(page_p);
                    }
                    catch (DocumentException e) {
                        System.err.print("Internal Error: addPage() failed for: ");
                        System.err.println(page_ref.m_page_num + " in file: " + page_pdf.m_filename);
                        ret_val = ErrorCode.BUG;
                    }
                }
                catch (IOException e) {
                    System.err.print("Internal Error: getImportedPage() failed for: ");
                    System.err.println(page_ref.m_page_num + " in file: " + page_pdf.m_filename);
                    ret_val = ErrorCode.BUG;
                }
            } else {
                System.err.print("Internal Error: no reader found for page: ");
                System.err.println(page_ref.m_page_num + " in file: " + page_pdf.m_filename);
                ret_val = ErrorCode.BUG;
            }
        } else {
            System.err.println("Internal Error: Unable to find handle in m_input_pdf.");
            ret_val = ErrorCode.BUG;
        }
        return ret_val;
    }

    static char GetPdfVersionChar(PdfName version_p) {
        int version_cc = 52;
        if (version_p != null) {
            if (version_p.equals(PdfName.VERSION_1_4)) {
                version_cc = 52;
            } else if (version_p.equals(PdfName.VERSION_1_5)) {
                version_cc = 53;
            } else if (version_p.equals(PdfName.VERSION_1_6)) {
                version_cc = 54;
            } else if (version_p.equals(PdfName.VERSION_1_7)) {
                version_cc = 55;
            } else if (version_p.equals(PdfName.VERSION_1_3)) {
                version_cc = 51;
            } else if (version_p.equals(PdfName.VERSION_1_2)) {
                version_cc = 50;
            } else if (version_p.equals(PdfName.VERSION_1_1)) {
                version_cc = 49;
            } else if (version_p.equals(PdfName.VERSION_1_0)) {
                version_cc = 48;
            }
        }
        return (char)version_cc;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    ErrorCode create_output() {
        ErrorCode ret_val = ErrorCode.NO_ERROR;
        if (!this.is_valid()) return ErrorCode.ERROR;
        if (this.m_verbose_reporting_b) {
            System.out.println();
            System.out.println("Creating Output ...");
        }
        String creator = "pdftk-java 3.1.2";
        if (this.m_output_owner_pw.equals("PROMPT")) {
            this.m_output_owner_pw = pdftk.prompt_for_password("owner", "the output PDF");
        }
        if (this.m_output_user_pw.equals("PROMPT")) {
            this.m_output_user_pw = pdftk.prompt_for_password("user", "the output PDF");
        }
        byte[] output_owner_pw_p = new byte[]{};
        if (!this.m_output_owner_pw.isEmpty() && (output_owner_pw_p = passwords.utf8_password_to_pdfdoc(this.m_output_owner_pw, true)) == null) {
            System.err.println("Error: Owner password used to encrypt output PDF includes");
            System.err.println("   invalid characters.");
            System.err.println("   No output created.");
            ret_val = ErrorCode.ERROR;
        }
        byte[] output_user_pw_p = new byte[]{};
        if (!this.m_output_user_pw.isEmpty() && (output_user_pw_p = passwords.utf8_password_to_pdfdoc(this.m_output_user_pw, true)) == null) {
            System.err.println("Error: User password used to encrypt output PDF includes");
            System.err.println("   invalid characters.");
            System.err.println("   No output created.");
            ret_val = ErrorCode.ERROR;
        }
        if (ret_val != ErrorCode.NO_ERROR) {
            return ret_val;
        }
        try {
            switch (this.m_operation) {
                case cat_k: 
                case shuffle_k: {
                    Document output_doc_p = new Document();
                    OutputStream ofs_p = pdftk.get_output_stream(this.m_output_filename, this.m_ask_about_warnings_b);
                    if (ofs_p == null) {
                        return ErrorCode.ERROR;
                    }
                    PdfCopy writer_p = new PdfCopy(output_doc_p, ofs_p);
                    char max_version_cc = '2';
                    output_doc_p.addCreator(creator);
                    if (this.m_output_uncompress_b) {
                        writer_p.filterStreams = true;
                        writer_p.compressStreams = false;
                    } else if (this.m_output_compress_b) {
                        writer_p.filterStreams = false;
                        writer_p.compressStreams = true;
                    }
                    if (this.m_output_encryption_strength != encryption_strength.none_enc || !this.m_output_owner_pw.isEmpty() || !this.m_output_user_pw.isEmpty()) {
                        boolean bit128_b = this.m_output_encryption_strength != encryption_strength.bits40_enc;
                        writer_p.setEncryption(output_user_pw_p, output_owner_pw_p, this.m_output_user_perms, bit128_b);
                        max_version_cc = bit128_b ? (char)'4' : '3';
                    }
                    if (this.m_output_keep_first_id_b || this.m_output_keep_final_id_b) {
                        PdfReader input_reader_p = this.m_output_keep_first_id_b ? this.m_input_pdf.get((int)0).m_readers.get((int)0).second : this.m_input_pdf.get((int)(this.m_input_pdf.size() - 1)).m_readers.get((int)0).second;
                        PdfDictionary trailer_p = input_reader_p.getTrailer();
                        PdfObject file_id_p = PdfReader.getPdfObject(trailer_p.get(PdfName.ID));
                        if (file_id_p != null && file_id_p.isArray()) {
                            writer_p.setFileID(file_id_p);
                        }
                    }
                    HashMap<PdfName, PdfName> ext_base_versions = new HashMap<PdfName, PdfName>();
                    HashMap<PdfName, Integer> ext_levels = new HashMap<PdfName, Integer>();
                    for (InputPdf it : this.m_input_pdf) {
                        PdfDictionary pdfDictionary;
                        PdfReader reader_p = it.m_readers.get((int)0).second;
                        if (max_version_cc < reader_p.getPdfVersion()) {
                            max_version_cc = reader_p.getPdfVersion();
                        }
                        if ((pdfDictionary = reader_p.getCatalog()).contains(PdfName.VERSION)) {
                            PdfName version_p = (PdfName)PdfReader.getPdfObject(pdfDictionary.get(PdfName.VERSION));
                            char version_cc = TK_Session.GetPdfVersionChar(version_p);
                            if (max_version_cc < version_cc) {
                                max_version_cc = version_cc;
                            }
                        }
                        if (!pdfDictionary.contains(PdfName.EXTENSIONS)) continue;
                        PdfObject extensions_po = PdfReader.getPdfObject(pdfDictionary.get(PdfName.EXTENSIONS));
                        if (extensions_po == null || !extensions_po.isDictionary()) continue;
                        PdfDictionary extensions_p = (PdfDictionary)extensions_po;
                        Set keys_p = extensions_p.getKeys();
                        for (PdfObject kit : keys_p) {
                            PdfDictionary dev_exts_p;
                            PdfName developer_p = (PdfName)PdfReader.getPdfObject(kit);
                            PdfObject dev_exts_po = PdfReader.getPdfObject(extensions_p.get(developer_p));
                            if (dev_exts_po == null || !dev_exts_po.isDictionary() || !(dev_exts_p = (PdfDictionary)dev_exts_po).contains(PdfName.BASEVERSION) || !dev_exts_p.contains(PdfName.EXTENSIONLEVEL)) continue;
                            PdfName base_version_p = (PdfName)PdfReader.getPdfObject(dev_exts_p.get(PdfName.BASEVERSION));
                            PdfNumber ext_level_p = (PdfNumber)PdfReader.getPdfObject(dev_exts_p.get(PdfName.EXTENSIONLEVEL));
                            if (!ext_base_versions.containsKey(developer_p) || TK_Session.GetPdfVersionChar((PdfName)ext_base_versions.get(developer_p)) < TK_Session.GetPdfVersionChar(base_version_p)) {
                                ext_base_versions.put(developer_p, base_version_p);
                                ext_levels.put(developer_p, ext_level_p.intValue());
                                continue;
                            }
                            if (TK_Session.GetPdfVersionChar((PdfName)ext_base_versions.get(developer_p)) != TK_Session.GetPdfVersionChar(base_version_p) || (Integer)ext_levels.get(developer_p) >= ext_level_p.intValue()) continue;
                            ext_levels.put(developer_p, ext_level_p.intValue());
                        }
                    }
                    writer_p.setPdfVersion(max_version_cc);
                    output_doc_p.open();
                    if (!ext_base_versions.isEmpty()) {
                        PdfDictionary extensions_dict_p = new PdfDictionary();
                        PdfIndirectReference extensions_ref_p = writer_p.getPdfIndirectReference();
                        for (Map.Entry entry : ext_base_versions.entrySet()) {
                            PdfDictionary ext_dict_p = new PdfDictionary();
                            ext_dict_p.put(PdfName.BASEVERSION, (PdfObject)entry.getValue());
                            ext_dict_p.put(PdfName.EXTENSIONLEVEL, new PdfNumber((Integer)ext_levels.get(entry.getKey())));
                            extensions_dict_p.put((PdfName)entry.getKey(), ext_dict_p);
                        }
                        writer_p.addToBody((PdfObject)extensions_dict_p, extensions_ref_p);
                        writer_p.setExtensions(extensions_ref_p);
                    }
                    if (this.m_operation == keyword.shuffle_k) {
                        int max_seq_length = 0;
                        for (ArrayList<PageRef> jt : this.m_page_seq) {
                            max_seq_length = max_seq_length < jt.size() ? jt.size() : max_seq_length;
                        }
                        int output_page_count = 0;
                        block35: for (int ii = 0; ii < max_seq_length && ret_val == ErrorCode.NO_ERROR; ++ii) {
                            for (ArrayList<PageRef> jt : this.m_page_seq) {
                                if (ret_val != ErrorCode.NO_ERROR) continue block35;
                                if (ii >= jt.size()) continue;
                                ret_val = this.create_output_page(writer_p, jt.get(ii), output_page_count);
                                ++output_page_count;
                            }
                        }
                    } else {
                        int output_page_count = 0;
                        block37: for (ArrayList<PageRef> jt : this.m_page_seq) {
                            if (ret_val != ErrorCode.NO_ERROR) break;
                            for (PageRef it : jt) {
                                if (ret_val != ErrorCode.NO_ERROR) continue block37;
                                ret_val = this.create_output_page(writer_p, it, output_page_count);
                                ++output_page_count;
                            }
                        }
                        if (this.m_cat_full_pdfs_b) {
                            void var14_73;
                            PdfDictionary output_outlines_p = new PdfDictionary(PdfName.OUTLINES);
                            PdfIndirectReference output_outlines_ref_p = writer_p.getPdfIndirectReference();
                            Object var14_72 = null;
                            PdfIndirectReference after_child_ref_p = null;
                            int page_count = 1;
                            int num_bookmarks_total = 0;
                            for (ArrayList<PageRef> jt : this.m_page_seq) {
                                PdfReader reader_p = this.m_input_pdf.get((int)jt.get((int)0).m_input_pdf_index).m_readers.get((int)0).second;
                                long reader_page_count = this.m_input_pdf.get((int)jt.get((int)0).m_input_pdf_index).m_num_pages;
                                PdfDictionary catalog_p = reader_p.getCatalog();
                                PdfObject outlines_p = PdfReader.getPdfObject(catalog_p.get(PdfName.OUTLINES));
                                if (outlines_p != null && outlines_p.isDictionary()) {
                                    ArrayList<PdfBookmark> bookmark_data;
                                    int rr;
                                    PdfObject top_outline_p = PdfReader.getPdfObject(((PdfDictionary)outlines_p).get(PdfName.FIRST));
                                    if (top_outline_p != null && top_outline_p.isDictionary() && (rr = bookmarks.ReadOutlines(bookmark_data = new ArrayList<PdfBookmark>(), (PdfDictionary)top_outline_p, 0, reader_p, true)) == 0 && !bookmark_data.isEmpty()) {
                                        bookmarks.BuildBookmarksState state = new bookmarks.BuildBookmarksState();
                                        state.final_child_p = var14_73;
                                        state.final_child_ref_p = after_child_ref_p;
                                        state.num_bookmarks_total = num_bookmarks_total;
                                        bookmarks.BuildBookmarks(writer_p, bookmark_data.listIterator(), output_outlines_p, output_outlines_ref_p, (PdfDictionary)var14_73, after_child_ref_p, 0, page_count - 1, 0, true, state);
                                        PdfDictionary pdfDictionary = state.final_child_p;
                                        after_child_ref_p = state.final_child_ref_p;
                                        num_bookmarks_total = state.num_bookmarks_total;
                                    }
                                }
                                page_count = (int)((long)page_count + reader_page_count);
                            }
                            if (num_bookmarks_total != 0) {
                                if (var14_73 != null && after_child_ref_p != null) {
                                    writer_p.addToBody((PdfObject)var14_73, after_child_ref_p);
                                }
                                writer_p.addToBody((PdfObject)output_outlines_p, output_outlines_ref_p);
                                writer_p.setOutlines(output_outlines_ref_p);
                            }
                        }
                    }
                    output_doc_p.close();
                    writer_p.close();
                    return ret_val;
                }
                case burst_k: {
                    if (1 < this.m_input_pdf.size()) {
                        System.err.println("Error: Only one input PDF file may be given for \"burst\" op.");
                        System.err.println("   No output created.");
                        return ErrorCode.ERROR;
                    }
                    PdfReader input_reader_p = this.m_input_pdf.get((int)0).m_readers.get((int)0).second;
                    int input_num_pages = this.m_input_pdf.get((int)0).m_num_pages;
                    if (this.m_output_filename.equals("PROMPT")) {
                        this.m_output_filename = pdftk.prompt_for_filename("Please enter a filename pattern for the PDF pages (e.g. pg_%04d.pdf):");
                    }
                    try {
                        String s1 = String.format(this.m_output_filename, 1);
                        String s2 = String.format(this.m_output_filename, 2);
                        if (s1.equals(s2)) {
                            this.m_output_filename = this.m_output_filename + "pg_%04d.pdf";
                            String.format(this.m_output_filename, 1);
                        }
                    }
                    catch (IllegalFormatException e) {
                        System.err.println("Error: Invalid output pattern:");
                        System.err.println("   " + this.m_output_filename);
                        System.err.println("   No output created.");
                        return ErrorCode.ERROR;
                    }
                    PdfDictionary input_info_p = null;
                    PdfDictionary input_trailer_p = input_reader_p.getTrailer();
                    if (input_trailer_p != null) {
                        PdfObject input_info_po = PdfReader.getPdfObject(input_trailer_p.get(PdfName.INFO));
                        if (input_info_po != null && input_info_po.isDictionary()) {
                            input_info_p = (PdfDictionary)input_info_po;
                        }
                    }
                    for (int ii = 0; ii < input_num_pages; ++ii) {
                        byte[] input_reader_xmp_p;
                        PdfDictionary pdfDictionary;
                        PdfDictionary writer_info_p;
                        String output_filename_p = String.format(this.m_output_filename, ii + 1);
                        OutputStream ofs_p = pdftk.get_output_stream_file(output_filename_p);
                        if (ofs_p == null) {
                            ret_val = ErrorCode.ERROR;
                            continue;
                        }
                        Document output_doc_p = new Document();
                        PdfCopy writer_p = new PdfCopy(output_doc_p, ofs_p);
                        output_doc_p.addCreator(creator);
                        if (this.m_output_uncompress_b) {
                            writer_p.filterStreams = true;
                            writer_p.compressStreams = false;
                        } else if (this.m_output_compress_b) {
                            writer_p.filterStreams = false;
                            writer_p.compressStreams = true;
                        }
                        if (this.m_output_encryption_strength != encryption_strength.none_enc || !this.m_output_owner_pw.isEmpty() || !this.m_output_user_pw.isEmpty()) {
                            boolean bit128_b = this.m_output_encryption_strength != encryption_strength.bits40_enc;
                            writer_p.setEncryption(output_user_pw_p, output_owner_pw_p, this.m_output_user_perms, bit128_b);
                        }
                        output_doc_p.open();
                        writer_p.setFromReader(input_reader_p);
                        if (input_info_p != null && (writer_info_p = writer_p.getInfo()) != null && (pdfDictionary = writer_p.copyDictionary(input_info_p)) != null) {
                            writer_info_p.putAll(pdfDictionary);
                        }
                        if ((input_reader_xmp_p = input_reader_p.getMetadata()) != null) {
                            writer_p.setXmpMetadata(input_reader_xmp_p);
                        }
                        PdfImportedPage page_p = writer_p.getImportedPage(input_reader_p, ii + 1);
                        writer_p.addPage(page_p);
                        output_doc_p.close();
                        writer_p.close();
                    }
                    String doc_data_fn = "doc_data.txt";
                    int loc = this.m_output_filename.lastIndexOf(File.separatorChar);
                    if (loc >= 0) {
                        doc_data_fn = this.m_output_filename.substring(0, loc) + File.separatorChar + doc_data_fn;
                    }
                    try {
                        PrintStream ofs = pdftk.get_print_stream(doc_data_fn, this.m_output_utf8_b);
                        report.ReportOnPdf(ofs, input_reader_p, this.m_output_utf8_b);
                        return ret_val;
                    }
                    catch (IOException e) {
                        System.err.println("Error: unable to open file for output: doc_data.txt");
                        return ErrorCode.ERROR;
                    }
                }
                case filter_k: {
                    PdfDictionary catalog_p;
                    PdfDictionary catalog_p2;
                    OutputStream ofs_p;
                    if (1 < this.m_input_pdf.size()) {
                        System.err.println("Error: Only one input PDF file may be given for this");
                        System.err.println("   operation.  Maybe you meant to use the \"cat\" operator?");
                        System.err.println("   No output created.");
                        return ErrorCode.ERROR;
                    }
                    FdfReader fdf_reader_p = null;
                    XfdfReader xfdf_reader_p = null;
                    if (this.m_form_data_filename.equals("PROMPT")) {
                        this.m_form_data_filename = pdftk.prompt_for_filename("Please enter a filename for the form data:");
                    }
                    if (!this.m_form_data_filename.isEmpty()) {
                        if (this.m_form_data_filename.equals("-")) {
                            try {
                                fdf_reader_p = new FdfReader(System.in);
                            }
                            catch (IOException ioe_p) {
                                try {
                                    xfdf_reader_p = new XfdfReader(System.in);
                                }
                                catch (IOException ioe2_p) {
                                    System.err.println("Error: Failed read form data on stdin.");
                                    System.err.println("   No output created.");
                                    return ErrorCode.ERROR;
                                }
                            }
                        } else {
                            try {
                                fdf_reader_p = new FdfReader(this.m_form_data_filename);
                            }
                            catch (IOException ioe_p) {
                                try {
                                    xfdf_reader_p = new XfdfReader(this.m_form_data_filename);
                                }
                                catch (IOException ioe2_p) {
                                    System.err.println("Error: Failed to open form data file: ");
                                    System.err.println("   " + this.m_form_data_filename);
                                    System.err.println("   No output created.");
                                    return ErrorCode.ERROR;
                                }
                            }
                        }
                    }
                    PdfReader mark_p = null;
                    boolean background_b = true;
                    if (this.m_background_filename.equals("PROMPT")) {
                        this.m_background_filename = pdftk.prompt_for_filename("Please enter a filename for the background PDF:");
                    }
                    if (!this.m_background_filename.isEmpty()) {
                        try {
                            mark_p = new PdfReader(this.m_background_filename);
                            mark_p.removeUnusedObjects();
                        }
                        catch (IOException ioe_p) {
                            System.err.println("Error: Failed to open background PDF file: ");
                            System.err.println("   " + this.m_background_filename);
                            System.err.println("   No output created.");
                            return ErrorCode.ERROR;
                        }
                    }
                    if (mark_p == null) {
                        if (this.m_stamp_filename.equals("PROMPT")) {
                            this.m_stamp_filename = pdftk.prompt_for_filename("Please enter a filename for the stamp PDF:");
                        }
                        if (!this.m_stamp_filename.isEmpty()) {
                            background_b = false;
                            try {
                                mark_p = new PdfReader(this.m_stamp_filename);
                                mark_p.removeUnusedObjects();
                            }
                            catch (IOException ioe_p) {
                                System.err.println("Error: Failed to open stamp PDF file: ");
                                System.err.println("   " + this.m_stamp_filename);
                                System.err.println("   No output created.");
                                return ErrorCode.ERROR;
                            }
                        }
                    }
                    if ((ofs_p = pdftk.get_output_stream(this.m_output_filename, this.m_ask_about_warnings_b)) == null) {
                        System.err.println("Error: unable to open file for output: " + this.m_output_filename);
                        return ErrorCode.ERROR;
                    }
                    PdfReader input_reader_p = this.m_input_pdf.get((int)0).m_readers.get((int)0).second;
                    if (this.m_output_drop_xfa_b && (catalog_p2 = input_reader_p.catalog) != null && catalog_p2.isDictionary()) {
                        PdfObject acro_form_p = PdfReader.getPdfObject(catalog_p2.get(PdfName.ACROFORM));
                        if (acro_form_p != null && acro_form_p.isDictionary()) {
                            ((PdfDictionary)acro_form_p).remove(PdfName.XFA);
                        }
                    }
                    if (this.m_output_drop_xmp_b && (catalog_p2 = input_reader_p.catalog) != null) {
                        catalog_p2.remove(PdfName.METADATA);
                    }
                    PdfStamperImp writer_p = new PdfStamperImp(input_reader_p, ofs_p, '\u0000', false);
                    if (this.m_update_info_filename.equals("PROMPT")) {
                        this.m_update_info_filename = pdftk.prompt_for_filename("Please enter an Info file filename:");
                    }
                    if (!this.m_update_info_filename.isEmpty()) {
                        if (this.m_update_info_filename.equals("-")) {
                            if (!data_import.UpdateInfo(input_reader_p, System.in, this.m_update_info_utf8_b)) {
                                System.err.println("Warning: no Info added to output PDF.");
                                ret_val = ErrorCode.WARNING;
                            }
                        } else {
                            try {
                                FileInputStream ifs = new FileInputStream(this.m_update_info_filename);
                                if (!data_import.UpdateInfo(input_reader_p, ifs, this.m_update_info_utf8_b)) {
                                    System.err.println("Warning: no Info added to output PDF.");
                                    ret_val = ErrorCode.WARNING;
                                }
                            }
                            catch (FileNotFoundException e) {
                                System.err.println("Error: unable to open FDF file for input: " + this.m_update_info_filename);
                                return ErrorCode.ERROR;
                            }
                        }
                    }
                    if (!this.m_page_seq.isEmpty()) {
                        for (ArrayList<PageRef> jt : this.m_page_seq) {
                            for (PageRef kt : jt) {
                                TK_Session.apply_rotation_to_page(input_reader_p, kt.m_page_num, kt.m_page_rot.value, kt.m_page_abs);
                            }
                        }
                    }
                    if (this.m_output_uncompress_b) {
                        TK_Session.add_marks_to_pages(input_reader_p);
                        writer_p.filterStreams = true;
                        writer_p.compressStreams = false;
                    } else if (this.m_output_compress_b) {
                        TK_Session.remove_marks_from_pages(input_reader_p);
                        writer_p.filterStreams = false;
                        writer_p.compressStreams = true;
                    }
                    if (this.m_output_encryption_strength != encryption_strength.none_enc || !this.m_output_owner_pw.isEmpty() || !this.m_output_user_pw.isEmpty()) {
                        boolean bit128_b = this.m_output_encryption_strength != encryption_strength.bits40_enc;
                        writer_p.setEncryption(output_user_pw_p, output_owner_pw_p, this.m_output_user_perms, bit128_b);
                    }
                    if (fdf_reader_p != null || xfdf_reader_p != null) {
                        if (input_reader_p.getAcroForm() != null) {
                            AcroFields fields_p = writer_p.getAcroFields();
                            fields_p.setGenerateAppearances(true);
                            if (fdf_reader_p != null && fields_p.setFields(fdf_reader_p) || xfdf_reader_p != null && fields_p.setFields(xfdf_reader_p)) {
                                this.m_output_need_appearances_b = true;
                            }
                        } else {
                            System.err.println("Warning: input PDF is not an acroform, so its fields were not filled.");
                            ret_val = ErrorCode.WARNING;
                        }
                    }
                    writer_p.setFormFlattening(this.m_output_flatten_b);
                    if (this.m_output_need_appearances_b && (catalog_p = input_reader_p.catalog) != null && catalog_p.isDictionary()) {
                        PdfObject acro_form_p = PdfReader.getPdfObject(catalog_p.get(PdfName.ACROFORM));
                        if (acro_form_p != null && acro_form_p.isDictionary()) {
                            ((PdfDictionary)acro_form_p).put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
                        }
                    }
                    if (mark_p != null) {
                        int mark_num_pages = 1;
                        if (this.m_multistamp_b || this.m_multibackground_b) {
                            mark_num_pages = mark_p.getNumberOfPages();
                        }
                        PdfImportedPage mark_page_p = null;
                        Object var14_77 = null;
                        int mark_page_rotation = 0;
                        int num_pages = input_reader_p.getNumberOfPages();
                        int ii = 0;
                        while (ii < num_pages) {
                            PdfContentByte content_byte_p;
                            float v_scale;
                            void var14_78;
                            if (++ii <= mark_num_pages) {
                                Rectangle rectangle = mark_p.getCropBox(ii);
                                mark_page_rotation = mark_p.getPageRotation(ii);
                                for (int mm = 0; mm < mark_page_rotation; mm += 90) {
                                    void var14_80;
                                    Rectangle rectangle2 = var14_80.rotate();
                                }
                                mark_page_p = writer_p.getImportedPage(mark_p, ii);
                            }
                            Rectangle doc_page_size_p = input_reader_p.getCropBox(ii);
                            int doc_page_rotation = input_reader_p.getPageRotation(ii);
                            for (int mm = 0; mm < doc_page_rotation; mm += 90) {
                                doc_page_size_p = doc_page_size_p.rotate();
                            }
                            float h_scale = doc_page_size_p.width() / var14_78.width();
                            float mark_scale = h_scale < (v_scale = doc_page_size_p.height() / var14_78.height()) ? h_scale : v_scale;
                            float h_trans = (float)((double)(doc_page_size_p.left() - var14_78.left() * mark_scale) + (double)(doc_page_size_p.width() - var14_78.width() * mark_scale) / 2.0);
                            float v_trans = (float)((double)(doc_page_size_p.bottom() - var14_78.bottom() * mark_scale) + (double)(doc_page_size_p.height() - var14_78.height() * mark_scale) / 2.0);
                            PdfContentByte pdfContentByte = content_byte_p = background_b ? writer_p.getUnderContent(ii) : writer_p.getOverContent(ii);
                            if (mark_page_rotation == 0) {
                                content_byte_p.addTemplate(mark_page_p, mark_scale, 0.0f, 0.0f, mark_scale, h_trans, v_trans);
                                continue;
                            }
                            if (mark_page_rotation == 90) {
                                content_byte_p.addTemplate(mark_page_p, 0.0f, -1.0f * mark_scale, mark_scale, 0.0f, h_trans, v_trans + var14_78.height() * mark_scale);
                                continue;
                            }
                            if (mark_page_rotation == 180) {
                                content_byte_p.addTemplate(mark_page_p, -1.0f * mark_scale, 0.0f, 0.0f, -1.0f * mark_scale, h_trans + var14_78.width() * mark_scale, v_trans + var14_78.height() * mark_scale);
                                continue;
                            }
                            if (mark_page_rotation != 270) continue;
                            content_byte_p.addTemplate(mark_page_p, 0.0f, mark_scale, -1.0f * mark_scale, 0.0f, h_trans + var14_78.width() * mark_scale, v_trans);
                        }
                    }
                    if (!this.m_input_attach_file_filename.isEmpty()) {
                        this.attach_files(input_reader_p, writer_p);
                    }
                    input_reader_p.removeUnusedObjects();
                    writer_p.close();
                    return ret_val;
                }
                case dump_data_k: 
                case dump_data_fields_k: 
                case dump_data_annots_k: {
                    if (1 < this.m_input_pdf.size()) {
                        System.err.println("Error: Only one input PDF file may be used for the dump_data operation");
                        System.err.println("   No output created.");
                        return ErrorCode.ERROR;
                    }
                    PdfReader input_reader_p = this.m_input_pdf.get((int)0).m_readers.get((int)0).second;
                    try {
                        PrintStream ofs = pdftk.get_print_stream(this.m_output_filename, this.m_output_utf8_b);
                        if (this.m_operation == keyword.dump_data_k) {
                            report.ReportOnPdf(ofs, input_reader_p, this.m_output_utf8_b);
                            return ret_val;
                        }
                        if (this.m_operation == keyword.dump_data_fields_k) {
                            report.ReportAcroFormFields(ofs, input_reader_p, this.m_output_utf8_b);
                            return ret_val;
                        }
                        if (this.m_operation != keyword.dump_data_annots_k) return ret_val;
                        report.ReportAnnots(ofs, input_reader_p, this.m_output_utf8_b);
                        return ret_val;
                    }
                    catch (FileNotFoundException e) {
                        System.err.println("Error: unable to open file for output: " + this.m_output_filename);
                    }
                    return ret_val;
                }
                case generate_fdf_k: {
                    if (1 < this.m_input_pdf.size()) {
                        System.err.println("Error: Only one input PDF file may be used for the generate_fdf operation");
                        System.err.println("   No output created.");
                        return ErrorCode.ERROR;
                    }
                    PdfReader input_reader_p = this.m_input_pdf.get((int)0).m_readers.get((int)0).second;
                    OutputStream ofs_p = pdftk.get_output_stream(this.m_output_filename, this.m_ask_about_warnings_b);
                    if (ofs_p == null) return ErrorCode.ERROR;
                    FdfWriter writer_p = new FdfWriter();
                    input_reader_p.getAcroFields().exportAsFdf(writer_p);
                    writer_p.writeTo(ofs_p);
                    return ret_val;
                }
                case unpack_files_k: {
                    if (1 < this.m_input_pdf.size()) {
                        System.err.println("Error: Only one input PDF file may be given for \"unpack_files\" op.");
                        System.err.println("   No output created.");
                        return ErrorCode.ERROR;
                    }
                    PdfReader input_reader_p = this.m_input_pdf.get((int)0).m_readers.get((int)0).second;
                    this.unpack_files(input_reader_p);
                    return ret_val;
                }
                default: {
                    System.err.println("Unexpected pdftk Error in create_output()");
                    return ErrorCode.BUG;
                }
            }
        }
        catch (NoClassDefFoundError error) {
            pdftk.describe_missing_library(error);
            return ErrorCode.ERROR;
        }
        catch (Throwable t_p) {
            System.err.println("Unhandled Java Exception in create_output():");
            t_p.printStackTrace();
            return ErrorCode.BUG;
        }
    }

    private boolean handle_some_output_options(keyword kw, ArgStateMutable arg_state_p) {
        switch (kw) {
            case output_k: {
                arg_state_p.value = ArgState.output_filename_e;
                break;
            }
            case owner_pw_k: {
                arg_state_p.value = ArgState.output_owner_pw_e;
                break;
            }
            case user_pw_k: {
                arg_state_p.value = ArgState.output_user_pw_e;
                break;
            }
            case user_perms_k: {
                arg_state_p.value = ArgState.output_user_perms_e;
                break;
            }
            case encrypt_40bit_k: {
                this.m_output_encryption_strength = encryption_strength.bits40_enc;
                break;
            }
            case encrypt_128bit_k: {
                this.m_output_encryption_strength = encryption_strength.bits128_enc;
                break;
            }
            case filt_uncompress_k: {
                this.m_output_uncompress_b = true;
                break;
            }
            case filt_compress_k: {
                this.m_output_compress_b = true;
                break;
            }
            case flatten_k: {
                this.m_output_flatten_b = true;
                break;
            }
            case need_appearances_k: {
                this.m_output_need_appearances_b = true;
                break;
            }
            case drop_xfa_k: {
                this.m_output_drop_xfa_b = true;
                break;
            }
            case drop_xmp_k: {
                this.m_output_drop_xmp_b = true;
                break;
            }
            case keep_first_id_k: {
                this.m_output_keep_first_id_b = true;
                break;
            }
            case keep_final_id_k: {
                this.m_output_keep_final_id_b = true;
                break;
            }
            case verbose_k: {
                this.m_verbose_reporting_b = true;
                break;
            }
            case dont_ask_k: {
                this.m_ask_about_warnings_b = false;
                break;
            }
            case do_ask_k: {
                this.m_ask_about_warnings_b = true;
                break;
            }
            case background_k: {
                if (this.m_operation != keyword.filter_k) {
                    System.err.println("Warning: the \"background\" output option works only in filter mode.");
                    System.err.println("  This means it won't work in combination with \"cat\", \"burst\",");
                    System.err.println("  \"attach_file\", etc.  To run pdftk in filter mode, simply omit");
                    System.err.println("  the operation, e.g.: pdftk in.pdf output out.pdf background back.pdf");
                    System.err.println("  Or, use background as an operation; this is the preferred technique:");
                    System.err.println("    pdftk in.pdf background back.pdf output out.pdf");
                }
                arg_state_p.value = ArgState.background_filename_e;
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    static enum keyword {
        none_k,
        cat_k,
        shuffle_k,
        burst_k,
        barcode_burst_k,
        filter_k,
        dump_data_k,
        dump_data_utf8_k,
        dump_data_fields_k,
        dump_data_fields_utf8_k,
        dump_data_annots_k,
        generate_fdf_k,
        unpack_files_k,
        fill_form_k,
        attach_file_k,
        update_info_k,
        update_info_utf8_k,
        update_xmp_k,
        background_k,
        multibackground_k,
        stamp_k,
        multistamp_k,
        rotate_k,
        attach_file_to_page_k,
        even_k,
        odd_k,
        output_k,
        input_pw_k,
        owner_pw_k,
        user_pw_k,
        user_perms_k,
        encrypt_40bit_k,
        encrypt_128bit_k,
        perm_printing_k,
        perm_modify_contents_k,
        perm_copy_contents_k,
        perm_modify_annotations_k,
        perm_fillin_k,
        perm_screen_readers_k,
        perm_assembly_k,
        perm_degraded_printing_k,
        perm_all_k,
        filt_uncompress_k,
        filt_compress_k,
        flatten_k,
        need_appearances_k,
        drop_xfa_k,
        drop_xmp_k,
        keep_first_id_k,
        keep_final_id_k,
        verbose_k,
        dont_ask_k,
        do_ask_k,
        rot_north_k,
        rot_east_k,
        rot_south_k,
        rot_west_k,
        rot_left_k,
        rot_right_k,
        rot_upside_down_k;

    }

    static enum encryption_strength {
        none_enc,
        bits40_enc,
        bits128_enc;

    }

    private static enum ArgState {
        input_files_e,
        input_pw_e,
        page_seq_e,
        form_data_filename_e,
        attach_file_filename_e,
        attach_file_pagenum_e,
        update_info_filename_e,
        update_xmp_filename_e,
        output_e,
        output_filename_e,
        output_args_e,
        output_owner_pw_e,
        output_user_pw_e,
        output_user_perms_e,
        background_filename_e,
        stamp_filename_e,
        done_e;

    }

    static enum PageRotate {
        NORTH(0),
        EAST(90),
        SOUTH(180),
        WEST(270);

        final int value;

        private PageRotate(int value) {
            this.value = value;
        }
    }

    class PageRef {
        int m_input_pdf_index;
        int m_page_num;
        PageRotate m_page_rot;
        boolean m_page_abs;

        PageRef(int input_pdf_index, int page_num) {
            this.m_input_pdf_index = input_pdf_index;
            this.m_page_num = page_num;
            this.m_page_rot = PageRotate.NORTH;
            this.m_page_abs = false;
        }

        PageRef(int input_pdf_index, int page_num, PageRotate page_rot, boolean page_abs) {
            this.m_input_pdf_index = input_pdf_index;
            this.m_page_num = page_num;
            this.m_page_rot = page_rot;
            this.m_page_abs = page_abs;
        }
    }

    class ArgStateMutable {
        ArgState value;

        ArgStateMutable() {
        }
    }
}

