/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.creole.command;

import net.sourceforge.plantuml.command.regex.Matcher2;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.Pattern2;
import net.sourceforge.plantuml.creole.StripeSimple;
import net.sourceforge.plantuml.creole.command.Command;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.SvgAttributes;

public class CommandCreoleSvgAttributeChange
implements Command {
    private final Pattern2 pattern;
    public static final String fontPattern = "\\<text[\\s:]+([^>]+)/?\\>";

    public static Command create() {
        return new CommandCreoleSvgAttributeChange("^(?i)(\\<text[\\s:]+([^>]+)/?\\>(.*?)\\</text\\>)");
    }

    public static Command createEol() {
        return new CommandCreoleSvgAttributeChange("^(?i)(\\<text[\\s:]+([^>]+)/?\\>(.*))$");
    }

    private CommandCreoleSvgAttributeChange(String p) {
        this.pattern = MyPattern.cmpile(p);
    }

    @Override
    public int matchingSize(String line) {
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            return 0;
        }
        return m.group(1).length();
    }

    @Override
    public String executeAndGetRemaining(String line, StripeSimple stripe) {
        FontConfiguration fc1;
        Matcher2 m = this.pattern.matcher(line);
        if (!m.find()) {
            throw new IllegalStateException();
        }
        FontConfiguration fc2 = fc1 = stripe.getActualFontConfiguration();
        if (m.group(2) != null) {
            fc2 = fc2.changeAttributes(new SvgAttributes(m.group(2)));
        }
        stripe.setActualFontConfiguration(fc2);
        stripe.analyzeAndAdd(m.group(3));
        stripe.setActualFontConfiguration(fc1);
        return line.substring(m.group(1).length());
    }
}

