/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.Scalable;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UShapeSized;

public class ULine
extends AbstractShadowable
implements Scalable,
UShapeSized {
    private final double dx;
    private final double dy;

    @Override
    public UShape getScaled(double scale) {
        if (scale == 1.0) {
            return this;
        }
        ULine result = new ULine(this.dx * scale, this.dy * scale);
        ((AbstractShadowable)result).setDeltaShadow(this.getDeltaShadow());
        return result;
    }

    public ULine(Point2D p1, Point2D p2) {
        this(p2.getX() - p1.getX(), p2.getY() - p1.getY());
    }

    public ULine(double dx, double dy) {
        this.dx = dx;
        this.dy = dy;
    }

    public static ULine hline(double dx) {
        return new ULine(dx, 0.0);
    }

    public static ULine vline(double dy) {
        return new ULine(0.0, dy);
    }

    public String toString() {
        return "ULine dx=" + this.dx + " dy=" + this.dy;
    }

    public double getDX() {
        return this.dx;
    }

    public double getDY() {
        return this.dy;
    }

    public double getLength() {
        return Math.sqrt(this.dx * this.dx + this.dy * this.dy);
    }

    @Override
    public double getWidth() {
        return this.dx;
    }

    @Override
    public double getHeight() {
        return this.dy;
    }
}

