/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NoSuchRemoteClusterException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportActionProxy;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;

public class RemoteConnectionManager
implements ConnectionManager {
    private final String clusterAlias;
    private final ConnectionManager delegate;
    private final AtomicLong counter = new AtomicLong();
    private volatile List<Transport.Connection> connections = Collections.emptyList();

    RemoteConnectionManager(String clusterAlias, ConnectionManager delegate) {
        this.clusterAlias = clusterAlias;
        this.delegate = delegate;
        this.delegate.addListener(new TransportConnectionListener(){

            @Override
            public void onNodeConnected(DiscoveryNode node, Transport.Connection connection) {
                RemoteConnectionManager.this.addConnection(connection);
            }

            @Override
            public void onNodeDisconnected(DiscoveryNode node, Transport.Connection connection) {
                RemoteConnectionManager.this.removeConnection(connection);
            }
        });
    }

    @Override
    public void connectToNode(DiscoveryNode node, ConnectionProfile connectionProfile, ConnectionManager.ConnectionValidator connectionValidator, ActionListener<Void> listener) throws ConnectTransportException {
        this.delegate.connectToNode(node, connectionProfile, connectionValidator, listener);
    }

    @Override
    public void addListener(TransportConnectionListener listener) {
        this.delegate.addListener(listener);
    }

    @Override
    public void removeListener(TransportConnectionListener listener) {
        this.delegate.removeListener(listener);
    }

    @Override
    public void openConnection(DiscoveryNode node, ConnectionProfile profile, ActionListener<Transport.Connection> listener) {
        this.delegate.openConnection(node, profile, listener);
    }

    @Override
    public Transport.Connection getConnection(DiscoveryNode node) {
        try {
            return this.delegate.getConnection(node);
        }
        catch (NodeNotConnectedException e) {
            return new ProxyConnection(this.getAnyRemoteConnection(), node);
        }
    }

    @Override
    public boolean nodeConnected(DiscoveryNode node) {
        return this.delegate.nodeConnected(node);
    }

    @Override
    public void disconnectFromNode(DiscoveryNode node) {
        this.delegate.disconnectFromNode(node);
    }

    @Override
    public ConnectionProfile getConnectionProfile() {
        return this.delegate.getConnectionProfile();
    }

    public Transport.Connection getAnyRemoteConnection() {
        long curr;
        List<Transport.Connection> localConnections = this.connections;
        if (localConnections.isEmpty()) {
            throw new NoSuchRemoteClusterException(this.clusterAlias);
        }
        while ((curr = this.counter.incrementAndGet()) == Long.MIN_VALUE) {
        }
        return localConnections.get(Math.toIntExact(Math.floorMod(curr, (long)localConnections.size())));
    }

    @Override
    public int size() {
        return this.connections.size();
    }

    @Override
    public void close() {
        this.delegate.closeNoBlock();
    }

    @Override
    public void closeNoBlock() {
        this.delegate.closeNoBlock();
    }

    private synchronized void addConnection(Transport.Connection addedConnection) {
        ArrayList<Transport.Connection> newConnections = new ArrayList<Transport.Connection>(this.connections);
        newConnections.add(addedConnection);
        this.connections = Collections.unmodifiableList(newConnections);
    }

    private synchronized void removeConnection(Transport.Connection removedConnection) {
        int newSize = this.connections.size() - 1;
        ArrayList<Transport.Connection> newConnections = new ArrayList<Transport.Connection>(newSize);
        for (Transport.Connection connection : this.connections) {
            if (connection.equals(removedConnection)) continue;
            newConnections.add(connection);
        }
        assert (newConnections.size() == newSize) : "Expected connection count: " + newSize + ", Found: " + newConnections.size();
        this.connections = Collections.unmodifiableList(newConnections);
    }

    static final class ProxyConnection
    implements Transport.Connection {
        private final Transport.Connection connection;
        private final DiscoveryNode targetNode;

        private ProxyConnection(Transport.Connection connection, DiscoveryNode targetNode) {
            this.connection = connection;
            this.targetNode = targetNode;
        }

        @Override
        public DiscoveryNode getNode() {
            return this.targetNode;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws IOException, TransportException {
            this.connection.sendRequest(requestId, TransportActionProxy.getProxyAction(action), TransportActionProxy.wrapRequest(this.targetNode, request), options);
        }

        @Override
        public void close() {
            assert (false) : "proxy connections must not be closed";
        }

        @Override
        public void addCloseListener(ActionListener<Void> listener) {
            this.connection.addCloseListener(listener);
        }

        @Override
        public boolean isClosed() {
            return this.connection.isClosed();
        }

        @Override
        public Version getVersion() {
            return this.connection.getVersion();
        }
    }
}

